***************************************************************************
*
* Procedure file: WINMOVE.PRG
*         System: GenScrnX
*        Version: 1.8
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* WINMOVE - Window Move driver.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Moves screen window off screen of display while Screen Layout is executed.
* This prevents the visual delay of GET/SAY refresh becuase the window
* is moved by row/column 999,999 during the Screen Layout and back to the
* original position at the end of the READ Show routine.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* Function calls made from this program may be contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE winname,codedata,addsection

* Ignore for non-header record or driver disable mode.
IF OBJTYPE#1.OR..NOT.drvenable(PROGRAM())
  GOTO BOTTOM
  RETURN .F.
ENDIF
IF TYPE('m.gsxversion')#'C'.OR.LEFT(m.gsxversion,4)<'1.7a'
  GOTO BOTTOM
  =warning('WinMove driver requires GENSCNRX 1.7a or later')
  RETURN .F.
ENDIF
IF m.loop_flag.OR.STYLE=0.OR..NOT.wordsearch(m.c_prg,.T.)==m.null
  GOTO BOTTOM
  RETURN .F.
ENDIF
IF EMPTY(NAME)
  REPLACE NAME WITH SYS(2015)
ENDIF
m.winname=MLINE(NAME,1)
m.codedata="IF WEXIST('"+m.winname+"').AND.WLROW('"+m.winname+"')<999"+;
           m.cr_lf+"  MOVE WINDOW "+m.winname+" TO 999,999"+m.cr_lf+"ENDIF"
m.addsection=.F.
IF wordsearch('#SECTION 2')==m.null
  m.codedata='#SECTION 2'+m.cr_lf+m.codedata
  m.addsection=.T.
ENDIF
REPLACE SETUPCODE WITH SETUPCODE+m.cr_lf+m.codedata
IF m.addsection.AND.wordsearch('#SECTION 1')==m.null
  REPLACE SETUPCODE WITH '#SECTION 1'+m.cr_lf+SETUPCODE
ENDIF
m.codedata="IF WEXIST('"+m.winname+"').AND.WLROW('"+m.winname+"')>=900"+;
           m.cr_lf+"  MOVE WINDOW "+m.winname+" "
IF CENTER
  m.codedata=m.codedata+"CENTER"
ELSE
  IF INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC')
    m.codedata=m.codedata+"TO "+ALLTRIM(STR(VPOS,9,3))+","+;
               ALLTRIM(STR(HPOS,9,3))
  ELSE
    m.codedata=m.codedata+"TO "+ALLTRIM(STR(VPOS,6))+","+;
               ALLTRIM(STR(HPOS,6))
  ENDIF
ENDIF
m.codedata=m.codedata+m.cr_lf+"ENDIF"
IF SHOWTYPE#1.AND.EMPTY(SHOW)
  REPLACE SHOWTYPE WITH 1
ENDIF
IF SHOWTYPE=1
  IF .NOT.m.codedata$SHOW
    REPLACE SHOW WITH SHOW+m.cr_lf+m.codedata
  ENDIF
ELSE
  LOCATE FOR m.codedata$SETUPCODE
  IF EOF()
    GOTO BOTTOM
    IF insrec()
      =instxt2(m.codedata)
    ENDIF
  ENDIF
ENDIF
GOTO BOTTOM
RETURN .T.

* END winmove
