/*
   FPT2DBT.PRG - Memo file converter.

   This is a simple program demonstrating how to convert
   SIx Driver (SIXCDX) .FPT's to Clipper .DBT's using a simple COPY TO routine,

    Compile:  CLIPPER FPT2DBT /n/w
    Link   :  BLINKER FI FPT2DBT,dbcreate LIB sixcdx,clipper

   For Clipper 5.01a, you must also include DBCREATE.OBJ when linking,
   since this will be creating a new table.  With Clipper 5.2, the
   DBCREATE.OBJ file is not needed.


   ---------------------------------------------------------------------
*/

REQUEST SIXCDX
REQUEST DBFNTX

#include "SIXCDX.CH"

PARAMETERS cOldFile, cNewFile

LOCAL aFile := {}, aStruct := {}, nLp, aSS, aFile2 := {}

PUBLIC C_TITLE[2], C_DESK[3], C_HELPLINE[2], C_KEY[18], C_MENU[18], C_WARN[18],;
       C_MESSAGE[18], C_DIALOG[18], C_LOOKUP[18], C_DATA[18], C_MEMO[18],;
       C_HELP[18]

CLEAR

InitColors()

IF  cOldFile == NIL
  cOldFile := ""
ENDIF

IF cNewFile == NIL
  cNewFile := ""
ENDIF

cOldFile := Upper( AllTrim( cOldFile ))
cNewFile := Upper( AllTrim( cNewFile ))

IF "." $ cOldFile
  cOldFile := Left( cOldFile, at( ".", cOldFile )-1 )
ENDIF

IF "." $ cNewFile
  cNewFile := Left( cNewFile, at( ".", cNewFile )-1 )
ENDIF

// Display a message
? "FPT2DBT - Memo File Converter"
?

// Make sure we got the correct parameters
IF PCOUNT() < 2
  ? "USAGE:  FPT2DBT <OldFile> <NewFile>"
  ?
  ? "where:  <OldFile> = Name of the database containing the memo"
  ? "                    field to convert."
  ? "        <NewFile> = New file to create."
  ?
  ? "   Ex:  FPT2DBT test test2"
  ?
  ? " NOTE:  This creates a new DBF and DBT file.  Both new files must be"
  ? "        used together."
  Return(1)
ENDIF

// Check for the original file
IF !File( cOldFile + ".DBF" )
  ? "Cannot find " + cOldFile + "!"
  ?
  Return(2)
ENDIF

// Open the original file (using DBFNTX)
// USE INFILE VIA "DBFNTX"
USE (cOldFile) VIA "SIXCDX" ALIAS "INFILE"

// Set SIx Driver as the default for creating new dbf
// SetRDD("SIXCDX")

RDDSETDEFAULT("DBFNTX")
// DBSETDRIVER("DBFNTX")

aStruct := INFILE->(DBSTRUCT())

DBCREATE(cNewFile,aStruct)
USE (cNewFile) ALIAS "OUTFILE" NEW
Msg_Box(,; // Message String
        ,; // Title
        ,; // Color Array
        ,; // Row
        ,; // Col
        4,; // Row Height
        54,;  // Column Width
        @aSS)  // Save Screen Array

INFILE->(DBGOTOP())
DO WHILE ! INFILE->(EOF())
  Odometer(INFILE->(RECNO()),; // Current Number
           INFILE->(LASTREC()),; // Total Iterations
           aSS[1]+1,; // Row Coordinate
           aSS[2]+2,; // Column Coordinate
           ,; // Show Bar Boolean
           ,; // Show Percent Complete Boolean
           ,; // Beginning SECONDS() of process
           ,; // Color Array
           ,; // Column Length
           ,; // Percent Picture Clause
           ,; // Bar Character
           )  // Empty Bar Character
  DBSELECTAREA("OUTFILE")
  APPEND BLANK
  FOR nLp := 1 TO FCOUNT()
    OUTFILE->(FIELDPUT(nLp,INFILE->(FIELDGET(nLp))))
  NEXT

  INFILE->(DBSKIP(+1))

ENDDO

// Show that we're doing something
// ? "Working"

// Now copy to the new file (with nifty UDF)
// COPY TO (cNewFile) FOR ShowDot()



// Look, we made it!
SETPOS(ROW()+1,0)
?? "Done!"
?
// Clean up before leaving
CLOSE ALL

// Compare file sizes
aFile  := Directory( cOldFile + ".FPT" )
aFile2 := Directory( cNewFile + ".DBT" )

Msg_Box({PADR( "Old " + cOldFile + ".FPT Size",21 ) + ": "+Str( aFile[1,2] )  + " bytes ",;
         PADR( "New " + cNewFile + ".DBT Size",21 ) + ": "+Str( aFile2[1,2] ) + " bytes" }  ,; // Message String
        ,; // Title
        ,; // Color Array
        16,; // Row
        ,; // Col
        ,; // Row Height
        ;  // Column Width
        )  // Save Screen Array

SETPOS(ROW()+2,0)

Return(0)

FUNC ShowDot()
  ?? "."
Return (.T.)

FUNCTION InitColors()
  C_TITLE    := {"W+" ,;        // Text Foreground
                 "B"}           // Text Background

  C_DESK     := {"",;  // BACKGROUND CHARACTER
                 "W",;          // TEXT FOREGROUND
                 "N"}           // TEXT BACKGROUND

  C_HELPLINE := {"W+",;         // TEXT FOREGROUND
                 "B"}           // TEXT BACKGROUND

  C_KEY      := {"B",;          // BORDER FOREGROUND
                 "BG",;         // BORDER BACKGROUND
                 "Ŀ ",;  // FRAME
                 "GR+",;        // TITLE FOREGROUND
                 "BG",;         // TITLE BACKGROUND
                 "BG",;         // WINDOW BACKGROUND
                 "B",;          // TEXT FOREGROUND
                 "BG",;         // TEXT BACKGROUND
                 "B",;          // SELECTED FOREGROUND
                 "W",;          // SELECTED BACKGROUND
                 "B",;          // UNSELECTED FOREGROUND
                 "BG",;         // UNSELECTED BACKGROUND
                 "N+",;          // DISPLAY FOREGROUND
                 "BG" ,;        // DISPLAY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND

  C_MENU     := {"B" ,;         // BORDER FOREGROUND
                 "BG",;         // BORDER BACKGROUND
                 "Ŀ ",;  // FRAME
                 "GR+",;        // TITLE FOREGROUND
                 "BG",;         // TITLE BACKGROUND
                 "BG",;         // WINDOW BACKGROUND
                 "W+",;         // TEXT FOREGROUND
                 "BG",;         // TEXT BACKGROUND
                 "B",;          // SELECTED FOREGROUND
                 "W",;          // SELECTED BACKGROUND
                 "W+",;         // UNSELECTED FOREGROUND
                 "BG",;         // UNSELECTED BACKGROUND
                 "W",;          // DISPLAY FOREGROUND
                 "BG",;         // DISPLAY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND

  C_WARN     := {"N+",;         // BORDER FOREGROUND
                 "R",;          // BORDER BACKGROUND
                 " ",;  // FRAME
                 "R*",;         // TITLE FOREGROUND
                 "W",;          // TITLE BACKGROUND
                 "R",;          // WINDOW BACKGROUND
                 "W+",;         // TEXT FOREGROUND
                 "R",;          // TEXT BACKGROUND
                 "B",;          // SELECTED FOREGROUND
                 "W",;          // SELECTED BACKGROUND
                 "W",;          // UNSELECTED FOREGROUND
                 "R",;          // UNSELECTED BACKGROUND
                 "GR+",;        // DISPLAY ONLY FOREGROUND
                 "R",;          // DISPLAY ONLY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND

  C_MESSAGE   := {"W",;         // BORDER FOREGROUND
                  "RB",;        // BORDER BACKGROUND
                  "ͻȺ ",; // FRAME
                  "N",;         // TITLE FOREGROUND
                  "W",;         // TITLE BACKGROUND
                  "RB",;        // WINDOW BACKGROUND
                  "W+",;        // TEXT FOREGROUND
                  "RB",;        // TEXT BACKGROUND
                  "N",;         // SELECTED FOREGROUND
                  "W",;         // SELECTED BACKGROUND
                  "W+",;        // UNSELECTED FOREGROUND
                  "RB",;        // UNSELECTED BACKGROUND
                  "W",;         // DISPLAY ONLY FOREGROUND
                  "RB",;        // DISPLAY ONLY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND

  C_DIALOG   := {"W+"       ,;  // BORDER FOREGROUND
                 "B"        ,;  // BORDER BACKGROUND
                 "ķӺ ",;  // FRAME
                 "W+"       ,;  // TITLE FOREGROUND
                 "B"        ,;  // TITLE BACKGROUND
                 "B"        ,;  // WINDOW BACKGROUND
                 "W+"       ,;  // TEXT FOREGROUND
                 "B"        ,;  // TEXT BACKGROUND
                 "GR+"      ,;  // SELECTED FOREGROUND
                 "BG"       ,;  // SELECTED BACKGROUND
                 "GR+"      ,;  // UNSELECTED FOREGROUND
                 "B"        ,;  // UNSELECTED BACKGROUND
                 "W"        ,;  // DISPLAY ONLY FOREGROUND
                 "B",;          // DISPLAY ONLY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND

  C_LOOKUP   := {"B"         ,; // BORDER FOREGROUND
                 "W"         ,; // BORDER BACKGROUND
                 "Ŀ " ,; // FRAME
                 "B"         ,; // TITLE FOREGROUND
                 "W"         ,; // TITLE BACKGROUND
                 "W"         ,; // WINDOW BACKGROUND
                 "B"         ,; // TEXT FOREGROUND
                 "W"         ,; // TEXT BACKGROUND
                 "GR+"       ,; // SELECTED FOREGROUND
                 "B"         ,; // SELECTED BACKGROUND
                 "N"         ,; // UNSELECTED FOREGROUND
                 "W"         ,; // UNSELECTED BACKGROUND
                 "N"         ,; // DISPLAY ONLY FOREGROUND
                 "N"         ,; // DISPLAY ONLY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND

  C_DATA     := {"W+"        ,; // BORDER FOREGROUND
                 "BG"        ,; // BORDER BACKGROUND
                 "͸Գ " ,; // FRAME
                 "N"         ,; // TITLE FOREGROUND
                 "W"         ,; // TITLE BACKGROUND
                 "BG"        ,; // WINDOW BACKGROUND
                 "N"         ,; // TEXT FOREGROUND
                 "BG"        ,; // TEXT BACKGROUND
                 "N"         ,; // SELECTED FOREGROUND
                 "W"         ,; // SELECTED BACKGROUND
                 "W+"        ,; // UNSELECTED FOREGROUND
                 "B"         ,; // UNSELECTED BACKGROUND
                 "GR+"       ,; // DISPLAY ONLY FOREGROUND
                 "BG",;         // DISPLAY ONLY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND

  C_MEMO     := {"W+"        ,; // BORDER FOREGROUND
                 "G"         ,; // BORDER BACKGROUND
                 "͸Գ " ,; // FRAME
                 "N"         ,; // TITLE FOREGROUND
                 "W"         ,; // TITLE BACKGROUND
                 "G"         ,; // WINDOW BACKGROUND
                 "W"         ,; // TEXT FOREGROUND
                 "N"         ,; // TEXT BACKGROUND
                 "N"         ,; // SELECTED FOREGROUND
                 "W"         ,; // SELECTED BACKGROUND
                 "W+"        ,; // UNSELECTED FOREGROUND
                 "G"         ,; // UNSELECTED BACKGROUND
                 "BG"        ,; // DISPLAY ONLY FOREGROUND
                 "N",;          // DISPLAY ONLY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND

  C_HELP     := {"W+"        ,; // BORDER FOREGROUND
                 "G"         ,; // BORDER BACKGROUND
                 "ͻȺ " ,; // FRAME
                 "N"         ,; // TITLE FOREGROUND
                 "W"         ,; // TITLE BACKGROUND
                 "G"         ,; // WINDOW BACKGROUND
                 "W+"        ,; // TEXT FOREGROUND
                 "G"         ,; // TEXT BACKGROUND
                 "N"         ,; // SELECTED FOREGROUND
                 "W"         ,; // SELECTED BACKGROUND
                 "W+"        ,; // UNSELECTED FOREGROUND
                 "G"         ,; // UNSELECTED BACKGROUND
                 "GR+"       ,; // DISPLAY ONLY FOREGROUND
                 "G",;          // DISPLAY ONLY BACKGROUND
                 "GR+"       ,; // SPECIAL 1 FOREGROUND
                 "W"         ,; // SPECIAL 1 BACKGROUND
                 "R"         ,; // SPECIAL 2 FOREGROUND
                 "W"}           // SPECIAL 2 BACKGROUND
RETURN NIL
