*===========================================================================*
* Program.........:Profile                                                  *
* Author..........:Gordon Walker                                            *
* Project.........:FoxProfile                                               *
* Description.....:This program takes a piece of program code which the     *
*                 :user has copied to the clipboard and processes it to     *
*                 :generate code which will time the execution of each line *
*                 :to allow analysis. The code should be left highlighted   *
*                 :so that FoxProfile can overwrite it with the new code.   *
*                 :The new code contains the old commented out so that the  *
*                 :user can revert to the original easily.                  *
* Pre.............:The clipboard (_CLIPTEXT) should contain valid Foxpro    *
*                 :code to be profiled. That code should be highlighted.    *
*                 :_CLIPTEXT must not contain any line of code longer than  *
*                 :256 characters (MEMOWIDTH limitation)                    *
* Post............:The clipboard will contain the processed code and it has *
*                 :been pasted.                                             *
* Calling Sample..:DO Profile                                               *
* Parameter List..:None                                                     *
*---------------------------------------------------------------------------*
*                             Major Change List                             *
*                                                                           *
*===========================================================================*
PRIVATE m.ljI, m.lcOldCode, m.lnNumLine, m.lnOrigLines, laCode, ;
	m.lnNewLines, m.lcNewCode

* Display the splash screen
IF _WINDOWS
	DO splash.spr WITH "DISPLAY"
ELSE
	WAIT CLEAR
	WAIT WINDOW "FoxProfile"+CHR(13)+"Version 1.0"
ENDIF

* Extend memowidth
SET MEMOWIDTH TO 256
* Turn TALK off
SET TALK OFF
* Take code from clipboard
lcOldCode=_CLIPTEXT
* Take a count of the lines in the passed code and establish a first
* record of the lines in the processed code
lnOrigLines=MEMLINES(lcOldCode)
lnNewLines=lnOrigLines
* Copy the code to an array. It is dimensioned initially to hold all
* the lines originally passed.
DIMENSION laCode(lnOrigLines)
FOR ljI=1 TO lnOrigLines
	laCode(ljI)=MLINE(_CLIPTEXT, ljI)
	* Remove &&'s because they screw up assignments
	* EG. _laProfile(1,1)="DO Something && hello"
	* will die because it doesn't see the second " after the &&
	* and reports a syntax error. In the code to remove them we
	* even have to use "&"+"&" instead of "&&"
	IF AT("&"+"&",laCode(ljI))>0
		laCode(ljI)=LEFT(laCode(ljI),AT("&"+"&",laCode(ljI))-1)
	ENDIF
ENDFOR
* Examine the array for ';' continued lines. Since each line will be
* interleaved with profile code, such lines must be compiled into single
* line commands. This will reduce the number of lines in the generated
* code and lnNewLines is decremented accordingly
ljI=1   && Establish a line count
DO WHILE ljI<=lnNewLines
	* See if the current line is ended with a ';'
	IF RIGHT(RTRIM(laCode(ljI)),1)=";"
		* Join this line with the next, removing the ';' itself together
		* with trailing spaces from this line and and leading spaces/tabs
		* from the next
		laCode(ljI)=RTRIM( LEFT(laCode(ljI),RAT(";",laCode(ljI))-1) ) ;
		            + " " + ;
		            LTRIM(STRTRAN(laCode(ljI+1),CHR(9)," "))
		* Delete the next line's entry in the array, it is now
		* contained in the current line
		=ADEL(laCode, ljI+1)
		* Keep our count of lines in the processed array correct
		lnNewLines=lnNewLines-1
		* Redimension the array to clear the blank entry at the end
		* of the array left by the ADEL command
		DIMENSION laCode(lnNewLines)
		* Reset the FOR variable so that this line will be processed
		* again. The line contatenated may also have had a ';' at
		* its end
		ljI=ljI-1
	ENDIF
	* Increment the line count
	ljI=ljI+1
ENDDO
* Prepare the code to create the analysis array
_CLIPTEXT="*===============================*"+CHR(13)+ ;
          "* FoxProfile - (c) NiSoft, 1995 *"+CHR(13)+ ;
          "*   Written by Gordon Walker    *"+CHR(13)+ ;
          "*        CIS:100411,3656        *"+CHR(13)+ ;
          "*-------------------------------*"+CHR(13)+ ;
          "* Dimension the array to hold    "+CHR(13)+ ;
          "* the code profile               "+CHR(13)+ ;
          "DIMENSION _laProfile("+ALLTRIM(STR(lnNewLines))+",3)"+CHR(13)+ ;
          "STORE 0 TO _laProfile            "+CHR(13)+ ;
          "* Local variables used in time   "+CHR(13)+ ;
          "* calculations                   "+CHR(13)+ ;
          "PRIVATE _lnStart, _lnTotal, m._ljI"+CHR(13)+ ;
          "*-------------------------------*"+CHR(13)+ ;
          "*         PROFILED CODE         *"+CHR(13)+ ;
          "*-------------------------------*"+CHR(13)
* Populate the array _laProfile
_CLIPTEXT=_CLIPTEXT+"*-------------------------------*"+CHR(13)+ ;
                    "* Populate the _laProfile array *"+CHR(13)+ ;
                    "*-------------------------------*"+CHR(13)
FOR ljI=1 TO lnNewLines
	_CLIPTEXT=_CLIPTEXT+"_laProfile("+ALLTRIM(STR(ljI))+",1)='"+laCode(ljI)+"'"+CHR(13)
	* If this line is not to be timed, set the number of executions
	* to -1
	IF NoTime(laCode(ljI))
		_CLIPTEXT=_CLIPTEXT+"_laProfile("+ALLTRIM(STR(ljI))+",3)=(-1)"+CHR(13)
	ENDIF
ENDFOR
* Insert the actual code with timing code interleaved
_CLIPTEXT=_CLIPTEXT+"*-------------------------------*"+CHR(13)+ ;
                    "*           Timed code          *"+CHR(13)+ ;
                    "*-------------------------------*"+CHR(13)
FOR ljI=1 TO lnNewLines
	* Ignore '*' commented lines. 'DO CASE' and 'CASE' lines cannot be
	* measured because the interpreter ignores lines between them
	IF NoTime(laCode(ljI))
		* Just paste the code in, make no attempt to time it
		_CLIPTEXT=_CLIPTEXT+laCode(ljI)+CHR(13)
	ELSE
		* Code to store start time of execution
		_CLIPTEXT=_CLIPTEXT+"_lnStart=SECONDS()"+CHR(13)
		* Actual line of code
		_CLIPTEXT=_CLIPTEXT+laCode(ljI)+CHR(13)
		* Code to record execution time
		_CLIPTEXT=_CLIPTEXT+"_laProfile("+ALLTRIM(STR(ljI))+",2)=_laProfile("+ALLTRIM(STR(ljI))+",2)+(SECONDS()-_lnStart)"+CHR(13)
		* Code to count the number of times this line was executed
		_CLIPTEXT=_CLIPTEXT+"_laProfile("+ALLTRIM(STR(ljI))+",3)=_laProfile("+ALLTRIM(STR(ljI))+",3)+1"+CHR(13)
	ENDIF
ENDFOR
* Generate a call to the profile analyser
_CLIPTEXT=_CLIPTEXT+"*-------------------------------*"+CHR(13)+ ;
                    "* FoxProfile Analyser           *"+CHR(13)+ ;
                    "* Compute total execution time  *"+CHR(13)+ ;
                    "_lnTotal=0                       "+CHR(13)+ ;
                    "FOR _ljI=1 TO "+ALLTRIM(STR(lnNewLines))+CHR(13)+ ;
                    "	_lnTotal=_lnTotal+_laProfile(_ljI,2)"+CHR(13)+ ;
                    "ENDFOR                           "+CHR(13)+ ;
                    "* Display the analysis          *"+CHR(13)+ ;
                    "DO ProAnlys IN Profile           "+CHR(13)+ ;
                    "RELEASE _laProfile, _lnStart, _lnBegin"+CHR(13)
* Append the original code
_CLIPTEXT=_CLIPTEXT+"*-------------------------------*"+CHR(13)+ ;
                    "*      END OF PROFILED CODE     *"+CHR(13)+ ;
                    "* To remove FoxProfiler, delete *"+CHR(13)+ ;
                    "* the code above and uncomment  *"+CHR(13)+ ;
                    "* the code which follows        *"+CHR(13)+ ;
                    "*-------------------------------*"+CHR(13)
FOR ljI=1 TO lnOrigLines
	_CLIPTEXT=_CLIPTEXT+"*"+MLINE(lcOldCode,ljI)+CHR(13)
ENDFOR
_CLIPTEXT=_CLIPTEXT+"*-------------------------------*"+CHR(13)+ ;
                    "*      END OF ORIGINAL CODE     *"+CHR(13)+ ;
                    "*===============================*"+CHR(13)

* Remove the splash screen
IF _WINDOWS
	DO splash.spr WITH "REMOVE"
ELSE
	WAIT CLEAR
ENDIF
* Paste it in
KEYBOARD '{CTRL+F1}{CTRL+V}'

*---------------------------------------------------------------------------*
* Procedure.......:ProAnlys                                                 *
* Author..........:Gordon Walker                                            *
* Description.....:This routine is called by code profiled by FoxProfile.   *
*                 :It takes the data gathered and displays it.              *
* Pre.............:ProAnlys expects an array _laProfile which one row for   *
*                 :each line of code profiled and three columns. The first  *
*                 :column contains the code executed, the second, the       *
*                 :length of time spent executing it, the third the number  *
*                 :of times it was executed. Also expected it a variable    *
*                 :_lnTotal which contains the total execution time of the  *
*                 :profiled code in seconds.                                *
* Post............:None                                                     *
* Calling Sample..:DO ProAnlys                                              *
* Parameter List..:None                                                     *
*---------------------------------------------------------------------------*
*                             Major Change List                             *
*                                                                           *
*---------------------------------------------------------------------------*
PROCEDURE ProAnlys
PRIVATE m._lhProfile, m._lhClose, m._ljI, m._lcRight
EXTERNAL ARRAY _laProfile
* Define a double arrow character
IF _DOS
	_lcRight="    "
ELSE
	_lcRight="    "   && This is the double arrow in Arial
ENDIF
* Prepare the percentage information and remove tabs
FOR _ljI=1 TO ALEN(_laProfile,1)
	* Replace any TAB with three spaces
	_laProfile(_ljI,1)=STRTRAN(_laProfile(_ljI,1),CHR(9),"   ")
	* Append a suitable tag to each line
	DO CASE
		CASE _laProfile(_ljI,3)=-1
			* This line was not timed
			_laProfile(_ljI,1)=RTRIM(_laProfile(_ljI,1))+_lcRight+ ;
				"[NOT TIMED]"
		CASE _laProfile(_ljI,3)=0
			* This line was never executed
			_laProfile(_ljI,1)=RTRIM(_laProfile(_ljI,1))+_lcRight+ ;
				"[NOT EXECUTED]"
		OTHERWISE
			* Append percentage execution time
			_laProfile(_ljI,1)=RTRIM(_laProfile(_ljI,1))+_lcRight+ ;
				"("+ALLTRIM(STR((_laProfile(_ljI,2)/_lnTotal)*100,5,2))+"%)"
	ENDCASE
ENDFOR
* Display analysis on screen
IF _WINDOWS
	DO Profile.spr
ELSE
	DO DProfile.spr
ENDIF
* Tidy up
RELEASE _lhProfile, _lhClose, _ljI, _lcRight

PROCEDURE NoTime
PARAMETERS m.tcLine
IF LEFT(LTRIM(STRTRAN(tcLine,CHR(9),"")),1)="*"       OR ;
   LEFT(LTRIM(STRTRAN(tcLine,CHR(9),"")),7)="DO CASE" OR ;
   LEFT(LTRIM(STRTRAN(tcLine,CHR(9),"")),5)="CASE " )
   		RETURN .T.
ELSE
		RETURN .F.
ENDIF
