*:
*: Procedure file: FP25CPER
*:
*:         System: FPWERROR-FoxPro Windows Error Handler
*:         Author: Pat Adams                Version 1.03
*:      Copyright (c) 1993, DB Unlimited
*:  Last modified: 04/06/93     10:57
*:
*:  Procs & Fncts: LOW_MEM
*:               : QQUIT
*:               : UPMVCOUNT
*:               : GO_MASTR
*:               : ERORSET
*:               : NO_FILE
*:               : FILE_BUSY
*:               : GO_AGAIN
*:               : TOO_HIGH
*:               : LOWFILES
*:               : REALBAD
*:               : INDEX_ER
*:               : SETENVMT
*:               : SAVE_IT
*:               : TOOBIG
*:               : NOMEMO
*:               : BAD_RPT
*:               : BADMEMFL
*:               : NOSPACE
*:               : TO_PRN
*:               : KORRUPT
*:               : REC_BUSY
*:               : LREADONLY
*:               : READONLY
*:               : BAD_DIF
*:               : BAD_SYLK
*:               : NOTRIGHT
*:               : BADLOTUS
*:               : REC2BIG
*:               : SQL_INTL
*:               : SQLTRASH
*:               : NOSQLIDX
*:               : SQL_IDX
*:               : SQLABORT
*:               : IO_FAILED
*:               : MEM_PROB
*:               : KODEKORUP
*:               : BADCHAIN
*:               : BAD_API
*:               : BADRIGHTS
*:               : NOCREATE
*:               : READ_ERR
*:               : RITE_ERR
*:               : TRANSACTN
*:               : BADCLOSE
*:               : BAD_OBJ
*:               : NOTFOXWEXE
*:               : VERBOSE
*:               : BAD_RESRC
*:               : NORUN
*:               : BAD_OLE
*:               : NO_OLE
*:               : OLE_SAVE
*:               : OLEKREATE
*:               : KLIPBOARD
*:               : BAD_WIN
*:               : BADEXCEL
*:               : ENKRYPTED
*:               : BADSYMPH
*:               : A_ONLY
*:               : L_HIDE
*:               : BAD_PARDX
*:               : DNOACCES
*:               : NOACCESS
*:               : SNOACCES
*:               : NO_CDX
*:               : NOAPI
*:               : NO_FLL
*:               : NOSQLOPEN
*:               : PROGBUG
*:               : UHOH
*:               : LOGVIEW
*:               : MEMOVIEW
*:               : NICECHIM
*:               : A_LERT
*:               : KANCEL
*:               : DEVELOPER
*:               : LAN_ADMIN
*:               : APP_ADMIN
*:               : USTRING
*:
*:         Set by: ERORSET            (procedure in FPWERROR.PRG)
*:
*:          Calls: LOW_MEM            (procedure in FPWERROR.PRG)
*:               : QQUIT              (procedure in FPWERROR.PRG)
*:               : UPMVCOUNT          (procedure in FPWERROR.PRG)
*:               : GO_MASTR           (procedure in FPWERROR.PRG)
*:               : ERORSET            (procedure in FPWERROR.PRG)
*:               : NO_FILE            (procedure in FPWERROR.PRG)
*:               : FILE_BUSY          (procedure in FPWERROR.PRG)
*:               : GO_AGAIN           (procedure in FPWERROR.PRG)
*:               : TOO_HIGH           (procedure in FPWERROR.PRG)
*:               : LOWFILES           (procedure in FPWERROR.PRG)
*:               : REALBAD            (procedure in FPWERROR.PRG)
*:               : INDEX_ER           (procedure in FPWERROR.PRG)
*:               : SETENVMT           (procedure in FPWERROR.PRG)
*:               : SAVE_IT            (procedure in FPWERROR.PRG)
*:               : TOOBIG             (procedure in FPWERROR.PRG)
*:               : NOMEMO             (procedure in FPWERROR.PRG)
*:               : BAD_RPT            (procedure in FPWERROR.PRG)
*:               : BADMEMFL           (procedure in FPWERROR.PRG)
*:               : NOSPACE            (procedure in FPWERROR.PRG)
*:               : TO_PRN             (procedure in FPWERROR.PRG)
*:               : KORRUPT            (procedure in FPWERROR.PRG)
*:               : REC_BUSY           (procedure in FPWERROR.PRG)
*:               : LREADONLY          (procedure in FPWERROR.PRG)
*:               : READONLY           (procedure in FPWERROR.PRG)
*:               : BAD_DIF            (procedure in FPWERROR.PRG)
*:               : BAD_SYLK           (procedure in FPWERROR.PRG)
*:               : NOTRIGHT           (procedure in FPWERROR.PRG)
*:               : BADLOTUS           (procedure in FPWERROR.PRG)
*:               : REC2BIG            (procedure in FPWERROR.PRG)
*:               : SQL_INTL           (procedure in FPWERROR.PRG)
*:               : SQLTRASH           (procedure in FPWERROR.PRG)
*:               : NOSQLIDX           (procedure in FPWERROR.PRG)
*:               : SQL_IDX            (procedure in FPWERROR.PRG)
*:               : SQLABORT           (procedure in FPWERROR.PRG)
*:               : IO_FAILED          (procedure in FPWERROR.PRG)
*:               : MEM_PROB           (procedure in FPWERROR.PRG)
*:               : KODEKORUP          (procedure in FPWERROR.PRG)
*:               : BADCHAIN           (procedure in FPWERROR.PRG)
*:               : BAD_API            (procedure in FPWERROR.PRG)
*:               : BADRIGHTS          (procedure in FPWERROR.PRG)
*:               : NOCREATE           (procedure in FPWERROR.PRG)
*:               : READ_ERR           (procedure in FPWERROR.PRG)
*:               : RITE_ERR           (procedure in FPWERROR.PRG)
*:               : TRANSACTN          (procedure in FPWERROR.PRG)
*:               : BADCLOSE           (procedure in FPWERROR.PRG)
*:               : BAD_OBJ            (procedure in FPWERROR.PRG)
*:               : NOTFOXWEXE         (procedure in FPWERROR.PRG)
*:               : VERBOSE            (procedure in FPWERROR.PRG)
*:               : BAD_RESRC          (procedure in FPWERROR.PRG)
*:               : NORUN              (procedure in FPWERROR.PRG)
*:               : BAD_OLE            (procedure in FPWERROR.PRG)
*:               : NO_OLE             (procedure in FPWERROR.PRG)
*:               : OLE_SAVE           (procedure in FPWERROR.PRG)
*:               : OLEKREATE          (procedure in FPWERROR.PRG)
*:               : KLIPBOARD          (procedure in FPWERROR.PRG)
*:               : BAD_WIN            (procedure in FPWERROR.PRG)
*:               : BADEXCEL           (procedure in FPWERROR.PRG)
*:               : ENKRYPTED          (procedure in FPWERROR.PRG)
*:               : BADSYMPH           (procedure in FPWERROR.PRG)
*:               : A_ONLY             (procedure in FPWERROR.PRG)
*:               : L_HIDE             (procedure in FPWERROR.PRG)
*:               : BAD_PARDX          (procedure in FPWERROR.PRG)
*:               : DNOACCES           (procedure in FPWERROR.PRG)
*:               : NOACCESS           (procedure in FPWERROR.PRG)
*:               : SNOACCES           (procedure in FPWERROR.PRG)
*:               : NO_CDX             (procedure in FPWERROR.PRG)
*:               : NOAPI              (procedure in FPWERROR.PRG)
*:               : NO_FLL             (procedure in FPWERROR.PRG)
*:               : NOSQLOPEN          (procedure in FPWERROR.PRG)
*:               : PROGBUG            (procedure in FPWERROR.PRG)
*:
*:           Uses: SYSDATA.DBF        
*:
*:      Documented 04/06/93 at 11:26               FoxDoc  version 2.10f
*:*****************************************************************************

*   PROGRAM: FPWERROR.PRG
*   VERSION: 1.03
*   AUTHOR:  Pat Adams, DB Unlimited  (718) 469-4032
*   DATE:    4/8/93
*
*
*   USE RESTRICTIONS: You may use FPWERROR and modifications
*   thereof as part of your custom applications without prior authorization
*   from DB Unlimited and without payment to DB Unlimited.  FPWERROR
*   may be freely distributed on electronic BBSes and via non-profit
*   user group disk libraries.
*
*   FPWERROR and modifications thereof may *NOT* be sold as shareware
*   or as a commercial product.  Use of the FPWERROR routine and modifi-
*   cations thereof in articles and books is reserved solely to DB Unlimited.
*
*   FPWERROR and modifications thereof may not be incorporated into
*   vertical market or commercial products without prior arrangement
*   with DB Unlimited.
*
*   NOTE: This routine is specific to FoxPro/Windows.  In some instances
*   FoxPro/Windows uses different error numbers for error conditons than
*   FoxPro 2.0.  Both the FoxPro 2.0 error numbers and the FoxPro 2.5
*   error numbers have been included to the extent possible.  However,
*   the original PROERROR.PRG should be used with FoxPro 1.x and
*   PRO2EROR should be employed with FoxPro 2.0.  FPW25EROR should be
*   used with FoxPro 2.5/DOS.
*
*   Information is stored to the FPWERROR.DBF file and then
*   the user is returned to master calling program if a RETRY
*   is not issued.  Please note that FPWERROR closes all files
*   and indexes before issuing a RETURN TO MASTER.  FPWERROR expects
*   that the MASTER level file will (re)initialize all necessary global
*   memvars, open databases and indexes, etc. as required for a
*   particular system.
*
*   When it is necessary to provide the user with the name and phone
*   number of an individual to call regarding an error the SYSDATA
*   database is opened and the record for the appropriate individual
*   is sought.  The titles supplied in the SYSDATA database which
*   accompanies this program should not be changed without modification
*   of the FPWERROR program.  The information for DEVELOPER is displayed
*   if the error is the result of a programming bug or syntax error.
*   Information for APP ADMINISTRATOR is called if files are missing
*   or other errors occur which require the attention of the applications
*   administrator.  LAN ADMINISTRATOR information is displayed if the
*   errors are related to specific LAN situations such as inappropriate
*   user authorizations on the LAN.
*
*   Because FoxPro/Windows is both single user and multi-user, unlike
*   earlier versions of the Fox product line, a logical .T. should
*   be placed in the MULTI_USER field of each record if your appli-
*   cation is multi-user.  If your application is for use in stand-
*   alone mode only then a logical .F. should be placed in this
*   field.  SYSDATA.DBF is delivered with a logical .T. in the
*   MULTI_USER field of each record.
*
*   DOS based LANs such as Novell Netware Lite, InvisibleNET and
*   LANtastic that utilize SHARE treat the #1705 error message
*   differently than Novell, Lan Man or Banyan.  Therefore, if your
*   application will be running on a LAN that utilizes SHARE the
*   DOS_LAN field in each record of the SYSDATA database should be
*   initialized to a logical .T.  FPWERROR will utilize the info in
*   this field to determine which error message will be presented
*   when error #1705 is encountered.  SYSDATA.DBF is delivered with
*   a logical .F. as the default value for the DOS_LAN file.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform Note:
*       When working in Windows on a standalone machine with SHARE
*       loaded, you may run multiple instances of FPD or FPW or both.
*       Error #1705 will occur if a user tries to use a file in one
*       instance which is in exclusive use in another instance.
*       Consequently, I changed this procedure to reflect that and
*       allow the user to retry.
*
*   Initializing a logical PUBLIC memvar named TESTING during test cycles
*   of your code will trigger an option in the STORE_IT module which
*   will provide you with the option of viewing the FPWERROR file at
*   the time the error condition occurs.  This module also permits
*   exit to DOS via use of the CONTROL-Q key combination.  If the
*   interactive version of FoxPro/Windows is in use the ESC key can be
*   used to return to the command window after viewing the error log.
*
*   Most modules make use of a READ for pushbuttons.  If you have
*   too many READs (5) already in effect those modules will bomb.
*   (Fixed with cross platform code -- nj)
*
*   SYS(13) always returns a logical .T. in FPW and PRNSTATUS() always
*   returns "READY" in FPW.  Therefore, there is no direct way to determine
*   whether a printer is on-line or not. The Windows Print Manager responds
*   to printer problems instead; they can not be captured by an ON ERROR
*   statement.  This assumes, of course, that the Windows print manager
*   is on when FoxPro/Windows is entered.
*
*   The font utilized for most FPWERROR windows is "Arial."  This assumes
*   that the Arial TrueType font is installed in MS-Windows.  In case
*   you do not like the Arial font or if Arial is not installed, the
*   FPW screen sets are included so you can easily change fonts and
*   generate your own screens.
*
*   You *MUST* hard code your name and phone number in procedure
*   VERBOSE for the reasons stated in the procedure file header.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform Note:
*       You will also want to hardcode the Windows alert message
*       title in the BugBox procedure. 
*
*	Modified by Tamar E. Granor 11/94
*		Changed call for 1705 to use a Mac-specific routine
*
*   Utilize the following command to set up this system to
*   respond to FoxPro/Windows errors:
*
*   ON ERROR DO FPWERROR WITH ERROR(), MESSAGE(), MESSAGE(1), ;
*      SYS(16), LINENO(), SYS(102), SYS(100), SYS(101), LASTKEY(), ;
*       ALIAS(), SYS(18), SYS(5), SYS(12), SYS(6), SYS(2003), WONTOP(), ;
*       SYS(2011), SYS(2018), SET("CURSOR")
*
*   or as an alternative:
*
*       [SET PROCEDURE TO FPWERROR]
*       DO erorset
*
*  Parameters are:
*
*   xerno =    The numeric code of the number provided by ERROR()
*   xmsg =     The error message provided by MESSAGE()
*   xkode =    The contents of the line of code which
*                 triggered the error as provided by MESSAGE(1)
*   xmodul =   The name of the code module, SYS(16)
*   xline =    The number of the line of code triggering the
*                 error, LINENO()
*   xprint =    Current PRINTER setting as per SYS(102)
*   xkonsol =   Current CONSOLE setting as per SYS(100)
*   xdevice =   Current DEVICE setting as per SYS(101)
*   keypress =  LASTKEY()
*   curr_dbf =  Selected .DBF when error occurred
*   getfield =  Field of GET...READ at time error occurred
*   def_drive = Default drive at time error occurred - SYS(5)
*   run_memry = Amount of DOS memory available for RUN command - SYS(12)
*   prnt_devic= Current SET PRINTER TO setting - SYS(6)
*   cur_direc = Current directory at time error occurred - SYS(2003)
*   top_win =   Top window at time error occurred
*   xlocked =   Record or file lock status at time error occurred -
*                 SYS(2011)
*   xmissing =  Missing file, window, etc.
*   curs_set =  Cursor setting at time error occurred.
*
*  In addition to this information, the routine saves the information
*  from LIST MEMORY and LIST STATUS is saved into the memo field.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS xerno, xmsg, xkode, xmodul, xline, xprint, ;
    xkonsol, xdevice, keypress, curr_dbf, getfield, def_drive, ;
    run_memry, prnt_devic, cur_direc, top_win, xlocked, ;
    xmissing, curs_set

IF xerno = 43 OR xerno = 809 OR xerno = 1809 OR xerno = ;
        845 OR xerno = 1845 OR xerno = 1149 OR xerno = ;
        1150 OR xerno = 1151 OR xerno = 1250 OR xerno = ;
        1281 OR xerno = 1310 OR xerno = 1600
    * ==============================
    *$ Insufficient memory
    *  User is returned to WINDOWS
    *  Modified by Nancy Jacobsen 5/93
    *  Original FPWERROR procedure
    *  retained for Windows (low_memW)
    *  Additional procedure for DOS
    *  (low_memD)
    * Mac needed
    * ==============================
    DO CASE
      CASE _Dos
        DO low_memd
    
      CASE _Windows
        DO low_memw
        
      CASE _Mac
        DO low_memm
    ENDCASE
    DO qquit
ENDIF (xerno = 43 OR xerno = 809 OR xerno = 1809 OR xerno = ;)

IF xerno = 21 OR xerno = 22
    * ==================================
    *$ String memory variable area overflow
    *$ Too many memory variables
    *
    *  The MVCOUNT statement in the
    *  CONFIG.FPW file needs to be increased.
    *
    *  This is placed in an IF/ENDIF rather
    *  than in the CASE statements so memvars
    *  used in the remainder of the modules
    *  can be initialized once for the CASE
    *  statements rather than in each module
    *  called.
    * ====================================
    DO upmvcount
    DO go_mastr
ENDIF (xerno = 21 OR xerno = 22)


PRIVATE tryagain, printit, kontinu, wincolor, pshbutton, ;
    m_call, m_title, m_phone,lcText,lcText2,lcMessage
* =================================================
*$ Initialize colors to be used in some message windows
* =================================================
STORE "RGB(,,,255,255,255)" TO wincolor
* ========================================
* NOTE: Do not change PSHBUTTON memvar
*       or the memvars M_CALL, M_TITLE
*       and M_PHONE.  They are used by
*       many of the modules in FPWERROR
* =======================================
STORE 1 TO pshbutton
STORE SPACE(0) TO m_call, m_title, m_phone
SET PRINT OFF
SET DEVICE TO SCREEN
STORE .F. TO tryagain
ON ERROR ?? CHR(7)
CLEAR TYPEAHEAD

IF xerno=181 OR xerno=182 OR xerno= ;
        279 OR xerno=4 OR xerno=1107 OR ;
        xerno=1164 OR (xerno=91 AND "RELEASE" $ xkode)
    * ===========================================================
    *$ Ignore these errors and continue with program execution
    *
    * Error #104 occurs when ON KEY LABEL calls to function keys
    * F11 and F12 are made on older keyboards which do not support
    * these keys.  It does not trap illegal SET FUNCTION x calls.
    *
    * Error #181, "MENU is already in use", occurs when an
    * attempt is made to activate a MENU which has already
    * been activated.
    *
    * Error #182, "POPUP is already in use", occurs when an
    * attempt is made to activate a POPUP which has already
    * been activated.
    *
    * Error #279, "Prompts for this popup have already been
    * defined" occurs when an attempt is made to use the BAR
    * option to define contents of a POPUP already defined
    * with PROMPT.
    *
    * Error #1107 = "Structural CDX file reference removed"
    *
    * Error #91 - "File was not LOADed"  An attempt was made to
    *              CALL a .BIN file which has not been loaded
    *              or RELEASE a .BIN file or .PLB that has not
    *              been loaded.  FPWERROR will ignore calls to
    *              RELEASE modules that are not loaded.
    *
    * Error #1164 - "Browse structure changed."
    *                The structure of a BROWSE window was
    *                changed by a BROWSE validation routine.
    * ===========================================================
    SET CONSOLE &xkonsol
    * =========================================
    * &macro substitution is utilized since
    * EVALUATE() does not work with SET commands
    * =========================================
    SET DEVICE TO &xdevice
    DO erorset
    * ==================================================
    * Ignore the error and return to the line of
    * code following the one which generated the error
    * ==================================================
    RETURN
ENDIF (xerno=181 OR xerno=182 OR xerno= ;)

IF xerno = 1726 OR xerno = 1642
    * =======================================================
    *$ Ignore error and continue with program.
    *
    *$ #1706 - API library not found.
    *          This error occurs when a SET
    *          LIBRARY TO or RELEASE LIBRARY has been
    *          issued and the .FLL is not been loaded.
    *          (If .FLL can not be found error #1
    *          is generated.)
    *
    *$ #1642 - COLORSET resource not found
    * =============================================
    SET CONSOLE &xkonsol
    SET DEVICE TO &xdevice
    DO erorset
    RETURN
ENDIF (xerno = 1726 OR xerno = 1642)

SET TALK OFF
SET PRINT OFF
SET PRINTER TO prn
SET DEVICE TO SCREEN

DO CASE xerno
    CASE xerno = 1 OR xerno = 802 OR xerno = ;
            1162 OR xerno = 1802
        * =================================================
        *$ File does not exist or can not be found.
        *  Error #1 applies to standard FoxPro file while
        *  error #802 or #1802 specifically references a SQL table
        *  Error #1162 applies to an unfound PROCEDURE
        *  Error #1802 applies to a SQL table or .DBF
        *  Pop up window to inform user
        * =================================================
        DO no_file WITH xmissing
        DO go_mastr
        
    CASE xerno = 3 OR xerno = 108 OR xerno = 1503
        * ============================================================
        *$ Advise user file is in use and provide option to try again
        *  NOTE: This case statement can be omitted for single user aps
        *        since it will only be triggered in a multi-user
        *        environment where someone else has a file in
        *        EXCLUSIVE use.
        * ============================================================
        DO file_busy WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the file
            * =============================
            DO go_again
            SET CURSOR &curs_set
            RETRY
        ELSE
            * ============================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FPWERROR database
            *  to provide a log of how often LAN users can
            *  not get use of a file.  If this situation
            *  occurs frequently it may mean that others on
            *  the LAN are using files interactively with
            *  EXCLUSIVE ON, or that the source code needs to be
            *  rewritten to avoid such frequent contentions.
            * ============================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 5
        * =======================================
        *$ Record is out of range
        *  Advise user & return to MASTER module
        * =======================================
        DO too_high
        DO go_mastr
        
    CASE xerno = 6
        * =====================
        *$ Too many files open
        * =====================
        DO lowfiles
        DO go_mastr
        
    CASE xerno = 15 OR xerno = 1111
        * ================================
        *$ # 15 - Database is trashed
        *$ #1111 - Invalid file descriptor
        * ================================
        DO realbad
        DO go_mastr
        
    CASE xerno = 19 OR xerno = 20 OR xerno = ;
            114 OR xerno = 1141 OR xerno = 1683 OR xerno = 1103
        * ==============================================
        *$ Index error problems - Recreate indexes
        * ==============================================
        DO index_er
        DO setenvmt
        DO save_it
        * ==============
        *$ Quit to DOS
        * ==============
        DO qquit
        
    CASE xerno = 38
        * ==============================================
        *$ Attempt has been made to position record
        *  pointer before the first record in the file.
        *  Correct by going to top of file, skipping down
        *  one record, then retrying the same command line.
        * ==============================================
        GO TOP
        SKIP
        DO go_again
        RETRY
        
    CASE xerno = 39
        * =========================================
        *$ Numeric overflow (data was lost)
        * =========================================
        DO toobig
        DO go_mastr
        
    CASE xerno = 41
        * =========================================
        *$ Missing or invalid MEMO file
        *  NOTE: Depending upon the application,
        *  it may be desirable to modify this
        *  CASE statement to return the user to DOS
        * =========================================
        DO nomemo
        DO go_mastr
        
    CASE xerno = 50 OR xerno = 54 OR xerno = 1241 ;
            OR xerno = 1243 OR xerno = 1245 OR ;
            xerno = 1246 OR xerno = 1645 OR ;
            xerno = 1646 OR xerno = 1647 OR xerno = 1653
        * ===============================================
        *$ Report form or label form problems
        * ===============================================
        DO bad_rpt WITH xerno
        DO go_mastr
        
    CASE xerno = 55
        * ======================
        *$ Invalid .MEM file
        * ======================
        DO badmemfl
        * ==================================
        * NOTE: If info in the .MEM file is
        * necessary for the entire application
        * this should be changed so user is
        * returned to Windows
        * =================================
        DO go_mastr
        
    CASE xerno = 56
        * =========================================
        *$ Out of disk space error.  Return to Windows
        * =========================================
        STORE .F. TO printit
        DO nospace WITH printit
        
        IF printit
            * ============================
            * Send error info to printer
            * ============================
            DO to_prn
        ENDIF (printit)
        * ======================================
        *$ Quit to DOS - No attempt is
        *$ made to close databases since
        *$ the error condition may preclude it
        * ======================================
        SET CURSOR ON
        SET COLOR TO W/N
        CLEAR
        SET CLEAR OFF && Suppresses "Normal Shutdown" message
        QUIT
        
    CASE xerno = 67 OR xerno = 1309
        * ====================================
        *$ Expression evaluator fault.
        *$ Object file corrupted
        * ====================================
        DO korrupt
        DO go_mastr
        
    CASE xerno = 109 OR xerno = 130 OR xerno = 1502
        * ========================================
        *$ Record is locked by another user
        *$ Record is not locked
        *$ Record is in use: Cannot write
        *  Inform user & provide option to retry
        * ========================================
        DO rec_busy WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the record
            * =============================
            DO go_again
            GO RECNO()
            RETRY
        ELSE
            * ============================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FPWERROR database
            *  to provide a log of how often LAN users can
            *  not get use of a record.  If this situation
            *  occurs frequently it may mean that a
            *  different methodology is required in the
            *  source code to prevent a high incidents of
            *  contentions.
            * ============================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 111 OR xerno = 1718
        * ===============================================
        *$ Attempt was made to write to a read-only file
        * ===============================================
        IF ! USED("SYSDATA")
            SELECT 0
            USE sysdata NOUPDATE
        ELSE
            SELECT sysdata
        ENDIF (! USED("SYSDATA"))
        
        IF sysdata.multi_user
            * ==============================
            * If we're on a LAN call up
            * the LAN version of message
            * ==============================
            DO lreadonly
            DO go_mastr
        ELSE
            * =====================================
            * If user is working in stand-alone mode
            * =====================================
            DO readonly
            DO go_mastr
        ENDIF (sysdata.multi_user)
        
    CASE xerno = 115 OR xerno = 116 OR xerno = 117
        * =========================================
        *$ Invalid DIF file header
        *$ Invalid DIF vector/DBF field mismatch
        *$ Invalid DIF type indicator
        * =========================================
        DO bad_dif
        DO go_mastr
        
    CASE xerno = 119 OR xerno = 120 OR xerno = ;
            121 OR xerno = 1670
        * ================================================
        *$ #119 - Invalid SYLK file header
        *$ #120 - Invalid SYLK file dimension bounds
        *$ #121 - Invalid SYLK file format
        *$ #1670 - Invalid Multiplan v 4.0 format
        * ================================================
        DO bad_sylk
        DO go_mastr
        
    CASE xerno = 176 OR xerno = 177
        * =======================================
        *$ Error #176 - Cannot clear menu in use
        *$ Error #177 - Cannot clear popup in use
        *
        *  Attempt was made to CLEAR or RELEASE
        *  MENU or POPUP which has not been
        *  deactivated.  Simply DEACTIVATE and
        *  RETRY the command.
        * =======================================
        IF xerno = 176
            DEACTIVATE MENU
        ELSE
            DEACTIVATE POPUP
        ENDIF (xerno = 176)
        
        DO go_again
        RETRY
        
    CASE xerno = 255 OR xerno = 256
        * ===========================================
        *$ Not a valid RapidFile or Framework II file
        * ===========================================
        DO notright WITH xerno
        DO go_mastr
        
    CASE xerno = 297 OR xerno = 1662 OR xerno = 1678
        * ======================================
        *$ Invalid Lotus 1-2-3 version X file
        * ======================================
        DO badlotus WITH xerno
        DO go_mastr
        
    CASE xerno = 392
        * ===============================================
        *$ Maximum record length exceeded in import file
        * ===============================================
        DO rec2big
        DO go_mastr
        
    CASE xerno = 800 OR xerno = 1800
        * =======================
        *$ SQL Internal Error
        * =======================
        DO sql_intl
        DO setenvmt
        DO save_it
        * =============
        *$ Quit to DOS
        * =============
        DO qquit
        
    CASE xerno = 821 OR xerno = 1821
        * ========================================
        *$ Temporary SQL file has been corrupted
        * ========================================
        DO sqltrash
        DO go_mastr
        
    CASE xerno = 830 OR xerno = 1830
        * =========================
        *$ SQL index not found
        * =========================
        DO nosqlidx
        DO go_mastr
        
    CASE xerno = 831 OR xerno = 1831
        * ==================================
        *$ SQL err building temporary index
        * ==================================
        DO sql_idx
        * ======================================
        *$ Quit to Windows
        * ======================================
        DO qquit
        
    CASE xerno = 839 OR xerno = 1839
        * =======================================
        *$ User pressed ESC during SQL operation
        * =======================================
        STORE .F. TO kancel
        DO sqlabort WITH kancel
        
        IF kancel
            * ============================
            *$ Return to Main Menu if user
            *$ really wants to abort
            * ============================
            DO go_mastr
        ELSE
            * ============================
            *$ Otherwise retry query
            * ============================
            DO go_again
            RETRY
        ENDIF (kancel)
        
    CASE xerno = 1002
        * =================================
        *$ I/O operation failure
        *  DOS is unable to perform a file
        *  or hardware operation.
        * =================================
        DO io_failed
        DO setenvmt
        DO save_it
        * =============
        *$ Quit to Windows
        * =============
        DO qquit
        
    CASE xerno = 1003 OR xerno = ;
        1004 OR xerno = 1005 OR xerno = ;
        1006 OR xerno = 1009 OR xerno = ;
        1011 OR xerno = 1000 OR xerno = 1296
        * ==============================
        *$ Free handle not found
        *$ Use of invalid handle
        *$ Use of unallocated handle
        *$ Use of transgressed handle
        *$ Incorrect handle found during compaction
        *$ Area can not contain handle
        *$ Internal consistency error
        *$ Error reading resource
        *
        *  Advise user of memory problems
        *  and quit to Windows
        * ==============================
        DO mem_prob
        DO setenvmt
        DO save_it
        * =====================
        *$ Quit to DOS
        * =====================
        DO qquit
        
    CASE xerno = 1007 OR xerno = ;
            1008 OR xerno = 1010
        * ======================================
        *$ #1007 - Transgressed node found during compaction
        *$ #1008 - Foreign node found during compaction
        *$ #1010 - Area size exceeded during compaction
        *
        * Advise user compiled code may have been
        * corrupted and return to Windows.
        * ========================================
        DO kodekorup
        DO setenvmt
        DO save_it
        * =====================
        *$ Quit to DOS
        * =====================
        DO qquit
        
    CASE xerno = 1012
        * =========================================
        *$ OS free memory chain has been scrambled.
        *  The only solution is to return to Windows.
        * =========================================
        DO badchain
        DO setenvmt
        DO save_it
        * =============
        *$ Quit to Windows
        * =============
        DO qquit
        
    CASE xerno = 1098
        * ======================================
        *$ API function _UserError() was called
        *  There is a problem in the API library
        *  being utilized
        * ======================================
        DO bad_api
        DO go_mastr
        
    CASE xerno = 1101 OR xerno = 101
        * ====================
        *$ Cannot open file
        * ====================
        DO badrights
        DO qquit
        
    CASE xerno = 1102 OR xerno = 1157 OR xerno = ;
            1410 OR xerno = 102 OR xerno = 1160
        * ==================================
        *$ Can not create file or update file
        * ==================================
        DO nocreate
        * ============================
        *$ Send error info to printer
        * ============================
        DO to_prn
        DO qquit
        
    CASE xerno = 1104
        * =====================
        *$ File read error
        * =====================
        DO read_err WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the file
            * =============================
            DO go_again
            RETRY
        ELSE
            * =======================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FPWERROR database
            * =======================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 1105
        * ===================
        *$ File write error
        * ===================
        DO rite_err WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the file
            * =============================
            DO go_again
            RETRY
        ELSE
            * =======================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FPWERROR database
            * =======================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 1106
        * ======================================
        *$ Transaction in progress
        *  For Novell TTS only
        * ======================================
        DO transactn WITH tryagain
        
        IF tryagain
            * =============================
            *$ Retry for use of the file
            * =============================
            DO go_again
            RETRY
        ELSE
            * =======================================
            *$ Abort and return to the MASTER module
            *  Information is saved to FPWERROR database
            * =======================================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 1112
        * =====================
        *$ File close error
        * =====================
        DO badclose WITH tryagain
        
        IF tryagain
            * =============================
            *$ Try to close the file again
            * =============================
            DO go_again
            RETRY
        ELSE
            * =======================================
            *$ Abort to DOS
            *  Information is saved to FPWERROR database
            * =======================================
            DO setenvmt
            DO save_it
            DO qquit
        ENDIF (tryagain)
        
    CASE xerno = 1154 OR xerno = 1155
        * ======================================
        *$ #1154 - Invalid buffpoint call
        *$ #1155 - Invalid buffdirty call
        * =======================================
        DO mem_prob
        DO setenvmt
        DO save_it
        * =====================
        *$ Quit to Windows
        * =====================
        DO qquit
        
    CASE xerno = 1190 OR xerno = ;
            1192 OR xerno = ;
            1691 OR xerno = 1711
        * ====================================
        *$ Invalid .LIB signature
        *$ Internal .LIB undefined symbol error
        *$ Library file is invalid
        *$ API library revision mismatch.
        * =====================================
        DO bad_api
        DO go_mastr
        
    CASE xerno = 1195 OR xerno = 1309
        * ===================================
        *$ Object file is the wrong version.
        *$ <file> is not an object file
        * ===================================
        DO bad_obj
        DO go_mastr
        
    CASE xerno = 1196
        * ======================================
        *$ <file> is not a FoxPro Windows .EXE file
        * ======================================
        DO notfoxwexe
        DO go_mastr
        
    CASE xerno = 1201 OR xerno = 1308
        * =====================================
        *$ Too many names used (1201)
        *$ or stack overflow (1308)
        *  Since the NAMES table has been
        *  exhausted it will may not be
        *  possible to open the SYSDATA or
        *  FPWERROR databases to save the info
        * =====================================
        STORE .F. TO printit
        DO verbose WITH printit
        
        IF printit
            * ============================
            * Send error info to printer
            * ============================
            DO to_prn
        ENDIF (printit)
        * ===============
        *$ Quit to Windows
        * ===============
        DO qquit
        
    CASE xerno = 1294
        * ===========================
        *$ FOXUSER file is invalid
        * ===========================
        DO bad_resrc
        DO save_it
        DO qquit
        
    CASE xerno = 1405
        * ========================
        *$ RUN/! command failed
        * ========================
        DO norun
        DO go_mastr
        
    CASE xerno = 1420
        * ===================================
        *$ Invalid or corrupted OLE object
        * ===================================
        DO bad_ole
        DO go_mastr
        
    CASE xerno = 1421
        * ===================================
        *$ Cannot activate OLE server
        * ===================================
        DO no_ole
        DO go_mastr
        
    CASE xerno = 1422
        * ===================================
        *$ Error saving OLE object
        * ===================================
        DO ole_save
        DO go_mastr
        
    CASE xerno = 1423
        * ===================================
        *$ Error creating OLE object
        * ===================================
        DO olekreate
        DO go_mastr
        
    CASE xerno = 1424
        * =======================================
        *$ Error copying OLE object to clipboard
        *
        *  User is provided with option to retry
        *  the operation that created the error.
        * =======================================
        DO klipboard WITH tryagain
        
        IF tryagain
            * =============================
            *$ User has elected to try again
            * =============================
            DO go_again
            RETRY
        ELSE
            * =============================
            *$ Otherwise return to main menu
            * =============================
            DO go_mastr
        ENDIF (tryagain)
        
    CASE xerno = 1462
        * ==================================
        *$ File internal consistency error
        *
        *  Advise user of memory problems
        *  and quit to Windows
        * ==============================
        DO mem_prob
        DO setenvmt
        DO save_it
        * =====================
        *$ Quit to DOS
        * =====================
        DO qquit
        
    CASE xerno = 1632
        * =========================================
        *$ Invalid WINDOW file format (.WIN file)
        * Advise user file has been corrupted and
        * return them to main menu
        * =========================================
        DO bad_win
        DO go_mastr
        
    CASE xerno = 1661
        * =========================================
        *$ Invalid Excel version 2.0 file format
        * =========================================
        DO badexcel
        DO go_mastr
        
    CASE xerno = 1671 OR xerno = 1672
        * ===========================================
        *$ Cannot import from a password protected file
        *$ Cannot append from a password protected file
        * ============================================
        DO enkrypted
        DO go_mastr
        
    CASE xerno = 1673 OR xerno = 1674
        * ========================================
        *$ Invalid Symphony version X file format
        * ========================================
        DO badsymph WITH xerno
        DO go_mastr
        
    CASE xerno = 1679
        * ===========================================
        *$ Import only Worksheet A for Lotus 1-2-3
        *  version 3.0 files.
        *
        *  Inform user and provide options to
        *  continue or abort
        * ===========================================
        STORE .F. TO kontinu
        DO a_only WITH kontinu
        
        IF kontinu
            SET CONSOLE &xkonsol
            SET DEVICE TO &xdevice
            DO erorset
            RETURN
        ELSE
            DO go_mastr
        ENDIF (kontinu)
        
    CASE xerno = 1680
        * =========================================
        *$ Worksheet A for Lotus 1-2-3 v 3.0 is hidden
        * =========================================
        DO l_hide
        DO go_mastr
        
    CASE xerno = 1688
        * ===========================================
        *$ Invalid Paradox v 3.5 file format
        * ===========================================
        DO bad_pardx
        DO go_mastr
        
    CASE xerno = 1705
        * ========================================
        *$ File access denied
        *
        *  If user is on a DOS based LAN s/he
        *  is provided with option to retry for
        *  use of the file.  Otherwise, routine
        *  is aborted & return to MASTER module
        * ========================================
        IF ! USED("SYSDATA")
            SELECT 0
            USE sysdata NOUPDATE
        ELSE
            SELECT sysdata
        ENDIF (! USED("SYSDATA"))
        
        DO CASE
        	CASE _MAC
                * ============================================
                * On a Mac
                * ============================================
                STORE .F. TO re_try
                DO mnoacces WITH re_try
                
                IF ! re_try
                    DO go_mastr
                ELSE
                    DO go_again
                    RETRY
                ENDIF (! re_try)
            CASE sysdata.multi_user AND sysdata.dos_lan 
                * =========================================
                * In multi-user mode on a DOS based LAN
                * where DOS SHARE is utilized.  Provide
                * user with option to retry for use of file.
                * =========================================
                STORE .F. TO re_try
                DO dnoacces WITH re_try
                
                IF ! re_try
                    DO go_mastr
                ELSE
                    DO go_again
                    RETRY
                ENDIF (! re_try)
                
            CASE sysdata.multi_user AND ! sysdata.dos_lan 
                * ============================================
                * In multi-user mode on a non-DOS based LAN
                * such as Novell 286/386, Banyan, Lan Man
                * ============================================
                DO noaccess
                DO go_mastr
                
            CASE ! sysdata.multi_user 
                * ============================================
                * Working in stand-alone mode
                * ============================================
                STORE .F. TO re_try
                DO snoacces WITH re_try
                
                IF ! re_try
                    DO go_mastr
                ELSE
                    DO go_again
                    RETRY
                ENDIF (! re_try)
        ENDCASE
        DO go_mastr
        
    CASE xerno = 1707
        * ================================================
        *$ Structural .CDX is missing & must be recreated
        * ================================================
        DO no_cdx
        DO setenvmt
        DO save_it
        * ==============
        *$ Quit to Windows
        * ==============
        DO qquit
        
    CASE xerno = 1709
        * =================================
        *$ Cannot load 16-bit API interface
        * =================================
        DO noapi
        DO qquit
        
    CASE xerno = 1726
        * ==================================
        *$ API library not found
        *  A SET LIBRARY TO was issued but the
        *  .FLL can not be found OR a RELEASE
        *  LIBRARY command was issued and the
        *  .FLL can not be found.  An earlier
        *  IF clause checks to see if "RELEASE"
        *  was included in the command that
        *  generated the error, so we know at
        *  this point that the .FLL can not
        *  be found.  User is returned to the
        *  main menu.
        * ===================================
        DO no_fll
        DO go_mastr
        
    CASE xerno = 823 OR xerno = 1823
        * ============================================
        *$  Error 823 or 1823 is generated when a SQL
        *   open of a specific file fails.
        *   Abort & return to master
        * ==========================================
        DO nosqlopen
        DO go_mastr
        
    OTHERWISE
        DO progbug
        DO go_mastr
ENDCASE  xerno
* End procedure FPWERROR



*!*****************************************************************************
*!
*!      Procedure: GO_MASTR
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: SETENVMT           (procedure in FPWERROR.PRG)
*!               : SAVE_IT            (procedure in FPWERROR.PRG)
*!               : ERORSET            (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE go_mastr
*******************************************************************************
* Save info to FPWERROR database, reset
* environmentals and return to master module
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/20/91
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DO setenvmt
* ==============================
*$ Save info to FPWERROR database
* ==============================
DO save_it
DO erorset
CLEAR GETS
CLEAR READ ALL
* ==================================
*$ Release all non-public memvars
* ==================================
RELEASE ALL
RELEASE lstext, lmtext
CLEAR TYPEAHEAD
SET CURSOR &curs_set
RETURN TO MASTER
* End procedure GO_MASTR



*!*****************************************************************************
*!
*!      Procedure: SETENVMT
*!
*!      Called by: FPWERROR.PRG                      
*!               : GO_MASTR           (procedure in FPWERROR.PRG)
*!
*!          Calls: USTRING            (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE setenvmt
*******************************************************************************
*& Change full range of environmentals
*  in anticipation of a RETURN TO MASTER
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/24/91
*
*   Modified 1/11/93 by Pat Adams
*       Dynamic naming changed to USTRING()
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE disk_space
STORE DISKSPACE() TO disk_space
SET CONSOLE OFF
* =====================================
* Create a program tree 20 levels deep
* =====================================
FOR xx = 1 TO 20
    nextlevl = "PROGTREE" + ALLTRIM(TRANSFORM(xx, "@Z 99"))
    STORE SYS(16, xx) TO &nextlevl
    
    IF EMPTY(SYS(16,xx))
        EXIT
    ENDIF (EMPTY(SYS(16,xx)))
ENDFOR (xx)

PUBLIC lstext, lmtext
STORE ustring() + ".TXT" TO lstext
LIST STATUS TO (lstext)
* ==================================================
*$ Create files which hold information from LIST STATUS
*$ and LIST MEMORY prior to closing files, etc.
* ==================================================
STORE ustring() + ".TXT" TO lmtext
LIST MEMORY TO (lmtext)
SET CONSOLE ON
* =================================================
* Re-initialize environment for defaults prior to
* commencing any of the following activities
* =================================================
ON KEY   && Null out hot keys
CLEAR GETS
CLEAR READ ALL
CLEAR FIELDS
CLEAR MACROS
CLEAR WINDOWS
DEACTIVATE MENUS
CLEAR MENUS
DEACTIVATE POPUPS
CLEAR POPUPS
CLEAR PROMPT
UNLOCK ALL
SET DEVICE TO SCREEN
CLOSE DATA
SET TALK OFF
SET ESCAPE OFF
SET CURSOR OFF
RETURN
* End procedure SETENVMT


*!*****************************************************************************
*!
*!      Procedure: SAVE_IT
*!
*!      Called by: FPWERROR.PRG                      
*!               : GO_MASTR           (procedure in FPWERROR.PRG)
*!
*!          Calls: LOGVIEW            (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!               : FPWERROR.DBF       
*!
*!*****************************************************************************
PROCEDURE save_it
*******************************************************************************
*& Store error info to FPWERROR database
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/29/91
*
*   Modified by Pat Adams 9/10/91
*       Bug fix - Corrected by adding SET CONSOLE ON
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDTA added
*
*   Modified 2/5/93 by Pat Adams
*       Code changed to use FoxPro/Windows format
*       and a .BMP file in the window.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross-platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
*-- Window "Moment" replaced by Wait Window
WAIT WINDOW "One moment please..."  nowait
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    PRIVATE uname
    STORE GETENV("USER") TO uname
ENDIF (sysdata.multi_user)
* ==========================
*$ Store info to error file
* ==========================
IF ! USED("FPWERROR")
    SELECT 0
    USE fpwerror
ELSE
    SELECT fpwerror
ENDIF (! USED("FPWERROR"))

SET CONSOLE OFF
APPEND BLANK
REPLACE er_no WITH xerno, er_msg WITH xmsg, ;
    kode WITH xkode, mmodul WITH xmodul, ddate ;
    WITH DATE(), ttime WITH TIME(), line_no WITH xline

IF TYPE("UNAME") <> "U" .AND. ! EMPTY(uname)
    REPLACE lan_user WITH uname
ELSE
    REPLACE lan_user WITH "NOT AVAILABL"
ENDIF (TYPE("UNAME") <> "U" .AND. ! EMPTY(uname))
* ==================================================
*$ Put info from the files created with LIST MEMORY
*$ and LIST STATUS into the memo field and then
*$ erase the text files
* ==================================================
*-- Capture version 
REPLACE notes with VERSION(1)+CHR(13)+CHR(10)
APPEND MEMO notes FROM (lstext)
ERASE (lstext)
APPEND MEMO notes FROM (lmtext)
ERASE (lmtext)
SET CONSOLE ON

IF TYPE("TESTING") <> "U"
    * =================================================
    *$ If memvar TESTING has been initialized at a higher
    *$ level provide developer/programmer with option to
    *$ view error log file now
    * =================================================
    IF testing
        DO logview
    ENDIF (testing)
ENDIF (TYPE("TESTING") <> "U")

CLOSE DATA
*-- 
WAIT CLEAR
RETURN
* End procedure save_it



*!*****************************************************************************
PROCEDURE no_file
*******************************************************************************
*& Error #1 - File does not exist or can not be found
*& Error #802 & 1802 - SQL database file can not be found
*& Error #1162 - PROCEDURE can not be found
*
*     The passed parameter is the name of the missing item
*
*  NOTE: This routine assumes that FULLPATH is OFF.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/4/91
*
*   Modified by Pat Adams 2/8/93
*       Code changed to FoxPro/Windows format
*       and differentiation of person to call
*       based upon single user vs. LAN environment
*       added.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross-platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS not_there
STORE UPPER(ALLTRIM(not_there)) TO not_there

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ========================================
    *$ Get info on appropriate person to call
    * ========================================
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)

ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText="The following file is missing:" +CHR(13)+CHR(13)+ ;
        PADC(not_there,60)+CHR(13)+CHR(13)+ ;
        "Please report this problem to:" +CHR(13)+CHR(13)
        
lcText2=SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone +CHR(13)
DO uhoh
=BUGBOX(lcText,'Stop','OK','BAD NEWS',lcMessage)
CLEAR TYPEAHEAD
RETURN
* End procedure NO_FILE


*!*****************************************************************************
*!
*!      Procedure: UHOH
*!
*!      Called by: LOW_MEM            (procedure in FPWERROR.PRG)
*!               : UPMVCOUNT          (procedure in FPWERROR.PRG)
*!               : NO_FILE            (procedure in FPWERROR.PRG)
*!               : TOO_HIGH           (procedure in FPWERROR.PRG)
*!               : LOWFILES           (procedure in FPWERROR.PRG)
*!               : INDEX_ER           (procedure in FPWERROR.PRG)
*!               : TOOBIG             (procedure in FPWERROR.PRG)
*!               : NOMEMO             (procedure in FPWERROR.PRG)
*!               : BAD_RPT            (procedure in FPWERROR.PRG)
*!               : BADMEMFL           (procedure in FPWERROR.PRG)
*!               : NOSPACE            (procedure in FPWERROR.PRG)
*!               : KORRUPT            (procedure in FPWERROR.PRG)
*!               : LREADONLY          (procedure in FPWERROR.PRG)
*!               : READONLY           (procedure in FPWERROR.PRG)
*!               : BAD_DIF            (procedure in FPWERROR.PRG)
*!               : BAD_SYLK           (procedure in FPWERROR.PRG)
*!               : NOTRIGHT           (procedure in FPWERROR.PRG)
*!               : BADLOTUS           (procedure in FPWERROR.PRG)
*!               : REC2BIG            (procedure in FPWERROR.PRG)
*!               : SQL_INTL           (procedure in FPWERROR.PRG)
*!               : SQLTRASH           (procedure in FPWERROR.PRG)
*!               : NOSQLIDX           (procedure in FPWERROR.PRG)
*!               : SQL_IDX            (procedure in FPWERROR.PRG)
*!               : SQLABORT           (procedure in FPWERROR.PRG)
*!               : IO_FAILED          (procedure in FPWERROR.PRG)
*!               : MEM_PROB           (procedure in FPWERROR.PRG)
*!               : KODEKORUP          (procedure in FPWERROR.PRG)
*!               : BADCHAIN           (procedure in FPWERROR.PRG)
*!               : BAD_API            (procedure in FPWERROR.PRG)
*!               : BADRIGHTS          (procedure in FPWERROR.PRG)
*!               : NOCREATE           (procedure in FPWERROR.PRG)
*!               : READ_ERR           (procedure in FPWERROR.PRG)
*!               : RITE_ERR           (procedure in FPWERROR.PRG)
*!               : BAD_OBJ            (procedure in FPWERROR.PRG)
*!               : NOTFOXWEXE         (procedure in FPWERROR.PRG)
*!               : VERBOSE            (procedure in FPWERROR.PRG)
*!               : BAD_RESRC          (procedure in FPWERROR.PRG)
*!               : OLE_SAVE           (procedure in FPWERROR.PRG)
*!               : BAD_WIN            (procedure in FPWERROR.PRG)
*!               : BADEXCEL           (procedure in FPWERROR.PRG)
*!               : BADSYMPH           (procedure in FPWERROR.PRG)
*!               : DNOACCES           (procedure in FPWERROR.PRG)
*!               : NOACCESS           (procedure in FPWERROR.PRG)
*!               : SNOACCES           (procedure in FPWERROR.PRG)
*!               : NO_CDX             (procedure in FPWERROR.PRG)
*!               : NOAPI              (procedure in FPWERROR.PRG)
*!               : NO_FLL             (procedure in FPWERROR.PRG)
*!               : NOSQLOPEN          (procedure in FPWERROR.PRG)
*!               : PROGBUG            (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE uhoh
*******************************************************************************
*   Courtesy of Hallie Steiner Cooper, age 4
*   and Lisa Slater
*
*	Modified 1/24/93 by Pat Adams
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET BELL TO 328,3
?? CHR(7)
SET BELL TO 261,8
?? CHR(7)
SET BELL TO
RETURN
* End procedure UHOH


*!*****************************************************************************
*!
*!      Procedure: LOGVIEW
*!
*!      Called by: SAVE_IT            (procedure in FPWERROR.PRG)
*!
*!          Calls: MEMOVIEW           (procedure in FPWERROR.PRG)
*!               : QQUIT              (procedure in FPWERROR.PRG)
*!               : KANCEL             (procedure in FPWERROR.PRG)
*!               : ERORSET            (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE logview
*******************************************************************************
*& View error log if user so requests
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/2/91
*
*   Modified 8/16/91 by Pat Adams
*     F2 KEY LABEL setting stored & then reinitialized
*     to original setting
*
*   Modified by Pat Adams 8/19/91
*     Existing ON KEY LABELs changed to SHIFT-Fx
*     to avoid conflicts with more commonly used
*     function keys.
*
*   Modified by Pat Adams 8/22/91
*      Use of ESC key to return to command window
*      if in interactive version of FoxPro 2.0 added
*
*   Modified by Pat Adams 12/16/91
*      Problems with cursor settings corrected
*
*   Modified 2/9/93 by Pat Adams
*       Code modified for FoxPro/Windows
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE do_it, scheme10, cursset, sf2key, sf9key, cqkey, ;
    esckey, escstat, ttitle, clockset
STORE 1 TO do_it
STORE SET("CURSOR") TO cursset
ACTIVATE SCREEN
lcMessage='Enter Y for Yes, N for No.'
lcText="Would you like to view the error log file now?"
do_it=BUGBOX(lcText,'Qmark','Yes','',lcMessage)

IF do_it
    *-- SET COLOR OF SCHEME screws up colors in WINDOWS
    *STORE SCHEME(10) TO scheme10
    *SET COLOR OF SCHEME 10 TO +W/N, N/W, +W/+R, R/W, R/W, N/W, N/W
    SET CURSOR ON
    * ==========================================
    *$ Store any ON KEY LABEL SHIFT-F2 setting
    *  and initialize for exit of BROWSE/MEMO
    * ==========================================
    STORE ON("KEY", "SHIFT-F2") TO sf2key
    ON KEY LABEL shift-f2 KEYBOARD CHR(23) && EXIT from BROWSE
    * ==========================================
    *$ Store any ON KEY LABEL SHIFT-F9 setting
    *  and initialize for exit of BROWSE/MEMO
    * ==========================================
    STORE ON("KEY", "SHIFT-F9") TO sf9key
    ON KEY LABEL shift-f9 DO memoview && OPEN window & view memo field
    * ===========================================
    *$ Store any ON KEY LABEL CTRL-Q TO cqkey
    *  and initialize for return to DOS
    * ===========================================
    STORE ON("KEY", "CTRL-Q") TO cqkey
    ON KEY LABEL ctrl-q DO qquit
    ttitle = IIF("EXE" $ VERS(1), "", "ESC=" + ;
        "Command Window,  ") + "Shift-F9=Stats,  " + ;
        "Shift-F2=Exit,  Ctrl-Q=Exit to DOS"
    *-- Row 0 is under the menu bar in FP/DOS
    *-- Use BROWSE COLORS, use SYSTEM border for full height titles
    *-- A Font clause should be added for international users
    *-- Titles changed to lower case
    DEFINE WINDOW browin FROM 1,0 TO 24,WCOLS()-1 SYSTEM ;
        TITLE ' &ttitle ' FLOAT ZOOM GROW COLOR SCHEME 10 
    DEFINE WINDOW memwin FROM 7,0 TO 21,WCOLS()-1 SYSTEM ;
        TITLE ' Press Shift-F2 to Exit ' FLOAT GROW ZOOM COLOR SCHEME 10 
    STORE SET("CLOCK") TO clockset
    SET CLOCK OFF
    
    IF ! "EXE" $ VERS(1)
        * ===============================================
        *$ If working in interactive development version
        *$ provide opportunity to press ESC to return to
        *$ command window
        * ===============================================
        STORE ON("KEY", "ESC") TO esckey
        STORE SET("ESCAPE") TO escstat
        SET ESCAPE ON
        ON KEY LABEL esc DO kancel
    ENDIF (! "EXE" $ VERS(1))
    
    SET REFRESH TO 200,200
    *-- BROWSE LAST in case user has preferance
    BROWSE WINDOW browin LAST
    * =========================================
    *$ Restore previous ON KEY LABEL settings
    * =========================================
    ON KEY LABEL f2 &sf2key
    ON KEY LABEL f9 &sf9key
    ON KEY LABEL ctrl-q &cqkey
    SET CLOCK &clockset
    CLEAR TYPEAHEAD
    
    IF ! "EXE" $ VERS(1)
        ON KEY LABEL esc &esckey
        SET ESCAPE &escstat
    ENDIF (! "EXE" $ VERS(1))
    
    SET REFRESH TO 0, 200
    CLEAR WINDOWS
    SET STATUS OFF
    *SET COLOR OF SCHEME 10 TO &scheme10
    SET CURSOR &cursset
ENDIF (do_it)

DO erorset
RETURN
* End procedure LOGVIEW

*!*****************************************************************************
*!
*!      Procedure: MEMOVIEW
*!
*!      Called by: LOGVIEW            (procedure in FPWERROR.PRG)
*!               : MEMOVIEW           (procedure in FPWERROR.PRG)
*!
*!          Calls: MEMOVIEW           (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE memoview
*******************************************************************************
*& Open large window to view memo field info in error log
*
*  Routine assumes the F2 key has been enabled at a higher
*  level to exit the window and that window MEMWIN has been
*  defined at a higher level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/2/91
*
*   Modified 8/19/91 by Pat Adams
*       Changes made to reflect modified ON KEY LABEL usage
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified 3/12/93 by Pat Adams
*       SET WINDOW OF MEMO TO added to clear
*       out memo field window.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON KEY LABEL shift-f9
SET WINDOW OF MEMO TO memwin
MODIFY MEMO notes NOEDIT
CLOSE MEMO notes
SET WINDOW OF MEMO TO
DEACTIVATE WINDOW memwin
CLEAR TYPEAHEAD
ON KEY LABEL shift-f9 DO memoview
RETURN
* End procedure MEMOVIEW

*!*****************************************************************************
*!
*!      Procedure: FILE_BUSY
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: NICECHIM           (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE file_busy
*******************************************************************************
*$ Display window informing user required file is busy
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/31/91
*
*   Modified 2/11/93 by Pat Adams
*       Code revised for FoxPro/Windows format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
ACTIVATE SCREEN
lcMessage='Would you like to retry for use of the file? (Y/N)'
lcText="Someone else was using the" + CHR(13) + ;
       "file required at this point." + CHR(13) + "" + CHR(13) + ;
       "Attempting a 'retry' may find" + CHR(13) + ;
       "that the file is now available."
DO nicechim
re_try=BUGBOX(lcText,'Caution','Retry','SORRY',lcMessage)
RETURN re_try
* End procedure FILE_BUSY

*!*****************************************************************************
*!
*!      Procedure: GO_AGAIN
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: ERORSET            (procedure in FPWERROR.PRG)
*!
*!    Other Files: &PRNT_DEVIC
*!
*!*****************************************************************************
PROCEDURE go_again
*******************************************************************************
*& Reset environment for RETRY
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/3/91
*
*   Modified 8/19/91 by Pat Adams
*       Selection of CURR_DBF (if ! EMPTY()) added before
*       execution of the RETRY upon return
*       to calling module.  Closure of FPWERROR
*       database added in the event it was used
*       since some modules which do a RETRY also
*       save data into the error log.
*
*   Modified 9/22/91
*       GO RECNO() added following SELECT (curr_dbf)
*       to make sure any changes in a record can be
*       viewed by user.
*
*   Modified 2/12/93 by Pat Adams
*       Code  modified for use in FoxPro/Windows
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF USED("SYSDATA")
    SELECT sysdata
    USE
ENDIF (USED("SYSDATA"))

IF USED("FPWERROR")
    SELECT fpwerror
    USE
ENDIF (USED("FPWERROR"))

IF ! EMPTY(curr_dbf)
    SELECT (curr_dbf)
    * =====================================
    *$ Move record pointer so user will see
    *$ any changes made by others on the LAN
    * =====================================
    GO RECNO()
ENDIF (! EMPTY(curr_dbf))

IF ! EMPTY(top_win)
    * ===================================
    * Note that EVALUATE() does not work
    * with ACTIVATE WINDOW so &macro is used
    * ===================================
    ACTIVATE WINDOW &top_win
ENDIF (! EMPTY(top_win))

SET CONSOLE &xkonsol
SET DEVICE TO &xdevice
SET PRINTER TO &prnt_devic
SET PRINT &xprint
RELEASE lstext, lmtext
DO erorset
CLEAR TYPEAHEAD
SET CURSOR &curs_set
RETURN
* End procedure GO_AGAIN

*!*****************************************************************************
*!
*!      Procedure: ERORSET
*!
*!      Called by: FPWERROR.PRG                      
*!               : GO_MASTR           (procedure in FPWERROR.PRG)
*!               : GO_AGAIN           (procedure in FPWERROR.PRG)
*!               : LOGVIEW            (procedure in FPWERROR.PRG)
*!               : KANCEL             (procedure in FPWERROR.PRG)
*!
*!          Calls: FPWERROR.PRG
*!
*!*****************************************************************************
PROCEDURE erorset
*******************************************************************************
*& Reinitialize error set statement for FPWERROR
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/12/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON ERROR DO fp25cper WITH ERROR(), MESSAGE(), ;
    MESSAGE(1), SYS(16), LINENO(), SYS(102), ;
    SYS(100), SYS(101), LASTKEY(), ALIAS(), ;
    SYS(18), SYS(5), SYS(12), SYS(6), SYS(2003), ;
    WONTOP(), SYS(2011), SYS(2018), SET("CURSOR")
RELEASE lstext, lmtext
RETURN
* End procedure ERORSET


*!*****************************************************************************
*!
*!      Procedure: NICECHIM
*!
*!      Called by: FILE_BUSY          (procedure in FPWERROR.PRG)
*!               : REC_BUSY           (procedure in FPWERROR.PRG)
*!               : TRANSACTN          (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nicechim
*******************************************************************************
* & Sound pleasant 3 part chime
*
*   Author: Pat Adams, DB Unlimited
*   Date: 7/24/89
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET BELL TO 2000,5
?? CHR(7)
SET BELL TO 2500,5
?? CHR(7)
SET BELL TO 3000,5
?? CHR(7)
SET BELL TO && RETURN BELL to normal setting
RETURN
* End Procedure NICECHIM



*!*****************************************************************************
*!
*!      Procedure: QQUIT
*!
*!      Called by: FPWERROR.PRG                      
*!               : LOGVIEW            (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE qquit
*******************************************************************************
*& Return user to Windows
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/7/91
*
*   Modified 1/12/93 by Pat Adams
*       SET LIBRARY TO added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLOSE DATA
SET CURSOR ON
SET LIBRARY TO
SET COLOR TO W/N
CLEAR
SET CLEAR OFF && Suppresses "Normal Shutdown" message
QUIT
* End procedure QQUIT



*!*****************************************************************************
*!
*!      Procedure: REC_BUSY
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: NICECHIM           (procedure in FPWERROR.PRG)
*!
*   Modified Nancy Jacobsen 5/93
*      Cross Platform
*!*****************************************************************************
PROCEDURE rec_busy
*******************************************************************************
*& Display window informing user record is locked by another
*
*   Author: Pat Adams  (718) 469-4032
*   Date:   8/1//91
*
*   Modified 2/12/93 by Pat Adams
*       Code modified for use in FoxPro/Windows
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
ACTIVATE SCREEN
lcMessage='Would you like to retry? (Y/N)'
lcText="Someone else has locked the record you need." + CHR(13) + ;
       "If you try again it may now be available."
DO nicechim
re_try=BUGBOX(lcText,'Qmark','Retry','SORRY',lcMessage)
RETURN re_try
* End procedure REC_BUSY

*!*****************************************************************************
*!
*!      Procedure: TOO_HIGH
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE too_high
*******************************************************************************
*& Error #5, "Record is out of range"
*
*   This error usually arises from the following conditions:
*
*     1.  Attempts to access a record number greater than
*         the actual number of records in the database.
*
*     2.  FoxPro has been installed with the demonstration
*         key instead of the activation key and the database
*         contains more records than permitted in the demo.
*
*     3.  An index is out of date and no longer matches
*         the database in use.
*
*   Inform user and have them call Application Administrator.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/6//91
*
*   Modified 2/12/93 by Pat Adams
*       Code changed for FoxPro/Windows format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*
* 	Modified by Tamar E. Granor 11/94
*		There is no demo version anymore. Removed reference
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText="One of your indexes is out of date."
   
lcText2=''+CHR(13)+ ;
        "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call+CHR(13)+ ;
        SPACE(5)+m_title+CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','BAD NEWS',lcmessage,lcText2)
RETURN
* End procedure TOO_HIGH

*!*****************************************************************************
*!
*!      Procedure: INDEX_ER
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE index_er
*******************************************************************************
*& Index error messages
*
*   Error #19 =   "Index file does not match database"  The
*                 most likely cause is that index uses fields not
*                 in the database or relies upon memvars which are
*                 not initialized.
*
*   Error #20 =   "Record is not in index"  Most likely cause is
*                 that the database structure was changed without
*                 the index being active.
*
*   Error #114 =  "Index does not match database file"  The most
*                 likely cause is corruption within the index file
*                 or in the index file header.  Do not REINDEX but,
*                 rather, recreate index with INDEX ON...TO
*
*   Error #1103 - "Illegal seek offset"
*                 This error is usually received when the index
*                 being used for a SEEK has become corrupted.
*
*   Error #1141 = Unrecognized index file revision.  Recreate index.
*                 The index file is in a format not compatible with
*                 the version of FoxPro being used.
*
*   Since application is not usable until the index problems
*   have been corrected the user will be returned to Windows at the
*   calling level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
*
*   Modified 1/4/93 by Pat Adams
*       Error #1141 added.
*
*   Modified 2/11/93/93 by Pat Adams
*       Code modified for FoxPro/Windows
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
IF sysdata.multi_user
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)

lcMessage='Press any key to return to '+IIF(_DOS,'DOS',IIF(_Windows,'Windows','the Finder'))
lcText= "There is a problem with the index files." + CHR(13) + ;
        "The indexes need to be recreated. You" + CHR(13) + ;
        "will not be able to use this application" + CHR(13) + ;
        "until that has been completed."
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','BAD NEWS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure index_er


*!*****************************************************************************
*!
*!      Procedure: NO_CDX
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE no_cdx
*******************************************************************************
*& Structural .CDX file not found - Error #1707
*
*   Since application is not usable until the .CDX
*   is recreated the user will be returned to Windows at the
*   calling level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
*
*   Modified 2/11/93/93 by Pat Adams
*       Routine modified for FoxPro/Windows use.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
IF sysdata.multi_user
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)

ACTIVATE SCREEN
lcMessage='Press any key to return to '+IIF(_DOS,'DOS',IIF(_Windows,'Windows','the Finder'))
lcText= "The structural index associated with the" + CHR(13) + ;
        "file you need seems to be missing. You" + CHR(13) + ;
        "will not be able to use this application" + CHR(13) + ;
        "until the problem has been corrected."
        
lcText2=''+CHR(13)+"Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','BAD NEWS', ;
        lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NO_CDX

*!*****************************************************************************
*!
*!      Procedure: READONLY
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE readonly
*******************************************************************************
*
*   This module is called if SYSDATA.DBF shows user
*   is working in stand-alone mode.
*
*&Error #111 -  Attempt was made to write to a read-only file
*
*   The most likely cause of this is attempting to
*   write to a file created as read-only or accessed
*   as read-only under program control.  User is in-
*   structed to call the developer because it is probably
*   a programming error.
*
*& #1718 - File is read only
*     1.  An attempt was made to write to a file whose
*         attribute is read only.  If the file is located
*         on a floppy disk the floppy may be write protected.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
*
*   Modified 2/11/93 by Pat Adams
*       Code changed to FoxPro/Windows style code.
*
*   Modified by Nancy Jacobsen 5/93
*        Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText= "There is a slight problem. An attempt was made to" + CHR(13) + ;
        "write to a read-only file. Your input can not be saved." + CHR(13) + ;
         "" + CHR(13) + "If you are putting " + ;
        "information on a floppy disk check " + ;
        "to" + CHR(13) + "make sure the disk " + ;
        "is not write protected. Otherwise" + CHR(13) + ;
        "please call:"  
lcText2=""+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Caution','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure READONLY

*!*****************************************************************************
*!
*!      Procedure: PROGBUG
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE progbug
*******************************************************************************
*& Inform user a programming bug has occurred
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
*
*   Modified 1/11/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified by Nancy Jacobsen 5/93
*           Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText= "An error that is most likely a" + CHR(13) + ;
        "programming bug has occurred."+CHR(13)+CHR(13)+ ;
        "Please report this immediately to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage)
CLEAR TYPEAHEAD
RETURN
* End procedure PROGBUG

*!*****************************************************************************
*!
*!      Procedure: NOCREATE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE nocreate
*******************************************************************************
*& Can not create file
*
*   Error #1102 = "Cannot create a [new] file"
*
*   Error #102 = "Cannot create file" <file>
*                 Memvar XMISSING provides file name
*
*   Error #1157 = "Cannot update file"
*
*   Error #1160 - Not enough disk space for file <file name>.
*
*&  Error #1410 - Unable to create temporary work file(s)
*                 (i.e., files required for SORT, INDEX,
*                 REINDEX or PACK
*
*   The situation is usually caused by one of the following:
*
*   1.  Insufficient disk space or, on a LAN, insufficient
*       directory space
*
*   2.  Attempted use of an invalid file name, including use
*       of a file name which already exists
*
*   3.  User does not have the correct LAN authorization to
*       create a file
*
*   4.  A hardware error has caused an inability to write to
*       the hard disk.
*
*   Because of the circumstances which may have created the
*   error condition error information output will be sent to
*   the printer and the user returned to Windows upon return to
*   the calling module.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
*
*   Modified 2/12/93 by Pat Adams
*       Code modified to FoxPro/Windows format.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform  
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
IF sysdata.multi_user
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)
*-- Had to shorten message.
lcMessage='Press any key to print and return to '+IIF(_DOS,'DOS',IIF(_Windows,'Windows','the Finder'))
lcText= "It is not possible to create a file needed at this " + ;
        "point." + CHR(13) + "This may be " + ;
        "due to several problems, one of " + ;
        "which is" + CHR(13) + "insufficient " + ;
        "disk space. Because disk space " + ;
        "may not" + CHR(13) + "be available, " + ;
        "error information will be sent to the printer." 
lcText2="Make sure your printer " + ;
        "is turned on and on-line." +CHR(13)+CHR(13)+ ;
        "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone+CHR(13)+ CHR(13)+;
       "and provide a copy of the printout."
DO uhoh
=BUGBOX(lcText,'Stop','OK','BAD NEWS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NOCREATE

*!*****************************************************************************
*!
*!      Procedure: TO_PRN
*!
*!      Called by: FPWERROR.PRG                      
*!               : SQL_IDX            (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE to_prn
*******************************************************************************
*& Send error info to printer
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
*
*   Modified by Pat Adams 10/1/92
*       Status of printer checked before
*       attempting to print
*
*   Modified 2/19/93 by Pat Adams
*       Code changed to eliminate checking whether
*       printer is ready or not since the Windows
*       print manager handles this for FPW.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE prnstatus
STORE .T. TO prnstatus
*-- SYS(13) always returns READY in Windows so this will work for both
*-- platforms
DO WHILE SYS(13) # "READY"
    STORE .F. TO prnstatus
    DO uhoh
    lcMessage='Do you want to try to print again? (Y/N)'
    lcText= "Your printer is not ready so we can't"+CHR(13)+ ;
            "print out the necessary information." +CHR(13)+CHR(13)+ ;
            "I'll wait while you check to see if your"+CHR(13)+ ;
            "printer is plugged in, is on-line, there"+CHR(13)+  ;
            "is paper or paper jams have been cleared."
    prnstatus=BUGBOX(lcText,'Qmark','Retry','WHOOPS',lcMessage)
    IF ! prnstatus OR SYS(13) = "READY"
        EXIT
    ENDIF ! prnstatus (! prnstatus OR SYS(13) = "READY")
ENDDO while sys(13) # "READY"

IF prnstatus OR SYS(13) = "READY"
    SET CONSOLE OFF
    LIST STATUS TO PRINT
    LIST MEMORY TO PRINT
    * FP/Windows has already issues an eject after the above two commands
    IF _dos
      EJECT
    ENDIF
    SET CONSOLE ON
ENDIF prnstatus (prnstatus OR SYS(13) = "READY")

RETURN
* End procedure TO_PRN

*!*****************************************************************************
*!
*!      Procedure: BADRIGHTS
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badrights
*******************************************************************************
*& Cannot open file - Error # 1101 and error #101
*
*   Assuming the name of the file has been spelled correctly and
*   the correct subdirectory has been stated, if necessary, the
*   most likely cause of this error is the user not having
*   the appropriate LAN rights.
*
*   In spite of what the FoxPro manuals may lead you to believe,
*   if the named file does not exist or if an invalid file name
*   or subdirectory has been used, Error #1 is returned, not
*   Error #1101.
*
*   User is sent to DOS after being returned to calling module.
*   Assumption is that if user does not have rights to open this
*   file user will also not have rights to open other files on
*   the LAN, therefore, no attempt is made (at the calling level)
*   to save error info to disk.  Using the same assumption, it
*   will not be possible to open the SYSDATA file to obtain info
*   on the person who should be called.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
*
*   Modified 2/19/93 by Pat Adams
*       Code changed to Windows format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* ======================================
*$ Get info on person to call
* ======================================
*DO lan_admin
lcMessage='Press any key to return to '+IIF(_DOS,'DOS',IIF(_Windows,'Windows','the Finder'))
lcText= "It appears you do not have the correct rights on the LAN."+CHR(13)+; 
        "Please report this problem to your network administrator."
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage)
CLEAR TYPEAHEAD
RETURN
* End procedure BADRIGHTS

*!*****************************************************************************
*!
*!      Procedure: REALBAD
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : A_LERT             (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE realbad
*******************************************************************************
*& Database is trashed
*
*   Error #15 - Not a database file
*
*   This can be caused by a bad .DBF file header.
*   Error #15 can also occur is attempting to use a non-
*   .DBF file as a .DBF file.
*
*   Error # 1111 - Invalid file descriptor.
*                  FoxPro was unable to open file.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 1/13/93 by Pat Adams
*       Error # 1111 added
*
*   Modified 2/19/93 by Pat Adams
*       Code changed to FPW format
*   
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
ACTIVATE SCREEN
lcMessage='Press any key to return to '+IIF(_DOS,'DOS',IIF(_Windows,'Windows','the Finder'))
lcText= "A database file has been trashed."
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO a_lert
=BUGBOX(lcText,'Toilet','OK','REAL BAD NEWS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure REALBAD

*!*****************************************************************************
*!
*!      Procedure: A_LERT
*!
*!      Called by: REALBAD            (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE a_lert
*******************************************************************************
*& Sound loud, long warning siren
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
*
*   Modified 2/19/93 by Pat Adams
*       Tones changed to accommodate Windows' ranges
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
FOR xx = 1 TO 3
    SET BELL TO 1950, 9
    ?? CHR(7)
    SET BELL TO 4500, 12
    ?? CHR(7)
ENDFOR (xx)
SET BELL TO
RETURN
* End procedure a_lert


*!*****************************************************************************
*!
*!      Procedure: KORRUPT
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE korrupt
*******************************************************************************
*& Corrupted object file
*
*   Error #67 - Internal consistency error
*
*   Error #1309 - Not an object file
*
*   Compiled object file has been corrupted - Recompile
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
*
*   Modified 1/9/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu.'
lcText= "An object file has " + ;
        "been corrupted." 
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Firebox','OK','BAD NEWS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure KORRUPT

*!*****************************************************************************
*!
*!      Procedure: READ_ERR
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE read_err
*******************************************************************************
*  Error #1104 - File read error
*
*  The operating system returned an error to FoxPro
*  while FoxPro was attempting to read a file.  It could
*  just be a "hiccup" or there could be problems with the
*  disk, controller or LAN connection.  Provide user with
*  option to retry
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/9/91
*
*   Modified 1/7/93 by Pat Adams
*       Use of SYSDATA added.
*       Routine also updated to differentiate
*       between multi-user and stand-alone environment.
*
*   Modified 2/19/93 by Pat Adams
*       Code changed to FPW format.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS rretry
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ========================================
    *$ Get info on appropriate person to call
    * ========================================
    DO lan_admin
    * ====================================
    *$ Tell user to call LAN administrator
    *  if working in a multi-user environment
    * ====================================
    *-- Had to shorten message
    lcMessage='Press Y to Retry, N to Return to Main Menu'
    lcText= "Your hardware and/or " + ;
        "operating system returned an error" + CHR(13) + ;
        "while attempting to read a file. This " + ;
        "may have been just" + CHR(13) + ;
        "a minor 'hiccup' or an indication of " + ;
        "serious hardware problems." + CHR(13) + CHR(13)+;
        "If this is the first time " + ;
        "you have received this message try"
    lcText2= "things again. If not, your hard disk, " + ;
        "controller and LAN" + CHR(13) + ;
        "connections should be checked."+ CHR(13)+CHR(13)+ ;
        "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
    DO uhoh
    rretry=BUGBOX(lcText,'Caution','Retry','BAD NEWS',lcMessage,lcText2)
ELSE
    * ============================================
    *$ Otherwise simply advise user of the problem
    * ============================================
    lcMessage='Press Y to Retry, N to Return to Main Menu'
    lcText= "Your hardware and/or " + ;
        "operating system returned an error" + CHR(13) + ;
        "while attempting to read a file. This " + ;
        "may have been just" + CHR(13) + ;
        "a minor 'hiccup' or an indication of " + ;
        "serious hardware problems." + CHR(13) + CHR(13)+;
        "If this is the first time " + ;
        "you have received this message try"
    lcText2= "things again. If not, your hard disk, " + ;
        "controller and LAN" + CHR(13) + ;
        "connections should be checked."
    DO uhoh
    rretry=BUGBOX(lcText,'Caution','Retry','BAD NEWS',lcMessage,lcText2)
ENDIF (sysdata.multi_user)
RETURN rretry
* End procedure READ_ERR

*!*****************************************************************************
*!
*!      Procedure: RITE_ERR
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE rite_err
*******************************************************************************
*& File write error - Error #1105
*
*   The most likely causes of this error are:
*
*   1.  An attempt to write to a floppy which is
*       write protected or a LAN subdirectory to
*       which the user does not have correct rights
*
*   2.  A problem with the operating system, hard disk,
*       controller, or LAN connections
*
*   User is provided with option to retry
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/9/91
*
*   Modified 1/11/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/6/93 by Pat Adams
*       Code changed to FPW format.  Different error
*       messages provided depending upon whether user
*       is working in M/U mode.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ========================================
    *$ Get info on appropriate person to call
    * Have user call LAN administrator
    * ========================================
    DO lan_admin
ELSE
    * ====================================================
    * Otherwise have user call applications administrator
    * ====================================================
    DO app_admin
ENDIF (sysdata.multi_user)
USE sysdata NOUPDATE

*-- I couldn't see any difference between the code
*-- for multi-user and single user so I combined them
lcMessage='Press Y to Retry, N to Return to Main Menu'
*-- Had to shorten message
lcText= "A problem " + ;
        "occurred while trying to write " + ;
        "to disk."+CHR(13) + CHR(13)+ ;
        "If you are writing " + ;
        "to a floppy disk, it may be write" + ;
        CHR(13) + ;
        "protected. Unprotect " + ;
        "the disk and try again." + CHR(13) + CHR(13)+;
        "If not, try again anyway. However, if " + ;
        "this problem " + CHR(13)+ ;
        "continues, there may be a problem with the hard" 
lcText2= "disk, controller, LAN connection or your LAN" + CHR(13) + ;
        "authorization rights. " + CHR(13)+CHR(13)+ ;
        "If this message " + ;
        "continually appears, please report " + CHR(13)+;
        "the problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
re_try=BUGBOX(lcText,'Caution','Retry','BAD NEWS',lcMessage,lcText2)
RETURN re_try
* End procedure RITE_ERR

*!*****************************************************************************
*!
*!      Procedure: LOWFILES
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE lowfiles
*******************************************************************************
*$ Error #6 - Too many files open
*
*   FoxPro Windows supports 99 open file handles in FoxPro itself.
*   A FILES= statement in the FoxPro CONFIG.FP file is not necessary
*   if present, will be ignored.  However, the following conditions
*   must be present on the computer, work node and file server:
*
*   1.  CONFIG.SYS must include the FILES= statement.  Although
*       different vendor editions of different versions of DOS
*       support a different FILES= maximum, in general DOS 3.3
*       and above supports a maximum of 250 file handles.  Usually
*       a CONFIG.SYS statement of FILES=99 is sufficient.
*
*   2.  Depending upon the LAN OS in use, the work node may need
*       a specific file handles statement for the LAN OS.  DOS
*       based LANs such as InvisibleNET and LANtastic use the DOS
*       CONFIG.SYS statement while LANs such as Novell require the
*       SHELL.CFG or NET.CFG file on each work station with a
*       FILE HANDLES=xxxx statement.  Otherwise Novell will default
*       to 40 file handles no matter what the CONFIG.SYS setting.
*       If both a NET.CFG and SHELL.CFG are present on the work node
*       the NET.CFG file settings take precedence.
*
*   3.  Novell LANs also require that the FILE HANDLES setting for
*       the SERVER be adjusted upwards.  Otherwise the default will
*       be 40 file handles and this will take precedence over any
*       settings on the work node.
*
*   4.  LANtastic needs a FILES= setting on the server that will
*       provide for sufficient file handles for all files opened
*       by the work nodes on the server as well as those opened
*       by the server in work node mode.
*
*   This message window loads a .BMP file which utilizes another
*   file handle.  Therefore, all database files and indexes are
*   closed before the error message appears.  The user will be
*   returned to the master module of the application.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/6/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*
*	Modified by Tamar E. Granor 11/94
*		Added case for _MAC in which this problem can't be fixed by user
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLOSE DATA
SELECT 0
USE sysdata NOUPDATE
ACTIVATE SCREEN

DO CASE  && Messages
	CASE _MAC 	&& handle this one first
        lcMessage='Press any key to return to Main Menu'
        *-- Had to shorten message
        lcText="You don't have enough 'file handles.'"+CHR(13)+CHR(13)+ ;
               "You must shut down other applications" + CHR(13) + ;
               "to allow this one to run."+CHR(13)
        lcText2= ""
        DO uhoh
        =BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
	
    CASE sysdata.multi_user AND sysdata.dos_lan
        * =============================================
        * Message if user is attached to a DOS based
        * LAN such as InvisibleNET, LANtastic or Novell
        * Netware Lite
        * =============================================
        DO lan_admin
        lcMessage='Press any key to return to Main Menu'
        *-- Had to shorten message
        lcText="You don't have enough 'file handles.'"+CHR(13)+CHR(13)+ ;
               "You must return to DOS, increase the FILES= setting" + CHR(13)+ ;
               "in your CONFIG.SYS file, and restart your computer " + CHR(13) + ;
               "for this new setting to take effect. " + CHR(13) + CHR(13)+ ;
               "It may also be necessary to increase the FILES = " + CHR(13) 
        lcText2="setting on your LAN server." +CHR(13)+CHR(13)+ ;
                 "If you don't know how to do this, please contact:" +CHR(13)+CHR(13)+ ;
                 SPACE(5)+m_call +CHR(13)+ ;
                 SPACE(5)+m_title +CHR(13)+ ;
                 SPACE(5)+m_phone
        DO uhoh
        =BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
    CASE sysdata.multi_user AND ! sysdata.dos_lan
        * ==============================================
        * Message if user is attached to a "full fledged"
        * LAN such as Novell, Lan Man or Banyan.
        * ==============================================
        DO lan_admin
        lcMessage='Press any key to return to Main Menu'
        *-- Had to shorten message
        lcText="You don't have enough 'file handles.'"+CHR(13)+CHR(13)+ ;
               "You must return to DOS, increase the FILES= setting in your" + CHR(13)+ ;
               "CONFIG.SYS file, and restart your computer for this new "+CHR(13)+ ;
               "setting to take effect. " + CHR(13)+ CHR(13)+ ;
               "If you are attached to a Novell LAN, you may also need to "
        lcText2= "increase the FILE HANDLES= setting in your NET.CFG or "+CHR(13)+ ;
                 "SHELL.CFG file. "+CHR(13)+CHR(13)+ ;
                 "If you don't know how to do this, please contact:" +CHR(13)+CHR(13)+ ;
                 SPACE(5)+m_call +CHR(13)+ ;
                 SPACE(5)+m_title +CHR(13)+ ;
                 SPACE(5)+m_phone
        DO uhoh
        =BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
    OTHERWISE
        * ==============================================
        * Message if user is working in stand_alone mode
        * User is instructed to call developer.
        * ==============================================
        DO developer
        lcMessage='Press any key to return to Main Menu'
        *-- Had to shorten message
        lcText="You don't have enough 'file handles.'"+CHR(13)+CHR(13)+ ;
               "You must return to DOS, increase the FILES= setting" + CHR(13)+ ;
               "in your CONFIG.SYS file, and restart your computer " + CHR(13) + ;
               "for this new setting to take effect. " + CHR(13) 
        lcText2= "If you don't know how to do this, please contact:" +CHR(13)+CHR(13)+ ;
                 SPACE(5)+m_call +CHR(13)+ ;
                 SPACE(5)+m_title +CHR(13)+ ;
                 SPACE(5)+m_phone
        DO uhoh
        =BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
ENDCASE  && Messages
RETURN
* End procedure LOWFILES

*!*****************************************************************************
*!
*!      Procedure: NOMEMO
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE nomemo
*******************************************************************************
*& Error #41 - MEMO file is missing/invalid
*
*   The most likely cause of this error is an attempt to
*   USE a database file whose associated memo file (either
*   .DBT or .FPT) has been erased.
*
*   Other possible causes include a trashed .DBT or .FPT file
*   or a .DBT/.FPT file which does not match the .DBF file.
*
*   User is returned to the MASTER module.  Depending upon the
*   application, it may be desirable to change this so the user
*   is returned to Windows.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/7/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ========================================
    *$ Get info on appropriate person to call
    * ========================================
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)
lcMessage='Press any key to return to Main Menu'
lcText= "A 'memo field' which contains free-form" + CHR(13) + ;
        "text or notes has been erased or does not "+ CHR(13) + ;
        "properly match its corresponding database "+ CHR(13) + ;
        "file. It's not possible to continue until " + CHR(13) + ;
        "this has been corrected." 
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','BAD NEWS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NOMEMO

*!*****************************************************************************
*!
*!      Procedure: BAD_RPT
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_rpt
*******************************************************************************
*& Error #50 - Report file invalid
*& Error #54 - Label file invalid
*& Error #1241 - Improper data type in group expression
*& Error #1243 - Internal error: Too many characters in report
*& Error #1245 - Error in label field definition
*& Error #1246 - Total label width exceeds maximum allowable
*& Error #1645 - Report nesting error
*& Error #1646 - Total field type in report must be numeric
*& Error #1647 - Improper data type in field expression
*& Error #1653 - Label nesting error
*
*   The most likely causes of this error are:
*
*   1.  Syntax error in the REPORT FORM .FRX file
*       or the LABEL FORM file
*
*   2.  Descriptions in the REPORT or LABEL FORM file do
*       not match the database
*
*   3.  The REPORT or LABEL file has become corrupted
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/6/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/8/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
* ===================================
* Get info on developer
* ===================================
DO developer
ACTIVATE SCREEN

IF error_no = 50 OR error_no = 1241 OR error_no = 1243 ;
        OR error_no = 1645 OR error_no = 1646 OR error_no ;
        = 1647
    STORE "report" TO which1, which2
ELSE
    STORE "label" TO which1
    STORE "labels" TO which2
ENDIF (error_no = 50 OR error_no = 1241 OR error_no = 1243 ;)

lcMessage='Press any key to return to Main Menu'
lcText= "There is a problem with the &which1 form" + CHR(13) + ;
        "file. The &which2 can not be generated" + CHR(13) + ;
        "until the problem is corrected." 
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_RPT

*!*****************************************************************************
*!
*!      Procedure: BADMEMFL
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badmemfl
*******************************************************************************
*& Error #55 - Memory Variable file is invalid
*
*   An attempt was made to RESTORE FROM a .MEM file
*   which has been trashed.
*
*   If info in the .MEM file is necessary to the overall
*   application change this module so user is returned to DOS.
*
*   Note that .MEM files should not be used in a LAN
*   environment because they can not be locked.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/8/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DO developer && GET info on person to call
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText= "There is a problem with a 'memory' file" + CHR(13) + ;
        "that contains necessary information." + CHR(13) + ;
        "This option can not be used until the" + CHR(13) + ;
        "problem has been corrected."
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BADMEMFL

*!*****************************************************************************
*!
*!      Procedure: NOSPACE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE nospace
*******************************************************************************
*& Error #56 - Not enough disk space
*
*   User has run out of disk space on a local hard disk,
*   a floppy disk, or in a LAN server subdirectory.
*
*   If user has a printer available send error output to
*   the printer.  An attempt is not made to USE the SYSDATA
*   file since this error condition may preclude such activity.
*
*   Menachem Bazian reports that the "out of disk" error has
*   been erroneously reported under both Novell 2.15C and Novell
*   3.11 at times.  This has been traced to files which have no
*   "owner" but, instead, are classified as N/A under Novell.
*   Without a Novell owner the size of a file can not be
*   increased.  Theoretically it should not be possible for a
*   file to be created under Novell without an owner, however...
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/7/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/8/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS doprint
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ==========================================
    *$ Provide user with error info appropriate
    *$ to those attached to a LAN
    * ==========================================
    lcMessage='Press any key to begin printing.'
    lcText= "You have run out of space on the LAN" + CHR(13) + ;
        "subdirectory in use, on your local hard" +CHR(13)+ ;
        "disk or on the floppy disk if you are attempting" + CHR(13) + ;
        "to write to a floppy. Information about this" + CHR(13) + ; 
        "problem will be sent to the printer. Please"
    lcText2="give a copy to your LAN administrator. "+CHR(13)+ CHR(13)+;
         "Unless you are attempting to write to a floppy" + CHR(13) + ;
        "disk, you should quit this application and return" + CHR(13) + ;
        "to "+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))+" until the problem is corrected." 
    DO uhoh
    =BUGBOX(lcText,'Stop','OK','REALLY BAD NEWS',lcMessage,lcText2)
    STORE .T. TO doprint
ELSE
    * ==========================================
    *$ Otherwise display error info appropriate
    *$ to a stand-alone system
    * ==========================================
    STORE .F. TO doprint
    lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
    lcText= "There is no more space on your" + CHR(13) + ;
            "hard disk or, if you are writing to" + CHR(13) + ;
            "a floppy disk, on that floppy disk. If" + CHR(13) + ;
            "you are not attempting to write to a" + CHR(13) + ;
            "floppy disk, you must quit this application" + CHR(13) + ;
            "and and clean out your hard disk." 
    DO uhoh
    =BUGBOX(lcText,'Stop','OK','REALLY BAD NEWS',lcMessage)
ENDIF (sysdata.multi_user)
CLEAR TYPEAHEAD
RETURN doprint
* End procedure NOSPACE

*!*****************************************************************************
*!
*!      Procedure: BAD_DIF
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_dif
*******************************************************************************
*& Error #115 - Invalid DIF file header
*& Error #116 - Invalid DIF vector-DBF field mismatch
*& Error #117 - Invalid DIF type indicator
*
*   The DIF file user is attempting to import may not
*   be in the DIF file format, the file may be corrupted,
*   or if APPEND FROM...DIF has been used the data elements
*   of the DIF file may not match the database in use.
*
*   Author: Pat Adams
*   Date: 8/1/91
*
*   Modified 1/6/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/9/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
lcMessage='Press any key to return to Main Menu'
lcText="There is a problem with the DIF" + CHR(13) + ;
    "(VisiCalc) file you are attempting" + CHR(13) + ;
    "to import. It may not actually be a DIF" + CHR(13) + ;
    "file, the file header may be corrupted or" + CHR(13) + ;
    "the data elements may not match the" + CHR(13) + ;
    "database in use." 
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_DIF

*!*****************************************************************************
*!
*!      Procedure: BAD_SYLK
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_sylk
*******************************************************************************
*& Error #119 - Invalid SYLK file header -
*    File header may have been trashed
*
*& Error #120 - Invalid SYLK dimension bounds -
*    The file being imported is indicating invalid
*    rows or columns - it is 'out of bounds'
*
*& Error #121 - Invalid SYLK file format -
*    File is not a SYLK (Multiplan) file.  It may
*    be that the file is a Multiplan 4.01 file in
*    which case the MOD option should be used.
*
*& Error #1670 - Invalid Multiplan v 4.0 file format
*    File being imported is not a v. 4.0 file or
*    has been corrupted
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/11/92 by Pat Adams
*     Error #1670 added.
*
*   Modified 3/10/93 by Pat Adams
*       Format changed to FPW
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
lcMessage='Press any key to return to Main Menu'
lcText="There is a problem with the Multiplan SYLK " + CHR(13) + ;
       "file that is being imported. The SYLK file" +CHR(13)+ ;
       "header may be corrupted or it may be that the" + CHR(13) + ;
       "file is a Multiplan 4.01 file which uses the MOD " + CHR(13) + ;
       "file structure rather than SYLK. It's also possible" 
lcText2="that the structure of your .DBF file does not match"+CHR(13)+ ;
        "that of the SYLK file."+CHR(13)+ CHR(13)+;
        "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_SYLK

*!*****************************************************************************
*!
*!      Procedure: NOTRIGHT
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE notright
*******************************************************************************
*& Error #255 - Not a valid Rapidfile database
*& Error #256 - Not a valid Framework II database\spreadsheet
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/11/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
ACTIVATE SCREEN

IF error_no = 255
    ftype = "RapidFile"
ELSE
    ftype = "Framework II"
ENDIF (error_no = 255)

lcMessage='Press any key to return to Main Menu'
lcText= "The file you are attempting to import" + CHR(13) + ;
        "is not a valid &ftype file." +CHR(13)
lcText2="If you would like help, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NOTRIGHT

*!*****************************************************************************
*!
*!      Procedure: BADLOTUS
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badlotus
*******************************************************************************
*& Error #297 - Invalid Lotus 1-2-3 version 2.0 file format
*& Error #1662 - Invalid Lotus 1-2-3 Version 1.0 file format
*& Error #1678 - Invalid Lotus 1-2-3 version 3.0 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/02/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE which1
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
ACTIVATE SCREEN

DO CASE error_no
    CASE error_no = 297
        STORE "2.0" TO which1
        
    CASE error_no = 1662
        STORE "1.0" TO which1
        
    CASE error_no = 1678
        STORE "3.0" TO which1
ENDCASE  error_no
lcMessage='Press any key to return to Main Menu'
lcText= "The file you are attempting to import is not" + CHR(13) + ;
        "a valid Lotus 1-2-3 version &which1 file."+CHR(13)
lcText2="If you would like help, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BADLOTUS

*!*****************************************************************************
*!
*!      Procedure: BADSYMPH
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badsymph
*******************************************************************************
*& Error #1673 - Invalid Symphony version 1.0 file format
*& Error #1674 - Invalid Symphony version 1.1 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/4/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE which1
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
ACTIVATE SCREEN

DO CASE error_no
    CASE error_no = 1673
        STORE "1.0" TO which1
        
    CASE error_no = 1674
        STORE "1.1" TO which1
ENDCASE  error_no

lcMessage='Press any key to return to Main Menu'
lcText= "The file you are attempting to import is not" + CHR(13) + ;
        "a valid Symphony &which1 file."+CHR(13)
lcText2="If you would like help, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BADSYMPH

*!*****************************************************************************
*!
*!      Procedure: BADEXCEL
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badexcel
*******************************************************************************
*& Error #1661 - Invalid Excel version 2.0 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/4/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
lcMessage='Press any key to return to Main Menu'
lcText= "The file you are attempting to import is not" + CHR(13) + ;
        "a valid Excel version 2.0 file."+CHR(13)
lcText2="If you would like help, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BADEXCEL

*!*****************************************************************************
*!
*!      Procedure: SQL_INTL
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE sql_intl
*******************************************************************************
*& Error #800 & 1800 - SQL Internal Err
*
*   User is instructed to call developer and then is
*   returned to DOS since the internal SQL error may
*   disrupt memory management.  Developer should report
*   details of the problem to Fox Software Technical
*   Support
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/3/93 by Pat Adams
*       Format changed to FPW
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
lcText= "An internal SQL error has occurred." + CHR(13) + ;
        "This may disrupt other memory management, therefore, " + CHR(13) + ;
        IIF(_Dos or _Mac,"you will be returned ","you should quit Windows and return ")+ ;
        "to "+IIF(_Mac,'the Finder.','DOS.') +CHR(13)
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','WHOOPS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
*End procedure SQL_INTL

*!*****************************************************************************
*!
*!      Procedure: SQL_IDX
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!               : TO_PRN             (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE sql_idx
*******************************************************************************
*& Error #831 or #1831 - SQL err building temporary index
*
*   The temporary index necessary to the SQL query
*   count not be built.  Possible causes are:
*
*   1.  Insufficient disk space on the local hard disk
*
*   2.  User may not have the necessary "rights"
*       on the LAN server
*
*   3.  Insufficient space in the LAN subdirectory
*
*   Check out the CONFIG.FPW file to see where the
*   TMPFILES and/or SORTWORK are directed.
*
*   Because of the potential for insufficient disk
*   space no attempt is made to save the error
*   information to file.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added and 2.5 error #1831 added.
*
*   Modified 3/3/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE llprint
llprint=.f.
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * =====================================
    * Provide this message if user is working
    * in a LAN environment
    * =====================================
    DO lan_admin && GET info on person to call
    lcMessage='Do you want to print information on this error? (Y/N)'
    lcText= "Unable to build the SQL index required for your query." + CHR(13) + ;
    "Possible causes may be:"  + CHR(13) + CHR(13) + ;
    "1. You have run out of disk space on your local hard disk."+ CHR(13) + ;
    "2. You have run out of space on the LAN subdirectory" +CHR(13)+ ;
    "3. You do not have the appropriate user rights on the LAN" + CHR(13)
    lcText2="Please print out information on this error and provide "+CHR(13)+ ;
        "a copy to the person listed below before are returned to " + CHR(13) + ;
        IIF(_Dos,"DOS.",IIF(_Windows,'Windows','the Finder')) + CHR(13) + CHR(13) + ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
    DO uhoh
    llprint=BUGBOX(lcText,'Stop','Print','BAD NEWS',lcMessage,lcText2)
ELSE
    * ======================================
    *$ Otherwise provide info pertinent to
    *$ single user situation
    * ======================================
    lcMessage='Enter Y to print information now.'
    lcText= "Unable to build the SQL index required for your query." + CHR(13) + ;
            "It's likely that you have run out of disk space. You " + CHR(13) + ;
            "will be returned to "+IIF(_Dos,"DOS. ",IIF(_Windows,'Windows. ','the Finder. '))+ ;
            " You should then clear"+CHR(13)+ ;
            "out files so you have additional space on your hard" 
    lcText2="disk"+IIF(_Dos or _Mac,"."," (you may need to quit to DOS first).") +CHR(13)+CHR(13) +  ; 
           "Would you like to print out information about this error?" 
    DO uhoh
    llprint=BUGBOX(lcText,'Stop','Yes','BAD NEWS',lcMessage,lcText2)
ENDIF (sysdata.multi_user)
CLEAR TYPEAHEAD
if llprint
    DO to_prn
ENDIF (pshbutton = 1)
RETURN
* End procedure SQL_IDX

*!*****************************************************************************
*!
*!      Procedure: SQLTRASH
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE sqltrash
*******************************************************************************
*& Error #821 - SQL invalid temporary file
*
*   The temporary file created by FoxPro for the SQL
*   query has been corrupted.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added
*       FoxPro 2.5 error #1821 added.
*
*   Modified 3/11/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
lcMessage='Press any key to return to Main Menu'
lcText= "The temporary file for the SQL query has been corrupted."  
lcText2=""+CHR(13)+ "If this error recurs, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure SQLTRASH


*!*****************************************************************************
*!
*!      Procedure: NOSQLIDX
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nosqlidx
*******************************************************************************
*& Error #830 & 1830 - SQL index not found
*
*   This may be the result of an incorrect PATH setting
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*       and FoxPro 2.5 error #1830 added
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
lcMessage='Press any key to return to Main Menu'
lcText= "Unable to find the SQL index required for this query." 
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY', lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NOSQLIDX

*!*****************************************************************************
*!
*!      Procedure: SQLABORT
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE sqlabort
*******************************************************************************
*& Error #839 & 1839 - SQL canceled operation
*
*   User pressed ESC key.  Determine if user
*   really wants to abort the query.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added
*       and FoxPro 2.5 error 1839 added
*
*   Modified 3/11/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS a_bort
ACTIVATE SCREEN
lcMessage='Enter Y for yes, N for no.'
lcText= "You pressed the ESCape key." + CHR(13) + ;
        "Do you really want to cancel the query?" 
DO uhoh
a_bort=BUGBOX(lcText,'Qmark','Yes','',lcMessage)
CLEAR TYPEAHEAD
RETURN a_bort
* End procedure SQLABORT
*!*****************************************************************************
*!
*!      Procedure: BADCLOSE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : DEVELOPER          (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE badclose
*******************************************************************************
*& Error #1112 - File close error
*
*   It may be that the operating system just
*   "hiccuped" or there may be a hardware problem.
*   Advise user & provide option to retry.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/4/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/11/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
IF sysdata.multi_user
    DO lan_admin
ELSE
    DO developer
ENDIF (sysdata.multi_user)

ACTIVATE SCREEN
lcMessage='Do you want to try again? (Y/N)'
lcText= "A problem occurred while attempting to close a file." +CHR(13)+CHR(13)+ ;
        "It may be that your computer just didn't get up on" + CHR(13) + ;
        "the right side of the bed and is feeling a little grumpy." + CHR(13) + ;
        "If so, trying again will correct the problem."  +CHR(13)+'' 
lcText2="However, if this message continually reappears it may" + CHR(13) + ;
        "be that there is a hardware problem. In that case" + CHR(13) + ; 	
        "please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
re_try=BUGBOX(lcText,'Caution','Retry','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN re_try
* End procedure BADCLOSE

*!*****************************************************************************
*!
*!      Procedure: VERBOSE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE verbose
*******************************************************************************
*$ Error #1201 - Too many names used
*
*   The FoxPro NAME TABLE "collects" the "names" used for
*   memory variables, arrays, data base files and indexes,
*   field names, procedures, etc. as they are used.  If
*   this table is exhausted the only thing that can be done
*   on an immediate basis is to return the user to DOS and
*   then restart the application.
*
*   The developer should modify the code so that memory
*   variable names, array names, window names, etc. are not
*   all unique but, rather, are used frequently in various
*   modules.  Simply use the PRIVATE statement to make sure
*   memvars and arrays do not conflict with others in use with
*   the same name at higher levels.
*
*   An example of this is the name BUGBOX used repeatedly
*   for message windows opened by FPWERROR.
*
*   Cross platform note: 
*   Nancy Jacobsen 
*   BUGBOX is not used the same way in this version.
*
*   Do not create procedures of the same name, however.
*
*   Because the name table is exhausted, it may not be
*   possible to open the SYSDATA and FPWERROR databases.
*   Therefore, the developer's name must be hard coded
*   in this module.
*
*   Since the Windows Print Manager handles printing
*   there is no prechecking of printer status done in
*   this module.
*
*$ Error #1308 - Stack overflow - expression too complex
*
*   Usually occurs because UDF's are nested too deeply or
*   the code is too recursive.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added
*       and error #1308 added.
*
*   Modified 3/11/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS doprint
ACTIVATE SCREEN
* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
* NOTE: Developer's name is hard coded
* here for reasons stated above and must
* be changed to the appropriate name & phone #
* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
lcMessage='Enter Y for yes, N for No.'
lcText= "A problem has occurred that can be temporarily" + CHR(13) + ;
        "cured by quitting to "+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))+" and then restarting" + CHR(13) + ;
        "this application." +CHR(13)+CHR(13)+ ;
        "Please report this problem immediately to:" +CHR(13)
lcText2=SPACE(5)+"     Pat Adams"+CHR(13)+ ;
        SPACE(5)+"     DB Unlimited"+CHR(13)+ ;
        SPACE(5)+"     (xxx) xxx-xxxx" +CHR(13)+CHR(13)+ ;
        "Do you have a printer available to print " + CHR(13) + ;
        "information about this error?"
DO uhoh
doprint=BUGBOX(lcText,'Stop','Yes','WHOOPS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN doprint
* End procedure VERBOSE

*!*****************************************************************************
*!
*!      Procedure: NORUN
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : APP_ADMIN          (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE norun
*******************************************************************************
*& Error #1405 - RUN/! command failed
*
*   Either there is insufficient free memory to execute the
*   program to be run from DOS or COMMAND.COM can not be found.
*   In the latter case make sure that the DOS COMMAND.COM is
*   accessible via the DOS environmental COMSPEC=
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/5/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/11/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*
*	Modified by Tamar E. Granor 11/94
*		The RUN command is not supported in FoxPro/Mac, so this error
* 		should never occur. Attempts to use RUN return 1001: Feature not
*		Available. This is covered by ProgBug, so "Not yet implement for Mac"
* 		message has been removed.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * =================================
    * Get info on person to call
    * =================================
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)
lcMessage='Press any key to return to Main Menu.'
lcText= "It was not possible to run a DOS program for one of"+CHR(13)+ ;
        "the following reasons:" +CHR(13)+CHR(13)+ ;
        "a.  Your computer does not have sufficient memory" + CHR(13) + ;
        "b.  The DOS COMMAND.COM file could not be found." + CHR(13)
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call+CHR(13)+ ;
        SPACE(5)+m_title+CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
doprint=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NORUN

*!*****************************************************************************
*!
*!      Procedure: BADCHAIN
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE badchain
******************************************************************************
*& Error #1012 - OS memory error
*
*   The DOS free memory chain has been scrambled.
*   The immediate solution is to return to DOS and
*   restart the application.
*
*   If the problem persists and/or is not cured by a
*   reboot the developer should look to the EMS memory
*   manager as the probable culprit.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
*
*   Modified 1/6/93 by Pat Adams
*       Use of SYSDATA added
*
*   Modified 3/12/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* =================================
*$ Get info on person to call
* =================================
DO developer
lcMessage='Press any key to return to '+IIF(_Dos,'DOS',IIF(_Windows,'Windows','the Finder'))
lcText= "Something has scrambled your computer's memory!" +CHR(13)+CHR(13)+;
        "You must quit "+IIF(_DOS or _MAC,'','Windows and return ')+"to "+ ;
        IIF(_DOS OR _Windows,'DOS','the Finder')+", then you" + CHR(13) + ;
        "can call up "+IIF(_Dos or _Mac,'','Windows and ')+"this application again." + CHR(13)+CHR(13)+ ;
        "If this problem persists, try turning off your computer" + CHR(13) + ;
        "and starting it again."+CHR(13)
lcText2="If the problem continues to persist, please contact:" + CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call+CHR(13)+ ;
        SPACE(5)+m_title+CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BADCHAIN

*!*****************************************************************************
*!
*!      Procedure: KANCEL
*!
*!      Called by: LOGVIEW            (procedure in FPWERROR.PRG)
*!
*!          Calls: ERORSET            (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE kancel
*******************************************************************************
*& Cancel program and return to command window
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/22/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON KEY   && Null out hot keys
CLEAR GETS
CLEAR READ ALL
CLEAR FIELDS
CLEAR MACROS
CLEAR WINDOWS
DEACTIVATE MENUS
CLEAR MENUS
DEACTIVATE POPUPS
CLEAR POPUPS
CLEAR PROMPT
SET REFRESH TO 0, 200
SET DEVICE TO SCREEN
CLOSE DATA
DO erorset
SET LIBRARY TO
* ================================================
* NOTE: Turn on/off the CLOSE PROCEDURE statement
* to suit your particular application
* ================================================
*CLOSE PROCEDURE
CLEAR MEMORY
PUBLIC testing
STORE .T. TO testing
CANCEL
* End procedure KANCEL

*!*****************************************************************************
*!
*!      Procedure: LOW_MEMW
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE low_memw
*******************************************************************************
*& Error # 1282 Insufficient memory
*
*& Error #43 - Insufficient memory
*
*& Error #809 & #1809 - SQL out of memory
*
*& Error #845 & #1845 - SQL expression too complex
*               FoxPro ran out of memory when it
*               tried to expand the SELECT
*               statement to analyze it
*
*& Error #1149 - No memory for buffer
*
*& Error #1150 - No memory for file map
*
*& Error #1151 - No memory for file name
*
*& Error #1600 - Not enough memory to USE database
*
*   User will be returned to Main Menu
*
*   Close all windows and databases,
*   inform user of problem and then
*   return to Windows.
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/6/91
*
*   Modified: 10/1/92 by Pat Adams
*       If any of these errors triggered FPWERROR
*       this module is called before any other
*       routines or initialization of additional
*       memory variables.
*
*   Modified: 1/4/93 by Pat Adams
*       Additional errors for low memory conditions
*       in FoxPro 2.5 added. Use of SYSDATA added
*
*   Modified 3/12/93 by Pat Adams
*       Changed to FPW format.  Unlike the DOS
*       error handler, user is returned to
*       Windows because this condition may be
*       caused by having other Windows appli-
*       cations active.
*
*   Modified 4/8/93 by Pat Adams
*       Message expanded to include more information
*       on potential causes of problem.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*       Since the memory error messages are so different for
*       Windows and DOS, I kept the Windows screen exactly the same
*       and branch to either low_memw for Windows or low_memd for DOS
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLEAR WINDOWS
CLOSE DATA
* ===========================================
* NOTE: Depending upon your application,
*       simply clearing all windows and
*       closing databases may not
*       be sufficient. You may also need
*       to release popups or menus first
* =========================================
ACTIVATE SCREEN
DEFINE WINDOW bugbox ;
    AT  0.000, 0.000  ;
    SIZE 17.133,76.600 ;
    FONT "Arial", 9 ;
    FLOAT ;
    NOMINIMIZE ;
    DOUBLE
MOVE WINDOW bugbox CENTER
ACTIVATE WINDOW bugbox NOSHOW
@ 0.267,0.400 SAY "stop.bmp" BITMAP ;
    SIZE 2.467,7.400 ;
    ISOMETRIC ;
    STYLE "T"
@ 0.800,9.800 SAY "You do not have " + ;
    "enough memory to continue at this point!"  ;
    FONT "Arial", 9 ;
    STYLE "T"
@ 2.067,10.000 SAY "There could be a number " + ;
    "of different causes.  If you have"  ;
    FONT "Arial", 9 ;
    STYLE "T"
@ 3.067,4.400 SAY "other Windows programs " + ;
    "running try closing them down.  Check" + ;
    CHR(13) + "your WINDOW virtual " + ;
    "Memory and make sure that you are " + ;
    "using " + CHR(13) + "either a permanent " + ;
    "or temporary disk swap for Virtual Memory."  ;
    SIZE 3.000,70.200, 0.000 ;
    FONT "Arial", 9 ;
    STYLE "T"
@ 6.067,4.400 SAY "Your SMARTDRV cache should " + ;
    "be small - 256k or 512k.  If you" + CHR(13) + ;
    "have a large SMARTDRV cache decrease it.  " + ;
    "You may also" + CHR(13) + "need to " + ;
    "reconfigure your computer to make more " + ;
    "conventional" + CHR(13) + "DOS memory " + ;
    "below 640k available."  ;
    SIZE 4.000,69.400, 0.000 ;
    FONT "Arial", 9 ;
    STYLE "T"
@ 10.400,4.400 SAY "Your computer should have " + ;
    "at least 8 mb. of memory in total" + CHR(13) + ;
    "to run this application successfully.  " + ;
    "If you are running under" + CHR(13) + ;
    "Workgroup for Windows you will need another " + ;
    "4 mb. of memory" + CHR(13) + ;
    "to avoid insufficient memory problems."  ;
    SIZE 4.000,70.800, 0.000 ;
    FONT "Arial", 9 ;
    STYLE "T"
@ 15.200,33.600 GET pshbutton ;
    PICTURE "@*HT \<OK" ;
    SIZE 1.923,8.167,1.333 ;
    DEFAULT 1 ;
    FONT "MS Sans Serif", 8 ;
    STYLE "B"
SHOW WINDOW bugbox
DO uhoh
READ
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure LOW_MEM

*!*****************************************************************************
*!
*!      Procedure: LOW_MEMD
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: Uhoh           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE low_memd
*******************************************************************************
*& Error # 1282 Insufficient memory
*
*& Error #43 - Insufficient memory
*
*& Error #809 & #1809 - SQL out of memory
*
*& Error #845 & #1845 - SQL expression too complex
*               FoxPro ran out of memory when it
*               tried to expand the SELECT
*               statement to analyze it
*
*& Error #1149 - No memory for buffer
*
*& Error #1150 - No memory for file map
*
*& Error #1151 - No memory for file name
*
*& Error #1600 - Not enough memory to USE database
*
*   User will be returned to Main Menu
*
*   Close all windows and databases,
*   inform user of problem and then
*   return to the master module
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/6/91
*
*   Modified: 10/1/92 by Pat Adams
*       If any of these errors triggered FP25EROR
*       this module is called before any other
*       routines or initialization of additional
*       memory variables.
*
*   Modified: 1/4/93 by Pat Adams
*       Additional errors for low memory conditions
*       in FoxPro 2.5 added. Use of color schemes
*       & SYSDATA added
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*       Since the memory error messages are so different for
*       Windows and DOS, I kept the Windows screen exactly the same
*       and branch to either low_memw for Windows or low_memd for DOS
*
*	Modified by Tamar E. Granor 11/94
*		Added word "memory" to first line of error message
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DO uhoh
CLEAR WINDOWS
CLOSE DATA
* ===========================================
* NOTE: Depending upon your application,
*       simply clearing all windows and
*       closing databases may not
*       be sufficient.  You may also need
*       to release popups or menus first
* =========================================
* =======================================
* Memvars for color schemes have not
* been initialized therefore hard coding
* of colors is required here
* =======================================
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu.'
lcText= "You do not have enough memory to continue at this point."+CHR(13)+ ;
        "You will need to reconfigure your"+CHR(13)+ ;
        "computer to make more memory below"+CHR(13)+ ;
        "640k available."+CHR(13)
lcText2="If you are running this under Windows, you may "+chr(13)+ ;
        "need to shut down other applications make more "+chr(13)+ ;
        "memory available in Windows itself."       
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure LOW_MEM

*******************************************************************************
PROCEDURE low_memm
*******************************************************************************
*& Error # 1282 Insufficient memory
*
*& Error #43 - Insufficient memory
*
*& Error #809 & #1809 - SQL out of memory
*
*& Error #845 & #1845 - SQL expression too complex
*               FoxPro ran out of memory when it
*               tried to expand the SELECT
*               statement to analyze it
*
*& Error #1149 - No memory for buffer
*
*& Error #1150 - No memory for file map
*
*& Error #1151 - No memory for file name
*
*& Error #1600 - Not enough memory to USE database
*
*   User will be returned to Main Menu
*
*   Close all windows and databases,
*   inform user of problem and then
*   return to the master module
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/6/91
*
*   Modified: 10/1/92 by Pat Adams
*       If any of these errors triggered FP25EROR
*       this module is called before any other
*       routines or initialization of additional
*       memory variables.
*
*   Modified: 1/4/93 by Pat Adams
*       Additional errors for low memory conditions
*       in FoxPro 2.5 added. Use of color schemes
*       & SYSDATA added
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*       Since the memory error messages are so different for
*       Windows and DOS, I kept the Windows screen exactly the same
*       and branch to either low_memw for Windows or low_memd for DOS
*
*	Modified by Tamar E. Granor 11/94
*		Created procedure Low_memm based on Low_Memd for Mac
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DO uhoh
CLEAR WINDOWS
CLOSE DATA
* ===========================================
* NOTE: Depending upon your application,
*       simply clearing all windows and
*       closing databases may not
*       be sufficient.  You may also need
*       to release popups or menus first
* =========================================
* =======================================
* Memvars for color schemes have not
* been initialized therefore hard coding
* of colors is required here
* =======================================
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu.'
lcText= "You do not have enough memory to continue at this point."+CHR(13)+ ;
        "You will need to reconfigure your computer to make"+CHR(13)+ ;
        "more memory available."+CHR(13)
lcText2="You may need to increase the Suggested Memory for "+CHR(13)+ ;
		"this application, shut down other applications or turn "+CHR(13)+ ;
		"on Virtual Memory to make more memory available."
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure LOW_MEMM

*!*****************************************************************************
*!
*!      Procedure: NOTFOXWEXE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE notfoxwexe
*******************************************************************************
*& Error # 1196 - <file> is not a FoxPro Windows .EXE file
*
*   This error would usually occur when attempting to
*   DO an .EXE from the interactive version of FoxPro Windows.
*
*   Routine assumes memvar named XMSG which contains
*   the contents of the error message has been
*   initialized at a higher level
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/7/93
*
*   Modified by Pat Adams 3/12/93
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
lcMessage='Press any key to return to the Command window.'
lcText= "The file you are attempting to 'DO' " + CHR(13) + ;
        "is not a FoxPro "+IIF(_Dos,"DOS ",IIF(_Windows,'Windows ','Mac '))+".EXE file" + CHR(13) + ;
        "or has been compiled for a different" + CHR(13) + ;
        "version of FoxPro "+IIF(_Dos,"DOS.",IIF(_Windows,'Windows.','Mac.'))+CHR(13)
lcText2=".EXE files compiled for FoxPro "+IIF(_Dos,"Windows or Mac",;
         IIF(_Windows,'Dos or Mac','Windows or MSDOS'))+ CHR(13) + ;
        "can not be used via the DO command" + CHR(13) + ;
        "in FoxPro " +IIF(_Dos,"DOS.",IIF(_Windows,"Windows.","Mac."))
DO uhoh
=BUGBOX(lcText,'Stop','OK','',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NOTFOXWEXE

*!*****************************************************************************
*!
*!      Procedure: BAD_RESRC
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_resrc
*******************************************************************************
*& Error # 1294 - FOXUSER file is invalid
*
*   NOTE: You may want to change this message if
*         users are working interactively with
*         FoxPro
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/7/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE userfile
STORE SYS(2005) TO userfile
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
ACTIVATE SCREEN
lcMessage='Press any key to return to '+IIF(_Dos,"DOS.",IIF(_Windows,'Windows.','the Finder.'))
lcText= "Your resource file - " + CHR(13) + ;
         userfile + CHR(13) + ;
        "has been corrupted! Please reinstall the file." +CHR(13)
lcText2="If you do not know how to do this, contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_RESRC

*!*****************************************************************************
*!
*!      Procedure: DEVELOPER
*!
*!      Called by: UPMVCOUNT          (procedure in FPWERROR.PRG)
*!               : LOWFILES           (procedure in FPWERROR.PRG)
*!               : TOOBIG             (procedure in FPWERROR.PRG)
*!               : BAD_RPT            (procedure in FPWERROR.PRG)
*!               : BADMEMFL           (procedure in FPWERROR.PRG)
*!               : READONLY           (procedure in FPWERROR.PRG)
*!               : SQL_INTL           (procedure in FPWERROR.PRG)
*!               : SQLTRASH           (procedure in FPWERROR.PRG)
*!               : NOSQLIDX           (procedure in FPWERROR.PRG)
*!               : MEM_PROB           (procedure in FPWERROR.PRG)
*!               : KODEKORUP          (procedure in FPWERROR.PRG)
*!               : BADCHAIN           (procedure in FPWERROR.PRG)
*!               : BAD_API            (procedure in FPWERROR.PRG)
*!               : BADCLOSE           (procedure in FPWERROR.PRG)
*!               : BAD_OBJ            (procedure in FPWERROR.PRG)
*!               : BAD_RESRC          (procedure in FPWERROR.PRG)
*!               : SNOACCES           (procedure in FPWERROR.PRG)
*!               : NOAPI              (procedure in FPWERROR.PRG)
*!               : NO_FLL             (procedure in FPWERROR.PRG)
*!               : NOSQLOPEN          (procedure in FPWERROR.PRG)
*!               : PROGBUG            (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE developer
*******************************************************************************
*& Get info on Developer from SYSDATA database.
*
*   This module assumes that memory variables
*   M_CALL, M_TITLE and M_PHONE have been
*   initialized at the calling level.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 12/30/92
*
*	Modified by Tamar E. Granor 11/94
*		Added UPPER() in case Sysdata file uses mixed case.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR UPPER(ALLTRIM(sysdata.title)) == "DEVELOPER"
STORE ALLTRIM(sysdata.call_who) TO m_call
STORE ALLTRIM(sysdata.other) TO m_title
STORE ALLTRIM(sysdata.phone) TO m_phone
USE
RETURN
* End procedure DEVELOPER


*!*****************************************************************************
*!
*!      Procedure: LAN_ADMIN
*!
*!      Called by: NO_FILE            (procedure in FPWERROR.PRG)
*!               : LOWFILES           (procedure in FPWERROR.PRG)
*!               : INDEX_ER           (procedure in FPWERROR.PRG)
*!               : NOMEMO             (procedure in FPWERROR.PRG)
*!               : LREADONLY          (procedure in FPWERROR.PRG)
*!               : SQL_IDX            (procedure in FPWERROR.PRG)
*!               : IO_FAILED          (procedure in FPWERROR.PRG)
*!               : MEM_PROB           (procedure in FPWERROR.PRG)
*!               : KODEKORUP          (procedure in FPWERROR.PRG)
*!               : BADRIGHTS          (procedure in FPWERROR.PRG)
*!               : NOCREATE           (procedure in FPWERROR.PRG)
*!               : READ_ERR           (procedure in FPWERROR.PRG)
*!               : RITE_ERR           (procedure in FPWERROR.PRG)
*!               : BADCLOSE           (procedure in FPWERROR.PRG)
*!               : NORUN              (procedure in FPWERROR.PRG)
*!               : OLE_SAVE           (procedure in FPWERROR.PRG)
*!               : DNOACCES           (procedure in FPWERROR.PRG)
*!               : NOACCESS           (procedure in FPWERROR.PRG)
*!               : NO_CDX             (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE lan_admin
*******************************************************************************
*& Get info on LAN ADMINISTRATOR from SYSDATA database
*& or if stand-alone system APP ADMINISTRATOR
*
*   This module assumes that memory variables
*   M_CALL, M_TITLE and M_PHONE have been
*   initialized at the calling level.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 12/30/92
*
*	Modified by Tamar E. Granor 11/94
*		Added UPPER() in case Sysdata file uses mixed case.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
IF sysdata.multi_user
    LOCATE FOR UPPER(ALLTRIM(sysdata.title)) == "LAN ADMINISTRATOR"
ELSE
    LOCATE FOR UPPER(ALLTRIM(sysdata.title)) == "APP ADMINISTRATOR"
ENDIF (sysdata.multi_user)

STORE ALLTRIM(sysdata.call_who) TO m_call
STORE ALLTRIM(sysdata.other) TO m_title
STORE ALLTRIM(sysdata.phone) TO m_phone
USE
RETURN
* End procedure LAN_ADMIN


*!*****************************************************************************
*!
*!      Procedure: APP_ADMIN
*!
*!      Called by: NO_FILE            (procedure in FPWERROR.PRG)
*!               : TOO_HIGH           (procedure in FPWERROR.PRG)
*!               : REALBAD            (procedure in FPWERROR.PRG)
*!               : INDEX_ER           (procedure in FPWERROR.PRG)
*!               : NOMEMO             (procedure in FPWERROR.PRG)
*!               : KORRUPT            (procedure in FPWERROR.PRG)
*!               : BAD_DIF            (procedure in FPWERROR.PRG)
*!               : BAD_SYLK           (procedure in FPWERROR.PRG)
*!               : NOTRIGHT           (procedure in FPWERROR.PRG)
*!               : BADLOTUS           (procedure in FPWERROR.PRG)
*!               : NOCREATE           (procedure in FPWERROR.PRG)
*!               : RITE_ERR           (procedure in FPWERROR.PRG)
*!               : NORUN              (procedure in FPWERROR.PRG)
*!               : BAD_OLE            (procedure in FPWERROR.PRG)
*!               : NO_OLE             (procedure in FPWERROR.PRG)
*!               : OLE_SAVE           (procedure in FPWERROR.PRG)
*!               : OLEKREATE          (procedure in FPWERROR.PRG)
*!               : KLIPBOARD          (procedure in FPWERROR.PRG)
*!               : BAD_WIN            (procedure in FPWERROR.PRG)
*!               : BADEXCEL           (procedure in FPWERROR.PRG)
*!               : BADSYMPH           (procedure in FPWERROR.PRG)
*!               : NO_CDX             (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE app_admin
*******************************************************************************
*& Get info on APP ADMINISTRATOR from SYSDATA database
*
*   This module assumes that memory variables
*   M_CALL, M_TITLE and M_PHONE have been
*   initialized at the calling level.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 12/30/92
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(sysdata.title) == "APP ADMINISTRATOR"
STORE ALLTRIM(sysdata.call_who) TO m_call
STORE ALLTRIM(sysdata.other) TO m_title
STORE ALLTRIM(sysdata.phone) TO m_phone
USE
RETURN
* End procedure APP_ADMIN

*!*****************************************************************************
*!
*!      Procedure: DNOACCES
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE dnoacces
*******************************************************************************
* This routine is called if running on a DOS based LAN
*
*& #1705 - File access denied
*      An attempt was made to write to a file that is
*      write protected by the DOS ATTRIB command.
*
*  DOS-based LANs:
*  #1705 File is in [exclusive] use by another.
*
*      Error #3 should be returned if a file is in exclusive
*      use by someone else, however, DOS based LANs that utilize
*      DOS SHARE such as InvisibleNet and LANtastic erroneously
*      return error 1705. This also occurs with Novell's Netware
*      Lite because it utilizes SHARE.  The problem does not
*      lie with FoxPro but, rather, with SHARE.
*
*      If you are using a DOS based LAN and get frequent recurrence
*      of error # 1705 and you are sure users have the correct LAN
*      rights this may be the culprit.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*
*	Modified by Tamar E. Granor 11/94
*		Added Mac-specific message re: file sharing
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS tryagain
* =============================================
*$ Get info on person to call
* =============================================
DO lan_admin
ACTIVATE SCREEN
lcMessage='Press Y to Retry, N to return to the Main Menu.'
lcText= "One of two problems may have occurred:"+ CHR(13)+CHR(13)+ ;
        "1. You are attempting to write to a file that has been" + CHR(13) + ;
        "     made read-only by "+IIF(_Mac, "being locked;","the DOS ATTRIB command;") + CHR(13) + ;
        "2. Someone else may have had exclusive use of the" + CHR(13) + ;
        "     file you need. If so, it may be available now."  +CHR(13)
lcText2="You can retry for use of the file. However, if this" + CHR(13) + ;
        "message continues to appear do not keep" + CHR(13) +  ;
        "retrying.  Instead, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
tryagain=BUGBOX(lcText,'Caution','Retry','SORRY',lcMessage,lcText2)
RETURN tryagain
* End procedure DNOACCES

*!*****************************************************************************
*!
*!      Procedure: NOACCESS
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE noaccess
*******************************************************************************
*
*   This routine is only called if SYSDATA indicates user
*   is running in a LAN environment and the LAN is not a
*   DOS based LAN such as InvisibleNET, LANtastic, or
*   Novell Netware Lite.
*
*$ #1705 - File access denied
*
*  Attempt has been made to write to a file that is
*  read only.  This may arise for several reasons:
*
*      1.  File is protected by the DOS
*          ATTRIB command as read only
*
*      2.  User rights have not been
*          configured properly for this
*          users LAN access.  Note that
*          a .DBF file may be opened  (for purposes
*          of reading or copying the file) with
*          read only rights on a LAN but
*          index files require both read and
*          write rights.
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/5/91
*
*   Modified 1/4/93 by Pat Adams
*       Module changed to respond only to error
*       #1705 when it occurs on a non_DOS LAN
*       such as Novell 286/386, Banyan, etc.
*
*   Modified 3/13/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
lcMessage='Press any key to return to the Main Menu.'
lcText= "One of two problems has occurred." + CHR(13) +CHR(13)+ ;
        "Either you do not have the appropriate" + CHR(13) + ;
        "use rights on the LAN or the file you" + CHR(13) + ;
        "need has inadvertently been flagged" + CHR(13) + ;
        "as read only or non-sharable." +CHR(13)
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
*End procedure NOACCESS

*!*****************************************************************************
*!
*!      Procedure: SNOACCES
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE snoacces
*******************************************************************************
*& Error #1705 - File access denied
*
*  Attempt has been made to write to a file that is
*  read only.   File is protected by the DOS
*  ATTRIB command as read only.
*
*  This module is called if user is working
*  in stand-alone mode.
*
*  Author: Pat Adams, DB Unlimited  (718) 469-4032
*  Date: 1/4/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*       When working in Windows on a standalone machine with SHARE
*       loaded, you may run multiple instances of FPD or FPW or both.
*       Error #1705 will occur if a user tries to use a file in one
*       instance which is in exclusive use in another instance.
*       Consequently, I changed this procedure to reflect that and
*       allow the user to retry.
*
*	Modified by Tamar E. Granor 11/94
*		Changed message to be appropriate to MAC as well.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS tryagain
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer

lcMessage='Press Y to Retry, N to return to the Main Menu.'
lcText= "You may be attempting to write to a floppy disk that is" + CHR(13) + ;
        "write protected or to a file that has been made read only." +CHR(13)+CHR(13)+ ;
        "If you are running "+iif(_Mac,'on the Mac','in Windows,')+ "the file may be in use in " + CHR(13) + ;
        "another instance of this application. If so, you can " 
lcText2="retry after correcting the situation. "+CHR(13)+CHR(13)+ ;
        "If you are not running"+iif(_Mac,'on the Mac','in Windows,')+"and not attempting to "+CHR(13)+ ;
        "write to a floppy disk, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone

DO uhoh
tryagain=BUGBOX(lcText,'Caution','Retry','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN tryagain
* End procedure SNOACCES
*******************************************************************************
PROCEDURE mnoacces
*******************************************************************************
* This routine is called if running on a Mac
*
*& #1705 - File access denied
*      An attempt was made to write to a file that is
*      write protected.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*
*	Modified by Tamar E. Granor 11/94
*		Created separate routine to handle Mac case
*       Added Mac-specific message re: file sharing
*		I'm actually not sure whether this error is called
*		for file sharing problems.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS tryagain
* =============================================
*$ Get info on person to call
* =============================================
DO lan_admin
ACTIVATE SCREEN
lcMessage='Press Y to Retry, N to return to the Main Menu.'
lcText= "One of two problems may have occurred:"+ CHR(13)+CHR(13)+ ;
        "1. You are attempting to write to a file that has been" + CHR(13) + ;
        "     made read-only by being locked; "+ CHR(13) + ;
        "2. You are attempting to use a file that is in use by another "+CHR(13)+ ;
        "     application. You may need to turn file sharing on." + CHR(13)
lcText2="You can retry for use of the file. However, if this" + CHR(13) + ;
        "message continues to appear do not keep" + CHR(13) +  ;
        "retrying.  Instead, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
tryagain=BUGBOX(lcText,'Caution','Retry','SORRY',lcMessage,lcText2)
RETURN tryagain
* End procedure MNOACCES

*!*****************************************************************************
*!
*!      Procedure: NOSQLOPEN
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE nosqlopen
*******************************************************************************
*
*& #823 - SQL open of file failed  (FoxPro 2.0)
*& #1823 - SQL open of file failed
*
*   Error # 823 or # 1823 is generated when a SQL open of a
*   specified file fails.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
lcMessage='Press any key to return to the Main Menu.'
lcText= "Unable to open the required SQL table!" +CHR(13)
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NOSQLOPEN

*!*****************************************************************************
*!
*!      Procedure: UPMVCOUNT
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE upmvcount
*******************************************************************************
*& #21 -  String memory variable area overflow
*& #22 -  Too many memory variables
*
*  The MVCOUNT statement in the
*  CONFIG.FP file needs to be increased.
*  Advise user & return to Main Menu
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified 3/11/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*
*	Modified by Tamar E. Granor 11/94
*		Changed message to refer to appropriate CONFIG.FP file	
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLOSE DATA
CLEAR MEMORY
PRIVATE m_call, m_title, m_phone, pshbutton
STORE SPACE(0) TO m_call, m_title, m_phone
STORE 1 TO  pshbutton
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText= "We've run out of space for memory variables!" +CHR(13)+CHR(13)+ ;
        "The MVCOUNT statement in your "+ ;
        IIF(_DOS,"CONFIG.FP",IIF(_WINDOWS,"CONFIG.FPW","CONFIG.FPM")) + CHR(13) + ;
        "file needs to be increased." +CHR(13)
lcText2="If you don't know how to do this, please contact:"+CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)        
CLEAR TYPEAHEAD
RETURN
* End procedure UPMVCOUNT

*!*****************************************************************************
*!
*!      Procedure: TOOBIG
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE toobig
*******************************************************************************
*& Error # 39 - Numeric overflow (data was lost)
*
*   A methematical operation resulted in a number that
*   was too large to be stored in the field or memvar
*   in which it was supposed to be placed.
*
*   Inform user info was lost, have them call the
*   developer/programmer and return to main menu.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified 3/12/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO developer
lcMessage='Press any key to return to Main Menu'
lcText= "The number being calculated was too large!" + CHR(13) + ;
        "The information has been lost."+CHR(13)
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure TOOBIG

*!*****************************************************************************
*!
*!      Procedure: LREADONLY
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE lreadonly
*******************************************************************************
*   This routine is called if the SYSDATA file shows
*   user is working in a LAN environment.
*
*&Error #111 -  Attempt was made to write to a read-only file
*
*   The most likely cause of this is attempting to
*   write to a file created as read-only or accessed
*   as read-only under program control.  User is in-
*   structed to call the developer because it is probably
*   a programming error.
*
*& #1718 - File is read only
*
*     1.  An attempt was made to write to a file whose
*         attribute is read only.  If the file is located
*         on a floppy disk the floppy may be write protected.
*
*     2.  User rights have not been
*         configured properly for this
*         users LAN access.  Note that
*         a .DBF file may be opened  (for purposes
*         of reading or copying the file) with
*         read only rights on a LAN but
*         index files require both read and
*         write rights.
*
*   These errors may also occur if a database file has
*   accidentally been included in the .APP and/or
*   compiled into the .EXE.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified 3/12/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO lan_admin
lcMessage='Press any key to return to Main Menu'
lcText= "It's not possible to save your information in the file." + CHR(13) + ;
        "This may be caused by one of several problems:"+CHR(13)+CHR(13)+  ;
        "1. You are attempting to save to a floppy disk" + CHR(13) + ;
        "     that is write-protected"  + CHR(13) +;
        "2. You do not have correct user rights on the LAN" 
lcText2="3. The file you are using is read-only" + CHR(13) + CHR(13)+ ;
        "If item #1 above does not apply, please report this "+CHR(13)+;
        "problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure LREADONLY

*!*****************************************************************************
*!
*!      Procedure: REC2BIG
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE rec2big
*******************************************************************************
*& Error #392 - Maximum record length exceeded in import file.
*
*   An attempt has been made to import a file that has a
*   record length greater than 65,000 bytes.
*
*   Advise user & return to main menu.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/4/93
*
*   Modified 3/12/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText= "The records in the file you are attempting to import are too big." + CHR(13) + ;
        "" + CHR(13) + 	;
        "Each individual record can not be larger than 65,000 bytes." + CHR(13) + ;
        "The records in the file to be imported exceed this limit."  
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage)
CLEAR TYPEAHEAD
RETURN
* End procedure REC2BIG

*!*****************************************************************************
*!
*!      Procedure: IO_FAILED
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE io_failed
*******************************************************************************
*& Error #1002 - I/O operation failure
*
*  DOS is unable to perform a file
*  or hardware operation.  Inform user
*  and return to Windows.
*
*  Different messages are provided depending
*  upon whether user is working in stand-alone
*  mode or in a LAN environment, as determined
*  by SYSDATA.DBF.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/5/93
*
*   Modified 3/12/93 by Pat Adams
*       Changed to FPW format.
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF ! sysdata.multi_user
    * ===============================================
    * Message if user is working in stand-alone mode.
    * ===============================================
    lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
    lcText= "A hardware failure or an operating system failure has occurred!" +CHR(13)+ ;
            "You should quit "+IIF(_Dos or _Mac,"","Windows ")+"and have your computer checked." 
    DO uhoh
     =BUGBOX(lcText,'Stop','OK','REAL BAD NEWS',lcMessage)
ELSE
    * ===============================================
    * Otherwise, if working in LAN environment call
    * the LAN administrator.
    * ===============================================
    DO lan_admin && GET INFO on person to call
    lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
    lcText= "A hardware failure or an operating system failure "+ ;
            "has occurred!"+CHR(13)+;
            IIF(_Dos or _Mac,"","After you have returned to Windows, you should quit to DOS.")
            
    lcText2="Please report this problem immediately to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
    DO uhoh
    =BUGBOX(lcText,'Stop','OK','REAL BAD NEWS',lcMessage,lcText2)
ENDIF (! sysdata.multi_user)
CLEAR TYPEAHEAD
RETURN
* End procedure IO_FAILED

*!*****************************************************************************
*!
*!      Procedure: USTRING
*!
*!      Called by: SETENVMT           (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE ustring
*******************************************************************************
*	Create a Unique Character String
*
*   Usage: ? USTRING()
*          Store USTRING() TO memvar
*
*   Author: Pat Adams
*   Date: 4/16/92
*   Copyright 1992 DB Unlimited
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS sendback
STORE SUBSTR(SYS(3), 4, 4) + ;
    SUBSTR(SYS(2015),7,4) TO sendback
RETURN sendback

*!*****************************************************************************
*!
*!      Procedure: MEM_PROB
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE mem_prob
*******************************************************************************
*& #1003 - Free handle not found
*& #1004 - Use of invalid handle
*& #1005 - Use of unallocated handle
*& #1006 - Use of transgressed handle
*& #1009 - Incorrect handle found during compaction
*& #1011 - Area can not contain handle
*& #1000 - Internal consistency error
*& #1296 - Error reading resource.  (Internal
*            FoxPro error)
*& #1462 - File internal consistency error
*
*   Advise user a memory problem has
*   occurred and return to DOS.  The FoxPro
*   docs request that Microsoft be called if
*   these problems occur.
*
*   Note that it is possible that error #1006
*   may result from a corrupted index file.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLOSE DATA
CLEAR WINDOWS
SELECT 0
USE sysdata NOUPDATE
CLEAR
ACTIVATE SCREEN

IF sysdata.multi_user
    DO lan_admin
ELSE
    DO developer
ENDIF (sysdata.multi_user)

lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
lcText= "A memory management problem has occurred!" + CHR(13) + ;
         IIF(_Dos or _Mac,"","You should quit Windows and return to DOS.")+CHR(13)
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone      
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lctext2)
CLEAR TYPEAHEAD
RETURN
* End procedure MEM_PROB

*!*****************************************************************************
*!
*!      Procedure: KODEKORUP
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE kodekorup
*******************************************************************************
*& #1007 - Transgressed node found during compaction
*& #1008 - Foreign node found during compaction
*& #1010 - Area size exceeded during compaction
*
*   The most likely causes of these errors is that
*   the compiled code has become corrupted or FoxPro
*   itself has become corrupted.  Advise user and
*   return to DOS.
*
*   Note that the message only informs the user that
*   the compiled code may have become corrupted.
*   This is because FPWERROR is aimed primarily at
*   handling errors in running applications.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
*
*	Modified 3/27/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLOSE DATA
USE sysdata NOUPDATE
CLEAR WINDOWS
ACTIVATE SCREEN
CLEAR

IF sysdata.multi_user
    * ===============================
    * If in multi-user mode call
    * LAN administrator
    * ===============================
    DO lan_admin
ELSE
    * ===============================
    * Otherwise call developer
    * ===============================
    DO developer
ENDIF (sysdata.multi_user)

lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
lcText= "It appears your source code may have " + CHR(13) + ;
        "become corrupted!  We can not continue." +CHR(13)
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure KODEKORUP

*!*****************************************************************************
*!
*!      Procedure: BAD_API
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_api
*******************************************************************************
*& Error #1098 - API function _UserError() was called.
*   There is a problem with the API library being
*   used that resuled in the _UserError being called.
*   The error # returned by _UserError will provide
*   more detailed information on the error in the .PLB.
*
*& Error #1190 - Invalid .LIB signature
*& Error #1192 - Internal .LIB undefined symbol error
*& Error #1691 - Library file is invalid
*& Error #1711 - API library revision mismatch.
*
*   The SET LIBRARY TO command is utilized to remove
*   all .PLBs from memory and user is returned to
*   the main menu or master module.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
*
*   Modified 3/14/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET LIBRARY TO
ACTIVATE SCREEN
* ================================
*$ Get info on person to call
* ================================
DO developer
lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
lcText= "There seems to be a problem with an API library being used."+CHR(13)+ ;
        chr(13)+"Please contact:"+chr(13)
lcText2=SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_API

*!*****************************************************************************
*!
*!      Procedure: TRANSACTN
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: NICECHIM           (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE transactn
*******************************************************************************
*& #1106 - Transaction in progress
*
*   Another user in the midst of a Novell transaction
*   that involves database records, indexes or memo
*   fields needed at this point.  Advise user and
*   provide option to retry.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
*
*   Modified 3/14/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
ACTIVATE SCREEN
lcMessage='Would you like to retry? (Y/N)'
lcText= "Another user was in the midst of a transaction" + CHR(13) + ;
        "involving the data you require. If you retry the" + CHR(13) + ;
        "transaction may be completed by now and the" + CHR(13) + ;
        "data available."  
DO nicechim
re_try=BUGBOX(lcText,'Caution','Retry','SORRY',lcMessage)

CLEAR TYPEAHEAD
RETURN re_try
* End procedure TRANSACTN

*!*****************************************************************************
*!
*!      Procedure: BAD_OBJ
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_obj
*******************************************************************************
*& Error #1195 - Object file is the wrong version
*
*   This message will occur if running the
*   interactive version of FoxPro and the
*   source code can not be found or has been
*   compiled with a different version of FoxPro.
*
*& Error #1309 - File is not an object file
*
*   Object file has most likely become corrupted.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/8/93
*
*   Modified 3/14/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ==================================
*$ Get info on person to call
* ==================================
DO developer
lcMessage='Press any key to return to Main Menu'
lcText= "Your source code has been compiled with a" + CHR(13) + ;
        "different version of FoxPro and can not be run."+CHR(13)  
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_OBJ

*!*****************************************************************************
*!
*!      Procedure: BAD_WIN
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_win
*******************************************************************************
*& #1632 - Invalid window format
*          .WIN file has become corrupted
*
*   Advise user and return to Main Menu
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified 3/14/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ======================================
*$ Get info on person to call
* ======================================
DO app_admin
lcMessage='Press any key to return to Main Menu'
lcText= "A required file has become corrupted.  We can not continue." +CHR(13)
lcText2="Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
 
CLEAR TYPEAHEAD
RETURN
* End procedure bad_win

*!*****************************************************************************
*!
*!      Procedure: ENKRYPTED
*!
*!      Called by: FPWERROR.PRG                      
*!
*!*****************************************************************************
PROCEDURE enkrypted
*******************************************************************************
*& #1671 - Cannot import from password protected file
*& #1672 - Cannot append from password protected file
*
*   Inform user and return to main menu (master module)
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified 3/15/93 by Pat Adams
*       Chantged to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText= "You are attempting to import or add data from a password" + CHR(13) + ;
        "protected or encrypted file. The file must first be unprotected."  
DO uhoh
=BUGBOX(lcText,'Stop','OK','WHOOPS',lcMessage)
CLEAR TYPEAHEAD
RETURN
* End procedure enkrypted

*!*****************************************************************************
*!
*!      Procedure: A_ONLY
*!
*!      Called by: FPWERROR.PRG                      
*!
*!*****************************************************************************
PROCEDURE a_only
*******************************************************************************
*& #1679 - Import only Worksheet A for Lotus 1-2-3
*          version 3.0 files
*
*          Worksheets B and C can not be imported
*          because a table is two-dimensional.
*
*   Inform user and provide the option to continue
*   with import or abandon the import.
*
*   The passed parameter, GO_ON, is a logical memvar
*   returned to the calling module.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified 3/15/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS go_on
ACTIVATE SCREEN
lcMessage='Do you want to continue with the import? (Y/N)'
lcText="The Lotus worksheet or table you are attempting" + CHR(13) + ;
       "to import is two-dimensional. It's only possible to" + CHR(13) + ;
       "import the first worksheet."
DO uhoh
go_on=BUGBOX(lcText,'Caution','Import','SORRY',lcMessage)
CLEAR TYPEAHEAD
RETURN go_on
* End procedure A_ONLY

*!*****************************************************************************
*!
*!      Procedure: L_HIDE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!*****************************************************************************
PROCEDURE l_hide
*******************************************************************************
*& #1680 - Worksheet for Lotus 1-2-3 v 3.0
*          file is hidden.  FoxPro can not
*          import a hidden worksheet.
*
*   Inform user and return to main menu (master)
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified 3/16/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText= "The Lotus spreadsheet you are attempting to " + CHR(13) + ;
        "import is hidden.  It can not be imported until" + CHR(13) + ;
        "it has been unhidden." 
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage)
 
CLEAR TYPEAHEAD
RETURN
* End procedure L_HIDE

*!*****************************************************************************
*!
*!      Procedure: BAD_PARDX
*!
*!      Called by: FPWERROR.PRG                      
*!
*!*****************************************************************************
PROCEDURE bad_pardx
*******************************************************************************
*& #1688 - Invalid Paradox v 3.5 file
*
*   File being imported is not a version 3.5
*   Paradox file or else it has become corrupted.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified 3/16/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
lcMessage='Press any key to return to Main Menu'
lcText= "Either the file you are trying to import is not a" + CHR(13) + ;
        "Paradox 3.5 file or it has been corrupted. Unable" + CHR(13) + ;
        "to complete the import." 
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage)
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_PARDX

*!*****************************************************************************
*!
*!      Procedure: NOAPI
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE noapi
*******************************************************************************
*& #1709 - Cannot load 16-bit API interface
*
*   The most likely cause is that the FOXPROW.EXE
*   file has become corrupted or the .EXE compiled
*   application has become corrupted.  Inform user
*   and quit to Windows.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified 3/17/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN

IF ATC("LIBRARY", VERS(1)) > 0
    * ==============================================
    * User is running an .EXE complied application
    * ==============================================
    DO developer && GET info on person to call
    lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
    lcText= "It appears that your software may have become corrupted." + CHR(13) + ;
            "If you have a back-up copy please reinstall it." + CHR(13) + ;
            "Since we can't continue, you will be returned to "+ ;
            IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))+CHR(13)
    lcText2="If you don't have a back-up copy, please contact:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
    DO uhoh
    =BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
ELSE
    * ==============================================
    * User is running interactive FoxPro Windows
    * ==============================================
    lcMessage='Press any key to return to '+IIF(_Dos,"DOS",IIF(_Windows,'Windows','the Finder'))
    lcText= "It appears your "+;
             IIF(_Dos,IIF('(X)'$VERS(1),"FOXPROX.EXE","FOXPRO.EXE"),IIF(_Windows,"FOXPROW.EXE","Microsoft FoxPro"))+ ;
             " file may have" + CHR(13) + ;
            "become corrupted. Please reinstall FoxPro for "+IIF(_Dos,"MSDOS.",IIF(_Windows,'Windows','Mac'))
    DO uhoh
    =BUGBOX(lcText,'Stop','OK','SORRY',lcMessage)
ENDIF (ATC("LIBRARY", VERS(1)) > 0)
CLEAR TYPEAHEAD
RETURN
* End procedure NOAPI

*!*****************************************************************************
*!
*!      Procedure: NO_FLL
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: DEVELOPER          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE no_fll
*******************************************************************************
*& #1726 - API library file could not be found
*
*   Author: Pat Adams, DB Unlimited
*   Date: 1/11/93
*
*   Modified 3/16/93 by Pat Adams
*       Changed to FPW format
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*       Same error, same message as for DOS missing .PLB file
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* =================================
* Get info on person to be called
* =================================
DO developer
lcMessage='Press any key to return to Main Menu'
lcText= "An API library file could not be found!" 
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NO_FLL

*!*****************************************************************************
*!
*!      Procedure: NO_OLE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE no_ole
*******************************************************************************
*& Error #1421 - Cannot activate OLE server
*
*   User is returned to "master" (main menu)
*
*   Author: Pat Adams, DB Unliited
*   Date: 3/21/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*
* 	Modified by Tamar E. Granor 11/94
* 		Removed the word "Windows" from message to make Mac-appropriate
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* =================================
* Get info on person to be called
* =================================
DO app_admin
lcMessage='Press any key to return to Main Menu'
lcText= "Unable to activate the other application" + CHR(13) + ;
        "required at this point."
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NO_OLE

*!*****************************************************************************
*!
*!      Procedure: KLIPBOARD
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE klipboard
*******************************************************************************
*& Error #1424 - Error copying OLE object to clipboard
*
*   User is provided with option to retry the
*   operation that created the error.
*
*   Author: Pat Adams, DB Unlimited
*   Date: 3/12/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
ACTIVATE SCREEN
* =================================
* Get info on person to be called
* =================================
DO app_admin
lcMessage='Press Y to Retry, N to return to Main Menu.'
lcText= "An error occurred while attempting to copy the"+CHR(13)+ ;
        "OLE object to the Clipboard."
DO uhoh
re_try=BUGBOX(lcText,'Caution','Retry','SORRY',lcMessage)
CLEAR TYPEAHEAD
RETURN re_try
* End procedure KLIPBOARD

*!*****************************************************************************
*!
*!      Procedure: OLEKREATE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE olekreate
*******************************************************************************
*& Error # 1423 - Error creating OLE object
*
*   Author: Pat Adams, DB Unlimited
*   Date: 3/22/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ===============================
*$ Get info on person to call
* ===============================
DO app_admin
lcMessage='Press any key to return to Main Menu'
lcText= "Unable to create a required OLE object." 
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure OLEKREATE

*!*****************************************************************************
*!
*!      Procedure: OLE_SAVE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FPWERROR.PRG)
*!               : APP_ADMIN          (procedure in FPWERROR.PRG)
*!               : UHOH               (procedure in FPWERROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE ole_save
*******************************************************************************
*& Error #1422 - Error saving OLE object
*
*   If user is working in a LAN environment
*   s/he is advised to call the LAN adminis-
*   trator since this problem may be caused
*   by incorrect LAN rights.  In a stand-
*   alone environment user is instructed to
*   call the application administrator.
*
*   Author: Pat Adams, DB Unlimited
*   Date: 3/23/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    * ===============================
    *$ Get info on person to call
    * ===============================
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)

lcMessage='Press any key to return to Main Menu'
lcText= "An error was encountered when attempting to save an OLE object."
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure OLE_SAVE

*!*****************************************************************************
*!
*!      Procedure: BAD_OLE
*!
*!      Called by: FPWERROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FPWERROR.PRG)
*!
*!*****************************************************************************
PROCEDURE bad_ole
******************************************************
*& Error #1420 - Invalid or corrupted OLE object
*
*   Author: Pat Adams, DB Unlimited
*   Date: 3/23/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ================================
*$ Get info on person to call
* ================================
DO app_admin
lcMessage='Press any key to return to Main Menu'
lcText= "An OLE file appears to have become corrupted" + CHR(13) + ;
        "We can not proceed."  
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_OLE

*!*****************************************************************************
*!  DOS SPECIFIC PROCEDURES
*!*****************************************************************************

*!*****************************************************************************
*!
*!      Procedure: INVALPRN
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : uhoh           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE invalprn
*******************************************************************************
*   Error #124 - Invalid printer redirection
*
*  This normally occurs when attempts are made to share a non-
*  sharable printer on a LAN or the path to the print device
*  has not been properly defined.
*
*  User will be returned to MASTER module.
*
*     Author: Pat Adams, DB Unlimited
*     Date: 8/9/91
*
*   Modified 1/7/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
*
*	Note by Tamar E. Granor 11/94
*		This item appears to be a non-issue for Macs, so message 
*		has not been changed to be more generic.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
DO lan_admin
lcMessage='Press any key to return to Main Menu.'
lcText= "An attempt was made to use an unavailable"+CHR(13)+ ;
        "print device. Either the printer you want"+CHR(13)+ ;
        "is not sharable or the correct DOS PATH"+CHR(13)+ ;
        "setting has not been made. This latter"+CHR(13)+ ;
        "problem can only be fixed by returning to"+CHR(13)+ ;
        "DOS, correcting matters there and then"
lcText2="entering this application again."+CHR(13)+ CHR(13)+;
         "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Caution','OK','WHOOPS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure INVALPRN

*!*****************************************************************************
*!
*!      Procedure: NOTREADY
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: uhoh           (procedure in FP25EROR.PRG)
*!               : YES_NO             (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE notready
*******************************************************************************
* Error #125 - Printer not ready
*
*   This error is triggered by a variety of problems:
*
*   1.  The printer is not turned on or plugged in.
*
*   2.  Printer is not on-line
*
*   3.  Printer out of paper or a paper jam has occurred
*
*   4.  The printer is timing out.  Changing the CONFIG.FP file
*       to include the statement:
*
*           TIME=10000000
*
*       and issuing a DOS command:
*
*           MODE LPT1,,p
*
*       to set up DOS for infinite retry of the printer will
*       usually help.
*
*   5.  The connection between the computer and the printer may
*       not be solid or the printer cable may be squashed.
*
*   Note that this error will occur infrequently, if at all, on a
*   LAN because output will normally be sent to a print spooler.
*
*   User is provided the option to try again for the printer or
*   Abort to the MASTER module.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
*
*   Modified 1/9/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
ACTIVATE SCREEN
lcMessage="Would you like to try for use of the printer again? (Y/N)"
lcText= "There is a problem with your printer. Check the following:" +CHR(13)+CHR(13)+ ;
        "1.  Is the printer turned on?" +CHR(13)+ ;
        "2.  Is the printer on-line? (A green light on the printer"+CHR(13)+ ;
        "    usually indicates the printer is on-line.)"+CHR(13)+ ;
        "3.  Is the printer out of paper or is there a paper jam?"+CHR(13)
lcText2="Try again or choose Cancel to return to Main Menu."
DO uhoh
re_try=BUGBOX(lcText,'Qmark','Retry','WHOOPS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN re_try
* End procedure NOTREADY

*!*****************************************************************************
*!
*!      Procedure: PKORRUPT
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : uhoh           (procedure in FP25EROR.PRG)
*!
*!*****************************************************************************
PROCEDURE pkorrupt
*******************************************************************************
*& Error #1643 - Printer driver corrupted
** Error #1644 - Printer driver is missing
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
*
*   Modified 1/8/93 by Pat Adams
*       Use of color schemes & SYSDATA added
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
* ========================================
*$ Get info on appropriate person to call
* ========================================
DO app_admin
lcMessage='Press any key to return to Main Menu'
lcText= "Your printer driver has been corrupted.  Printing" +CHR(13)+ ;
        "can not be done until this is corrected."
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','BAD NEWS',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure PKORRUPT

*: EOF: FPWERROR.PRG

*!*****************************************************************************
*!
*!      Procedure: NOPSERVER
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : UhOh          (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE nopserver
*******************************************************************************
*& #1715 - Server "<server>" could not be found.
*          The server specified with SET PRINTER TO
*          command could not be found.
*
*   The passed parameter is the name of the missing server.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
*
*   Modified by Nancy Jacobsen 5/93
*       Cross Platform
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETER pserver
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

DO lan_admin
lcMessage='Press any key to return to Main Menu'
lcText= "Print server &pserver could not be found."
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NOPSERVER

*!*****************************************************************************
*!
*!      Procedure: NO_QUE
*!
*!      Called by: FP25EROR.PRG                      
*!
*!          Calls: LAN_ADMIN          (procedure in FP25EROR.PRG)
*!               : APP_ADMIN          (procedure in FP25EROR.PRG)
*!               : RAZBERRY           (procedure in FP25EROR.PRG)
*!
*!           Uses: SYSDATA.DBF        
*!
*!*****************************************************************************
PROCEDURE no_que
*******************************************************************************
*&  #1716 - Queue <queue> not found.
*           The print queue specified in the SET
*           PRINTER TO command can not be found.
*
*   Passed parameter nopq is the name of the print que.
*
*   Author: Pat Adams, DB Unlimited  (718) 469-4032
*   Date: 1/11/93
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS nopq
PRIVATE m_call, m_title, m_phone
STORE SPACE(0) TO m_call, m_title, m_phone

IF ! USED("SYSDATA")
    SELECT 0
    USE sysdata NOUPDATE
ELSE
    SELECT sysdata
ENDIF (! USED("SYSDATA"))

IF sysdata.multi_user
    DO lan_admin
ELSE
    DO app_admin
ENDIF (sysdata.multi_user)

lcMessage='Press any key to return to Main Menu'
lcText= "Print queue &nopq could not be found."
lcText2=""+CHR(13)+ "Please report this problem to:" +CHR(13)+CHR(13)+ ;
        SPACE(5)+m_call +CHR(13)+ ;
        SPACE(5)+m_title +CHR(13)+ ;
        SPACE(5)+m_phone
DO uhoh
=BUGBOX(lcText,'Stop','OK','SORRY',lcMessage,lcText2)
CLEAR TYPEAHEAD
RETURN
* End procedure NO_QUE

*****************************************
* WINDOW DEFINITION PROCEDURES AND YES/NO
*****************************************

*!*****************************************************************************
*!
*!      Procedure: BUGBOX
*!
*!*****************************************************************************
PROCEDURE bugbox
****************************************************
*       Author: Nancy Jacobsen
*       Copyright (c) 1993, Nancy Jacobsen
*       Cross Platform Window definition procedure
*
*		Update: 11/93 Macintosh
*
* CALLING THIS PROCEDURE
* ----------------------
* This procedure may be called as a UDF, ;
* using a construct like:
*   =xpalert(lcText,'Stop','OK','SORRY',lcMessage, ;
*            lcText2)
*
* or
*
*  return_var=xpalert(lcText,'Stop','OK','SORRY' ;
*                     lcMessage,lcText2)
*
* It is also possible, of course, to DO this ;
* procedure with parameters.
*

* PARAMETERS
* ----------
* PARAMETERS lcText,lcBitMap,lhWhatButt,lcHeader,lcMsg, 
*            lcText2,lcTitle
*
* lcText=     First block of text to be displayed 
*             in the window. This should be limited 
*             to 254 characters, including expanded
*             variables and/or expressions. Only this 
*             parameter is *required*.
*
* lcBitMap =  The name of the bitmap that is to be 
*             displayed in the window. On the DOS side, 
*             this item is used to create a character 
*             equivalent. If not passed as a 
*             parameter, the "i" for information
*             bitmap is used as the default.
*
* lhWhatButt= The button set to be used in the 
*             window. This is used to determine 
*             which buttons are displayed. If not
*             passed as a parameter, the OK button
*             is used as the default.
*
* lcHeader=   Optional headline to appear in window.
*
* lcMsg=      This message is used instead of push 
*             buttons when the READ level is already
*             at the maximum of 5 and INKEY()
*             routine is used instead. If not passed
*             as a parameter, the default message is 
*             "Press any key to continue." 
*
* lcText2=    Optional second block of text. This 
*             should also be limited to 254 
*             characters. 
*
*

* * * * * * * * * * * * * * * * * * * * * * * * * * 
PARAMETERS lcText,lcBitMap, lhWhatButt,lcHeader,lcMsg, ;
           lcText2
PRIVATE    lcExclaim,lhPush,lcScrFont,lcPicture, ;
           lcPushWid,lnButtWid,llRetVal,lnRows, ;
           lnCols,lcSetMemo,lnFudge,lnRdLevel, ;
           lnParams,lcStyle,lcTitleFon,lcTitleSty;
           lcButtFont,lnCurRd

lnParams=PARAMETER()
lnCurRd=RDLEVEL()

*-- Establish some default values so only the first
*-- block of text needs to be passed as a parameter.
*-- I could have used lnParams to figure this out, 
*-- but doing it this way allows you to pass a 
*-- logical value to XPALERT if you want the 
*-- default values.

if UPPER(TYPE('lcBitMap'))='L'
  lcBitMap="Info"
endif
if UPPER(TYPE('lhWhatButt'))='L'  
  lhWhatButt='OK'
endif
if UPPER(TYPE('lcMsg'))='L' 
  lcMsg="Press any key to continue."
endif  

*-- The following code is used for testing only.
*-- A value of 1 for the parameter lnRdTest, tells 
*-- XPALERT that you want to see how the dialog 
*-- would look if the READ level were at the 
*-- maximum. If you want to test interactively, 
*-- set the value of lnRdLevel to zero. 
lnRdLevel=5    && normal
IF lnParams=7  && if testing
  lnRdLevel=IIF(lnRdTest=1,1,5)
ENDIF

*-- This procedure uses MLINE(). Changing MEMOWIDTH 
*-- will allow you to have more characters per line 
*-- in a message than FoxPro's default of 50. Also,
*-- if you're using this with an error handler, you
*-- don't know what the current MEMOWIDTH setting 
*-- is -- so we'll save it and restore it later.
lcSetMemo=SET('MEMOWIDTH')
SET MEMOWIDTH TO 100

*-- This is the variable that will be RETURNed
*-- to the calling program. This allows XPALERT to
*-- be used as a UDF. It will return .t. or .f.
*-- depending on the user's choice of options.
*-- If you need to have push button sets with
*-- more than two buttons, you'll need to return
*-- a number or character to the calling program
*-- instead and you'll have to rewrite XPALERT
*-- and the GETKEY procedure to reflect this 
*-- change.
llRetVal=.T.

*-- Font for window definition. The FONT clause
*-- is ignored in DOS.
*-- Also set fonts for the headline and push buttons
lcTitleSty='B'
DO CASE
  CASE _WINDOWS or _DOS
   lcScrFont="'Arial',10"
   lcStyle="STYLE 'B'"
   lcTitleFon="'Arial',12"
   lcButtFont="'Ms Sans Serif',8"
  
  CASE _MAC
   lcScrFont="'Geneva',10"
   lcStyle=''
   lcTitleFon="'Geneva',12"
   lcButtFont="'Geneva',9"

ENDCASE   

*-- Truncate text to 254 characters to avoid errors
*-- One of the hardest things to do when using 
*-- XPALERT is to limit text strings to 254 
*-- characters. This is necessary because @ ... SAY
*-- <text> will generate an error on longer strings.
*-- This is especially problematical when you are
*-- embedding variables or expressions which can
*-- vary in length depending on their current value.
*-- As a precaution, XPALERT truncates the two
*-- blocks of text to avoid these errors. If you use
*-- the viewer utility to create your code, you'll
*-- be able to create text blocks with *much* less
*-- trouble. In fact, that's one of the main reasons
*-- I wrote it!
lcText=LEFT(lcText,254)
IF !(UPPER(TYPE('lcText2'))='L' OR EMPTY(lcText2))
  lcText2=LEFT(lcText2,254)
ENDIF

*-- Determine window height
*-- The window height is a combination of text lines
*-- plus additional space for the push buttons or
*-- message. The additional space was determined
*-- largely by experimentation. You can change it,
*-- of course.
*-- The lines of text are calculated by counting
*-- the number of carriage returns in the text. The
*-- second block of text is positioned one row after
*-- the first block. A space between the two is 
*-- created by adding a carriage return to the end
*-- of the first block.
*-- Need to add an extra row for the Mac.
IF UPPER(TYPE('lcText2'))='L' OR EMPTY(lcText2)
  lnRows=OCCURS(CHR(13),lcText)+6
ELSE
  lnRows=OCCURS(CHR(13),lcText)+1+ ;
         OCCURS(CHR(13),lctext2)+6
ENDIF
IF _MAC
   lnRows=lnRows+1
ENDIF   

*-- Determine window width
*-- This uses the TXTWIDTH() function (which works
*-- like LEN() in DOS) to measure the actual width
*-- of the text in terms of the current window font.
*-- When lnCurRd=5 (maximum READ levels already 
*-- used), then we measure the width of the 
*-- alternate message too, since that will be 
*-- displayed rather than push buttons. Additional 
*-- spacing is then added to allow for the FPW 
*-- bitmap (or DOS equivalent) plus a right margin.
*-- For MS Sans Serif, no fudge factor was 
*-- necessary. However with some
*-- fonts, like Arial, it seemed to work better to 
*-- adjust the character width by multiplying it 
*-- times 1.1. You may need to adjust the fudge 
*-- factor (lnFudge) if you use a different window 
*-- font.
lnFudge=IIF(_Windows,1.1,1)
lnCols=0
FOR ii=1 TO MEMLINES(lctext) && determine # of lines
  lncols=MAX(lnCols,TXTWIDTH(MLINE(lctext,ii), ;
         &lcScrFont))
ENDFOR
IF UPPER(TYPE('lcText2'))<>'L'
  FOR ii=1 TO MEMLINES(lctext2)
    lncols=MAX(lnCols,TXTWIDTH(MLINE(lctext2,ii), ;
           &lcScrFont))
  ENDFOR
ENDIF
IF lnCurRd=lnRdLevel
  lnCols=MAX(lnCols,TXTWIDTH(lcmsg,&lcScrFont)+2)
ENDIF

*-- If you are using a fixed width font, you don't
*-- need to round up or consider the fudge factor.
*-- This test for whether a font is fixed width is
*-- necessary since FONTMETRIC(6) (average width)
*-- does not equal FONTMETRIC(7) (widest width) for
*-- True Type fonts in odd point sizes (and 
*-- perhaps for some even point sizes). The 
*-- difference, however, never seems to be more than
*-- 1.
IF FONT(7,&lcScrFont)-FONT(6,&lcScrFont)<=1
  lnCols=lnCols+13
ELSE
  lnCols=CEILING(lnCols*lnFudge+13)
ENDIF

*-- Determine which push button set to use.
*-- lcPushWid is used to force the buttons to be
*-- the same size. lcButtWid is used to center them.
*-- You can have any combination of buttons and 
*-- attributes. The first button in the set will
*-- return true to the calling program. The second
*-- will return false. 
lhPush=0   && Initialize the GET variable
*-- Create a picture clause that will cause a GET
*-- to be a push button.
DO CASE
  CASE lhWhatButt="OK"
    lcPicture= "@*HT \!\?\<OK"
    lcPushWid=4
    lnButtWid=9
  CASE lhWhatButt="Retry"
    if _Mac
      lcPicture=  "@*HT \?\<Cancel;\!\<Retry"
    else  
      lcPicture=  "@*HT \!\<Retry;\?\<Cancel"
    endif  
    lcPushWid=8
    lnButtWid=19
  CASE lhWhatButt="Cancel"
    if _Mac
      lcPicture=  "@*HT \?\<Retry;\!\<Cancel"
    else
      lcPicture=  "@*HT \!\<Cancel;\?\<Retry"
    endif
    lcPushWid=8
    lnButtWid=19  
  CASE lhWhatButt="Yes"
    if _Mac
      lcPicture= "@*HT \?\<No;\!\<Yes"
    else
      lcPicture= "@*HT \!\<Yes;\?\<No"
    endif
    lcPushWid=4
    lnButtWid=19
  CASE lhWhatButt="No"
    if _Mac
      lcPicture= "@*HT \?\<Yes;\!\<No"
    else
      lcPicture= "@*HT \!\<No;\?\<Yes"
    endif
    lcPushWid=4
    lnButtWid=19  
  CASE lhWhatButt="Print"
    if _Mac
      lcPicture=  "@*HT \?\<Cancel;\!\<Print"
    else
      lcPicture=  "@*HT \!\<Print;\?\<Cancel"
    endif
    lcPushWid=8
    lnButtWid=19
  CASE lhWhatButt="Import"
    if _Mac
       lcPicture=  "@*HT \?\<Cancel;\!\<Import "
    else
      lcPicture=   "@*HT \!\<Import ;\?\<Cancel"
    endif
    lcPushWid=8
    lnButtWid=19  
  *-- The following is an example of adding your
  *-- own button set.  
  CASE lhWhatButt='Dog'
    if _Mac
      lcPicture= "@*HT \?\<Cat;\!\<Dog"
    else  
      lcPicture= "@*HT \!\<Dog ;\?\<Cat"
    endif
    lcPushWid=4
    lnButtWid=18
ENDCASE

*-- Adjust the window width if it's too small for
*-- the buttons.
lnCols=MAX(lnCols,lnButtWid+8)

*-- Windows interface guidelines suggest a window 
*-- title for message dialogs. On the Mac, window 
*-- titles aren't used for Alerts. In DOS, it 
*-- doesn't really make any difference -- you could
*-- have a title here as well. In this version of
*-- XPALERT, the title only shows up in FPW. You
*-- can change this, of course.
*-- This code also sets up what will be used with
*-- @...SAY to either display a bitmap in Windows or 
*-- a DOS character equivalent.
*-- The bitmap "Gilly" is an example of adding your
*-- own bitmap.
*-- XPALERT is using pictures with the same names but
*-- different extensions: .BMP for Windows and .PIC
*-- (for .PICT) for Mac.
lcBitMap=trim(lcBitMap)
lcTitle=''
IF _WINDOWS or _MAC
  lcTitle=IIF(_Mac,'','Application Alert Title')
  lcExt='BMP'
  IF INLIST(lcBitMap,'Info','Caution','Stop','Qmark')
    IF _MAC
     lcExt='PIC'
    ENDIF  
  ENDIF    
  lcExclaim="'&lcBitMap..&lcExt' BITMAP STYLE 'T' "
ELSE
  DO CASE
    CASE INLIST(lcBitMap,'Info','Caution')
      lcExclaim="REPL(CHR(255),5)+'!!'"
    CASE INLIST(lcBitMap,'Qmark')
      lcExclaim="REPL(CHR(255),5)+'??'"
    OTHERWISE
      lcExclaim="REPL(CHR(255),4)+'*!!*'"
  ENDCASE
ENDIF

*-- Defines the window. The FONT
*-- clause is ignored in DOS. The DOS alert color 
*-- scheme (scheme 7) is used which will be the same
*-- as any other color scheme in Windows if Windows
*-- colors are the default. On the Mac, this will
*-- also be color scheme 7 which defaults to  
*-- black on a white background.
DEFINE WINDOW xpalert ;
  AT 0,0 SIZE lnRows,lnCols ;
  TITLE lctitle ;
  FLOAT ;
  NOCLOSE ;
  SHADOW ;
  NOMINIMIZE ;
  DOUBLE ;
  COLOR SCHEME 7 ;
  FONT &lcScrFont &lcStyle

MOVE WINDOW xpalert CENTER
ACTIVATE WINDOW xpalert NOSHOW

*--Display the headline and center it on the screen. 
*--The FONTMETRIC() function will be ignored in DOS. 
*--In DOS, TXTWIDTH() works the same as LEN() so it
*--will center there too.
@ 0,(WCOLS()-TXTWIDTH(lcHeader,&lcTitleFon,lcTitleSty)* ;
  FONTMETRIC(6,&lcTitleFon,lcTitleSty)/FONTMETRIC(6))/2  ;
  SAY lcHeader FONT &lcTitleFon STYLE lcTitleSty

*--Display the bitmap or DOS equivalent.
IF _WINDOWS or _MAC
  @ 1,1 SAY &lcExclaim ;
    SIZE 6,6
ELSE
  @ 1,1 TO 5,6  && draws a box
  @ 2,2 SAY &lcExclaim ;
    SIZE 3,4
ENDIF

*-- The second block of text is optional. If it has
*-- not been passed as a parameter, you need only 
*-- say the first block of text. If the second block
*-- of text *has* been passed as a parameter, 
*-- say the first block of text and then the second
*-- block of text.
*-- If there are two blocks of text, the SIZE
*-- clause uses uses the number of lines in
*-- the first text block, based on the number of 
*-- carriage returns in the text.
IF UPPER(TYPE('lcText2'))='L' OR EMPTY(lcText2)
  @ 2,9 SAY lcText SIZE WROW()-5,WCOLS()-11
ELSE
  @ 2,9 SAY lcText SIZE ;
            OCCURS(CHR(13),lctext)+2,WCOLS()-11
  @ ROW(),9 SAY lcText2 SIZE ;
            WROWS()-5-MEMLINES(lctext),WCOLS()-11
ENDIF

*-- If the READ level is already at the maximum, 
*-- display the message instead of push buttons.
*-- If using push buttons, issue the GET using
*-- the PICTURE clause determined above.
IF lnCurRd=lnRdLevel
  @ WROWS()-IIF(_MAC,3,2),(WCOLS()-TXTWIDTH(lcMsg))/2 SAY lcMsg
ELSE
  @ WROWS()-IIF(_MAC,3,2), (WCOLS()-lnButtWid)/2 GET lhpush ;
    PICTURE '&lcPicture' ;
    SIZE 1.769,10,2 ;
    DEFAULT 1 FONT &lcButtFont STYLE 'B'
ENDIF

*-- We can reset MEMOWIDTH to its original value 
*-- now.
SET MEMOWIDTH TO lcSetMemo
ACTIVATE WINDOW xpalert

*-- If the READ level is already at the maximum, use
*-- an INKEY() construct. If there's only one button
*-- (usually OK), then the user can click with the
*-- mouse or press any key. If a two button set is
*-- used and thus a response is required 
*-- for further action, a UDF()is used which
*-- requires that the user press Y or N. This
*-- routine was inspired by one Pat Adams uses
*-- in the DOS version of her FP25EROR program.
*
*-- If the READ level is less than maximum, a MODAL 
*-- READ is issued to activate the push buttons. 
IF lnCurRd=lnRdLevel
  IF lhWhatButt="OK"
    =INKEY(0,'HM')
  ELSE
    llRetVal=getKey()
  ENDIF
ELSE
  READ CYCLE MODAL
  IF lhPush=iif(_mac,2,1)
    llReTval=.T.
  ELSE
    llRetVal=.F.
  ENDIF
ENDIF

RELEASE WINDOW xpalert

*-- Return a value to the calling program.
RETURN llRetVal

*!*************************************************
PROCEDURE getkey
***************************************************
PRIVATE lcGetKey,lcSetCursor,llRetVal
STORE 0 TO lcGetKey
lcCursor=SET("CURSOR")
SET CURSOR OFF

*-- User can only exit window by pressing Y or N.
DO WHILE lcGetKey = 0
  lcGetKey = INKEY(0)
  lcGetKey=MAX(0,lcGetKey)
  IF UPPER(CHR(lcGetKey))$"YN"
     IF lhWhatButt="No"
      llRetVal=IIF(UPPER(CHR(lcGetKey))$ "N",.T.,.F.)
    ELSE
      llRetVal=IIF(UPPER(CHR(lcGetKey))$ "Y",.T.,.F.)
    ENDIF 
  ELSE
    lcGetKey=0
  ENDIF
ENDDO

SET CURSOR &lcCursor
CLEAR TYPEAHEAD
RETURN llRetVal

