* Function:
*	YN()
* Date:
*	August 20, 1992
* Revision:
*
* Purpose:
*	Processes a Yes/No response with keyboard or mouse.
* Usage:
*	YN("message")
*		Where: "message" is text for window display.
* Local VARs:
*	c_YNMsg 		= Text for system messages.
*	n_YNParmCnt		= Number of Parameters passed to function.	
*	n_KeyPress		= Var containing last key pressed.
*	n_SCol			= Mouse column position.
*	n_SRow			= Mouse row position.
* Calls VARs:
*	(none)
* Calls Programs:
*	SoundBell()		= Local function, Sounds PC speaker.
*	YNEnviorment()	= Local function, restores old enviorment on exit.
* Returns:
*	.T. (True) if Yes or .F. (False) if No.
* Comments:
*	I can be reached at the Silver Bullet BBS at 407-277-2007
***
parameters c_YNMsg
*
private c_YNMsg, n_KeyPress, c_NotifyStatus, n_SCol, n_SRow, ;
	c_TalkStatus
* set enviorment.
if set("TALK")="ON"				&& Set system talk status.
	c_TalkStatus="ON"
	set talk off
else
	c_TalkStatus="OFF"			&& Only used to set var to 'char'.
endif
if set("NOTIFY")="OFF"			&& Set system notify status.
	c_NotifyStatus="OFF"
	set notify on
else
	c_NotifyStatus="ON"			&& Only used to set var to 'char'.
endif
if parameter()>1				&& # of Parameters Failsafe.
	=SoundBell(200)
	wait 'ERROR: None or one parameter only, Returning a "NO"!' window
	=YNEnviorment()
	return(.F.)
endif
if type("c_YNMsg")#"C"			&& Parameter type failsafe.
	release c_YNMsg
	private c_YNMsg
	c_YNMsg="Yes or No"
endif
c_YNMsg=alltrim(c_YNMsg)
if c_YNMsg="?"
	=SoundBell(1000)
	wait 'SYNTAX: YN("message")' window timeout 6
	=SoundBell(1000)
	wait '"message": Any text desired or none.' window timeout 6
	=SoundBell(1000)
	wait 'A ",(Y/N)" prompt is automatically added.' window timeout 6
	=SoundBell(1000)
	=SoundBell(1000)
*
	return(.T.)
endif
* Begin Actual Program.
=sys(2002)						&& Turn cursor off.
=SoundBell(750)
do while .T.					&& Loop until required key is pressed.
	wait (c_YNMsg+",(Y/N)?") window
	n_KeyPress=inkey(_dblclick,"M")	&& Was the left mouse double clicked.
	do case
	case n_KeyPress=151			&& Left mouse clicked.
		n_SRow=mrow("")			&& Get row ordinate.
		n_SCol=mcol("")			&& Get column ordinate.
		do case
		case n_SRow=2 and n_SCol=70	&& Get click position for 'Y'es.
			=YNEnviorment()		&& Resets enviorment as was.
			return(.T.)
		case n_SRow=2 and n_SCol=72	&& Get click position for 'N'o.
			=YNEnviorment()
			return(.F.)
		endcase
	case lastkey()=89 or lastkey()=121	&& Keyboard 'Y' or 'y'.
		=YNEnviorment()
		return(.T.)
	case lastkey()=78 or lastkey()=110	&& Keyboard 'N' or 'n'.
		=YNEnviorment()
		return(.F.)
	endcase
enddo
* Failsafe - Can be deleted.
=SoundBell(200)
wait 'ERROR: An error occured, Returning a "NO"!' window
=YNEnviorment()
*
return(.F.)
* End of main procedure.
*
* Begin function YNEnviorment()
* Function restores previous enviorment on exit.
*
function YNEnviorment
*
=sys(2002,1)					&& Turn cursor on.
if c_TalkStatus="ON"			&& Leave enviorment as was.
	set talk on
endif
if c_NotifyStatus="OFF"
	set notify off
endif
*
return(.T.)
* End sub-function YNEnviorment().
*
* Begin sub-function SoundBell()
* Sounds PC speaker.
*
function SoundBell
*
parameter n_SBHz
*
private n_SBHz
*
do case
case n_SBHz=200
	set bell to 200,8
case n_SBHz=750
	set bell to 750,4
case n_SBHz=1000
	set bell to 1000,4
endcase
*
?? chr(7)
*
return(.T.)
*
* End sub-function SoundBell().
*
*
* End of YN() function (EOF).