* Function:
*	Process()
* Date:
*	March 11, 1992
* Author:
*	Tom O'Hare
* Copyright (c) 1992, Tom O'Hare
* Revision:
*
* Purpose:
*	Simple function to inform user:   "Processing, Please Standby..."
* Usage:
*	Process(n)  - or -  Process("?")
* 	Where: 
*		"n" is the action to take or "?" is for help.
*		n=-1   Releases the window "Process" if defined.
*		n=0 (or blank)   returns status:
*						(2=Hidden, 1=Visible, -1=Not active).
*		n=1   Defines/Activates window
*		n=2   Hides window if active.
*	example: =Process(1)  Activates/Shows "Process" window.
*			 var=Process()	Returns window status to "var(iable)".
* Local VARs:
*	n_PStatus	= Holds current status value (num).
*	n_SBHz		= Sounds PC speaker (num)
*	c_TalkStatus= Previous talk setting.
* Calls VARs:
*	(none)
* Calls Programs:
*	(none)
* Returns:
*	Status of window ( -1, 1, 2 ).
* Notes:
*	Use '=' to invoke this function & not '?'.  The '?' would
*		display any output from the function, including unwanted
*		output, in the active window which would be	the 'Process'
*		window.  Example: =Process(1)
* Comments:
*	I can be reached on the Silver Bullet BBS at 407-277-2007.
***
function PROCESS
*
parameter n_PStatus
*
private n_PStatus
*
if set("TALK")="ON"				&& Set system talk status.
	c_TalkStatus="ON"
	set talk off
else
	c_TalkStatus="OFF"			&& Only used to set var to 'char'.
endif
*
if parameter()>1				&& # of Parameters Failsafe.
	=SoundBell(200)
	wait 'ERROR: None or one parameter only, Aborting!' window
	=PEnviorment()
	return(.F.)
endif
* Failsafe - Missing parameter
do case
case empty(n_PStatus)
	n_PStatus=0
case type("n_PStatus")="C"
	if alltrim(n_PStatus)="?"
		=SoundBell(1000)
		wait 'Informs user of wait, Synatx: Process(n)' window timeout 6
		=SoundBell(1000)
		wait 'Where n=1 Defines/Activates window, ' ;
			+'n=2 Hides window if active, ...' window timeout 6
		=SoundBell(1000)
		wait 'n=-1 releases window from memory.' window timeout 6
		=SoundBell(1000)
		wait 'n=0 returns window status: ' ;
			+'(2=Hidden, 1=Visible, -1=Not active).' window timeout 6
		=SoundBell(1000)
		=SoundBell(1000)
		=PEnviorment()
		return(.T.)
	else
		=SoundBell(200)
		wait 'ERROR: Bad syntax, Numeric values (-1,0,1,2) ' ;
			+'or "?" for help only!' window
		=PEnviorment()
		return(.F.)
	endif
case type("n_PStatus")#"N"
	=SoundBell(200)
	wait 'ERROR: Bad syntax, Numeric values (-1,0,1,2) ' ;
		+'or "?" for help only!' window
	=PEnviorment()
	return(.F.)
endcase
* Begin program.
do case
case n_PStatus=0					&& Return current window status.
	do case
	case !wexist("PROCESS")
		=PEnviorment()
		return(-1)
	case wvisible("PROCESS")
		=PEnviorment()
		return(1)
	case !wvisible("PROCESS")
		=PEnviorment()
		return(2)
	endcase
*
case !wexist("PROCESS") and n_PStatus=-1	&& Failsafe, no window.
	=PEnviorment()
	return(n_PStatus)
case wexist("PROCESS")			&& Handle window.
	do case
	case n_PStatus=1
		activate window PROCESS
		@ 0,8 SAY "Processing, Please Standby..."	&& Window message.
	case n_PStatus=2
		deactivate window PROCESS
	case n_PStatus=-1
		release window PROCESS
	endcase
	=PEnviorment()
	return(n_PStatus)
case !wvisible("PROCESS") and n_PStatus=2	&& Failsafe, hidden window.
	=PEnviorment()
	return(n_PStatus)
endcase
* Define window if not defined.
if !wexist("PROCESS")
	define window PROCESS ;
		from int((srow()-3)/2),int((scol()-48)/2) ;
		to int((srow()-3)/2)+2,int((scol()-48)/2)+47 ;
		nofloat noclose double color scheme 5
endif
if wvisible("PROCESS")			&& System window handler.
	activate window PROCESS same
else
	activate window PROCESS noshow
endif
*
@ 0,8 say "Processing, Please Standby..."	&& Window message.
*
if !wvisible("PROCESS")
	activate window PROCESS
endif
*
=PEnviorment()
*
return(n_PStatus)
*
* Begin sub-function SoundBell()
* Sounds PC speaker.
*
function SoundBell
*
Parameter n_SBHz
*
private n_SBHz
*
do case
case n_SBHz=200
	set bell to 200,8
case n_SBHz=750
	set bell to 750,4
case n_SBHz=1000
	set bell to 1000,4
endcase
*
?? chr(7)
*
return(.T.)
*
* End sub-function SoundBell()
*
* Begin sub-function PEnviorment()
* Sub-function restores previous enviorment on exit.
*
function PEnviorment
*
=sys(2002,1)					&& Turn cursor on.
if c_TalkStatus="ON"			&& Leave enviorment as was.
	set talk on
endif
*
return(.T.)
* End PEnviorment() sub-function.
*
*
* End of function Process() (EOF).