*:*********************************************************************
*:
*:        Program: H:\FTCL\CLLOAD.PRG
*:
*:         System: FoxPro 2.0 Change Log Database
*:         Author: Maurice Frank
*:      Copyright (c) 1991, Maurice Frank
*:  Last modified: 11/10/91     21:00
*:
*:          Calls: CLMAKDBF()         (function  in CLMAKDBF.PRG)
*:               : CLCHKLOG()         (function  in CLCHKLOG.PRG)
*:               : LOGFILES()         (function  in ?)
*:               : CLIMPORT()         (function  in CLIMPORT.PRG)
*:               : CLBROW.PRG
*:
*:      Documented 11/11/91 at 21:01               FoxDoc  version 2.10b
*:*********************************************************************

* Load FoxPro 2 Change Log files - shell program

PARAMETERS mcl_dbf, mfilespec

IF SET("TALK") = "ON"
   SET TALK OFF
   mset_talk = "ON"
ELSE
   mset_talk = "OFF"
ENDIF

* check database name parameter
mcl_dbf = IIF(EMPTY(mcl_dbf),"FP2CL",mcl_dbf)

* check filespec parameter; use default if no parameter
* either way, get a fully qualified filename for fopen()

mfilespec = FULLPATH(IIF(EMPTY(mfilespec),"*.log",mfilespec))

* load log files into array
mfcount = ADIR(logfiles,mfilespec)

IF mfcount > 0
   
   * check for dbf; if it is not created, open or select it
   
   IF !clmakdbf( mcl_dbf )
      IF USED( mcl_dbf )
         SELECT (mcl_dbf)
      ELSE
         USE ( mcl_dbf )
      ENDIF
   ENDIF
   
   * sort the logfiles array
   = ASORT( logfiles )
   
   SET ORDER TO filename
   
   * import each filename in array
   
   mloaded = 0
   
   FOR F = 1 TO mfcount
      
      * find out what to do with this file (load, skip, etc)
      mloadit = clchklog( logfiles(F,1) )
      
      DO CASE
      CASE mloadit = 1
         * let's go fishing ...
         * climport is the heart of this system
         mloaded = mloaded + climport(mcl_dbf,logfiles(F,1))
      CASE mloadit = 2
         * skip log file already loaded
         WAIT WINDOW "Skipping log file " ;
            + logfiles(F,1) NOWAIT
      CASE mloadit = -1
         * if we got a minus 1 back, abort the whole process
         EXIT
      ENDCASE
      
   NEXT
   
   SET CURSOR OFF
   WAIT WINDOW STR(mloaded,2) + " log files loaded into " ;
      + mcl_dbf
   SET CURSOR ON
   
ELSE
   
   SET CURSOR OFF
   WAIT WINDOW "No FoxPro 2 Change Log files to load: " ;
      + mfilespec
   SET CURSOR ON
   
ENDIF

WAIT CLEAR

IF mset_talk = "ON"
   SET TALK ON
ELSE
   SET TALK OFF
ENDIF

DO clbrow

RETURN
*: EOF: CLLOAD.PRG
