*:*********************************************************************
*:
*: Procedure file: H:\FTCL\CLIMPORT.PRG
*:
*:         System: FoxPro 2.0 Change Log Database
*:         Author: Maurice Frank
*:      Copyright (c) 1991, Maurice Frank
*:  Last modified: 11/13/91     21:00
*:
*:  Procs & Fncts: CLIMPORT()
*:
*:          Calls: SPLITPTH()         (function  in SPLITPTH.PRG)
*:
*:    Other Files: MCL_FILE
*:
*:      Documented 11/13/91 at 21:00               FoxDoc  version 2.10b
*:*********************************************************************

* Imports a FoxPro 2.0 Change Log text file into a dbf

PARAMETER mcl_dbf, mcl_file

* initialize return variable
mloaded = 0

* validate parameter

IF !EMPTY(mcl_file) AND TYPE("mcl_file") = "C"
   
   mhandle = FOPEN(mcl_file)
   
   IF mhandle != -1
      
      WAIT WINDOW "Importing: " + mcl_file NOWAIT
      m.item_no = 0
      m.filename = splitpth(mcl_file,"ne")         && filename.ext only
      
      FOR i = 1 TO 3
         m.line = FGETS(mhandle)
      NEXT
      
      DO WHILE !FEOF(mhandle)
         
         * read next line - should be header information
         m.line = FGETS(mhandle)
         
         * parse the line
         * character positions of keywords can be computed
         * but I'll keep it simple until Fox moves things
         m.item_no = m.item_no + 1
         m.commfunc = ALLTRIM(SUBSTR(m.line,9,30))
         m.category = ALLTRIM(SUBSTR(m.line,48,18))
         m.dt_fixed = CTOD(SUBSTR(m.line,72,8))
         
         INSERT INTO (mcl_dbf) FROM MEMVAR
         
         *    IF M.COMMFUNC='WAIT'
         *    SUSP
         *    ENDIF
         
         * get next line - should be the lower double line
         * we don't use this
         m.line = FGETS(mhandle)
         
         * load the text
         
         m.details = ""
         m.line = ""
         
         * chr(205) is the horizontal double bar
         mdivider = REPL(CHR(205),80)
         
         DO WHILE m.line != mdivider
            
            * remove formfeed character
            m.line = STRTRAN(m.line,CHR(12),"")
            
            IF !("FOXPRO 2.0 CHANGE LIST" $ UPPER(m.line))
               * do not process page header
               
               IF (ISALPHA(RIGHT(m.details,1)) OR RIGHT(m.details,1)=".") ;
                     AND ISALPHA(LEFT(m.line,1))
                  * add a space between last word and first word
                  m.details = m.details + " "
               ENDIF
               
               * concatenate explanation into one memo memvar
               m.details = m.details + m.line
               
            ENDIF
            
            IF FEOF(mhandle)
               * bail out after processing m.line
               EXIT
            ENDIF
            
            m.line = FGETS(mhandle)
            
         ENDDO
         
         REPLACE details WITH m.details
         
      ENDDO
      
      mloaded = 1                                  && return value
      
   ELSE
      
      WAIT WINDOW "Unable to open log file: " + mcl_file
      
   ENDIF
   
   = FCLOSE(mhandle)
   
ELSE
   
   WAIT WINDOW "Missing or invalid file name parameter"
   
ENDIF

RETURN mloaded

*: EOF: CLIMPORT.PRG
