** PrintSel.PRG
*  Wayne A. Willingham/Survivor Software (214) 783-0094
*                                   FAX: (214) 783-0095
*                                   CIS: 76170,2016
*
*  Taken from MicroSoft Knowledge Base article 103645
*
*  USAGE: DO PrintSel WITH <PrtChoice>, <DoManual>
*  PrtChoice = character - The printer you want to select
*  DoManual  = logical   - forces the printer driver dialog
*                          if you want, otherwise it just
*                          quits without making a change
*
* CHANGE:  Add cDefaultP. -->CM (07/27/94)
*
PARAMETERS PrtChoice, DoManual
* If no parameters are passed, bring up the printer select dialog, then quit
*////  For debugging purposes.
   IF SET("ECHO")="ON"
     ACTIVATE WINDOW Trace
     SUSPEND
   ENDIF
*\\\\  -->CM (07/27/94) 
IF PARAMETERS() < 1
	=SYS(1037)
	RETURN
	ENDIF
IF PARAMETERS() < 2
	DoManual = .F.
	ENDIF
DIMENSION Device[1]
numPrinters = 0
defaultprnt = ""
Do GETPRINT WITH Device, NumPrinters, DefaultPrnt

* If the printer is listed anywhere in the array, set it as default
* otherwise, bring up the printer select dialog

IF ASCAN(Device,PrtChoice) > 0
	DO Putprint  WITH Device, ALEN(Device,1), ASUBSCRIPT(Device,ASCAN(Device,PrtChoice),1)
ELSE
	IF DoManual
		=SYS(1037)
	ELSE
		RETURN .F.
	ENDIF
ENDIF




* Following is the code for the three main procedures, GETPRINT, LISTPRINT, 
* and PUTPRINT, which make calls to three additional procedures, PUTPROSTRG, 
* GETPROSTRG, and GETPORT.

    *]***************************************************************** 
    *] 
    *]     Procedure: GETPRINT 
    *] 
    *]***************************************************************** 
    PROCEDURE getprint 
    * Query WIN.INI to get data on the installed and default printers.

    PARAMETER DEVICE, NUMBER, dfltprnt 
    * Usage: 
    *    DIMENSION device[1! 
    *    numprinters = 0 
    *    defaultprnt = "" 
    *    DO GETPRINT WITH device, numprinters, defaultprnt 
    * 
    * The "device" array will be populated with the names and 
    * parameters for all installed print devices. 
    * 
    * The "device" array has this structure: 
    * Col 1: Printer name 
    * Col 2: Parameter for [device! section 
    * Col 3: Parameter for [PrinterPort! section (includes time-out 
    * parameters) 
    * 
    * The contents of "device" might look something like this after 
    * GETPRINT is called: 
    *   Col 1                      Col 2           Col 3 
    *   -------------------------  --------------  ---------------- 
    *   Apple LaserWriter II NTX   pscript,LPT2:   pscript,LPT2:,15,90 
    *   Generic / Text Only=TTY    fred.prn        fred.prn,15,45 
    *   HP LaserJets(Level 5)      HPPCL5MS,LPT1:  HPPCL5MS,LPT1:,15,45 
    * 
    * "numprinters" in this case would be 3 
    * "defaultprnt" might be this: 
    *    HP LaserJets(Level 5),HPPCL5MS,LPT1:

    #DEFINE buflen 2048 
    PRIVATE m.in_talk, m.dcount, m.retbuf, m.bytes, m.thisdevice

    IF PARAMETERS() < 3 
       WAIT WINDOW "This procedure requires 3 parameters" 
       RETURN 
    ENDIF

    IF FILE(SYS(2004)+"FOXTOOLS.FLL") 
       SET LIBRARY TO (SYS(2004)+"foxtools.fll") ADDITIVE 
    ELSE 
       WAIT WINDOW "GETPRINT requires the FoxTools library." 
       RETURN 
    ENDIF

    IF SET("TALK") = "ON" 
       SET TALK OFF 
       m.in_talk = "ON" 
    ELSE 
       m.in_talk = "OFF" 
    ENDIF

    * Fill in the first column of the array with installed device 
    * names. 
    m.retbuf = REPLICATE(CHR(0),buflen) 
    m.bytes = getprostrg("devices",0,CHR(0),@m.retbuf,buflen) 
    * The second argument of 0 to GetProfileString() returns the contents 
    * of the entire section, with each entry separated by a null terminator 
    * (CHR(0)). 
    m.dcount = 0 
    m.retbuf = LEFT(m.retbuf,m.bytes) 
    DO WHILE CHR(0) $ m.retbuf 
       m.thisdevice = LEFT(m.retbuf,AT(CHR(0),m.retbuf)-1) 
       IF LEFT(m.thisdevice,1) <> CHR(0) 
          m.dcount = m.dcount + 1 
          DIMENSION device[m.dcount,3] 
          device[m.dcount,1] = m.thisdevice 
       ENDIF 
       m.retbuf = SUBSTR(m.retbuf,AT(CHR(0),m.retbuf)+1) 
    ENDDO

    * Fill in the second and third columns of the device array with the 
    * parameters of each installed device from the [devices! section 
    * (column 2) and the [PrinterPorts! section (column 3). 
    FOR m.j = 1 TO m.dcount 
       retbuf = REPLICATE(CHR(0),256) 
       m.bytes = ; 
          getprostrg("devices",device[m.j,1],CHR(0),@m.retbuf,256) 
       m.retbuf = LEFT(m.retbuf,m.bytes) 
       device[m.j,2] = m.retbuf

       retbuf = REPLICATE(CHR(0),256) 
       m.bytes = ; 
          getprostrg("PrinterPorts",device[m.j,1],CHR(0),@m.retbuf,256) 
       m.retbuf = LEFT(m.retbuf,m.bytes) 
       device[m.j,3] = m.retbuf 
    ENDFOR

    * Store the number of installed devices. 
    m.number = m.dcount

    * Now get the default printer. 
    retbuf = REPLICATE(CHR(0),256) 
    m.bytes = getprostrg("windows","device",CHR(0),@m.retbuf,256) 
    m.retbuf = LEFT(m.retbuf,m.bytes) 
    m.dfltprnt = m.retbuf
*//// If declared in host, stores default printer before change.   
    cDefaultP  = SUBST(m.dfltprnt,1, AT(',',m.dfltprnt)-1) 
*\\\\ 07/27/94    

    SET TALK &in_talk

    *]***************************************************************** 
    *] 
    *]     Procedure: LISTPRINT 
    *] 
    *]***************************************************************** 
    PROCEDURE listprint 
    PARAMETER DEVICE 
    #DEFINE buflen 2048 
    PRIVATE m.in_talk,m.i 
    IF FILE(SYS(2004)+"FOXTOOLS.FLL") 
       SET LIBRARY TO (SYS(2004)+"foxtools.fll") ADDITIVE 
    ELSE 
       WAIT WINDOW "LISTPRINT requires the FoxTools library." 
       RETURN 
    ENDIF 
    IF SET("TALK") = "ON" 
       SET TALK OFF 
       m.in_talk = "ON" 
    ELSE 
       m.in_talk = "OFF" 
    ENDIF

    DIMENSION DEVICE(1) 
    NUMBER = 0 
    dflt = ""

    DO getprint WITH DEVICE, NUMBER, dflt 
    SET TALK &in_talk

    *]***************************************************************** 
    *] 
    *]     Procedure: PUTPRINT 
    *] 
    *]***************************************************************** 
    PROCEDURE putprint 
    PARAMETER DEVICE, NUMBER, dflt, portnum 
    * Take the printer device information in the device array and 
    * update WIN.INI with it. 
    * 
    * "Number" is the total number of printers listed in "device." 
    * "dflt" is the string to write to the [windows! device= statement 
    * to set the default printer, or if dflt is a number, the array row 
    * to construct this statement from. Thus, to make the default 
    * printer the third one listed in "device," either pass a 3 as dflt 
    * or pass the actual string (something like HP LaserJets(Level 
    * 5),HPPCL5MS,LPT1:). If the string is passed, it must exactly 
    * match an entry in the [devices! section of the WIN.INI file. 
    * 
    * GETPRINT can be used to construct the device array. 
    * 
    IF FILE(SYS(2004)+"FOXTOOLS.FLL") 
       SET LIBRARY TO (SYS(2004)+"foxtools.fll") ADDITIVE 
    ELSE 
       WAIT WINDOW "PUTPRINT requires the FoxTools library." 
       RETURN 
    ENDIF

    IF TYPE("dflt") = "N" 
       IF PARAMETERS() < 4 
          portnum = 1 
       ENDIF 
       m.strg = device[m.dflt,1]+","+getport(device[m.dflt,2],portnum) 
    ELSE 
       m.strg = m.dflt 
    ENDIF

    * Set the default printer 
    =putprostrg("windows","device",m.strg)

    * Delete all existing device and PrinterPort entries. 
    =putprostrg("devices",0,CHR(0)) 
    =putprostrg("PrinterPort",0,CHR(0))

    FOR m.i = 1 TO NUMBER 
       =putprostrg("devices",device[m.i,1],device[m.i,2]) 
       =putprostrg("PrinterPorts",device[m.i,1],device[m.i,3]) 
    ENDFOR

    *]***************************************************************** 
    *] 
    *]     Function: PUTPROSTRG 
    *] 
    *]***************************************************************** 
    FUNCTION putprostrg 
    PARAMETER SECTION, entry, string 
    fn = regfn("WRITEPROFILESTRING","CCC","I") 
    RETURN callfn(fn,SECTION,entry,string)

    *]***************************************************************** 
    *] 
    *]     Function: GETPROSTRG 
    *] 
    *]***************************************************************** 
    FUNCTION getprostrg 
    PARAMETER SECTION, entry, dflt, buffer, blen 
    fn = regfn("GETPROFILESTRING","CCC@CI","I") 
    RETURN callfn(fn,SECTION,entry,dflt,@buffer,blen)

    *]***************************************************************** 
    *] 
    *]     Function: GETPORT 
    *] 
    *]***************************************************************** 
    FUNCTION getport 
    PARAMETER m.pstrg, m.pnum 
    * Get the first "port" from a printer string.

    * First get the printer driver name (e.g., pscript) and the comma. 
    m.retstrg = SUBSTR(m.pstrg,1,AT(',',m.pstrg))

    * Now get the port designation (e.g., LPT1: or FILE:)

    * Check if the port passed is greater than the ports available. 
    IF OCCURS(',',m.pstrg) >= m.pnum 
       m.portstrg = SUBSTR(m.pstrg,AT(',',m.pstrg,m.pnum)+1) 
    ELSE 
       m.portstrg = SUBSTR(m.pstrg,AT(',',m.pstrg,1)+1) 
    ENDIF

    IF AT(',',m.portstrg) > 0 
       m.portstrg = LEFT(m.portstrg,AT(',',m.portstrg)-1) 
    ENDIF

    RETURN m.retstrg + m.portstrg

