;
; DOSPARAM() 
; 
; FUNCTION CHAR DosParam PROTOTYPE 
;
; PURPOSE: Returns the argument from a dos command line. 
; 
; PRAMETERS: None. 
;
; RETURNS: Arguments from the dos command line.	
; This is a example of a asm prog for force. This function simply
; returns the commamd line arguments at the calling program. It is also
; a little plug for my library DFORCE. See the TEST.PRG for more info.
; This function is in the DFORCE library.
;
; EXAMPLE: See TEST.PRG
; SEND COMMEMTS TO
; SOFTMAGIC
; Albert Alexander Bukoksi
; P.O BOX 27909
; San Diego CA, 92198
;

				    ; FORCE always is LARGE memory model.
$S_FUNCTION_SEG	SEGMENT PUBLIC      ; DECLARE THE SEGMENT OF THE PROGRAM
      ASSUME CS:$S_FUNCTION_SEG     ; MAKE IT ALRIGHT TO USE
PUBLIC _DOSPARAM		    ; MAKE IT PUBLIC. NOTICE THE UNDERSCORE
                                    ; THIS IS NEEDED FOR ALL ASM PROGS FOR 
				    ; FORCE!!!!!!!!!!!!!!!!!!!!!!!!

_DOSPARAM PROC FAR
        PUSH BP                     ; SAVE REGISTERS
        MOV BP, SP		    ; MOV BP TO SP TO CALL LATER
	PUSH	SI		    ; SAVE SI
	PUSH	DI		    ; SAVE DI
	PUSH	DS		    ; SAVE DS
	PUSH	ES		    ; SAVE ES
	CLD                         ; SET FORWARD
	MOV	AH,51H              ; SERVICE 51H
	INT	21H		    ; GET PSP ADDRESS
	MOV	DS,BX		    ; MOVE BX TO DS
	MOV	SI,0081H	    ; GO 81H DISTANCE AWAY
	LES	DI,[BP+06H]	    ; SET TO DESTINATION(RETURN OFFSET)
	XOR	CH,CH		    ; CLEAR CH FOR LOOP
	MOV	CL,DS:[0080H]	    ; READ FROM 80H OF PSP STUFF
	REPZ	MOVSB		    ; MOVE ALL CHARS AND SAVE
	XOR	AL,AL		    ; CLEAR AL 
	STOSB			    ; STORE THE CHARACTERS
	POP	ES		    ; THIS IS WHY WE PUSHED EARLIER, TO
	POP	DS		    ; SAVE THESE REGISTERS. WE HAVE LEFT THEM
	POP	DI		    ; TO ORIGINAL STATES BEFORE WE DID ANY 
	POP	SI		    ; CODING. 
	POP	BP		    ; PUSH AND POP ONLY WHAT IS NEEEDED.
	RET			    ; RETURN TO PROGRAM 
$S_FUNCTION_SEG	ENDS                ; THIS IS THE END OF THE PROGRAM
END				    ; THIS IS THE END OF THE OBJ FILE
				    ; THE END. YOU MUST DECLARE THE FUNCTION
				    ; PUBLIC SO THE LINKER AND 
				    ; YOUR FORCE PROGRAM WILL UNDERSTAND IT.
				    ; ALSO THE NAME OF THE FUNCTION MUST HAVE
				    ; A UNDERSCORE BEFORE THE NAME. LOOK AT HOW
				    ; THIS FUNCTION IS NAMED. "_DOSPARAM" NOT "DOSPARAM". 

