*:*********************************************************************
*:
*:        Program: DISPSTRU.PRG
*:
*:         System: Display DBF file structure
*:         Author: John Wright
*:      Copyright (c) 1990, WRIGHTware
*:  Last modified: 08/12/90
*:
*:  Procs & Fncts: FORCE_MAIN
*:
*:      Documented 08/12/90                         SNAP!  version 4.02h
*:*********************************************************************
* Created - 08/08/90 - Display DBF structure with FORCE.
* Revised - 08/10/90 - Fixed a bug - initialize FLD_NAME before DO WHILE.
*                      Added some file header information.
* Revised - 08/12/90 - Added ability to redirect output using FB_WRITE.
*                      Use FIND_FILE functions to process DOS wildcards.

#INCLUDE fileio.hdr
#INCLUDE string.hdr
#INCLUDE system.hdr
#INCLUDE io.hdr

#PRAGMA w_func_proc-

*!*********************************************************************
*!
*!      Procedure: FORCE_MAIN
*!
*!*********************************************************************
PROCEDURE force_main
PARAMETERS CHAR cmd_line

VARDEF
  CHAR      cr_lf
  CHAR      pattern
  CHAR      dbf_path
  CHAR      dbf_name
  CHAR      txt_line
  CHAR(3)   lst_updt
  UINT      handle
  * field info
  CHAR(10)  fld_name
  CHAR(1)   fld_type
  CHAR(1)   fld_len
  CHAR(1)   fld_dec
  INT       fld_num
  INT       rec_size
  INT       spot
ENDDEF

STORE cmd_line TO pattern

IF pattern = ""
  ?"Syntax:  DISPSTRU <dbf>                  display on screen"
  ?"         DISPSTRU <dbf> >PRN             send to printer"
  ?"         DISPSTRU <dbf> >FILENAME.TXT    redirect to a file"
  ?""
  QUIT
ENDIF

IF ".DBF" $ UPPER(pattern)
  STORE UPPER(LTRIM(RTRIM(pattern))) TO pattern
ELSE
  STORE UPPER(LTRIM(RTRIM(pattern)))+".DBF" TO pattern
ENDIF

* Save path if specified (FIND_FSTR only returns the file name)
IF "\" $ pattern
  STORE UPPER(SUBSTR(pattern,1,RAT("\",pattern))) TO dbf_path
ENDIF
 
* search for matching file(s)
IF find_first(pattern,0x20)

  STORE CHR(13)+CHR(10) TO cr_lf

  REPEAT

    STORE dbf_path+find_fstr() TO dbf_name

    IF .NOT. Fb_open(handle,dbf_name,&B_READ)
      ?"ERROR:  Cannot open file => "+dbf_name
      ?""
      ?CHR(7)
      QUIT
    ENDIF

    STORE 0 TO fld_num,rec_size

    FB_write(&STD_OUT,cr_lf,2)
    STORE "Name of database file: "+dbf_name+cr_lf TO txt_line
    FB_write(&STD_OUT,txt_line,LEN(txt_line))

    * Cannot get the number of records because it is stored as
    * a four digit binary number.

    * date of last update is stored as a three digit character string in header
    Fb_seek(handle,1,&fb_begin)
    Fb_read(handle,lst_updt,3)
    * a whole lot of code just to print a "nice" date...
    STORE "Date of last update  : "+;
    RIGHT("00"+LTRIM(STR(ASC(SUBSTR(lst_updt,2,1)),2,0)),2)+"/"+;
    RIGHT("00"+LTRIM(STR(ASC(SUBSTR(lst_updt,3,1)),2,0)),2)+"/"+;
    STR(ASC(SUBSTR(lst_updt,1,1)),2,0)+cr_lf TO txt_line
    FB_write(&STD_OUT,txt_line,LEN(txt_line))

    STORE "Field  Field name  Type        Width   Dec"+cr_lf TO txt_line
    FB_write(&STD_OUT,txt_line,LEN(txt_line))

    * process the DBF header
    STORE " " TO fld_name
    DO WHILE SUBSTR(fld_name,1,1) <> CHR(13)
      STORE fld_num+1 TO fld_num
      STORE (fld_num*32) TO spot
      Fb_seek(handle,spot,&fb_begin)
      * check the first character - a CHR(13) means end of field definitions
      Fb_read(handle,fld_name,1)
      IF SUBSTR(fld_name,1,1) <> CHR(13)
        * get field name
        Fb_seek(handle,spot,&fb_begin)
        Fb_read(handle,fld_name,10)
        * field type  -  11th position
        STORE (fld_num*32)+11 TO spot
        Fb_seek(handle,spot,&fb_begin)
        Fb_read(handle,fld_type,1)
        STORE SUBSTR(fld_type,1,1) TO fld_type
        * field length - 16th position
        STORE (fld_num*32)+16 TO spot
        Fb_seek(handle,spot,&fb_begin)
        Fb_read(handle,fld_len,1)
        * field decimal - 17th position
        Fb_read(handle,fld_dec,1)
        * print the field and continue
        STORE STR(fld_num,5,0)+"  "+SUBSTR(fld_name+SPACE(12),1,12) TO txt_line
        DO CASE
        CASE fld_type = "C"
          STORE txt_line+"Character" TO txt_line
        CASE fld_type = "D"
          STORE txt_line+"Date     " TO txt_line
        CASE fld_type = "L"
          STORE txt_line+"Logical  " TO txt_line
        CASE fld_type = "M"
          STORE txt_line+"Memo     " TO txt_line
        CASE fld_type = "N"
          STORE txt_line+"Numeric  " TO txt_line
        OTHERWISE
          STORE txt_line+"unknown  " TO txt_line
        ENDCASE
        STORE txt_line+STR(ASC(fld_len),8,0) TO txt_line
        rec_size=rec_size+ASC(fld_len)
        IF fld_type = "N"
          STORE txt_line+STR(ASC(fld_dec),6,0) TO txt_line
        ENDIF
        STORE txt_line+cr_lf TO txt_line
        FB_write(&STD_OUT,txt_line,LEN(txt_line))
      ENDIF
    ENDDO
    STORE "** Total **"+STR((rec_size+1),25,0)+cr_lf TO txt_line
    FB_write(&STD_OUT,txt_line,LEN(txt_line))
    FB_write(&STD_OUT,cr_lf,2)

    Fb_close(handle)

  UNTIL .NOT. find_next()

ELSE
  ?"ERROR:  No files found matching => "+pattern
  ?""
ENDIF

QUIT

ENDPRO

*: EOF: DISPSTRU.PRG
