*
*  (PARSBETA.PRG) now PARSFF.PRG
*  Author: TOM (the Meekster) MEEKS 70304,2176 -and- DREW SPEEDIE 71045,3357
*
*  PARAMETERS:
*    thisfile = character string of the message file to be parsed
*    clearflag = "N" to leave new from pass 1 intact!
*
*  USAGE:
*       do parsFF with "BETA1001.MES"
*  parses out the message file BETA1001.MES downloaded from the 
*  forum
*
*********************
*
*  Seriously hacked by Paul Maskens @ OMRI, UK  100012,3274
*
*  For OzCIS 2.0, assumes 'c:\ozcis\foxforum\foxforum.msg'
*  Second parameter added to control initial state of clear flag
*  Added record count in message
*
parameters thisfile,clearflag
clear
if type('clearflag') # 'C'
	clearflag = "Y"					&& preserve old behaviour
endif
IF (type("thisfile") # "C") or (thisfile="N")
  ?? chr(7)
  wait window [Correct syntax is   DO PARSFF with "MSGFILE.MSG"] timeout 2
  *
  wait window [Assuming OZCIS\FOXFORUM messages] timeout 5
  thisfile="c:\ozcis\foxFORUM\foxFORUM.msg"
ENDIF
SET SAFETY OFF
SET TALK   OFF
CLOSE ALL
IF file("FOXFORUM.DBF")
  DEFINE WINDOW whattodo ;
		FROM INT((SROW()-13)/2),INT((SCOL()-68)/2) ;
		TO INT((SROW()-13)/2)+12,INT((SCOL()-68)/2)+67 ;
		FLOAT ;
		NOCLOSE ;
		SHADOW ;
		DOUBLE ;
		COLOR SCHEME 5
  ACTIVATE WINDOW whattodo
  if clearflag="N"
  	clearnew = .f.
  else
	clearnew = .t.
  endif
  dopack = .f.
  @ 2,7 GET clearnew ;
	  PICTURE "@*C Clear the {New} mark from all existing messages" ;
	  SIZE 1,51  
  @ 4,7 GET dopack ;
	  PICTURE "@*C Do a PACK to zap records marked for deletion" ;
	  SIZE 1,48  
  @ 8,17 GET action ;
	  PICTURE "@*HT \!\<Go For It;\?\<Oops, Forget It" ;
	  SIZE 1.5,18,10 ;
	  DEFAULT 1
  READ CYCLE object 3 TIMEOUT 10
  release window whattodo
  IF (action = 2)
    return
  ENDIF
 ELSE
  clearnew = .f.
  dopack = .f.
ENDIF
*IF ! FILE("TEMPFF.DBF")
  CREATE CURSOR newFORUM (new    C(1), ;
                       threadnew C(1), ;
                       area   C(16), ;
                       thread C(25), ;
                       number C(06),;
                       prior  C(06), ;
                       from   C(24),;
                       to     C(24),;
                       date   D(08),;
                       time   C(05),;
                       from_addr C(12),;
                       to_addr C(12),;
                       text   M)
* ELSE
* use TEMPFF in select(1)
*  select TEMPFF
*ENDIF
set status BAR on
*zap
clear 

wait window "Parsing messages ..." nowait

fhandle = FOPEN(thisfile,0)
baseline = FGETS(fhandle)

IF fhandle > -1
   DO WHILE ! FEOF(fhandle)
      APPEND BLANK
      REPLACE number WITH alltrim(SUBSTR(baseline,AT(' ',baseline,1)+1,AT(' ',baseline,2)-AT(' ',baseline,1)-1))
      *
      * kludge to sort out OzCis Private flag
      *
      if "(P) " $ baseline
      	baseline=strtran(baseline,"(P) ")
      endif
      
      x = RIGHT(baseline,LEN(baseline)-AT(' ',baseline,2))
      replace area with substr(x,2)
      *
      * kludge to sort 01 before 02 before 10 before 11
      *
      if val(area)<10
      	replace area with '0'+area
      endif

      baseline = FGETS(fhandle)   && Second Line
      m.date  = IIF(SUBSTR(UPPER(baseline),8,3)='JAN','01',;
                IIF(SUBSTR(UPPER(baseline),8,3)='FEB','02',;
                IIF(SUBSTR(UPPER(baseline),8,3)='MAR','03',;
                IIF(SUBSTR(UPPER(baseline),8,3)='APR','04',;
                IIF(SUBSTR(UPPER(baseline),8,3)='MAY','05',;
                IIF(SUBSTR(UPPER(baseline),8,3)='JUN','06',;
                IIF(SUBSTR(UPPER(baseline),8,3)='JUL','07',;
                IIF(SUBSTR(UPPER(baseline),8,3)='AUG','08',;
                IIF(SUBSTR(UPPER(baseline),8,3)='SEP','09',;
                IIF(SUBSTR(UPPER(baseline),8,3)='OCT','10',;
                IIF(SUBSTR(UPPER(baseline),8,3)='NOV','11','12')))))))))));
                +'/'+SUBSTR(baseline,5,2)+'/'+SUBSTR(baseline,12,2)
			*
			*  ONLY works if DATE is AMERICAN !
			*
	  		m.adate = m.date
			if set("date")=="BRITISH"
	  		m.date  = substr(m.adate,4,2)+'/'+left(m.adate,2)+'/'+right(m.adate,2)
				*
				*  m.date is now BRITISH, m.adate is American.
				*
      	REPLACE date WITH CTOD(m.date)
      else
      	replace date with ctod(m.adate)
      endif
      
      REPLACE time WITH RIGHT(baseline,LEN(baseline)-RAT(' ',baseline))
      
      baseline = FGETS(fhandle)   && Third Line
      *
      * first try to kill Kevin Podbielniak's messages!
      *    e.g. Sb: ##65037-Print Setup
      *         ^   ^^
      *         1   56
      if substr(baseline,5,1)=substr(baseline,6,1)
      	baseline=strtran(Baseline,'##','#',1)
      endif
      *
      * and deal with funny subjects with spaces in!
      *
      *   e.g. Sb: # 2.5 upgrade
      *             ^
      *              \ causes problems!
      *
      do while substr(baseline,6,1)=" "
      	baseline=left(baseline,5)+substr(baseline,7)
      enddo
      *
      * now try to kill Meng's #12345-#67689-string
      *    e.g. Sb: #65037-#65014-#Print Setup
      *         ^   ^    ^ ^    ^
      *         1   5   10 12  17
      *         Sb: #107731-#107356 Close Buttons
      *         ^   ^     ^ ^     ^
      *         1   5    11 13   19
			**
			**if substr(baseline,12,1)='#';
			**and val(substr(baseline,13,5)) >10000
			**		baseline=strtran(baseline,substr(baseline,11,7),'-')
			**endif
      **(old code copes with >99999 only)
      *
      start=at('-',baseline) +1
      *
      *  0+1 =1  IF no '-' in the subject at all...
      *
      if start>1 and substr(baseline,start+1,1)="#"
      	first=start+2
      	last=0
      	for ptr=first to len(baseline)
      		if !isdigit(substr(baseline,ptr,1))
      			last=ptr
      			exit
      		endif
      	endfor
      	numlen=last-first
      	*
      	*  We make an arbitrary decision that message numbers
      	*   will be at least 5 digits...
      	*
      	*	 This allows messages about 1024x768 mode !
      	*
      	if numlen>4
      		newbase=left(baseline,start-1)
      		newbase=newbase+substr(baseline,last)
      		baseline=newbase
      	endif
      endif
      *
      * prior = number if 5th char is # and value of 6->> is numeric >9999
      *    e.g. Sb: #65037-Print Setup
      *         Sb: #384093-FP message
      *         ^   ^    ^
      *         1   5    10
      *
      REPLACE prior  WITH IIF(SUBSTR(baseline,5,1) = '#';
      									  AND VAL(SUBSTR(baseline,6,6)) > 9999 ;
                              ,alltrim(str(val(SUBSTR(baseline,6,6)),6));
                              ,'')
      *
      * thread = all past '-' if 5th char is # and value of 6->> is numeric >9999
      * thread = all past ' ' if not
      *    e.g. Sb: Win Application Error
      *         Sb: #65037-Print Setup
      *         Sb: #384093-FP message
      *         ^   ^    ^
      *         1   5    10
      *
      REPLACE thread WITH IIF(SUBSTR(baseline,5,1) = '#';
                          AND VAL(SUBSTR(baseline,6,6)) > 9999 ;
                              ,RIGHT(baseline,LEN(baseline)-AT('-',baseline));
                              ,RIGHT(baseline,LEN(baseline)-AT(' ',baseline)))
      *
      * if thread begins with "#" or " ", remove it...
      *  empty() check added 10/6/93
      *
      do while !empty(thread);
       and ((left(thread,1)=="#") or (left(thread,1)==" "))
      	REPLACE thread WITH substr(thread,2)
      enddo

      baseline = FGETS(fhandle)   && Fourth Line
      REPLACE from_addr WITH RIGHT(baseline,LEN(baseline)-RAT(' ',baseline))
      REPLACE from WITH SUBSTR(baseline,5,RAT(' ',baseline)-4)
      
      baseline = FGETS(fhandle)   && Fifth Line
      if " (X)" $ baseline
      	baseline=strtran(baseline," (X)")
      endif
      *
      REPLACE to_addr WITH RIGHT(baseline,LEN(baseline)-RAT(' ',baseline))
      REPLACE to WITH SUBSTR(baseline,5,RAT(' ',baseline,1)-4)
      *
      * if to is sysop, all &c, then there is no to_addr !
      *
      if val(to_addr)=0
      	replace to_addr with ""
      	replace to with substr(baseline,5)
      endif
      *
      * now the message
      *
      baseline = FGETS(fhandle)
      IF EMPTY(baseline)
         baseline = FGETS(fhandle)
      ENDIF
      m_string = ''
      DO WHILE LEFT(baseline,2) != '#:' .AND. ! FEOF(fhandle)
         m_string = m_string + baseline + CHR(13)
         baseline = FGETS(fhandle)
         if len(m_string) >10500
         	wait window "ERROR - MESSAGE TOO LONG!"
         	suspend
         	exit
         endif
      ENDDO
      REPLACE text with m_string
      
      *
      * Paul's bodge for forum announcements
      *
      if ("PASS 1 HEADER" $ upper(thread);
       or "PASS 2 HEADER" $ upper(thread));
      and memlines(text) > 19
      	replace thread with 'Forum Header'
      	msgline = mline(text,atline("Forum messages:",text))
      	replace number with '-'+substr(dtoc(newforum.date),4,2)+left(dtoc(newforum.date),2)+right(dtoc(newforum.date),1)
      endif
		wait window "Parsing messages ... "+str(recno()) nowait      
   ENDDO
ENDIF
=FCLOSE(fhandle)

wait window [Adding to database ...] nowait
set deleted off
*select * from TEMPFF distinct  ;
*     WHERE !"PASS 1 HEADER" $ upper(thread) ;
*       AND !"PASS 2 HEADER" $ upper(thread) ;
*     INTO cursor newFORUM
wait window [Adding to database] nowait
*use in TEMPFF
*erase tempFF.dbf
*erase tempFF.fpt
IF file("FOXFORUM.DBF")
  use FOXFORUM in select(1) exclusive
  select FOXFORUM
  IF tag(1) # "THREADS" .or. tag(2) # "NUMBER" .or. tag(3) # "ISDEL" ;
       .or. tag(4) # "NEW" .or. tag(5) # "THREADNEW" .or. tag(6) # "THREAD" ;
       .or. tag(7) # "TO" .or. tag(8) # "FROM"
    delete tag all
    wait window "Rebuilding .CDX tags ..." nowait
    index on alltrim(left(area,2)+thread+number) tag threads
    index on number tag number
    index on deleted() tag isdel
    index on new tag new
    index on threadnew tag threadnew
    index on thread tag thread
    index on upper(to) tag to
    index on upper(from) tag from
  ENDIF
 ELSE
  copy stru to FOXFORUM.DBF
  use FOXFORUM in select(1) exclusive
  select FOXFORUM
  index on alltrim(left(area,2)+thread+number) tag threads
  index on number tag number
  index on deleted() tag isdel
  index on new tag new
  index on threadnew tag threadnew
  index on thread tag thread
  index on upper(to) tag to
  index on upper(from) tag from
ENDIF
set order to tag number
IF clearnew
	wait window "Clearing NEW flags ..." nowait
  replace all new with space(1)
ENDIF
IF dopack
  wait window "PACKing, as you requested ..." nowait
  pack
ENDIF
select NEWFORUM
replace all new with chr(16)
wait window str(reccount())+" Eliminating duplicates ..." nowait
jnAdded=0
SCAN
  IF !seek(NEWFORUM.number,"FOXFORUM")
     IF !"PASS 1 HEADER" $ upper(thread) ;
       AND !"PASS 2 HEADER" $ upper(thread)
	    scatter memvar memo 
	    insert into FOXFORUM from memvar
	    jnAdded = jnAdded +1
		wait window str(reccount())+" Eliminating duplicates ... "+str(jnAdded) nowait
	  ENDIF
  ENDIF
ENDSCAN
rele jnAdded
*
* NEW LINE
*
use in newforum
*
wait window [Updating "NEW" flags ...] nowait
select FOXFORUM
replace all threadnew with space(1) for !empty(threadnew)
*
wait window [Updating "NEW" flags ... find] nowait
set order to tag thread
* cursore containing threads that have NEW messages:
SELECT * FROM FOXFORUM ;
    WHERE new # space(1) ;
    GROUP by thread ;
    INTO cursor newTHREAD
go top
wait window [Updating "NEW" flags ... replace] nowait
SCAN
  select FOXFORUM
  seek newTHREAD.thread
  replace threadnew with "*" WHILE FOXFORUM.thread = newTHREAD.thread
  select newTHREAD
ENDSCAN
use in newTHREAD
*erase newFORUM.dbf
*erase newFORUM.fpt
set status off
wait clear
return
