* Program..:  Extract.prg
* Author...:  Martin Schiff
* Date.....:  February 24,1987
* Notice...:  (C) Custom Data Solutions, 1987, All rights reserved
* Notes....:  This program will perform a wildcard match using spaces in
* .........:  the input variable code as wild cards.  You can change the
* .........:  variable "wildcard" to any other character you wish as long
* .........:  as it is a character not otherwise allowed in the code.
* .........:  Database must have a flag field (here it is "selected").
* .........:  This code or a variation may be used in its current form or
* .........:  in modified form in any way you choose.
*
* .........:  If you are working with a very large list, and the first
* .........:  position of the code is not allowed to be a blank or wildcard,
* .........:  you could speed this up tremendously by indexing on the code,
* .........:  SEEKing the first letter of the code you are trying to find,
* .........:  and restricting your DO WHILE loop to quit when the first
* .........:  letter of the code changes.  
wildcard=' '
codelen=12
clear
select mail          && select your database that you will extract
set order to 0
replace all selected with .f.       && initialize flag field in the database 
code=space(codelen)                      && input variable for code to match
clear
@ 10,10 say 'What is the code that you wish to use? ' get code picture '@!'
read
if code=space(codelen)
  ?? chr(7)
  ? 'No code selected press any key to return to main menu...'
  wait ''
  return
endif
clear
@ 10,25 say '    *** Please Wait ***'
@ 12,25 say '  Creating Temporary list...'
go top
do while .not. eof()        && mark all records that meet the search criteria
  n=1
  match=.t.
  do while n<=len(code) .and. match     && match code to field in database (class)
    * if the code does not match, and that position of the input code is not a 
    * wildcard, this is not a match
    if upper(substr(code,n,1))<>upper(substr(class,n,1)) .and. substr(code,n,1)<>wildcard
      match=.f.
    endif
    n=n+1
  enddo
  if match        && if it was a match flag the record
    replace selected with .t.
  endif
  skip 1
enddo
set filter to selected        && or whatever you want to do with the flagged
go top                        && records
curlist='TEMP'                && pretend you have created a new smaller list
return

