parameters textin, titlein, buttonno

private minwidth,;
        winwidth,;
        xmin,;
        xmax,;
        ymin,;
        ymax,;
        rowctr,;
        startrow,;
        endrow,;
        buttonset,;
        symbolset,;
        savemwidth,;
        buttoncnt,;
        buttonarr,;
        textlines,;
        winheight,;
        memowidth,;
        textarray,;
        x,;
        winname,;
        retval,;
        pushlen,;
        maxbtn
        
*-- save status of memowidth
m.savemwidth = set("MEMOWIDTH")        

*-- trim title
m.titlein = alltrim(m.titlein)
        
*-- determine which set of buttons to use        
m.buttonset = m.buttonno % 16

*-- m.symbolset is not currently used, but could be used to emulate
*-- the graphics that Windows uses in left side of msgbox
*-- m.symbolset = 0 - no graphic
*--               1 - stop sign
*--               2 - question mark
*--               3 - exclamation point
*--               4 - lower case "i"
*m.symbolset = int(m.buttonno/16)       
        
*-- determine width of push buttons, compare to width of title
*-- to determine minimum window width (actual window width may
*-- be greater, depending on text).
m.maxbtn = 8
do case

  *-- ok
  case m.buttonset = 0
    m.buttoncnt  = 1
    dimension buttonarr[1]
    buttonarr[1] = 1
    m.promptstr  = "\?\<OK"
    m.inkeystr   = "O"
    m.maxbtn     = 4
    
  *-- ok, cancel  
  case m.buttonset = 1
    m.buttoncnt = 2
    dimension buttonarr[2]
    m.promptstr  = "\<OK;\?\<Cancel"
    buttonarr[1] = 1
    buttonarr[2] = 2
    m.inkeystr   = "OC"
           
  *-- abort, retry, ignore
  case m.buttonset = 2
    m.buttoncnt = 3
    dimension buttonarr[3]  
    buttonarr[1] = 3
    buttonarr[2] = 4    
    buttonarr[3] = 5
    m.promptstr  = "\?\<Abort;\<Retry;\<Ignore"
    m.inkeystr   = "ARI"    
    
  *-- yes, no, cancel
  case m.buttonset = 3  
    m.buttoncnt = 3
    dimension buttonarr[3]  
    buttonarr[1] = 6
    buttonarr[2] = 7    
    buttonarr[3] = 2
    m.promptstr  = "\<Yes;\<No;\?\<Cancel"    
    m.inkeystr   = "YNC"
    
  *-- yes, no
  case m.buttonset = 4  
    m.buttoncnt = 2
    dimension buttonarr[2]  
    buttonarr[1] = 6
    buttonarr[2] = 7
    m.promptstr  = "\<Yes;\?\<No"    
    m.maxbtn     = 5    
    m.inkeystr   = "YN"

  *-- retry, cancel
  case m.buttonset = 5
    m.buttoncnt = 2
    dimension buttonarr[2]  
    buttonarr[1] = 4
    buttonarr[2] = 2
    m.promptstr  = "\<Retry;\?\<Cancel"
    m.inkeystr   = "RC"
    
  *-- abort, retry
  case m.buttonset = 8
    m.buttoncnt = 2
    dimension buttonarr[2]  
    buttonarr[1] = 3
    buttonarr[2] = 4
    m.promptstr  = "\?\<Abort;\<Retry"  
    m.maxbtn     = 7    
    m.inkeystr   = "AR"
    
  *-- ok, cancel, abort, retry, ignore
  case m.buttonset = 9
    m.buttoncnt = 5
    dimension buttonarr[5]  
    buttonarr[1] = 1
    buttonarr[2] = 2      
    buttonarr[3] = 3      
    buttonarr[4] = 4
    buttonarr[5] = 5
    m.promptstr  = "\<OK;\?\<Cancel;\<Abort;\<Retry;\<Ignore"
    m.inkeystr   = "OCARI"
    
  *-- yes
  case m.buttonset = 12
    m.buttoncnt = 1
    dimension buttonarr[1]
    buttonarr[1] = 6
    m.promptstr  = "\?\<Yes"
    m.maxbtn     = 5    
    m.inkeystr   = "Y"
    
  *-- cancel, retry
  case m.buttonset = 14
    m.buttoncnt = 2
    dimension buttonarr[2]
    buttonarr[1] = 2
    buttonarr[2] = 4
    m.promptstr  = "\?\<Cancel;\<Retry"
    m.inkeystr   = "CR"
    
  *-- 6,7,10,11,13 and 15 have no valid buttons.
  *-- use 1 OK button to prevent error.
  otherwise
     m.buttoncnt  = 1
    dimension buttonarr[1]
    buttonarr[1] = 1
    m.promptstr  = "\?\<OK"
    m.inkeystr   = "O"
    m.maxbtn     = 4
 
endcase

*-- width of push buttons = length of all buttons (up to 8/button) +
*-- spacing between buttons (1 between each set)
*-- len   = length of buttons        + spacing between buttons
m.pushlen = (m.buttoncnt * m.maxbtn) + (m.buttoncnt - 1)

*-- compare with title
m.minwidth = max(m.pushlen,len(m.titlein)+2)

*-- 8 is minimum width allowed by set memowidth command
m.minwidth = max(m.minwidth,8)

*-- determine number of lines to be displayed. this can
*-- then be used to determine height of window.
*-- start with a memowidth of 50 (or minwidth). if it fits on 1 line,
*-- decrement memowidth until no space is wasted. if it doesn't fit in
*-- enough lines to fit on screen, increment memowidth until text will
*-- fit on the screen. must leave 2 lines at top (window border and 1
*-- blank line) and 4 lines at bottom (window border, blank line, push
*-- buttons, and another blank line.
m.memowidth = max(50,m.minwidth)
set memowidth to m.memowidth
do while m.memowidth <= (scols() - 6)
  if memlines(m.textin) <= (srows() - 6)
    exit
  endif  
  m.memowidth = m.memowidth + 5
  set memowidth to m.memowidth  
enddo

*-- text fits on one line, reduce size of box until no space is wasted.
if memlines(m.textin) = 1
  do while m.memowidth >= m.minwidth
    m.memowidth = m.memowidth - 1
    set memowidth to m.memowidth
    if memlines(m.textin) > 1
      m.memowidth = m.memowidth + 1
      set memowidth to m.memowidth
      exit
    endif
  enddo
endif

*-- create array holding message. each element in array holds
*-- one line of text.
m.textlines = memlines(m.textin)
if m.textlines > 0
  dimension textarray[m.textlines]
  _mline = 0
  for m.x = 1 to m.textlines
    textarray[m.x] = mline(m.textin,1,_mline)
  endfor  
else
  dimension textarray[1]
  store "" to m.textarray
endif  

*-- determine height and width of window
m.winwidth  = m.memowidth + 4
m.winheight = m.textlines + 4
     
*-- determine window coordinates.
m.xmin    = int((srows() - m.winheight)/2)
m.xmax    = m.xmin + m.winheight
m.ymin    = int((scols() - m.winwidth)/2)
m.ymax    = m.ymin + m.winwidth

*-- define window
m.winname = "_" + sys(3)
do while wexist(m.winname)
  m.winname = _ + sys(3)
enddo
define window (m.winname);
 from m.xmin,m.ymin to m.xmax,m.ymax;
 title m.titlein;
 noclose;
 float;
 nogrow;
 shadow;
 color scheme 13

activate window (m.winname) noshow 
for m.rowctr = 1 to m.textlines
  @ m.rowctr,1 say textarray[m.rowctr]
endfor

m.retval = 0
m.promptstr = "*TH " + m.promptstr
@ m.rowctr + 1,((m.winwidth - m.pushlen)/2) get m.retval;
  function m.promptstr size 1,m.maxbtn

show window (m.winname)  

if rdlevel() = 5
  m.retval = getkey()
  clear gets
else
  read cycle modal
endif  

release window (m.winname)
*-- restore previous memowidth setting.
set memowidth to m.savemwidth

return buttonarr[m.retval]
*****************************************


*****************************************
function getkey
private x,;
        promptarr,;
        mousecol,;
        mouserow,;
        retval,;
        keystroke

*-- determine applicable beginning and ending columns for prompts
*-- so user can click on them with a mouse.        
dimension promptarr[m.buttoncnt,2]
for m.x = 1 to m.buttoncnt
  promptarr[m.x,1] = ((m.winwidth - m.pushlen)/2) +;
                     ((m.maxbtn + 1) * (m.x - 1))
  promptarr[m.x,2] = ((m.winwidth - m.pushlen)/2) +;
                     ((m.maxbtn + 1) * (m.x - 1)) +;
                     (m.maxbtn - 1)
endfor                       

m.retval = 0

do while m.retval = 0
  m.keystroke = max(inkey(0,"HM"),0)
  
  do case
    
    *-- check for mouse click
    case m.keystroke = 151  
    
      m.mousecol = mcol(m.winname)
      m.mouserow = mrow(m.winname)
      
      if m.mousecol <> -1 .and. m.mouserow = m.rowctr + 1
        for m.x = 1 to m.buttoncnt
          if m.mousecol >= promptarr[m.x,1] .and.;
             m.mousecol <= promptarr[m.x,2]
             m.retval = m.x
             exit
          endif
        endfor
      endif  
      
    *-- check for correct hot key
    case upper(chr(m.keystroke)) $ m.inkeystr
      m.retval = at(upper(chr(m.keystroke)),m.inkeystr)
      
  endcase    
enddo

return m.retval  
***************************************
