/*-------------------------------------------------------------------------
* Program:   DMACRO.C
*
* Author:    Richard Low
*
* Date:      10/08/91
*
* Version:   1.1
*
* Compiler:  Borland C++ (or Turbo C 1.5, 2.0)
*
* Purpose:   Search dBase/Clipper/Xbase .prg files for lines that contain
*            macro references.  This utility is perfect for ferreting out
*            calls to macros to be converted to code blocks in Clipper 5.0
*
*-------------------------------------------------------------------------*/
#include <dir.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define  TRUE       1
#define  FALSE      0
#define  MAXSPEC    MAXDRIVE + MAXDIR + MAXFILE + MAXEXT


/* function prototypes */
int GetListFile(FILE *listfile, struct ffblk *ffblkptr, char *filespec,
                char *drive, char *dir, char *name, char *ext);


/* execution starts here */
void main(int argc, char *argv[])
{
   char    filespec[ MAXSPEC ];
   char    drive[ MAXDRIVE ];
   char    dir[ MAXDIR ];
   char    name[ MAXFILE ];
   char    ext[ MAXEXT ];

   struct  ffblk ffblk;                            /* normal file structure   */
   FILE    *infile, *listfile;                     /* file pointers           */
   char    s[512];                                 /* string to hold readln   */
   char    *macro;                                 /* macro location in string*/
   int     i;                                      /* generic loop counter    */

   int     anyfoundflag;
   int     thisfileflag;
   int     linenum;
   int     finished;
   int     uselist;


   if ( argc < 2 ) {
      puts("DMACRO Version 1.1 - Copyright (c) 1991 Richard Low\n");
      puts("Purpose: Display macro references in .prg files\n");
      puts("Syntax:  DMACRO [d:][path]filespec  @listfile\n");
      puts("RLIB Software");
      puts("P. O. Box 3232");
      puts("Durham, NC 27715");
      puts("Phone: (919) 383-0488");
      puts("CompuServe: 72007,1063");
      exit(1);
   }

   for ( i = 2; i < argc; i++ )                    /* convert parms to upcase */
      strupr(argv[i]);

   strcpy(filespec, argv[1]);                      /* copy filespec parameter */
   uselist = ( *filespec == '@' );                 /* see if they gave a list */


   if ( uselist ) {
      if ( (listfile = fopen(&filespec[1], "rt")) == NULL ) {
         puts("Error opening list file.  Program aborted!");
         exit(1);
      }
      finished = GetListFile(listfile,&ffblk,filespec,drive,dir,name,ext);
   }
   else {
      fnsplit(filespec,drive,dir,name,ext);        /* break out path parts    */
      finished = findfirst(filespec, &ffblk, 0);   /* find first match file   */
   }


   if ( finished ) {
      printf("File not found: %s\n", filespec);
      if ( uselist )
         fclose(listfile);
      exit(1);
   }

   anyfoundflag = FALSE;

   while ( !finished ) {
      fnsplit(ffblk.ff_name,"","", name, ext);     /* split into name + ext   */
      fnmerge(filespec, drive, dir, name, ext);    /* re-build full filename  */

      if ( (infile = fopen(filespec, "rt")) == NULL ) {
         printf("Error opening file: %s.\n", ffblk.ff_name);
         if ( uselist )
            fclose(listfile);
         exit(1);
      }

      memset(s, '\0', 512);                        /* fill buffer with nulls  */
      thisfileflag = FALSE;                        /* set flag for this file  */
      linenum = 1;                                 /* start at file line #1   */

      while ( fgets(s, 512, infile) ) {            /* read in line at a time  */
         if ((macro = strchr(s, '&')) != NULL )    /* look for a & in string  */
            if (isalpha(macro[1]) || macro[1] == '_') {
               if ( !thisfileflag )                /* 1st find for this file? */
                  printf("File: %s\n", ffblk.ff_name); /* show the file name  */

               printf("%4d | %s", linenum, s);     /* print the line with num */
               thisfileflag = anyfoundflag = TRUE;
            }
         linenum++;
         memset(s, '\0', 512);                     /* reset the buffer        */
      }

      fclose(infile);                              /* remember to close file  */

      if ( uselist )
         finished = GetListFile(listfile,&ffblk,filespec,drive,dir,name,ext);
      else
         finished = findnext(&ffblk);              /* find the next match     */
   }

   if ( !anyfoundflag )
      puts("No match found.");

   if ( uselist )
      fclose(listfile);
}



/*--------------------------------------------------------------------------
* Function: GetListFile()
*
* Returns.: 0 on success, 1 on error (file not found or EOF)
*--------------------------------------------------------------------------*/
int GetListFile( FILE *listfile, struct ffblk *ffblkptr, char *filespec,
                 char *drive, char *dir, char *name, char *ext )
{
   char *chrptr;

   while (1) {
      memset(filespec, '\0', MAXSPEC);             /* fill buffer with nulls  */
      chrptr = fgets(filespec,MAXSPEC,listfile);   /* read in the 1st line    */

      if ( chrptr == NULL )                        /* if end-of-file          */
         break;                                    /* finished                */

      if ( (chrptr = strchr(filespec,'\n')) != NULL ) /* look for CRLF        */
         *chrptr = '\0';                           /* replace with terminator */

      fnsplit(filespec, drive, dir, name, ext);    /* break out path parts    */
      if ( strlen(ext) == 0 )                      /* if no extension given   */
         {
         strcpy(ext, ".PRG");                      /* default to .PRG         */
         fnmerge(filespec,drive,dir,name,ext);     /* re-build full filename  */
         }

      if ( findfirst(filespec,ffblkptr,0) == 0 )  /* find first match file   */
         return (0);

      printf("File not found: %s\n", filespec);
   }

   return (1);
}

