***********************************************************************
*
* DIR@SELC - Select a program from the list of programs available
*            to the user
*
*  Copyright 1994 - Chris Bobbitt
*  All Rights Reserved
*
***********************************************************************
*	IN:	
*			who			-	name of user
*	OUT:
*			npath		-	full path/filename of MAS@DEFS database
*			dpath		-	path to the individual programs data directory
*			rpath		-	path to the individual programs program directory
*			upath		-	full path/filename of the programs ..@ENV database
*			topath		-	user text output path
*			dopath		-	user database output path
*			mpgmid		-	ID code of the program being run
*			mdefid		-	ID code of the default lookup database
*			mprefix		-	program type prefix
*			pgmfn		-	program filename
*			pgman		-	program descriptions
*
*	*NOTE* All variables passed through public variables
***********************************************************************
*
	end_win=0
*
* Open files if necessary
*
	IF ! used(1,'USERBASE')
		set exclusive off
		select 1		&& Open the USERBASE user database
		use (l_userbase)
		set order to username
	ENDIF
*
* Dump information out of files if necessary
*
	IF end_win=0
		select 1
		declare pgm_list[1],pgm_ids[1]
* Get users programs from list
		select program;
		  from (l_userbase);
		  where username=who;
		  order by program;
		  into array pgm_list
		select pgmid;
		  from (l_userbase);
		  where username=who;
		  order by program;
		  into array pgm_ids
		set order to pgmid
		goto top
		numpgms=alen(pgm_list)
		end_win=iif(numpgms>15,20,7+numpgms)
	ENDIF
*
*	Select program from menu
*
	set filter to username=who
	msg="<CTRL><W>-Select Program  <ESC>-Cancel"
   	do sub@disc with msg
   	define window atran from 4,17 to end_win,63 double nozoom noclose title 'Select a Program'
   	activate window atran
   	sel_pgm=1
	@ 0, 0 get sel_pgm from pgm_list
	read cycle
	release window atran
	on key label f9
	on key label f10
	set library to
   	@24,0 say space(80)
	IF lastkey()=27
		select 1
		use
		release pgm_list,pgm_ids
		return
	ENDIF
	goto top
	mpgmid=space(8)
	tpgmid=pgm_ids[sel_pgm]
	seek tpgmid
	IF found()
*
*	Ask for a password if there is one
*
		IF password
			try=3
			okay=0
			DO WHILE try>0
				pwrd=space(20)
			   	define window askpass from 16,40 to 18,75 double
			   	activate window askpass
			   	@0,0 say 'Password? ' get pwrd picture '@!' color ,W/W
			   	read
			   	release window askpass
				IF alltrim(upper(pwrd))=alltrim(upper(pwd))
		   			okay=1
		   			try=0
		   		ELSE
					wait window 'Sorry... Incorrect... Try again!' nowait
		   			okay=0
		   			try=try-1
		   		ENDIF
		   	ENDDO
		ELSE
			okay=1
		ENDIF		
*
* Setup Environmental variables
* Get user information from USERBASE
*
		mpgmid=tpgmid							&& Save pgm id code
		dpath=alltrim(datdirect)				&& Save program data path
		pgmfn=pgmfilenme						&& Save program type
		mprefix=prefix							&& Save program prefix
		m.opgmnm=program
		m.oprefix=prefix
*
* Set up filename logicals for databases and indexes
*
		l_pgm_path=alltrim(pgmdirect)
		l_log_data=dpath+mprefix+'@LOG.DBF'
		l_add_data=dpath+mprefix+'@ADD.DBF'
		l_src_data=dpath+mprefix+'@SRC.DBF'

	ENDIF
	select 1
	use
*
RETURN