* 
* UDF - Yes/No question
* 
* display yes/no question in sized window and 
* return user's response
* 
* P:	msg -	message to display as question, maximum
*			   is 130 chars, excess is truncated
*		mrow - message row (optional), default is 12
* R:	user response T/F
* 
PARAMETERS msg,mrow
mrow = IIF(PARAMETERS() > 1,mrow,12)
msg = LEFT(msg,130)
f_twolines = .F.
* 
* if msg > 65 chars, split message into two lines
* on the space closest to center of message.
* len_msg gets the greater of the two message lines.
* 
IF LEN(TRIM(msg)) > 65
	FOR loc = INT(LEN(msg)/2) TO LEN(msg)
		IF SUBSTR(msg,loc,1) = " "
			EXIT
		ENDIF
	ENDFOR
	msg1 = LEFT(msg,loc-1)
	msg2 = RIGHT(msg,LEN(msg)-loc)
	len_msg = MAX(LEN(msg1),LEN(msg2))
	f_twolines = .T.
ELSE
	len_msg = LEN(TRIM(msg))
ENDIF
* 
* define window based on size of message.
* minimum message (window) size is 40
* 
len_msg = IIF(len_msg<40,40,len_msg)
DEFINE WINDOW W_YN;
	FROM mrow,39-ROUND(len_msg/2+2,0);
	TO mrow+IIF(f_twolines,5,4),40+INT(len_msg/2+2);
	COLOR SCHEME 23;
	DOUBLE;
	SHADOW
ACTIVATE WINDOW W_YN
* 
* display message in window with Yes/No buttons
* 
IF f_twolines
	@ 0,2 SAY PADC(msg1,len_msg)
	@ 1,2 SAY PADC(msg2,len_msg)
ELSE
	@ 0,2 SAY PADC(msg,len_msg)
ENDIF
@ IIF(f_twolines,03,02),len_msg/2-11 GET m.yn;
	PICTURE "@*HT \<Yes;\<No";
	SIZE 1,10,5;
	DEFAULT 1
READ CYCLE MODAL
DEACTIVATE WINDOW W_YN
* 
* return response, ESC returns .F.
* 
IF m.yn = 1 .AND. LASTKEY() <> 27
	rval = .T.
ELSE
	rval =.F.
ENDIF
RETURN rval