* 
* user selects project file to report on,
* exit if no selection was made
* 
vc_ProjLFile = GETFILE("PJX","Select Project ")
IF EMPTY(vc_ProjLFile)
	RETURN
ENDIF
WAIT WINDOW "Working, please wait" NOWAIT
vc_ProjSFile = SYS(2014,vc_ProjLFile)
* 
* create cursor used for proecessing.
* the table that the report will be genrate from.
* 
CREATE CURSOR CProj (CType C(12), CName C(50))
* 
* create cursor of all records from selected project
* including type and name, ordered by name
* 
SELECT Type, LEFT(Name+SPACE(50),50) AS Name;
	FROM &vc_ProjLFile;
	ORDER BY 2;
	INTO CURSOR Proj
SELECT Proj
* 
* find header record in project file to get name,
* create header for report including the name of
* the project, plus current date and time
* 
LOCATE FOR Type = "H"
vc_Header = "Proj Info for "+LEFT(Proj.Name,AT(".",Proj.Name)-1)+;
	" as of "+DTOC(DATE())+" at "+LEFT(TIME(),5)
* 
* ProjType is a dbf containing the different types 
* of components (screens, programs, menus, etc) of
* a project with code and description
* 
USE ProjType IN SELECT(1)
SELECT ProjType
GO TOP
* 
* for each project component type from ProjType, go
* through project file and insert a record into 
* curosr CProj for each record with matching 
* project type.  if no records exist for component
* type, insert one record with 'none' for name
* 
DO WHILE NOT EOF()
	f_NoRecs = .T.
	SELECT Proj
	GO TOP
	DO WHILE !EOF()
* 
* the cuurent project record matches component type,
* insert record into cursor, including component
* description and name of the file, no extension.
* 
		IF Proj.Type = ProjType.Code
			m.CName = SUBSTR(Proj.name,1,LEN(ALLTRIM(Proj.Name))-5)
			m.CType = ProjType.Desc
			INSERT INTO CProj FROM MEMVAR
			f_NoRecs = .F.
		ENDIF
		SKIP
	ENDDO
* 
* no records for this project component
* 
	IF f_NoRecs
		m.CName = "None"
		m.CType = ProjType.Desc
		INSERT INTO CProj FROM MEMVAR
	ENDIF
	SELECT ProjType
	SKIP
ENDDO
WAIT CLEAR
* 
* print report
* 
SELECT CProj
DO CASE
	CASE rn_OutWhere = 1
		REPORT FORM ProjInfo PREVIEW
	CASE rn_OutWhere = 2
		WAIT WINDOW "Printing report, please wait" NOWAIT
		REPORT FORM ProjInfo TO PRINT NOCONSOLE
		WAIT WINDOW "Printing complete" NOWAIT
	CASE rn_OutWhere = 3
		WAIT WINDOW "Printing report to file, please wait" NOWAIT
		REPORT FORM ProjInfo TO FILE (vc_File) NOCONSOLE
		WAIT WINDOW "Printing complete" NOWAIT
ENDCASE
CLOSE DATA
