/* HEADER DDOS */

/*
Term      : System File Access
Last Edit : 11/94
System    : FOXPRO PLB/FLL C7 or Watcom C8.5
Copyright : Feel free to use and/or modify.

Author    : Roland Kappeler 100022,1370

Comment   : Can be used in DOS and Windows. All data passed to
            DOS is copied to protected areas.
*/

#define ACCESS_READ          0x00
#define ACCESS_WRITE         0x01
#define ACCESS_READWRITE     0x02

#define MODE_COMPATIBILITY   0x00
#define MODE_DENYALL         0x10
#define MODE_DENYWRITE       0x20
#define MODE_DENYREAD        0x30
#define MODE_DENYNONE        0x40

/* ------------------------------------------------------------ */

int DOSOpen (    char far *FileName,
                 int       AccessMode);

/*
  Opens a file.

  Returns -1 on failure, or a file handle > 0.

  AccessMode:

  Add or OR (|) one of each ACCESS and MODE groups.
*/
/* ------------------------------------------------------------ */

int DOSCreate (    char far *FileName);

/*
  Creates and opens a file (exclusive mode).

  Returns -1 on failure, or a file handle > 0.
*/
/* ------------------------------------------------------------ */

void DOSClose (    int Handle);

/*
  Closes a file.
*/
/* ------------------------------------------------------------ */

long DOSPos (    int Handle);

/*
  Returns the current file pointer.
*/
/* ------------------------------------------------------------ */

void DOSSeek (    int  Handle,
                  long Pos);

/*
  Sets the current file pointer.
*/
/* ------------------------------------------------------------ */

long DOSSize (    int Handle);

/*
  Returns the file size.
*/
/* ------------------------------------------------------------ */

unsigned int DOSRead (    int           Handle,
                          void far     *Item,
                          unsigned int  Size);

/*
  Reads Size bytes from a file into Item.
  Returns the number of bytes actually read.
*/
/* ------------------------------------------------------------ */

unsigned int DOSWrite (    int           Handle,
                           void far     *Item,
                           unsigned int  Size);

/*
  Writes Size bytes from Item into a file.
  Returns the number of bytes actually written
  < Size means Disk full.
*/
/* ------------------------------------------------------------ */

// END DDOS
