/*    Dbtdoc.c										*/

/*    Version 1.0     December 8, 1991    */
/*    Programmer:     Jay Parsons         */

#include <ctype.h>
#include <stdio.h>
#include <string.h>

/****************************************************************************/
/*                          definitions                                     */
/****************************************************************************/

typedef unsigned long ulong;        /* just an abbreviation                 */

extern char *filespec, message[];

/****              ****  function prototypes  ****                       ****/

int dbtdoc ( char *filespec );

FILE * dbtopen ( char *filespec );

/****************************************************************************/
/*                              dbtdoc                                      */
/*  Principal routine of this module. 													 */
/*  Parameters:                                                             */
/*      char *filespec  -- pointer to specification of the .dbt file        */
/*	 Returns 1 for error or 0, and fills external buffer "message"				 */
/*                                                                          */
/****************************************************************************/

int dbtdoc ( char *filespec )
{
	FILE *dbtfile;
	unsigned blocksize = 512;
	char foundname[9];
	char *ptr;

	/*  open file and check for .dbt type       */

	if ( ( dbtfile = fopen( filespec, "rb" ) ) == NULL )
	{
		sprintf( message, "Unable to open file %s ", filespec );
		printit( 1 );
		return 1;                           /* can't open file  */
	}

	/*  locate file name in spec and end it with null */

	ptr = strrchr( filespec, '\\' );
	if ( ptr )
		ptr++;
	else
		ptr = filespec;
	memset( strrchr( filespec, '.' ), '\0', 1 );

	/*  check name starting at byte 8 of file   */

	if ( fseek( dbtfile, 8, SEEK_SET ) != 0 )
	{
		fclose( dbtfile );
		sprintf( message, "No dBASE IV .dbt file header" );
		printit( 1 );
		return 1;                       /* can't reach name in .dbt     */
	}
	if ( fread( foundname, 9, 1, dbtfile ) != 1 )
	{
		fclose( dbtfile );
		sprintf( message, "Can't read file header" );
		printit( 1 );
		return 1;                       /* can't read it                */
	}
	if ( strcmp( foundname, ptr ) !=0 )
	{
		fclose( dbtfile );
		sprintf( message, "Wrong name in header--dBASE III+ type?" );
		printit( 1 );
		return 1;                       /* wrong name in file--corrupt  */
	}

/*  get and check blocksize at bytes 20-21  */

	if ( fseek( dbtfile, 20, SEEK_SET ) != 0 )
	{
		fclose( dbtfile );
		sprintf( message, "Can't reach blocksize word" );
		printit( 1 );
		return 1;                       /* can't reach size in .dbt     */
	}

	if ( fread( &blocksize, 2, 1, dbtfile ) != 1 )
	{
		fclose( dbtfile );
		sprintf( message, "Can't read blocksize from file" );
		printit( 1 );
		return 1;                       /* can't read block size        */
	}

	if ( blocksize & 511 != 0 || blocksize > 32 * 512 )
	{
		fclose( dbtfile );
		sprintf( message, "Illegal blocksize" );
		printit( 1 );
		return 1;                       /* illegal .dbt block size      */
	}
	else
	{
		fclose( dbtfile );
		sprintf( message, "Blocksize is %d, %d bytes", blocksize/512, blocksize );
		printit( 0 );
		return 0;
	}
}

/*   EOF  */
