/**************************************/
/*       dbdoc.c                      */
/*   dBASE documentor                 */
/*   Programmer:  Jay Parsons         */
/*   Version 1.0   10/31/91           */
/**************************************/

#include <string.h>
#include <stdio.h>
#include <dir.h>
#include <dos.h>

/**************************************/
/*       global declarations          */
/**************************************/

char file_name[ 78 ], message[ 1024 ], tempbuff[ 128 ];

/**************************************/
/*       function declarations        */
/**************************************/

int main( int argc, char *argv[] );
void printit( int err );

extern int memdoc(), dbfdoc(), mdxdoc(), qbedoc(), dbtdoc();

/**************************************/
/*       main routine                 */
/*                                    */
/*  Assumes first command-line        */
/*  argument is the file to document. */
/*                                    */
/*  If the file is not found or no    */
/*  routine exists for files of that  */
/*  extension type, quits with a      */
/*  message.                          */
/*                                    */
/*  Otherwise passes the file name    */
/*  to the appropriate routine for    */
/*  files of that extension.          */
/*                                    */
/**************************************/

int main( int argc, char *argv[] )
{
    struct ffblk ffblk;
	int err;
    char *dot, extension[5];
	 char *ftypes = ".MEM.DBF.MDX.QBE.DBT";
	 int (*ext_ptr[]) () = { memdoc, dbfdoc, mdxdoc, qbedoc, dbtdoc };

	if ( argc != 2 )
	{
		strcpy( message, "Syntax is \"Dbdoc <filespec>\"" );
		printit( 1 );
		return( 0 );
	}

	strcpy( file_name , strupr( argv[ 1 ] ) );
	if ( ( dot = strchr( file_name, '.' ) ) == NULL )
	{
        strcpy( message, "File extension must be given" );
        printit( 1 );
        return( 0 );
	}

	if ( findfirst( file_name, &ffblk, 0 ) )
	{
		sprintf( message, "Can't find file %s", file_name );
		printit( 1 );
		return( 0 );
	}

	strupr( strcpy( extension, dot ) );
	if ( ( dot = strstr( ftypes, extension ) ) == NULL )
	{
		sprintf( message, "File of extension type %s not supported", extension );
		printit( 1 );
		return( 0 );
	}

	err = ( *ext_ptr[ ( dot - ftypes ) / 4 ] ) ( file_name ) ;

	if( ! err )
		putchar('\n');
	return err;
}

/************************************/
/*    void printit( int err )       */
/*                                  */
/*   prints "message" to stdout,    */
/*   or to stderr if err, and \n.   */
/*                                  */
/*   Minimal sophistication, for    */
/*   test purposes only.            */
/************************************/

void printit( int err )
{
	if ( err )
	{
		fputs( message, stderr );
		fputc( '\n', stderr );
	}
	else
		if ( *message != '\0' )
			puts( message );
}
/*		EOF		*/
