/*

+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
*
*               Program..: DBDIR.c   Version 8
*               Author...: Vernon E. Davis
*               Date.....: 12/21/86
*               Notes....: a utility for DOS to display
*                          database file information like dBASE.
*
*               Compiled with Turbo C  v2.0
*
*               References:
*                  Advanced Programmers Guide(dBASE) - Ashton Tate
*                  C Language User's Guide - Weber Systems
*                  Programmer's Guide to the IBM PC - Peter Norton
*
*               dBASE is a registered trademark of Ashton Tate
*               Turbo C is a trademark of Borland International
*
*
*
*  Revision History
*  ~~~~~~~~~~~~~~~~
*  V    Date    Description
*  ~  ~~~~~~~~  ~~~~~~~~~~~
*  1  12/15/86  Preliminary release( Lattice C v3.1 )
*  2  12/21/86  Corrected pointer problem ( *buffer was not reinitialized )
*  3  02/09/87  Added III,III+ distinction; corrected problem in II
*               ( *buffer was not reinitialized )
*  4  08/08/87  Recoded and recompiled under Turbo C v1.0; II info removed
*  5  02/20/88  Recompiled under Turbo C v1.5
*  6  05/04/88  Fixed printf() when memo field is present
*  7  02/04/89  Recompiled under Turbo C v2.0; added IV distinction;
*               added title message; source code included with program.
*  8  04/03/89  Fix to filter DBF type.
*
*
*
+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+

*/

#include <DIR.h>
#include <DOS.h>
#include <FCNTL.h>
#include <STDIO.h>
#include <STDLIB.h>
#include <STRING.h>

   typedef struct
   {  unsigned char dbtype; /* .DBF type (0x03 = .DBF)(0x83 = .DBF + .DBT) */
      char lupy;                                     /* last update - year */
      char lupm;                                    /* last update - month */
      char lupd;                                     /* last update - date */
      unsigned long reccnt;                     /* total number of records */
      unsigned int headlen;                               /* header length */
      unsigned int reclen;    /* record length ( including delete marker ) */
      char reserved[20];                          /* reserved ( not used ) */
   }  headdef;                   /* .... dBASE III header definitions .... */

   /* The field type is contained in the twelfth byte of the field info.   */


void main(void)
{  headdef dirhead,*dhdr=&dirhead;
   struct ffblk ffblk;
   struct dfree dfree;
   int h,i=0,j,filecnt=0,fh,fldcnt;
   long sizecnt=0L,diskfree=0L;
   char dbfver[5],*vptr=&dbfver[0],ismemo[4],*iptr=&ismemo[0],*mptr,*tptr;

   printf("dBDIR.com  version 8 (04/03/89)  Vernon E. Davis\n");
   if((h=findfirst("*.DBF",&ffblk,FA_ARCH))==-1)
      printf("\nNone\n");
   else
   {  printf("\nDatabase Files    # Records    Last Update     Size  ");
      printf("Memo  RecLen  # Flds  Ver.\n");
      while(!h)
      {  /* *** 1. Attempt to open DBF *** */
         if((fh=open(ffblk.ff_name,O_RDONLY|O_BINARY))==-1)
         {  printf("%-12s  Cannot open\n",ffblk.ff_name);
            h=findnext(&ffblk);
            continue;
         }
         filecnt++;
         sizecnt+=ffblk.ff_fsize;

         /* *** 2. Read the header information *** */
         _read(fh,dhdr,32);
         dhdr->dbtype&=0x83; /* filter DBF type */
         if(dhdr->dbtype!=3&&dhdr->dbtype!=0x83) /* if not .DBF, continue */
         {  close(fh);
            printf("%-12s  Not a database file        %10ld\n",
             ffblk.ff_name,ffblk.ff_fsize);
            h=findnext(&ffblk);
            continue;
         }

         /* *** 3. Determine the field count *** */
         fldcnt=(dhdr->headlen-32)/32;

         /* *** 4. Determine the DBF version and if MEMOs exist *** */
         lseek(fh,dhdr->headlen-1,0);        /* point to end of header - 1 */
         _read(fh,&i,1);
         if(!i)                              /* if zero, force III */
         {  close(fh);
            strcpy(vptr,"III");
         }
         else                                /* ... else */
         {  if(fldcnt<=128)
            {  tptr=mptr=malloc(fldcnt*32);  /* allocate memory: field info */
               if(mptr==NULL)
               {  close(fh);
                  printf("\n... Memory Allocation Error.\n");
                  exit(1);
               }
               lseek(fh,33,0);               /* point to start of field info */
               _read(fh,tptr,fldcnt*32);     /* read field info in memory */
               close(fh);                    /* close database */
               h=0;                          /* flag for III+ */
               for(i=0;i<10;i++) *tptr++;    /* point to first field type */
               for(i=0;i<fldcnt;i++)
               {  if(*tptr=='F')             /* if field type = FLOAT */
                  {  h=1;                    /* flag for IV */
                     break;                  /* exit loop */
                  }
                  for(h=0;h<32;h++) *tptr++; /* else loop to next field type */
                  h=0;                       /* reset flag for III+ */
               }
               free(mptr);                   /* unallocate memory */
            }
            else
            {  close(fh);
               h=1;                          /* force IV */
            }
            !h?strcpy(vptr,"III+"):strcpy(vptr,"IV");
         }
         dhdr->dbtype==0x83?strcpy(iptr,"Yes"):strcpy(iptr," No");

         /* *** 5. Display DBF information *** */
         printf("%-12s    %10ld     %02d/%02d/%02d  %10ld   %s"
          ,ffblk.ff_name,dhdr->reccnt,dhdr->lupm,dhdr->lupd,dhdr->lupy
          ,ffblk.ff_fsize,iptr);
         printf("    %4d     %3d  %s\n",dhdr->reclen,fldcnt,vptr);

         h=findnext(&ffblk);
      }
   }

   /* *** 6. Obtain and display disk bytes free *** */
   printf("\n%10ld bytes in %d files.\n",sizecnt,filecnt);
   getdfree(0,&dfree);
   diskfree=dfree.df_bsec*dfree.df_sclus;
   diskfree*=dfree.df_avail;
   printf("%10ld bytes remaining on drive.\n",diskfree);
   exit(0);
}

