************************************************************************
*                                                                      *
*   DB4API.PRG sample program.                                         *
*                                                                      *
*   Wayne L. Gary      CIS:   71640,3466                               *
*   Tarrant County     Phone: (817) 884-2977                           *
*   Data Servics                                                       *
*   100 E. Weatherford St.                                             *
*   Ft. Worth, TX 76190                                                *
*                                                                      *
*   The following functions are performed:                             *
*                                                                      *
*     1.  A CID# is retrieved as a passed parameter.                   *
*     2.  Connection is made to 3270 PC session "A"                    *
*     3.  A "clear key" is sent to the 3270 session                    *
*     4.  CICS user transaction SH01 is issued to load                 *
*         the image into CICS temp storage.                            *
*     5.  The 3270 buffer is  check for a responce from SH01.          *
*     6.  If the responce is not "YES" the program is terminated.      *
*         NOTE: Photo date is also passed in a "YES" responce.         *
*     7.  A dBASE "RUN" is issued to invoke 3270 PC file transfere     *
*     8.  The 3270 buffer is  check for a responce from IND$.          *
*     9.  If the responce is not "TRANS03" the program is terminated.  *
*     10. Procedure "call_db4api" is at the end of this program        *
*                                                                      *
*     NOTE:  The remainder if the code is an example of T-BASE from    *
*            VIDEOTEX.                                                 *
*            T-BASE is used to display the image on the PC screen.     *
*                                                                      *
************************************************************************
PARAMETERS cid_num
SET TALK OFF
cid_num = UPPER(cid_num)
seq_num = " "

NULL        = CHR(00)
ZERO        = 0
CONNECT     = 1
DISCONNECT  = 2
SENDKEY     = 3
APIWAIT     = 4
STRCPY      = 8

LOAD e:\tbase.tst\db4api.bin

api_func = CONNECT
api_data = "A"
api_leng = LEN(api_data)
api_retc = ZERO
DO call_db4api
IF api_retc <> 0
  ? api_retc
  i = INKEY(0)
ENDIF

api_func = SENDKEY
api_data = "@C"
api_leng = LEN(api_data)
api_retc = ZERO
DO call_db4api
IF api_retc <> 0
  ? api_retc
  i = INKEY(0)
ENDIF

api_func = SENDKEY
api_data = "SH01 " + cid_num + "," + seq_num + "@E"
api_leng = LEN(api_data)
api_retc = ZERO
DO call_db4api
IF api_retc <> 0
  ? api_retc
  i = INKEY(0)
ENDIF

api_func = STRCPY
api_data = "NO   1234567 1234567 01/27/1992"
api_leng = LEN(api_data)
api_retc = 1
DO call_db4api
IF api_retc <> 0
  ? api_retc
  i = INKEY(0)
ENDIF
IF LEFT(api_data,3) <> "YES"
  ? api_data
  ? LEN(api_data)
  i = INKEY(0)
  RETURN
ENDIF

cid_data = cid_num + " - " + SUBSTR(api_data,22,2)
cid_data = cid_data + "-" +  SUBSTR(api_data,25,2)
cid_data = cid_data + "-" +  SUBSTR(api_data,28,4)

rtn_code = RUN ("receive tmug.gif MUGSHOT (binary)")

api_func = STRCPY
api_data = "TRANSXX"
api_leng = LEN(api_data)
api_retc = 1
DO call_db4api
IF api_retc <> 0
  ? api_retc
  i = INKEY(0)
ENDIF
IF LEFT(api_data,7) <> "TRANS03"
  ? api_data
  i = INKEY(0)
ENDIF

RELEASE MODULE db4api

******************** Code for VideoTex T-BASE *************************

rtn_code = RUN ("chromac tmug.gif /o=tmug.pcx /j=tmug.jfl")

LOAD c:\tbase\tb_pcx
LOAD c:\tbase\tb_saygt

pict_info = "/NTMUG.PCX /M19 /B0 /WL60 /WR260 /WT0 /WB188 /SS /PF"
CALL tb_pcx WITH pict_info
IF LEFT(PICT_INFO,2) <> "00"
  ? PICT_INFO
ENDIF

col_val = 20 - (LEN(cid_data)/2)
col_str = LTRIM(STR(col_val))
PICT_INFO = "/M19 /B0 /CB0 /T15 /CT15 /ROW24 /COL" + col_str + " /S" + cid_data
CALL TB_SAYGT WITH PICT_INFO
IF LEFT(PICT_INFO,2) <> "00"
  ? PICT_INFO
ENDIF

PICT_INFO = "/FT  "
CALL TB_PCX WITH PICT_INFO
IF LEFT(PICT_INFO,2) <> "00"
  ? PICT_INFO
ENDIF

RELEASE MODULE tb_saygt
RELEASE MODULE tb_pcx
RELEASE ALL

RETURN

*********************** End of T-BASE Code ***************************

PROCEDURE call_db4api

CALL db4api with api_func, api_data, api_leng, api_retc
IF api_retc <> 0
  RETURN
ENDIF

api_func = APIWAIT
CALL db4api with api_func, api_data, api_leng, api_retc

RETURN
