***********************************************************
*     PROGRAM NAME: JERROR.PRG 
*
*       CONTRACTOR: BOOZ ALLEN HAMILTON (COMSYS sub)
*
*   AUTHOR & PHONE: J. COOPER, x34340
*
* SYSTEM/SUBSYSTEM: MSSINIT
*       ACTIVE DBF: asst,ERROR.DBF
*        CALLED BY: any
*      SUBROUTINES: NONE
*       INPUT FILE: NONE
*      OUTPUT FILE: NONE
*     INPUT MEMORY: NONE
*    OUTPUT MEMORY: NONE
*
*      DESCRIPTION: PROGRAMMER'S ERROR HANDLING ROUTINE.  DISPLAYS
*                   PROGRAM NAME THAT INCURRED UNKNOWN ERRORS
*                   AND HANDLES KNOWN ERRORS.
*
*     REQUIREMENTS: THE FOLLOWING STATEMENTS MUST BE IN EVERY FILE:
*
*  ON ERROR DO jerror WITH "prg name",ERROR(),DBF(),NDX(1),NDX(2),NDX(3),
*     NDX(4),NDX(5),NDX(6),NDX(7)
*
***********************************************************

PARAMETERS prog_name, error_no, db_open, ndx_open1, ndx_open2, ndx_open3, ndx_open4, ndx_open5, ndx_open6, ndx_open7

SET ECHO OFF
WAIT
SET DEVICE TO SCREEN
SET COLOR TO W+/B,W+/R
IF FILE("error.dbf")
   SELECT 9
   USE error
   SET TALK OFF
   APPEND BLANK
   REPLACE program WITH prog_name
   REPLACE errdate WITH DATE()
   REPLACE errtime WITH TIME()
   REPLACE errorno WITH error_no
   REPLACE errmsg WITH MESSAGE()
   REPLACE dbopen WITH db_open
   REPLACE ndxopen1 WITH ndx_open1
   REPLACE ndxopen2 WITH ndx_open2
   REPLACE ndxopen3 WITH ndx_open3
   REPLACE ndxopen4 WITH ndx_open4
   REPLACE ndxopen5 WITH ndx_open5
   REPLACE ndxopen6 WITH ndx_open6
   REPLACE ndxopen7 WITH ndx_open7
   CLOSE DATABASE error
ENDIF
IF prog_name = "            "
    STORE "UNKNOWN ERROR " TO prog_name
ENDIF
* case deleted for programmers version *
IF FILE("SAVEREST.BIN")
   LOAD saverest
   CALL saverest WITH "S"
ENDIF
      @10,4 CLEAR TO 20,74
      @11,5 SAY "Error in Program "
      SET COLOR TO GR+/N
      @11,23 SAY prog_name
      @13,5 SAY DTOC(DATE())
      @13,16 SAY MESSAGE()
      @11,40 SAY LTRIM(STR(error_no))
      @15,22 SAY db_open
      @16,25 SAY ndx_open1
      @16,42 SAY ndx_open2
      @16,59 SAY ndx_open3
      @17,8 SAY ndx_open4
      @17,25 SAY ndx_open5
      @17,42 SAY ndx_open6
      @17,59 SAY ndx_open7
      SET COLOR TO W+/B
      @11,35 SAY "err# "
      @15,5 SAY "Database open:   "
      @16,5 SAY "Indices open:    (1)"
      @16,39 SAY "(2)"
      @16,56 SAY "(3)"
      @17,5  SAY "(4)"
      @17,22 SAY "(5)"
      @17,39 SAY "(6)"
      @17,56 SAY "(7)"
      @19,5 SAY "Press ESC to suspend or Print Screen to print error"
      @10,4 TO 20,74
      STORE 0 TO STOPPER
      WAIT TO STOPPER
      IF FILE("SAVEREST.BIN")
         CALL saverest WITH "R"
         RELEASE MODULE saverest.bin
      ELSE
         @10,4 CLEAR TO 20,74
         @21,0 CLEAR TO 22,29
      ENDIF
      IF STOPPER="J" .OR. STOPPER="j" 
         SUSPEND
      ELSE
         CANCEL
      ENDIF
