SET CONSOLE OFF
CURSOR = SET("CURSOR")
TALK = SET("TALK")
SAFETY = SET("SAFETY")
SET CURSOR OFF
SET SAFETY OFF
PUBLIC mFB, forepad, foregrnd, backpad, backgrnd
DECLARE Colors[8]
colors[1] = "Normal"
colors[2] = "Highlight"
colors[3] = "Messages"
colors[4] = "Titles"
colors[5] = "Box"
colors[6] = "Information"
colors[7] = "Fields"
*-- Get default colors from saved default or system default.
s_Normal = LEFT(SET("ATTRIBUTES"), AT(",", SET("ATTRIBUTES")) - 1)
mAttr = RIGHT(SET("ATTRIBUTES"), LEN(SET("ATTRIBUTES")) - ;
   AT(",", SET("ATTRIBUTES")))
s_Highlight = LEFT(mAttr, AT(",", mAttr) - 1)
mAttr=SUBSTR(mAttr, AT("&", mAttr) + 3, LEN(mAttr))
s_Messages = LEFT(mAttr, AT(",", mAttr) - 1)
mAttr = RIGHT(mAttr, LEN(mAttr) - LEN(s_messages) - 1)
s_Titles = LEFT(mAttr, AT(",", mAttr) - 1)
mAttr = RIGHT(mAttr, LEN(mAttr) - LEN(s_titles) - 1)
s_Box = LEFT(mAttr, AT(",", mAttr) - 1)
mAttr = RIGHT(mAttr, LEN(mAttr) - LEN(s_box) - 1)
s_Information =LEFT(mAttr, AT(",", mAttr) - 1)
s_Fields = RIGHT(mAttr, LEN(mAttr) - LEN(s_information) - 1)
SAVE TO DEFAULT.SET
IF FILE("colors.set")
   RESTORE FROM colors.set ADDITIVE
ENDIF
DEFINE POPUP Attribs FROM 1, 1
X = 1
DO WHILE X <= 7
   *-- Set default colors
   s_Color = s_&colors[x]
   SET COLOR OF &colors[x] TO &s_Color
   *-- Establish reset variables
   r_&colors[x] = "&s_Color"
   *-- Define popup for color item selection
   DEFINE BAR X OF Attribs PROMPT Colors[x] MESSAGE ;
      "Sample Color of Messages"
   X = X + 1
ENDDO
*-- Finish defining popup
DEFINE BAR 8 OF Attribs PROMPT REPLICATE(CHR(205), 15) SKIP
DEFINE BAR 9 OF Attribs PROMPT "Save colors" MESSAGE ;
   "Save the current colors to COLORS.SET"
DEFINE BAR 10 OF Attribs PROMPT "Restore colors" MESSAGE ;
   "Restore the colors you had set when you entered this program"
ON SELECTION POPUP Attribs DO Colors
DO Clr_Reset
ACTIVATE POPUP Attribs
SET CONSOLE ON
RELEASE POPUP Attribs
SET CURSOR &cursor
SET TALK &talk
SET SAFETY &safety
CLEAR
RETURN
*--*
PROCEDURE Colors
SAVE SCREEN TO Attribs
*-- Get the Foreground and Background color for the item selected.
m_Prompt = PROMPT()
DO CASE
CASE BAR() = 0
   RETURN
CASE BAR() >= 1 .AND. BAR() <= 7
   Backgrnd = RIGHT(s_&m_Prompt, LEN(s_&m_Prompt) - ;
      AT("/", s_&m_Prompt))
   Foregrnd = LEFT(s_&m_Prompt, AT("/", s_&m_Prompt) - 1)
CASE BAR() = 9
   SAVE ALL LIKE s_* TO Colors.SET
   DO Clr_Reset
   RETURN
CASE BAR() = 10
   RESTORE FROM DEFAULT.SET ADDITIVE
   X = 1
   DO WHILE X <= 7
      *-- Set default colors
      s_Color = s_&colors[x]
      SET COLOR OF &colors[x] TO &s_Color
      *-- Establish reset variables
      r_&colors[x] = "&s_Color"
      X = X + 1
   ENDDO
   DO Clr_Reset
   RETURN
ENDCASE
*--  Chart of available color options
chart = "   ,N  ,B  ,G  ,GB ,R  ,RB ,RG ,W  ,N+ ,B+ ,G+ ,GB+,R+ ,RB+,RG+,W+ "
*--  Find the row position for the foreground and
*--  background cursors in the on-screen color chart.
Forepad = INT(3 + (AT(Foregrnd, chart) / 4))
Backpad = INT(3 + (AT(Backgrnd, chart) / 4))
*--  Save the current Fore/Background colors for the reset option.
Forereset = Forepad
Backreset = Backpad
*--  Draw on-screen color chart
@ 1, 33 SAY CHR(201) + REPLICATE(CHR(205), 41) + CHR(187) COLOR W+/N
@ 2, 33 SAY CHR(186) + "     Foreground           Background     " + ;
   CHR(186) COLOR W+/N
@ 3, 33 SAY CHR(204) + REPLICATE(CHR(205), 20) + CHR(203) + ;
   REPLICATE(CHR(205), 20) + CHR(185) COLOR W+ /N
ROW = 4
DO WHILE ROW <= 19
   @ ROW, 33 SAY CHR(186) + SPACE(20) + CHR(186) + SPACE(20) + ;
      CHR(186) COLOR W+/N
   ROW = ROW + 1
ENDDO
@ 20, 33 SAY CHR(200) + REPLICATE(CHR(205), 20) + CHR(202) + ;
   REPLICATE(CHR(205), 20) + CHR(188) COLOR W+/N
*--  Fill on-screen color chart with color options
DO RePaint
*--  Cursor control loop for Fore/Background cursors,
*--  attribute selector, reset key, save key & escape.

keytrap = 0
colorset = .T.
@ 2, 39 SAY "Foreground" COLOR N/W
DO WHILE .NOT. STR(keytrap, 3, 0) $ " 27, 13"
   mFB = IIF(colorset, "Fore", "Back")
   DO WHILE .NOT. STR(keytrap, 3, 0) $ " 27, 13"
      keytrap = INKEY(0)
      IF STR(keytrap, 3, 0) $ "  4, 19"
         DO ColChng
         EXIT
      ENDIF
      o_&mFB.pad = &mfb.pad
      IF keytrap = 5
         STORE IIF(&mFB.pad - 1 < 4, IIF(colorset, 19, 11), ;
            &mFB.pad - 1) TO &mFB.pad
      ENDIF
      IF keytrap = 24
         STORE IIF(&mFB.pad + 1 > IIF(colorset, 19, 11), 4, ;
            &mFB.pad + 1) TO &mFB.pad
      ENDIF
      IF STR(keytrap, 3, 0) $ " 18, 26"
         STORE 4 TO &mFB.Pad
      ENDIF
      IF STR(keytrap, 3, 0) $ "  3,  2"
         STORE IIF(colorset, 19, 11) TO &mFB.Pad
      ENDIF
      IF keytrap = 32
         STORE &mFB.reset TO &mFB.Pad
      ENDIF
      @ o_&mFB.Pad, IIF(colorset, 35, 56) SAY " " COLOR N/N
      @ &mFB.Pad, IIF(colorset, 35, 56) SAY CHR(16) COLOR W+/N
      STORE SUBSTR(chart, ((&mFB.Pad - 3) * 4) + 1, 3) TO &mFB.grnd
      DO RePaint
   ENDDO
ENDDO
IF keytrap = 27                && Reset if ESCAPE was pressed.
   Foregrnd = SUBSTR(chart, ((Forereset - 3) * 4) + 1, 3)
   Backgrnd = SUBSTR(chart, ((Backreset - 3) * 4) + 1, 3)
ENDIF
*-- If RETURN was pressed, set item to new
*-- foreground/background colors selected.
s_&m_Prompt = TRIM(Foregrnd) + "/" + TRIM(Backgrnd)
r_&m_Prompt = s_&m_Prompt
tmp_1 = s_&m_Prompt
tmp_2 = "&tmp_1"
SET COLOR OF &m_Prompt TO &tmp_2
*-- Remove on-screen color chart and restore original screen.
RESTORE SCREEN FROM Attribs
RELEASE SCREEN Attribs
DO Clr_Reset
RETURN
*--*
PROCEDURE ColChng
colorset = .NOT. colorset
IF colorset
   @ 2, 60 SAY "Background" COLOR W/N
   @ 2, 39 SAY "Foreground" COLOR N/W
ELSE
   @ 2, 39 SAY "Foreground" COLOR W/N
   @ 2, 60 SAY "Background" COLOR N/W
ENDIF
RETURN
PROCEDURE RePaint
*--  Fills the on-screen color chart with color options.
*--  Foreground colors
@  4, 37 SAY "Black           " COLOR N/&Backgrnd
@  5, 37 SAY "Blue            " COLOR B/&Backgrnd
@  6, 37 SAY "Green           " COLOR G/&Backgrnd
@  7, 37 SAY "Cyan            " COLOR GB/&Backgrnd
@  8, 37 SAY "Red             " COLOR R/&Backgrnd
@  9, 37 SAY "Magenta         " COLOR RB/&Backgrnd
@ 10, 37 SAY "Brown           " COLOR RG/&Backgrnd
@ 11, 37 SAY "White           " COLOR W/&Backgrnd
@ 12, 37 SAY "Gray            " COLOR N+/&Backgrnd
@ 13, 37 SAY "Lt Blue         " COLOR B+/&Backgrnd
@ 14, 37 SAY "Lt Green        " COLOR G+/&Backgrnd
@ 15, 37 SAY "Lt Cyan         " COLOR GB+/&Backgrnd
@ 16, 37 SAY "Lt Read         " COLOR R+/&Backgrnd
@ 17, 37 SAY "Lt Magenta      " COLOR RB+/&Backgrnd
@ 18, 37 SAY "Yellow          " COLOR RG+/&Backgrnd
@ 19, 37 SAY "Brt White       " COLOR W+/&Backgrnd
*-- Background colors
@  4, 58 SAY "Black           " COLOR &Foregrnd/N
@  5, 58 SAY "Blue            " COLOR &Foregrnd/B
@  6, 58 SAY "Green           " COLOR &Foregrnd/G
@  7, 58 SAY "Cyan            " COLOR &Foregrnd/GB
@  8, 58 SAY "Red             " COLOR &Foregrnd/R
@  9, 58 SAY "Magenta         " COLOR &Foregrnd/RB
@ 10, 58 SAY "Brown           " COLOR &Foregrnd/RG
@ 11, 58 SAY "White           " COLOR &Foregrnd/W

*-- Place cursors at initial positions.
@ Forepad, 35 SAY CHR(16) COLOR W+/N
@ Backpad, 56 SAY CHR(16) COLOR W+/N
RETURN
*--*
PROCEDURE Clr_Reset
CLEAR
X = 1
@ 13, 1 FILL TO 21, 31 COLOR N+
DO WHILE X <= 7
   s_Color = s_&colors[x]
   @ X + 13, 2 SAY "Sample : Color of " + colors[x] COLOR &s_Color
   X = X + 1
ENDDO
RETURN
*: EOF: COLORSET.PRG x004
