DO CASE
CASE Dot_1st = "ASCII"
   *-- Displays an ASCII Chart. CHR(7) (BELL) does not show.
   m_DotStat = SET("STATUS")
   SAVE SCREEN TO Dot_Screen
   SET STATUS OFF
   CLEAR
   @ 0, 0 TO 24, 79 DOUBLE
   @ 1, 33 SAY "ASCII Chart"
   m_Ascii = 0
   DO WHILE m_Ascii <= 255
      @ 3 + MOD(m_Ascii, 20), 2 + (6 * INT(m_Ascii / 20)) SAY ;
         RIGHT("000" + LTRIM(STR(m_Ascii)), 3) + " " + ;
         IIF(m_Ascii = 7, "", CHR(m_Ascii))
      m_Ascii = m_Ascii + 1
   ENDDO
   @ 23, 20 SAY "Press Any Key to Continue ... "
   I=INKEY(0)
   SET STATUS &m_DotStat
   RESTORE SCREEN FROM Dot_Screen
   
CASE Dot_1st = "ASSIST"
   *-- User-Defined menu program (ASSIST3) when using RunTime.
   IF "RUNTIME" $ UPPER(VERSION(0))
      IF FILE("Assist3.DBO")
         IF m_Prog = "ASSIST3"
            DO Dot_Release
            PUBLIC m_Prog             && Dot_Release releases m_Prog.
            m_Prog = "ASSIST3"        && Needs to be reset.
            RETURN TO MASTER
         ELSE
            DO Assist3
         ENDIF
      ELSE
         ? "NOT AVAILABLE IN RUNTIME - Download Assist3.ZIP " + ;
            "from the BBS" AT 10
         ?
      ENDIF
   ELSE
      ASSIST
   ENDIF
CASE Dot_1st = "CLS"
   CLEAR
   
CASE Dot_1st = "COLOR"
   *-- Displays a color chart (Foreground and background colors).
   DO colors
   
CASE Dot_1st = "HELP"
   *-- User-defined HELP screen.
   SAVE SCREEN TO Dot_Screen
   CLEAR
   @  0,  0 TO 21, 79 DOUBLE
   @  1, 30 SAY "Added Commands"
   @  3,  3 SAY "ASCII - Display an ASCII chart"
   @  5,  3 SAY "ASSIST - Execute Assist3 program (if available)"
   @  7,  3 SAY "COLORS - Display a color chart"
   @  9,  3 SAY "HELP - This Screen "
   @ 11,  3 SAY "POP [on / OFF] - Command history is " + ;
      "displayed in a POPUP / on command line "
   @ 13,  3 SAY "SETCOLOR - Set colors for the program (if available)"
   @ 15,  3 SAY "SHIFT - Move Dot UP/DOWN n rows " + ;
      "(SHIFT 3 / SHIFT -1) "
   @ 17,  3 SAY "WHO - Displays Creator info"
   @ 20, 24 SAY " Press Any Key to Continue ... "
   I=INKEY(0)
   RESTORE SCREEN FROM Dot_Screen
   RELEASE SCREEN Dot_Screen
   
CASE "MODIFY" = Dot_1st
   mtmp_1 = UPPER(LTRIM(Dot_Rest))
   mtmp_2 = IIF(AT(" ", mtmp_1) = 0, mtmp_1, ;
      LEFT(mtmp_1, AT(" ", mtmp_1) - 1))
   mtmp_3 = IIF(AT(" ", mtmp_1) = 0, "", ;
      SUBSTR(mtmp_1, AT(" ", mtmp_1) + 1, LEN(mtmp_1)))
   DO CASE
      ***1***        CASE "STRUCTURE" = mtmp_2
      ***1***            DO CREASTRU WITH .F.
   CASE "COMMAND" = mtmp_2
      IF "" <> Dot_Edit
         RUN &Dot_Edit &mtmp_3
      ENDIF
   ENDCASE
   
CASE Dot_1st = "POP"
   *-- Display command line history in a POPUP or on the command line.
   Dot_Pop = (UPPER(Dot_Rest) = "ON")
   
CASE Dot_1st = "SETCOLOR"
   *-- Allows user to set new colors (Foreground and background).
   IF FILE("setcolor.dbo")
      DO SETCOLOR
      DO SET_COLOR      && DOT.DBO procedure
   ENDIF
   
CASE Dot_1st = "SHIFT"
   *-- Shift the prompt up / down n lines.
   IF VAL(Dot_Rest) <= 0
      Dot_Row = MAX(0, Dot_Row + VAL(Dot_Rest))
   ELSE
      Dot_Row = MIN(IIF("43" $ SET("DISPLAY"), 42, 24), ;
         Dot_Row + VAL(Dot_Rest))
   ENDIF
   
ENDCASE
RETURN
*--*
PROCEDURE Colors
*-- By Steve Koterski - modified by Adam L. Menkes
*-- Routine to display the full array of 16
*-- Fore-ground and 8 back-ground colors
mNorm = LEFT(SET("ATTRIBUTES"), AT(",", SET("ATTRIBUTES")) - 1)
mStat = SET("STATUS")
mClock = SET("CLOCK")
SET STATUS OFF
SET SCOREBOARD OFF
SET COLOR OF NORMAL TO W+/N
SET CURSOR OFF
CLEAR
STORE " COLOR " TO mvar
STORE 1 TO ct1, ct2
STORE 11 TO MCOL
@  2, 2 SAY "FORE-"  COLOR R+
@  3, 2 SAY "GROUND" COLOR R+
@  4, 2 SAY "Black"
@  5, 2 SAY "Blue"
@  6, 2 SAY "Green"
@  7, 2 SAY "Cyan"
@  8, 2 SAY "Red"
@  9, 2 SAY "Magenta"
@ 10, 2 SAY "Brown"
@ 11, 2 SAY "White"
@ 12, 2 SAY "Gray"
@ 13, 2 SAY "Blue   +"
@ 14, 2 SAY "Green  +"
@ 15, 2 SAY "Cyan   +"
@ 16, 2 SAY "Red    +"
@ 17, 2 SAY "Purple +"
@ 18, 2 SAY "Yellow +"
@ 19, 2 SAY "White  +"
@ 20, 9 SAY "+ indicates BRIGHT" COLOR R+
@ 1, 30 SAY "BACKGROUND" COLOR R+
@ 3, 12 SAY "Black"
@ 3, 19 SAY "Blue"
@ 3, 26 SAY "Green"
@ 3, 33 SAY "Cyan"
@ 3, 41 SAY "Red"
@ 3, 46 SAY "Magenta"
@ 3, 54 SAY "Brown"
@ 3, 61 SAY "Gray"
DECLARE colors[8]
colors[1] = "n"
colors[2] = "b"
colors[3] = "g"
colors[4] = "bg"
colors[5] = "r"
colors[6] = "rb"
colors[7] = "gr"
colors[8] = "w"
DO WHILE ct1 <= 8
   DO WHILE ct2 <= 16
      BR = IIF(ct2 > 8,"+", "")
      mColor = colors[IIF(ct2 > 8, ct2 - 8, ct2)] + ;
         BR + "/" + colors[ct1]
      @ ct2 + 3, MCOL SAY mVar COLOR &mColor
      ct2 = ct2 + 1
   ENDDO
   MCOL = MCOL + 7
   ct2 = 1
   ct1 = ct1 + 1
ENDDO
@ 20, 1 SAY ""
SET COLOR OF NORMAL TO W+/N
@ 21, 20 SAY " Press any key to continue ... "
I = INKEY(0)
SET STATUS &mStat
SET COLOR &mClock
SET COLOR OF NORMAL TO &mNorm
SET CURSOR ON
CLEAR
RETURN
*-- X003
