/* Checkdbf.c Copyright Mark Egan 1990,1991.  All rights reserved. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <errno.h>
#include <io.h>

#define RECCOUNT  2048
#define FIELDSIZE 256
#define FALSE     0
#define TRUE      1

int Hardware_Error_Handler(void);
char filedate(char *fname);
int chkfield(char *str,int,char,int,int);

typedef  struct {
       char              field_name[11];
       char              field_type;
       unsigned long int field_addr;
       char              field_len;
       char              field_dec;
       char              reserved_net_a[2];
       char              wrk_area_id;
       char              reserved_net_b[2];
       char              set_fields;
       char              reserved[8];
} DBFFIELDS;

    char               dbf_date[7],dos_date[7];

    char               INPUTFILE[MAXPATH];

    FILE              *fp;
    FILE              *fp_err;

    unsigned long      rec_no;
    unsigned int       field_no;

int main(int argc, char *argv[])
{
    int                no_fields, pos_count;
    int                mem_size;
    int                see_err  = FALSE;
    int                i;
    char               record[RECCOUNT];
    struct             ffblk ffblk;

    struct {
       char              type;
       char              updt_yy;
       char              updt_mm;
       char              updt_dd;
       unsigned long int no_rec;
       unsigned int      no_head_bytes;
       unsigned int      no_rec_bytes;
       char              reserved_1[3];
       char              reserved_net[13];
       char              reserved_2[4];
    }  dbf_header;

    DBFFIELDS     *dbf_fields, *field;

    harderr(Hardware_Error_Handler);    /* Establish hardware error handler. */
    clrscr();

    INPUTFILE[0] = NULL;
    if (argc > 1)
       strcpy(INPUTFILE, argv[1]);
    while (INPUTFILE[0] == NULL) {
       printf("Input filename? ");
       gets(INPUTFILE);
    }

    if ((fp_err = fopen("checkdbf.err", "w")) == NULL) {
       printf("OPEN ERROR checkdbf.err errno %d\n", errno);
       exit(1);
    }
    else
        setvbuf(fp_err, NULL, _IOFBF, 16384);

    if ((fp = fopen(INPUTFILE, "rb")) == NULL)  {
       printf("OPEN ERROR %s errno %d\n",INPUTFILE, errno);
       fprintf(fp_err,"OPEN ERROR %s errno %d\n",INPUTFILE, errno);
       see_err = TRUE;
       exit(1);
    }
    else
         setvbuf(fp, NULL, _IOFBF, 16384);


    if (fread(&dbf_header,sizeof(dbf_header),1,fp) != 1)  {
       printf("ERROR %s Header File.\n",INPUTFILE);
       exit(1);
    }
    else  {
       sprintf(dbf_date,"%02d%02d%02d",dbf_header.updt_mm,dbf_header.updt_dd,dbf_header.updt_yy);
       printf("DBF File date = %s\n",dbf_date);
       filedate(INPUTFILE);
       printf("DOS File date = %s\n",dos_date);
       if (strncmp(dbf_date,dos_date,6) != 0) {
          fprintf(fp_err,"dbf_date: %s  dos_date: %s\n",dbf_date,dos_date);
          see_err = TRUE;
       }
       printf("Number of records = %lu\n",dbf_header.no_rec);
       printf("Record size = %u\n",dbf_header.no_rec_bytes);
       findfirst(INPUTFILE,&ffblk,0);
       printf("File size = %u\n",ffblk.ff_fsize);

    }
    mem_size  = dbf_header.no_head_bytes - 32;
    no_fields = mem_size / sizeof(DBFFIELDS);

    if ((dbf_fields = malloc(sizeof(DBFFIELDS)*no_fields)) == NULL) {
       printf("Out of memory!\n");
       exit(1);
    }

    for (i=0; i < no_fields; i++) {
        field = &dbf_fields[i];
        if (fread(field,sizeof(DBFFIELDS),1,fp) != 1) {
           printf("ERROR %s Fields Array\n",INPUTFILE);
           exit(1);
        }
        else  {
           printf("%s", field->field_name);
           printf(" %c", field->field_type);
           printf(" %u", field->field_len);
           printf(" %u\n", field->field_dec);
        }
    }
    if (fgetc(fp) != 13)  {
       printf("Unable to find end of header\n");
       exit(1);
    }
    /* fgetc(fp); */
 /******************* START READING RECORDS ********************/
    for (rec_no=0; rec_no < dbf_header.no_rec; rec_no++) {
      if ((rec_no & 0xFFFFFFF0UL) == rec_no) {
         clreol();
         printf("Record %lu\r", (rec_no+1));
      }

      if (fread(record,dbf_header.no_rec_bytes,1,fp) != 1) {
          fprintf(fp_err,"Error at record no. %lu\n",rec_no+1);
          exit(1);
       }
       if (strchr(" *",record[0]) == NULL)  {
          fprintf(fp_err,"Error at record no. %lu DELETE flag\n",rec_no+1);
       }
       pos_count = 0;
       for (field_no=0; field_no < no_fields; field_no++)  {
          if (chkfield(&record[1],pos_count,dbf_fields[field_no].field_type,dbf_fields[field_no].field_len,dbf_fields[field_no].field_dec))
             see_err = TRUE;
          pos_count=pos_count+dbf_fields[field_no].field_len;
       }
    }

    if (see_err)
       printf("\a\n\nError(s) found in %s. See error file for details.\n", INPUTFILE);
    else {
       fprintf(fp_err, "No errors found in %s.\n", INPUTFILE);
       printf("\n\nNo errors found in %s.\n", INPUTFILE);
    }

    fclose(fp_err);
    fclose(fp);

    printf("\nPress any key to continue...");
    getch();
    puts("\n");

    return 0;
}

int chkfield(char *field,int pos,char type,int len,int dec)
{
   char   *ptr, *beg_ptr, *end_ptr, *dec_ptr;
   int    bad_rec;

   bad_rec = FALSE;

   beg_ptr = field + pos;
   ptr     = beg_ptr;
   end_ptr = ptr + len;

   switch (type)  {
      case 'C':
         for (; ptr < end_ptr; ptr++)  {
            if (!isprint(*ptr))  {
               bad_rec = TRUE;
               break;
            }
         }
         break;
      case 'N':
         for (; *ptr == ' ' && ptr < end_ptr; ptr++);

         if (ptr < end_ptr)  {
            if (*ptr == '-')  ptr++;
            if (dec > 0)  {
               dec_ptr = end_ptr - dec - 1;
               for(; ptr < dec_ptr; ptr++) {
                  if (!isdigit(*ptr)) {
                     bad_rec = TRUE;
                     break;
                  }
               }
               if (*dec_ptr != '.') bad_rec = TRUE;
               for(ptr=dec_ptr+1; ptr < end_ptr; ptr++)  {
                  if (!isdigit(*ptr)) {
                     bad_rec = TRUE;
                     break;
                  }
               }
            }
	 }
	 else  {
            for(; ptr < end_ptr; ptr++)  {
               if (!isdigit(*ptr)) {
		  bad_rec = TRUE;
		  break;
	       }
	    }
	 }
         break;
      case 'L':
         if (strchr(" ?YyNnTtFf",*ptr) == NULL) bad_rec = TRUE;
         break;
      case 'D':
         if (*ptr == ' ')  {
            for (ptr++; *ptr == ' ' && ptr < end_ptr; ptr++);
            if (ptr < end_ptr)
                bad_rec = TRUE;
         }
         else  {
            for (; ptr < end_ptr; ptr++)  {
               if (!isdigit(*ptr))  {
                  bad_rec = TRUE;
                  break;
               }
            }
         }
         break;
      default:
         fprintf(fp_err,"An invalid TYPE was found!!!\n");
         break;
   }
   if (bad_rec) {
      fprintf(fp_err,"Error: Record: %lu Field: %d Type: %c Len: %d Dec: %d Value: %*.*s\n",
                     rec_no+1, field+1, type, len, dec, len, len, beg_ptr);
   }

   return bad_rec;

}


int Hardware_Error_Handler(void)
{
   hardretn(0);
   return 0;
}

char filedate(char *filename)
{
    int    month, day, year;
    struct ffblk ffblk;

    findfirst(filename, &ffblk, 0);
    day   = ffblk.ff_fdate & 0x001F;
    month = (ffblk.ff_fdate >> 5) & 0x000F;
    year  = (ffblk.ff_fdate >> 9) + 80;
    sprintf(dos_date,"%02d%02d%02d\n", month,day,year);
    return 0;
}
