*       ķ
*                                                                
*        08/09/93             dayutils.prg                       
*                       FoxPro Version 2.x Source Code           
*       Ķ
*                                                                
*        Bill Nicholson  70400,3672                              
*                                                                
*        Nicholson Computer Consulting                           
*        996 Glendale Drive                                      
*        Batavia, OH 45103   (513) 752-0540                      
*                                                                
*        Description:  Set up different date formats.            
*       Ķ
*         History:                                               
*          8/09/93  Initial Release                              
*                                                                
*       Ľ
*******************************************************************
* These procedures will keep all the date variables in order      *
*                                                                 *
*                                                                 *
* Variables:                                                      *
*                                                                 *
* c_dow      Text for current day "Saturday", etc                 *
* c_month    Text for current month "January", etc                *
* c_year     Text for year "1991", etc                            *
* c_date     Text for date in "mm/dd/yy" (DATE()) format          *
* c_l_date   Text for date in "Saturday, November 2 1991" format  *
*                                                                 *
*                                                                 *
* i_dow      Numeric for day of week. 1 = Sunday, etc             *
*                                                                 *
* i_month    Numeric for month of year. 1 = January               *
* i_DayOfMon Numeric for day of month. 1...31                     *
* i_year     Numeric for year. 1991, etc                          *
*                                                                 *
*                                                                 *
* This variable will be used to calculate all the above variables *
*                                                                 *
* d_date     Date in date() format                                *
*                                                                 *
*                                                                 *
*******************************************************************
PROCEDURE dayutils

* -----------------------------------------
* Integer values

i_dow = DOW(d_date)

i_DayofMon = DAY(d_date)

i_month = MONTH(d_date)

i_year = YEAR(d_date)

*------------------------------------------
* Character values

c_dow = CDOW(d_date)

c_month = CMONTH(d_date)

c_year = ALLTRIM(STR(i_year))

c_date = DTOC(d_date)

c_l_date = c_dow + ", " + c_month + " " + ALLTRIM(STR(i_DayOfMon)) + " " + c_year

RETURN

