*-- Program...: BARCHART.PRG
*-- Notes.......: Application for the generation of BARCHARTS 

*-- Application initialization code 
mTalk  = SET("TALK")
mEcho = SET("ECHO")
mStat = SET("STATUS")
mDisp = SET("DISPLAY")
SET TALK OFF
SET ECHO OFF
SET BELL TO 25,1
SET STATUS OFF
SET DISPLAY TO EGA43

*--Define application variables -
n          =   12
x          =   12
y          =   31
x1         =    1
y1         =    1
vert_scale = 1550
curr_val   = 1550

grid_top   = CHR(218) + REPLICATE(CHR(194), 70) + CHR(191)
grid_line  = CHR(195) + REPLICATE(CHR(197), 70) + CHR(180)
grid_bttm = CHR(192) + REPLICATE(CHR(193), 70) + CHR(217)

title          = "SAMPLE BAR CHART PROGRAM: FOR THE YEAR 1992"

*-- Chart Legends 
legend      = "legend"
legend1    = "Jan"
legend2    = "Feb"
legend3    = "Mar"
legend4    = "Apr"
legend5    = "May"
legend6    = "Jun"
legend7    = "Jul"
legend8    = "Aug"
legend9    = "Sep"
legend10   = "Oct"
legend11   = "Nov"
legend12   = "Dec"

*-- Sample DATA Set for Chart Demonstration 
DECLARE chart[12,3]

chart[ 1,1]= 1283 
chart[ 2,1]=  769 
chart[ 3,1]=  488 
chart[ 4,1]=  653 
chart[ 5,1]= 1105 
chart[ 6,1]=  931 
chart[ 7,1]= 1483 
chart[ 8,1]= 1322  
chart[ 9,1]=  876 
chart[10,1]= 1027 
chart[11,1]=  598 
chart[12,1]=  947 
chart[ 1,2]=  961 
chart[ 2,2]=  923 
chart[ 3,2]=  879 
chart[ 4,2]=  834 
chart[ 5,2]=  802 
chart[ 6,2]=  764 
chart[ 7,2]=  739 
chart[ 8,2]=  778 
chart[ 9,2]=  838 
chart[10,2]=  881 
chart[11,2]=  947 
chart[12,2]= 1027 
chart[ 1,3]=  293
chart[ 2,3]=  341
chart[ 3,3]=  406
chart[ 4,3]=  482
chart[ 5,3]=  589
chart[ 6,3]=  705
chart[ 7,3]=  847
chart[ 8,3]= 1018
chart[ 9,3]= 1193
chart[10,3]=  973
chart[11,3]=  718
chart[12,3]=  492
		 
*-- @ SAY; Screen generation processing. 
CLEAR
*-- Drawing the grid 
@  2,40 - (LEN(title)  /2) SAY title COLOR RG+/R
@  3,41 - (LEN(title) / 2) FILL TO 3, 40 + (LEN(title) / 2) COLOR B/N

@  5, 5 SAY grid_top
gline = 6
DO WHILE gline < 36	&& Draw the body of the grid.
  @ gline, 5 SAY grid_line
  gline = gline + 1
ENDDO

@ 36, 5 SAY grid_bttm 
@  6, 2 FILL TO 37, 78 COLOR B/N
@  5, 5 FILL TO 36, 77 COLOR W+/BG

*-- Draw the legend 
gline = 6
high_val = 1500
DO WHILE gline < 37
  @ gline, 1 SAY 
  @ 6, 1 SAY STR(high_val,4)
  gline = gline + 2
  high_val = high-val - 100
ENDDO
@  5, 1 FILL TO 36,   4 COLOR RG+/RB

*-- Legend Display processing 
DO WHILE n >= 1

  legend = "legend" + LTRIM(STR(n, 2))
  @ 39, (6*n)-1 SAY &legend 
  n = n - 1

ENDDO

@ 39,  5 FILL TO 39, 77 COLOR W+/G
@ 40,  6 FILL TO 40, 78 COLOR B/N

*-- Data Set Display Processing 

n = 1

*-- Color selection for specific data sets 

DO WHILE n <= 3

	DO CASE 
		 CASE n = 1
			bar_clr = "R/BG"
			offset = -1
			shadow = 2

		CASE n = 2
			bar_clr = "B+/BG"
			offset = 0
			shadow = 3

		CASE n = 3
			bar_clr = "RG+/BG"
			offset = 1
			shadow = 4

	ENDCASE
	y1 = 31
	*-- Y Axis Scan Loop 
	DO WHILE y1 > 0
		x1 = 1
 
		curr_val = (vert_scale / y) * (y - y1)

		* -- X	Axis Scan Loop ------------------------------
		DO WHILE x1 <= 12
			DO CASE
				CASE curr_val <= chart[x1, n]- 25 .AND. ;
					curr_val > chart[x1, n] - 50
					@ y1 + 5,(x1 * 6) + offset SAY ;
					REPLICATE(CHR(219), 3) COLOR &bar_clr
					IF y1 + 5 <= 35
						@ y1 + 6, (x1 * 6) + shadow ;
						FILL TO y1 + 6, (x1 * 6) + shadow COLOR W/B
					ENDIF

				CASE curr_val <= chart[x1, n] - 50
					@ y1 + 5,(x1 * 6) + offset SAY ;
					REPLICATE(CHR(219), 3) COLOR &bar_clr
					IF y1 + 5 <= 35
						@ y1 + 6, (x1 * 6) + shadow ;
						FILL TO y1 + 6, (x1 * 6) + shadow COLOR W/B
					ENDIF
			ENDCASE
			x1 = x1 + 1
		ENDDO
		y1 = y1 - 1
	 ENDDO
	 n = n + 1
ENDDO

*-- Barchart exit code 
@ 41, 0
WAIT "     PRESS ANY KEY TO CONTINUE..."
CLEAR
SET TALK &mTalk
SET STATUS &mStatus
SET ECHO &mEcho
SET DISPLAY TO &mDisp
RELEASE ALL
RETURN

