* valdate.prg
* Validates date fields based on DD/MM/YY format
PARAMETER passdate
pvaldate=0
MonthName=''
IF !EMPTY(pvaldate)
* Make sure date is string (or else BOOM!)
	InputDays=VAL(SUBSTR(DTOC(passdate),4,2))
	MonthNum =VAL(SUBSTR(DTOC(passdate),1,2))
	InputYear=VAL(SUBSTR(DTOC(passdate),7,2))
	Today=DATE()
		
	DO CASE
		*Determine name of month 	
		CASE MonthNum=1
			MonthName='January' 
		CASE MonthNum=2
			MonthName='February' 
		CASE MonthNum=3
			MonthName='March' 
		CASE MonthNum=4
			MonthName='April' 
		CASE MonthNum=5
			MonthName='May' 
		CASE MonthNum=6
			MonthName='June' 
		CASE MonthNum=7
			MonthName='July' 
		CASE MonthNum=8
			MonthName='August' 
		CASE MonthNum=9
			MonthName='September' 
		CASE MonthNum=10
			MonthName='October' 
		CASE MonthNum=11
			MonthName='November' 
		CASE MonthNum=12
			MonthName='December' 
	ENDCASE

	DO CASE
	****> Valid Length
*		CASE LEN(passdate)<8
*			WAIT WINDOW "Date must be 8 digits long in the form DD/MM/YY"
	****> Compare to today
		CASE passdate > Today
			WAIT WINDOW "That date is in the future (according to computer's date)."
	****> Valid Month
		CASE MonthNum<1 OR MonthNum>12
			WAIT WINDOW "Month must be between 1 and 12"
	****> Valid Day
		*Thirty days hath September, April, June and November...
		CASE INLIST(MonthNum,9,4,6,11) AND (InputDays<1 OR InputDays>30)
			WAIT WINDOW "Sorry. "+MonthName+" has between 1 and 30 days"
		*All the rest have thirty-one except...
		CASE INLIST(MonthNum,1,3,5,7,8,10,12) AND (InputDays<1 OR InputDays>31)
			WAIT WINDOW "Sorry. "+MonthName+" has between 1 and 31 days"
		*February, which has twenty-eight...
		CASE MonthNum=2 AND NOT MOD(InputYear,4)=0 AND (InputDays<1 OR InputDays>28)
			WAIT WINDOW "Sorry. February has between 1 and 28 days for this non-leap year" 
		*and twenty-nine in a leap year
		CASE MonthNum=2 AND MOD(InputYear,4)=0 AND (InputDays<1 OR InputDays>29)
			WAIT WINDOW "Sorry. February has between 1 and 29 days for this leap year"
		OTHERWISE
			pvaldate=.T.
	ENDCASE
ELSE
	pvaldate=.T. &&Users don't need to enter a value
ENDIF
RETURN pvaldate
* eof valdate.prg