/*
	This program will determine whether or not an XMS driver is
	installed, and will return several statistics about it if
	a driver is found.

    It will also test most of the XMSLIB routines.

    USE AT YOUR OWN RISK
*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "xmslib.h"


int main()
{
    unsigned char error;    /* error code returned be most routines */
    unsigned int freemem, totmem;   /* memory stats */
    unsigned int ver_proto, ver_driver, hma_avail;  /* version stats */
    unsigned int state; /* state of the A20 line. */
    unsigned int handle;    /* EMB handle allocated */
    void far *address;  /* pointer to EMB.  Note:  this is a 32bit linear    */
                        /* address, so it cannot be used directly.           */
    unsigned char locks, fhandles;  /* locks on the handle, and handles free */
    unsigned int blength;   /* size of the block (for info request) */
    unsigned int maxumb, segaddr;   /* for UMB request.  (not on MY machine!) */
    char    message[30]  = "This be a test.";   /* for extended mem move    */
    char    message2[30] = "xxxxxxxxxxxxxxx";   /*  "     "      "   "      */

    struct EMMMoveStruct moverec; /* also for extended memory move          */

    if(!XMS_Setup()) {  /* must be called before using any other XMS function */
        printf("There seems to be no XMS driver installed!\n");
        exit(1);
    }
    XMS_Version(&ver_proto, &ver_driver, &hma_avail);
    printf("XMS Status:  Protocol version: %x  Internal version: %x  HMA avail: %s\n",
                ver_proto, ver_driver, hma_avail ? "Yes" : "No");
    if(ver_proto!=0x0200) {
        printf("Protocol version is NOT 2.00, so I'm gonna FREAK!\n");
        exit(1);
    }
    XMS_FreeMem(&freemem,&totmem);  /* query free XMS memory */
    printf("XMS Status:  %dk total, %dk total\n", totmem, freemem);
    printf("Allocate HMA: %x\n",XMS_RequestHMA(0xffff));
    printf("Release HMA: %x\n",XMS_ReleaseHMA());
    printf("GlobalDisableA20: %x :",XMS_GlobalDisableA20());

    XMS_QueryA20(&state);
    printf("A20 state: %s\n",state ? "Enabled" : "Disabled");
    printf("LocalEnableA20: %x :",XMS_LocalEnableA20());

    XMS_QueryA20(&state);
    printf("A20 state: %s\n",state ? "Enabled" : "Disabled");
    printf("LocalDisableA20: %x :",XMS_LocalDisableA20());

    XMS_QueryA20(&state);
    printf("A20 state: %s\n",state ? "Enabled" : "Disabled");

    error = XMS_AllocEMB(10,&handle); /* allocate 10k of memory */
    printf("AllocEMB: %x   handle: %x\n",error, handle);

/* next, copy our little message to extended memory */
    moverec.Length = sizeof(message);
    moverec.SourceHandle = 0;   /* handle of 0 means direct memory */
    moverec.SourceOffset = (unsigned long)message;
    moverec.DestHandle = handle;    /* our EMB handle */
    moverec.DestOffset=0;   /* copy to the front of the block */
    error = XMS_MoveEMB(&moverec);
    printf("MoveEMB: %x\n",error);
    printf("String 1: %s\nString 2: %s\n",message, message2);

    moverec.Length = sizeof(message);   /* now, move it to the second string */
    moverec.DestHandle = 0;
    moverec.DestOffset = (unsigned long)message2;
    moverec.SourceHandle = handle;
    moverec.SourceOffset=0;
    error = XMS_MoveEMB(&moverec);
    printf("MoveEMB: %x\n",error);
    printf("String 1: %s\nString 2: %s\n",message, message2);

    error = XMS_LockEMB(handle, &address);
    printf("Handle %x located at linear memory address %p\n",handle, address);
    printf("Lock returned error %x\n",error);

    error = XMS_ReallocEMB(handle, 20); /* reallocate as 20k instead of 10 */
    printf("ReallocEMB: %x\n",error);   /* THIS SHOULD FAIL BECAUSE OF LOCK */

    error = XMS_GetEMBHandleInfo(handle, &locks, &fhandles, &blength);
    printf("Info on handle %x: Locks: %d Free handles: %d Block length: %d\n",
        handle, locks, fhandles, blength);

    error = XMS_UnlockEMB(handle);
    printf("Unlock returned error %x\n",error);

    error = XMS_ReallocEMB(handle, 20); /* reallocate as 20k instead of 10 */
    printf("ReallocEMB: %x\n",error);

    error = XMS_GetEMBHandleInfo(handle, &locks, &fhandles, &blength);
    printf("Info on handle %x: Locks: %d Free handles: %d Block length: %d\n",
        handle, locks, fhandles, blength);

    error = XMS_FreeEMB(handle); /* free memory */
    printf("FreeEMB: %x\n",error);

    error = XMS_RequestUMB(0xffff, &segaddr, &maxumb);
    printf("RequestUMB: %x  MaxSize: %d\n",error, maxumb);

    return 0;
}
