/*\t*******************************************************************/
/*    Creation Date .......  Tue  06-22-1993  13:13:06                */
/*    Filename  ...........  wnuutil.cpp                              */
/*    Project .............  Windows Utilities                        */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C++                                      */
/*    Operating System  ...  Windows                                  */
/*    Processor  ..........  WNU - Windows Utilities                  */
/*    Function: Windows utility support functions that aren't         */
/*      tied to existing classes.                                     */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*
   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
**\r*/

/*\i********************************************************************
**                       Module Include Files
***********************************************************************/

/*********************** System Include Files *************************/
#ifndef NOSTRICT
#define STRICT
#endif
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/********************** Constant Include Files ************************/
#include "liidSys.h"

/***************** External Variable Include Files ********************/



/***************** External Procedure Include Files *******************/
#include "wnuutil.h"

/*\i*/

/*\m********************************************************************
**                       Module Declarations
***********************************************************************/

/************************* Module Constants ***************************/

/************************* Module Variables ***************************/

/************************* Module Procedures **************************/

/*\p********************************************************************
**                                                                    **
    NAME:       WNUbusy
    PURPOSE:  to set the standard windows busy cursor
**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

LOCAL HCURSOR wnmOldHc=NULL;

void WNUbusy()
{
/*********** Local Constant & Variable Declarations *******************/
/************************* Procedure Body *****************************/
wnmOldHc = SetCursor( LoadCursor( NULL, IDC_WAIT) );
} /* WNUbusy end */

/*\p********************************************************************
**                                                                    **
    NAME:       WNUdone
    PURPOSE:  to restore previous cursor
**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

void WNUdone()
{
/*********** Local Constant & Variable Declarations *******************/
/************************* Procedure Body *****************************/
if (wnmOldHc)
  {
  SetCursor( wnmOldHc );
  }
} /* WNUdone end */
