/*------------------------------------------------
Listing 7 - Toolbar.C, Main Toolbar routines.
------------------------------------------------*/

#include        <windows.h>
#include        "toolbar.h"
#include        "host.h"

HWND CreateToolBar(HWND hwnd, LONG style){
static  BOOL  bInit=FALSE;
WNDCLASS      class;

  if(!bInit){
    bInit=TRUE;   /*** Only do this once ***/
    class.lpszClassName = "ToolBarClass";
    class.lpfnWndProc = ToolWndProc;
    class.style = NULL;
    class.cbClsExtra = 0;
    class.cbWndExtra = 4;
    class.hInstance = HINST(hwnd);
    class.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    class.hCursor = LoadCursor(NULL, IDC_ARROW);
    class.hbrBackground= GetStockObject(LTGRAY_BRUSH);
    class.lpszMenuName = NULL;
    RegisterClass(&class);

    class.lpszClassName = "ToolBarButtonClass";
    class.lpfnWndProc = ButtonProc;
    class.cbWndExtra = 2;
    class.hIcon = NULL;
    RegisterClass(&class);
  }
return(CreateWindow("ToolBarClass", "Tools", style,
      0, 0, 200, 100,
      hwnd, NULL, HINST(hwnd), NULL));
}

/*------------ Main Toolbar Procedure -------------*/
long FAR PASCAL ToolWndProc(HWND hwnd, UINT message,
                    WPARAM wParam, LPARAM lParam){
TB_DATA *button;
int             i;

switch (message){

  case TBM_INITIALIZE:
    SetWindowWord(hwnd,TB_PTR,(WORD)(TB_DATA *)wParam);
    SetWindowWord(hwnd,TB_COUNT, (WORD)lParam);
    CreateTB_Btns(hwnd,(TB_DATA *)wParam,(int)lParam);
    return 0;

  case TBM_GETSTATE:
    button=(TB_DATA *)GetWindowWord(hwnd, TB_PTR);
    i=(WORD)GetWindowWord(hwnd, TB_COUNT);
    while(i--)
      if(button[i].msg_id == wParam)
        return (long) button[wParam].state;
    return 0;

  case TBM_SETMYMENU:
    button=(TB_DATA *)GetWindowWord(hwnd, TB_PTR);
    i=(WORD) GetWindowWord(hwnd, TB_COUNT);
    while(i--)
      if(button[i].state == TBPOS_PUSH)
        CheckMenuItem(wParam, button[i].msg_id, 
                      MF_CHECKED);
      else
        CheckMenuItem(wParam, button[i].msg_id, 
                      MF_UNCHECKED);
    return 0;

  case TBM_MENUPICKED:
    button=(TB_DATA *)GetWindowWord(hwnd, TB_PTR);
    i=(WORD)GetWindowWord(hwnd, TB_COUNT);

    while(i--){
      if(button[i].msg_id == wParam){
        if(button[i].style == TBS_PUSH)
          return 1;
        if(button[i].style == TBS_RADIO)
           return SendMessage(hwnd, TBM_SETSTATE, 
                  wParam, (long)TBPOS_PUSH);
        if(button[i].style == TBS_TOGGLE){
          if(button[i].state == TBPOS_PUSH)
            SendMessage(hwnd, TBM_SETSTATE, wParam,
                       (long) TBPOS_NORM);
          else if(button[i].state == TBPOS_NORM)
            SendMessage(hwnd, TBM_SETSTATE, wParam,
                       (long) TBPOS_PUSH);
        return 1;
        }     /* If it is a toggle button style   */
      }       /* Correct button (msg_id==wParam)  */
    }         /* while(i--) loop thru all buttons */
    return 0;

  case TBM_SETSTATE:
    button=(TB_DATA *)GetWindowWord(hwnd, TB_PTR);
    i=(WORD) GetWindowWord(hwnd, TB_COUNT);

    while(i--){
      if(button[i].msg_id == wParam){
        button[i].state=(WORD)lParam;
        REDRAW(button[i].hwnd);
      if(button[i].style == TBS_RADIO)
        PopRadioBtns(hwnd, &button[i]);
      return TRUE;
      }
    }
    return FALSE;

  case WM_SHOWWINDOW:
    if(GetWindowLong(hwnd, GWL_STYLE) & WS_CAPTION){
      SetWindowPos(hwnd, 0, 0, 0,
      GetProp(hwnd,"WIDE"), GetProp(hwnd,"TALL"),
       SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);
    }
    break;

  case WM_DESTROY:
    if(GetProp(hwnd,"NOTIFY"))
      SendMessage(RemoveProp(hwnd,"NOTIFY"),
          TBM_DESTROYED, hwnd, 0L);
    RemoveProp(hwnd,"TALL");
    RemoveProp(hwnd,"WIDE");
    break;
  }
return (DefWindowProc(hwnd, message, wParam, lParam));
}

/* Creates toolbar buttons from TB_DATA struct */
void CreateTB_Btns(HWND hwnd, TB_DATA *button, 
                   int count){
HWND    hButton;
BITMAP  bm;
HBITMAP hBitmap;
int     i, xpos, ypos, widest, tallest;

  widest=tallest=xpos=ypos=0;

  for(i=0; i<count; i++){
    if(button[i].style == TBS_ESCAPE){
      if(button[i].msg_id == TB_MOVE){
         xpos+=button[i].state;
         ypos+=button[i].group;
      }
      else if(button[i].msg_id == TB_NEXT_ROW){
        xpos=0;
        ypos=tallest;
      }
      continue;
    }
    hBitmap=LoadBitmap(HINST(hwnd),button[i].bmNorm);
    GetObject(hBitmap, sizeof(BITMAP),&bm);
    DeleteObject(hBitmap);

    hButton=CreateWindow(
      "ToolBarButtonClass",NULL,WS_VISIBLE|WS_CHILD,
      xpos,ypos, bm.bmWidth, bm.bmHeight,
      hwnd, NULL, HINST(hwnd), NULL);

    SetWindowWord(hButton, 0, (WORD) &button[i]);
    button[i].hwnd=hButton;
    xpos+=bm.bmWidth;
    widest=max(xpos, widest);
    tallest=max(ypos+bm.bmHeight,, tallest);
  }

  if(!GetProp(hwnd,"TALL")){
    tallest+=GetSystemMetrics(SM_CYMENU);
    tallest+=3*GetSystemMetrics(SM_CYBORDER);
    SetProp(hwnd,"TALL",tallest);
  }
  if(!GetProp(hwnd,"WIDE")){
    widest+=2*GetSystemMetrics(SM_CXBORDER);
    SetProp(hwnd,"WIDE", widest);
  }
}
