// ==============================================
//  Listing 1 - barcode.c Barcode DLL source code
// ==============================================

#define STRICT
#define WINVER  0x0300

#include <windows.h>
#include <string.h>
#include "barcode.h"

#define TABLESIZE 44

struct
    {
    char   c;
    BY  bar;
    BY  space;
    }
bc [TABLESIZE] = {{'1', 17, 4},   // 10001 0100
                  {'2',  9, 4},   // 01001 0100
                  {'3', 24, 4},   // 11000 0100
                  {'4',  5, 4},   // 00101 0100
                  {'5', 20, 4},   // 10100 0100
                  {'6', 12, 4},   // 01100 0100
                  {'7',  3, 4},   // 00011 0100
                  {'8', 18, 4},   // 10010 0100
                  {'9', 10, 4},   // 01010 0100
                  {'0',  6, 4},   // 00110 0100
                  {'A', 17, 2},   // 10001 0010
                  {'B',  9, 2},   // 01001 0010
                  {'C', 24, 2},   // 11000 0010
                  {'D',  5, 2},   // 00101 0010
                  {'E', 20, 2},   // 10100 0010
                  {'F', 12, 2},   // 01100 0010
                  {'G',  3, 2},   // 00011 0010
                  {'H', 18, 2},   // 10010 0010
                  {'I', 10, 2},   // 01010 0010
                  {'J',  6, 2},   // 00110 0010
                  {'K', 17, 1},   // 10001 0001
                  {'L',  9, 1},   // 01001 0001
                  {'M', 24, 1},   // 11000 0001
                  {'N',  5, 1},   // 00101 0001
                  {'O', 20, 1},   // 10100 0001
                  {'P', 12, 1},   // 01100 0001
                  {'Q',  3, 1},   // 00011 0001
                  {'R', 18, 1},   // 10010 0001
                  {'S', 10, 1},   // 01010 0001
                  {'T',  6, 1},   // 00110 0001
                  {'U', 17, 8},   // 10001 1000
                  {'V',  9, 8},   // 01001 1000
                  {'W', 24, 8},   // 11000 1000
                  {'X',  5, 8},   // 00101 1000
                  {'Y', 20, 8},   // 10100 1000
                  {'Z', 12, 8},   // 01100 1000
                  {'-',  3, 8},   // 00011 1000
                  {'.', 18, 8},   // 10010 1000
                  {' ', 10, 8},   // 01010 1000
                  {'*',  6, 8},   // 00110 1000
                  {'$',  0,14},   // 00000 1110
                  {'/',  0,13},   // 00000 1101
                  {'+',  0,11},   // 00000 1011
                  {'%',  0, 7}};  // 00000 0111

#pragma argsused
BOOL FAR PASCAL LibMain (
    HINSTANCE   hModule,
    WORD        wDataSeg,
    WORD        cbHeapSize,
    LPSTR       lpCmdLine)
// -------------------------
//  Entry point into the DLL
// -------------------------
{
if (cbHeapSize != 0) UnlockData (0);
return (TRUE);
}

BOOL _export BarCode (
        hdc,
        x,
        y,
    int    iWide,
    int     iNarrow,
    int     iHeight,
    LPST    szBarcode)
// ----------------
//  Print a barcode
// ----------------
{
BYTE
    mask [5] = {16, 8, 4, 2, 1};
int
    i,
    j,
    iWidth,
    xPos;
LPSTR
    sz;
char
    szTemp [255];

//  check for too long of a string
if (_fstrlen (szBarcode) > sizeof (szTemp) + 3) return (FALSE);

//  process the string
xPos = x;
wsprintf (szTemp, "*%s*", szBarcode);
sz = (LPSTR) szTemp;
while (*sz)
    {
    // find the character in the lookup table
    for (i=0; i<TABLESIZE; i++)
    {
           if (*sz == bc[i].c)
            {
        // loop through the bars
            for (j=0; j<5; j++)
                {
                // print the bar
                iWidth = (bc[i].bar & mask [j]) ? iWide : iNarrow;
                Rectangle (hdc, xPos, y, xPos + iWidth, y + iHeight);
                xPos += iWidth;
        // always end with a bar
                if (j == 4) break;   
                // move over the space
                xPos += (bc[i].space & mask [j+1]) ? iWide : iNarrow;
                }
            // Print an inter-character gap
            xPos += iNarrow;
            break;
            }
    }
    sz++;
    }
return (TRUE);
}
