#include <stdio.h>
#include <string.h>

#include <windows.h>
#include <commdlg.h>
#include <cderr.h>

#if defined(_MSC_VER)
    #include    <direct.h>
    #define     CHDIR   _chdir
    #define     CHDRIVE _chdrive
    #define     GETCWD  _getcwd
#elif defined(__BORLANDC__)
    #include    <direct.h>
    #define     CHDIR   chdir
    #define     CHDRIVE _chdrive
    #define     GETCWD  getcwd
#endif

#define MAXFILENAME 128


UINT    ClipInitFormat;
HINSTANCE   ModuleHandle;

/* LibMain - store module handle, register clipboard format */

#ifdef __BORLANDC__
    #pragma argsused
#endif        
int CALLBACK LibMain(HINSTANCE ModuleHandle_,
    WORD DataSegment, WORD HeapSize, LPSTR CommandLine)
    {
    if(HeapSize > 0)
        UnlockData(0);
    ModuleHandle    = ModuleHandle_;
    ClipInitFormat  = RegisterClipboardFormat("WinHelpKludge");
    if(ClipInitFormat == 0)
        {
        MessageBox(NULL,
            "[wddjbest.dll]Can't register clipboard format.",
            NULL, MB_OK);
        return 0;
        }
    else
        return 1;
    }

/* WEP - return success */

int CALLBACK WEP(int ExitCode)
    {
    return 1;
    }

/* HookReturn - how to return value from common dialog */

static BOOL    HookReturn(HWND Dialog, UINT Value)
    {
    return PostMessage(Dialog, WM_COMMAND, IDABORT, (LONG)Value);
    }

/* DialogHook() - customize common dialog */

UINT    CALLBACK _export DialogHook(HWND Dialog, UINT Message,
                            WPARAM WordParm, LPARAM LongParm)
    {
    static  char FAR *Buffer;
    switch(Message)
        {
        case    WM_INITDIALOG   :
            {
            OPENFILENAME    FAR *FilePtr;
            FilePtr = (OPENFILENAME FAR *)LongParm;
            Buffer = (char FAR *)FilePtr->lCustData;

            /* disable File Name label */
            EnableWindow(GetDlgItem(Dialog,1090), FALSE);
            /* disable File Name edit control */
            EnableWindow(GetDlgItem(Dialog,1152), FALSE);
            /* disable File Name listbox */
            EnableWindow(GetDlgItem(Dialog,1120), FALSE); /* listbox */
            EnableWindow(GetDlgItem(Dialog,1136), FALSE);
            return FALSE;
            }
        case    WM_COMMAND      :
            switch(WordParm)
                {
                case    IDOK    :
                    {
                    GetDlgItemText(Dialog, 1088, Buffer, MAXFILENAME-1);
                    HookReturn(Dialog, TRUE);
                    }
                }
            return FALSE;
        }
    return FALSE;
    }

/* Beep() - a handy routine for debugging */

void    WINAPI _export Beep()
    {
    MessageBeep(0);
    }

/* SetPath() - Get desired directory from user */

static
char    CurDir[MAXFILENAME];

int WINAPI _export SetPath()
    {
    char            HomeDir[MAXFILENAME];   
    OPENFILENAME    FileInfo;
    OPENFILENAME FAR *FileInfoPtr = &FileInfo;
    char            FileName[MAXFILENAME];
    int             Drive;

    Drive       = _getdrive();
    HomeDir[0]  = Drive-1+'A';
    HomeDir[1]  = ':';
    GETCWD(&HomeDir[2], MAXFILENAME-3); /* remember current dir/drive */
    _fstrcpy(CurDir, "");
    _fstrcpy(FileName, "");
    _fmemset(FileInfoPtr, 0, sizeof(FileInfo));
    FileInfo.lStructSize    = sizeof(FileInfo);
    FileInfo.lCustData      = (LPARAM)(char FAR *)CurDir;
    FileInfo.lpstrFile      = FileName;
    FileInfo.nMaxFile       = MAXFILENAME-1;
    FileInfo.lpfnHook       = DialogHook;
    FileInfo.lpstrTitle     = "Select Directory to Save to";
    FileInfo.lpstrFilter    = "All\0*.*\0\0";
    FileInfo.Flags          = OFN_HIDEREADONLY
                            | OFN_NOTESTFILECREATE
                            | OFN_ENABLEHOOK
                            | OFN_PATHMUSTEXIST;
    CHDRIVE(Drive);     /* restore drive */
    CHDIR(HomeDir+2);   /* restore directory */
    if(GetOpenFileName(&FileInfo))
        return TRUE;
    else
        {
        char    *Cause;
        DWORD   Error = CommDlgExtendedError();
        switch(Error)
            {
            case    CDERR_FINDRESFAILURE    :
                Cause   = "could not find specified resource";
                break;
            case    CDERR_INITIALIZATION    :
                Cause   = "failed during initialization, possibly out of memory";
                break;
            case    CDERR_LOADRESFAILURE    :
                Cause   = "failed to load specified resource";
                break;
            case    CDERR_LOCKRESFAILURE    :
                Cause   = "failed to lock specified resource";
                break;
            case    CDERR_LOADSTRFAILURE    :
                Cause   = "load specified string";
                break;
            case    CDERR_MEMALLOCFAILURE   :
                Cause   = "could not allocate memory for internal structures";
                break;
            case    CDERR_MEMLOCKFAILURE    :
                Cause   = "could not lock allocated memory";
                break;
            case    CDERR_NOHINSTANCE       :
                Cause   = "found ENABLETEMPLATE flag, but no instance handle";
                break;
            case    CDERR_NOHOOK            :
                Cause   = "found ENABLEHOOK flag, but no hook function";
                break;
            case    CDERR_NOTEMPLATE        :
                Cause   = "found ENABLETEMPLATE flag, but no template";
                break;
            case    CDERR_REGISTERMSGFAIL   :
                Cause   = "received error from RegisterWindowMessage()";
                break;
            case    CDERR_STRUCTSIZE        :
                Cause   = "received an invalid lStructSize field";
                break;
            case    CFERR_NOFONTS           :
                Cause   = "no fonts exist";
                break;
            case    CFERR_MAXLESSTHANMIN    :
                Cause   = "size in nSizeMax is less than nSizeMin";
                break;
            case    FNERR_BUFFERTOOSMALL    :
                Cause   = "buffor for filename was too small (lpstrFile)";
                break;
            case    FNERR_INVALIDFILENAME   :
                Cause   = "filename is invalid";
                break;
            case    FNERR_SUBCLASSFAILURE   :
                Cause   = "attempt to subclass listbox failed due to insufficient memory";
                break;
            case    0:  /* No error, just hit cancel button */
                return FALSE;
            default :
                Cause   = "unknown error";
            }
        {
        char    Message[128];
        wsprintf(Message, "Common dialog error occurred because %s.", Cause);
        MessageBox(NULL, Message, "Common Dialog Error", MB_OK);
        }
        return FALSE;
        }
    }


/* SetCaption() - Set caption of current help window */

int     WINAPI _export SetCaption(unsigned long WindowHandle,
            char FAR *Caption)
    {
    HWND    Handle  = (HWND)(WindowHandle&0x0FFFF);

    Handle  = GetParent(Handle);
    if(Handle != (HWND)NULL)
        {
        SetWindowText(Handle, Caption);
        return TRUE;
        }
    else
        return FALSE;
    }

/* HelpYield() - clean clogged WinHelp message queues! */

static  void    HelpYield(BOOL Clipboard)
    {
    MSG     Message;

    while(PeekMessage(&Message, NULL, 0, 0, PM_REMOVE))
        {
        if(Message.message == WM_QUIT)
            {
            PostQuitMessage(0);
            return;
            }
        else
            {
            TranslateMessage(&Message);
            DispatchMessage(&Message);
            }
        if(Clipboard && !IsClipboardFormatAvailable(ClipInitFormat))
            return;
        }
    }

/*
 *  IsSecondary() - return true if in secondary help window.
 *
 *  This function works by checking to see if the class name of the
 *  enclosing window is "MS_WINTOPIC_SECONDARY".
 */
int WINAPI _export IsSecondary(long WinHandle)
    {
    char    ClassName[128];
    HWND    HelpWindow = (HWND)LOWORD(WinHandle);

    if(HelpWindow != NULL)
        {
        HelpWindow  = GetParent(HelpWindow);
        if(HelpWindow != (HWND)NULL)
            if(GetClassName(HelpWindow, ClassName, 127))
                if(!_fstrcmp(ClassName, "MS_WINTOPIC_SECONDARY"))
                    return TRUE;
        }
    return FALSE;
    }


/*
 *  InitClip() - Clear clipboard to dummy format so we'll know when
 *               valid data appears. 
 */

int WINAPI _export InitClip()
    {
    HANDLE  Success = NULL;
    HGLOBAL Dummy = GlobalAlloc(GHND, 1);

    if(Dummy != (HGLOBAL)NULL)
        {
        if(OpenClipboard(NULL))
            {
            EmptyClipboard();
            Success = SetClipboardData(ClipInitFormat, Dummy);
            CloseClipboard();
            }
        if(Success == NULL)
            GlobalFree(Dummy);
        }
    return Success != NULL;
    }

/* Extract() - copy clipboard to desired filename */

int    WINAPI _export Extract(char FAR *FileName)
    {
    HelpYield(FALSE);
    if(IsClipboardFormatAvailable(CF_TEXT))
        {
        if(OpenClipboard((HWND)NULL))
            {
            HANDLE  MemoryHandle;
            MemoryHandle    = GetClipboardData(CF_TEXT);
            if(MemoryHandle)
                {
                char FAR *FileData;

                FileData    = GlobalLock(MemoryHandle);
                if(FileData)
                    {
                    static char Name[128];
                    FILE    *OutputFile;

                    {
                    char FAR *p = Name;
                    while((*p++ = *FileName++) != '\0');
                    }

                    OutputFile  = fopen(Name, "w");

                    if(OutputFile != NULL)
                        {
                        HelpYield(FALSE);
                        while(*FileData)
                            if(*FileData == '\r')
                                ++FileData;
                            else if(*FileData == '\n')
                                fputc('\n', OutputFile), ++FileData;
                            else
                                fputc(*FileData++, OutputFile);
                        fclose(OutputFile);
                        HelpYield(FALSE);
                        }
                    GlobalUnlock(MemoryHandle);
                    }
                }
            CloseClipboard();
            }
        }
    else
        {
        MessageBeep(0);
        MessageBox(NULL, "Clipboard did not contain text!",
            "[wddjbest.dll]", MB_OK);
        }
    return 0;
    }




