// demondx.cpp  		DATABASE INDEX SELECTOR DIALOG BOX
//	written by Gregory K. Miskin
//	COPYRIGHT (C) 1992.  All Rights Reserved.
//	Gregory K. Miskin, Orem, Utah  USA

#define Uses_TButton
#define Uses_TEvent
#define Uses_TDialog
#define Uses_TRect
#define Uses_TObject
#define Uses_TLabel
#define Uses_TSItem
#define Uses_TCommandSet
#define Uses_TRadioButtons

#include <tv.h>
#include <stdlib.h>
#include <string.h>
#include "commands.hpp"
#include "demondx.hpp"

/*------------------------------------------------------------------------*/
TSelectIndex::TSelectIndex() :
		TDialog(TRect(0, 0, 32, 8), "Select Index"),
		TWindowInit(&TSelectIndex::initFrame)
{
	TView *ToName	= new TRadioButtons(TRect(12,2,30,4),
						  new TSItem("No index",
						  new TSItem("Alphabetical",0)));
	okbutton = new TButton(TRect(9, 5, 21, 7), "~O~K", cmSave, bfNormal);

	insert(ToName);
	insert(new TLabel(TRect(1,2,11,3),  "Use Index:", ToName));
	insert(okbutton);

	options |= ofCentered;
	selectNext(FALSE);
	memset(&fields, 0, sizeof(fields));
	setData(&fields);
}

/*------------------------------------------------------------------------*/
void TSelectIndex::handleEvent(TEvent &event)
{
	 TDialog::handleEvent(event);

	 switch(event.what)
	 {
		case evCommand:
			switch(event.message.command)
			{
				case cmSave:
					getData(&fields);
					GeneralFlag = fields.select;
					event.what = evCommand;
					event.message.command = cmOK;
					event.message.infoWord = 0;
					putEvent(event);
				break;

				default:
					break;
			}
			break;

		case evBroadcast:
			if(event.message.command == cmDefault)
				selectNext(FALSE);
			break;
		default:
			return;
	}
}
