// edit.hpp			BROWSE RECORD EDIT WINDOW
//	written by Gregory K. Miskin
//	COPYRIGHT (C) 1992.  All Rights Reserved.
//	Gregory K. Miskin, Orem, Utah  USA

#ifndef _edit_hpp
#define _edit_hpp

#include <tv.h>
#include "structs.hpp"
#include "formatln.hpp"
#include "d4all.h"

class TEditRecord : public TDialog
{
public:
	CodeBase 	*cBase;
	DataIndex	**name;
	Field			*Fld;
	int delCount;
	int status;
	long baseRec;
	long compRec;

	TEditRecord(DataIndex **i);
	~TEditRecord();
	virtual void handleEvent(TEvent& event);

protected:
	void SetupScreen();
	void Initialize();
	void SaveFile();
	void SaveRecord1();
	void SaveRecord2();
	void Quit();
	void Delete();
	void UnDelete();
	void Delete2();
	void UnDelete2();
	void GetCompareRec();
	void WriteRecord1();
	void WriteRecord2();
	void GetStr(int field_num, char *fld);
	void PutStr(int field_num, char *fld);
	void GetBaseFields();
	void GetCompFields();
	void Cancel(TEvent &event);

	struct
	{
		char  fname    [16];
		char	count		[7];
		char  lname    [16];
		char	recno		[7];
		char  street   [31];
		char  city     [21];
		char  state    [3];
		char  zip      [6];
		char  fname_c	[16];
		char	recno_c	[7];
		char  lname_c	[16];
		char  street_c	[31];
		char  city_c	[21];
		char  state_c	[3];
		char  zip_c		[6];
	} fields;

	TFormatLine *e_count;
	TFormatLine *e_recno;
	TFormatLine *e_fname;
	TFormatLine *e_lname;
	TFormatLine *e_street;
	TFormatLine *e_city;
	TFormatLine *e_state;
	TFormatLine *e_zip;
	TFormatLine *c_recno;
	TFormatLine *c_fname;
	TFormatLine *c_lname;
	TFormatLine *c_street;
	TFormatLine *c_city;
	TFormatLine *c_state;
	TFormatLine *c_zip;

	TButton		*e_save;
	TButton		*e_del1;
	TButton		*e_undel1;
	TButton		*e_del2;
	TButton		*e_undel2;
	TButton		*e_compare;
	TButton		*e_quit;
};
#endif
