#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
struct RGB {char R,G,B;};
struct SVGAInfo
{char           VESASignature[4];   //'VESA'
 unsigned       VESAVersion;        //The higher byte is the major version
                                    // the lower byte is the minor version
 char far *     VendorIDPtr;        //Pointer to vendor ID string
 unsigned long  Capabilities;       //If bit 0 is on, DAC width is switchable,
                                    // otherwise it is fixed  All other bits
                                    // are reserved for future expansion
 unsigned far * VideoModePtr;       //Pointer to list of suppported modes
                                    // terminated by a 0xFFFF
 unsigned       TotalMemory;        //Number of 64kB blocks of memory
                                    // installed on card
 char           x[236];};           //Reserved for future expansion
struct ModeInfo
{unsigned       ModeAttributes;     //If bit 0 is on the mode is supported
                                    //Bit 1 is always on
                                    //If bit 2 is on BIOS supports output
                                    // functions in that mode
                                    //If bit 3 is on it is a color mode
                                    // otherwise it is a monochrome mode
                                    //If bit 4 is on it is a graphics mdoe
                                    // otherwise it is a TEXT mode
                                    //All other bits are reserved
 char           WinAAttributes,     //If bit 0 is on the window is supported
                WinBAttributes;     //If bit 1 is on the window is readable
                                    //If bit 2 is on the window is writeable
                                    //All other bits are reserved
 unsigned       WinGranularity,     //Specifies the granularity in kB of
                                    // the window(s)
                WinSize,            //Specifies the size in kB of the window(s)
                WinASegment,        //Specifies the segment where the window is
                WinBSegment;
 void far *     WinFuncPtr;         //Pointer to the VIDEO memory windowing
                                    // function  The windowing function can be
                                    // directly accessed for faster access or
                                    // it can be accessed by VESA function 05h
                                    // This program uses VESA function 05h
 unsigned       BytesPerScanLine,
                XResolution,
                YResolution;
 char           XCharSize,
                YCharSize,
                NumberOfPlanes,
                BitsPerPixel,       //4=16 colors, 8=256 colors,
                                    // 16=65536 colors, 32=16M
                NumberOfBanks,      //Number of banks in which each row is
                                    // grouped  Most modes do not use banking
                                    // This is set to 1 for nonbanking modes
                MemoryModel,        //The method of storing data in memory
                BankSize,           //Set to 0 for nonbanking modes
                NumberOfImagePages,
                Reserved,
                RedMaskSize,        //If the memory model is direct color
                RedFieldPosition,   // (06h) this data describes the color
                GreenMaskSize,      // fields' position in bits and size
                GreenFieldPosition, // in bits
                BlueMaskSize,       //If it's not direct color this data
                BlueFieldPosition,  // is empty
                ReservedMaskSize,   //The number of unused bits in the field
                DirectColorModeInfo,//If bit 0 is on the color ramp is fixed
                                    // otherwise it is programmable
                                    //If bit 1 is on the unused bits in the
                                    // color fields cannot be altered
                                    // otherwise they are usable
                x[216];};           //Reserved for future expansion

void * VIDEO=MK_FP(0xA000,0x0000);
unsigned * TEXT=(unsigned *)MK_FP(0xB800,0x0000);

void GetSVGAInfo(SVGAInfo *x)
{_AX=0x4F00;
 _ES=FP_SEG(x);
 _DI=FP_OFF(x);
 geninterrupt(0x10);}

void GetModeInfo(unsigned mode,ModeInfo *x)
{_AX=0x4F01;
 _CX=mode;
 _ES=FP_SEG(x);
 _DI=FP_OFF(x);
 geninterrupt(0x10);}

void SetVideoMode(unsigned mode)
{_AX=0x4F02;
 _BX=mode;
 geninterrupt(0x10);}

unsigned GetVideoMode()
{_AX=0x4F03;
 geninterrupt(0x10);
 return(_BX);}

void SetVideoWindow(unsigned window)
{_AX=0x4F05;
 _BX=0x0000;
 _DX=window;
 geninterrupt(0x10);}

unsigned GetVideoWindow()
{_AX=0x4F05;
 _BX=0x0100;
 geninterrupt(0x10);
 return(_DX);}

unsigned GetWidth()  //Only works in VESA modes, not VGA modes
{_AX=0x4f06;
 _BL=0x01;
 geninterrupt(0x10);
 return(_CX);}

void SetPalette(RGB pal[],unsigned num)
{_AX=0x1012;
 _BX=0x0000;
 _CX=num;
 _ES=FP_SEG(pal);
 _DX=FP_OFF(pal);
 geninterrupt(0x10);}

void SetCursor(char state)
{_AH=0x01;
 if (state) _CX=0x0607;
 else _CX=0x2607;
 geninterrupt(0x10);}

void MoveCursor(char x,char y)
{_AH=0x02;
 _BH=0x00;
 _DH=y;
 _DL=x;
 geninterrupt(0x10);}

char GetChar()
{_AH=0x10;
 geninterrupt(0x16);
 return(_AL);}

char GetScan()
{_AH=0x10;
 geninterrupt(0x16);
 return(_AH);}

char KeyHit()
{_AH=0x11;
 geninterrupt(0x16);
 if (_FLAGS&0x40) return(0);
 else return(1);}

void main()
{int x;
 SVGAInfo VesaSVGAInfo;
 ModeInfo VesaModeInfo;
 GetSVGAInfo(&VesaSVGAInfo);
 printf("VESA Information:\n");
 printf(" Signature   :  ");
 for (x=0;x<4;x++) printf("%c",VesaSVGAInfo.VESASignature[x]);
 printf("\n");
 printf(" Version     :  %d.%d\n",VesaSVGAInfo.VESAVersion/0x100,VesaSVGAInfo.VESAVersion%0x100);
 printf(" OEM String  :  ");
 for (x=0;VesaSVGAInfo.VendorIDPtr[x];x++) printf("%c",VesaSVGAInfo.VendorIDPtr[x]);
 printf("\n");
 printf(" Capabilities:  ");
 for (x=0;x<32;x++)
 {if ((VesaSVGAInfo.Capabilities>>x)%2) printf("1");
  else printf("0");}
 printf("\n Modes       :\n");
 for (x=0;VesaSVGAInfo.VideoModePtr[x]!=0xFFFF;x++) printf("%Xh ",VesaSVGAInfo.VideoModePtr[x]);
 printf("\n\nMode Information:\n");
 for (x=0;VesaSVGAInfo.VideoModePtr[x]!=0xFFFF;x++)
 {printf(" %Xh  ",VesaSVGAInfo.VideoModePtr[x]);
  GetModeInfo(VesaSVGAInfo.VideoModePtr[x],&VesaModeInfo);
  printf("%-4d x %4d",VesaModeInfo.XResolution,VesaModeInfo.YResolution);
  if (VesaModeInfo.ModeAttributes&0x0010) printf(" x %d  ",VesaModeInfo.NumberOfPlanes);
  else printf("      ");
  printf("%2d bpp, ",VesaModeInfo.BitsPerPixel);
  printf("%2dx%d char, ",VesaModeInfo.XCharSize,VesaModeInfo.YCharSize);
  if (VesaModeInfo.ModeAttributes&0x0008) printf("Color ");
  else printf("Mono  ");
  if (VesaModeInfo.ModeAttributes&0x0004) printf("with BIOS support");
  printf("\n       ");
  if (VesaModeInfo.BankSize) printf("%2dK x %d banks ",VesaModeInfo.BankSize,VesaModeInfo.NumberOfBanks);
  else printf("NO banks      ");
  if (VesaModeInfo.WinAAttributes&0x01)
  {printf("A:%04X ",VesaModeInfo.WinASegment);
   if (VesaModeInfo.WinAAttributes&0x02) printf("R");
   else printf(" ");
   if (VesaModeInfo.WinAAttributes&0x04) printf("W ");
   else printf("  ");}
  else printf("          ");
  if (VesaModeInfo.WinBAttributes&0x01)
  {printf("B:%X ",VesaModeInfo.WinBSegment);
   if (VesaModeInfo.WinBAttributes&0x02) printf("R");
   else printf(" ");
   if (VesaModeInfo.WinBAttributes&0x04) printf("W");
   else printf(" ");}
  else printf("         ");
  switch (VesaModeInfo.MemoryModel)
  {case 0x00: printf("TEXT");break;
   case 0x01: printf("CGA");break;
   case 0x02: printf("Hercules");break;
   case 0x03: printf("4-plane");break;
   case 0x04: printf("Packed pixel");break;
   case 0x05: printf("Non-chain 4, 256 color");break;
   case 0x06: printf("Direct color");break;
   case 0x07: printf("YUV");break;
   case 0x08: case 0x09: case 0x0A: case 0x0B:
   case 0x0C: case 0x0D: case 0x0E: case 0x0F:
    printf("memory model reserved by VESA");break;
   default:   printf("memory model defined by OEM");}
  printf("\n       ");
  if (VesaModeInfo.ModeAttributes&0x0001) printf("Available      ");
  else printf("Not available  ");
  printf("%4d raster  ",VesaModeInfo.BytesPerScanLine);
  printf("Win: %2dK  ",VesaModeInfo.WinSize);
  printf("WinFunc:  %X:%X\n",FP_SEG(VesaModeInfo.WinFuncPtr),FP_OFF(VesaModeInfo.WinFuncPtr));
  if (VesaModeInfo.MemoryModel==0x06)
  {char y,s[33];
   for (y=0; y<VesaModeInfo.RedMaskSize; y++) s[VesaModeInfo.RedFieldPosition+y]='R';
   for (y=0; y<VesaModeInfo.GreenMaskSize; y++) s[VesaModeInfo.GreenFieldPosition+y]='G';
   for (y=0; y<VesaModeInfo.BlueMaskSize; y++) s[VesaModeInfo.BlueFieldPosition+y]='B';
   for (y=0; y<VesaModeInfo.ReservedMaskSize; y++) s[VesaModeInfo.RedMaskSize
                                                     +VesaModeInfo.GreenMaskSize
                                                     +VesaModeInfo.BlueMaskSize
                                                     +y]='X';
   s[VesaModeInfo.RedMaskSize
     +VesaModeInfo.GreenMaskSize
     +VesaModeInfo.BlueMaskSize
     +VesaModeInfo.ReservedMaskSize]=0;
   printf("       %s\n",s);}}}
