                .MODEL  SMALL,C
                .CODE

;
; int gettype( int * );
; returns the adapter type (1=VGA, 0=other) and number of displayed rows
;

gettype         PROC    USES SI DI, rows:PTR

                mov     ax,40h
                mov     es,ax                   ; ES -> video BIOS data area
                mov     al,es:[84h]             ; ROWS
                xor     ah,ah
                inc     ax
                mov     bx,rows
                mov     [bx],ax                 ; number of displayed rows

; the following function is supported only by the VGA
                mov     ax,1200h
                mov     bl,36h
                int     10h                     ; enable screen refresh
                cmp     al,12h
                xor     ax,ax                   ; assume not VGA
                jne     return                  ; jump if not supported

                mov     ax,500h
                int     10h                     ; select display page 0

; Select the alternate print-screen routine that works properly if the number
; of displayed rows is not 25.
                mov     ah,12h
                mov     bl,20h
                int     10h                     ; select alternate print-screen

                mov     ax,1                    ; is VGA

return:         ret

gettype         ENDP

;
; void loadfont( int );
; Loads the ROM BIOS default 8x8, 8x14, or 8x16 font table into character
; generator RAM.  Only call immediately after a mode set or the results will be
; unpredictable.
;

loadfont        PROC    USES SI DI, font

                mov     ax,font                 ; 18=8x8, 17=8x14, 20=8x16
                mov     ah,11h
                xor     bl,bl                   ; block
                int     10h                     ; load ROM font

                ret

loadfont        ENDP

;
; void setmode( int, int );
; sets the number of scan lines for alphanumeric modes and the video mode
;

setmode         PROC    USES SI DI, lines, video

                mov     ax,lines                ; 0=200, 1=350, 2=400
                mov     ah,12h
                mov     bl,30h
                int     10h                     ; set scan lines

; The selected number of scan lines will not go into effect until the video
; mode is set.
                mov     ax,video                ; AH = 0
                int     10h                     ; set video mode

                ret

setmode         ENDP

                END
