/*
	USER.CPP

	Copyright 1987-1993		Ambrose & Muckerman

	Written by:				Dan Ambrose
							Ambrose & Muckerman
	CIS ID:					71062,523
*/


#define Uses_TApplication
#define Uses_TBackground
#define Uses_TButton
#define Uses_TKeys
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#include <tv.h>

#include "ttywin.h"
#include "debug.h"
#include "user1.h"
#include "eventcmd.h"

#include "px.h"
#include <dos.h>
#include <string.h>
#include <process.h>
#include <dir.h>

const cmNothing   			= 100;  // User selected menu item 'About'
const cmAbout   			= 101;  // User selected menu item 'About'
const cmLogin   			= 102;
const cmUserInfo			= 103;


class User : public TApplication
{
public:
	User();
	~User();
	static TMenuBar *initMenuBar( TRect);
	static TDeskTop *initDeskTop( TRect);
	void handleEvent( TEvent &);
	void AboutDialog();
	void Login();
	void UserInfo();
	void idle();
	int	parseGet ( char *, char *, char *, int, int);
	void parseArg (char *, int);
};


#pragma argsused
int	User::parseGet ( char *dest, char *src, char *arg, int num, int argc)
{
	int sizeA;
	char *off;

	off = strstr ( src, arg );
	if ( off == NULL )
		return ( -1 );

	sizeA = strlen ( arg );
	off = &off[sizeA];
	sizeA = strlen ( off );

	//	If nothing to copy then ret /w success
	if ( num == 0)
		return ( 0 );

	if ( num == -1)
	{
		if ( sizeA == 0)
			return 1;

		strcpy (dest, off );
		return ( 0 );
	}

	// IF too small then error
	if ( sizeA != num)
		return 1;

	strcpy (dest, off );

	return ( 0 );
}

void User::parseArg (char *s, int argc )
{
	int i;
	char upper [128];
	char buf [128];

	i = strlen (s);
	if (i == 0)
	{
		return;
	}

	strcpy (upper, s);
	strupr (upper);

	//	Check foe a help request first
	if (strstr (upper, "/H") != NULL ||
		strstr (upper, "/Help") != NULL ||
		strstr (upper, "?") != NULL )
	{
		return;
	}


	if ( parseGet (buf, upper, "DEBUG", 0, argc ) == 0 )
	{
		debug = True;
		static Boolean isDebugInstalled = False;
		if (isDebugInstalled==False)
		{
			TTYWindow *ttyWin;
			TTerminal *term;
			ttyWin = new TTYWindow(TRect(0,14,80,23),"Debug Info",
				wnNoNumber, term, 2048);
			_dout = new otstream(term);
			deskTop->insert(ttyWin);
			tout << "Ambrose & Muckerman" << endl;
		}
		return;
	}

	if ( parseGet (buf, upper, "NET=", -1, argc ) == 0 )
	{
		tout << "NET=" << buf << endl;
		strcpy(pxNetPath, buf);
		uses_Network = True;
		return;
	}

	if ( parseGet (buf, upper, "WORK=", -1, argc ) == 0 )
	{
		tout << "WORK=" << buf << endl;
		strcpy(pxWorkSpacePath, buf);
		return;
	}

}


User::User() : TProgInit( &TApplication::initStatusLine,
				&User::initMenuBar, &User::initDeskTop )
{
	debug = False;

	for (int i = 1; i < _argc; i++)
		parseArg(_argv [i], i );

	//	set paradox engine workspace to be that of the default directory
	getcwd(pxWorkSpacePath, 63);		// global from PX1.CPP
	tout << pxWorkSpacePath << endl;

	if (pxstart())
		exit(1);
}

User::~User()
{
	pxstop();
}


TMenuBar *User::initMenuBar( TRect r )
{
	r.b.y = r.a.y + 1;
	return new TMenuBar( r,
		*new TSubMenu( "~~", kbAltSpace )+
			*new TMenuItem( "~A~bout", cmAbout, kbAltA, hcNoContext)+
		*new TSubMenu( "~E~xit", kbNoKey)+
			*new TMenuItem( "~Y~es", cmQuit, kbAltX, hcNoContext, "Alt-X" ) +
			*new TMenuItem( "~N~o", cmNothing, kbNoKey) +
		*new TSubMenu( "~U~ser", kbAltU) +
			*new TMenuItem( "User ~I~nfo", cmUserInfo, kbAltI, hcNoContext, "Alt-I" ) +
			*new TMenuItem( "User ~L~ogin", cmLogin, kbAltL, hcNoContext, "Alt-L" )
	);

}

TDeskTop *User::initDeskTop( TRect r )
{
	r.a.y++;
	r.b.y--;
	return new TDeskTop( r );
}

void User::handleEvent (TEvent &event)
{
	// override the handleEvent so we can call the about box
	TApplication::handleEvent( event );
	if( event.what == evCommand )
	{
		switch( event.message.command )
		{
		case cmAbout:
			AboutDialog();
			clearEvent( event );
			break;

		case cmLogin:
			Login();
			break;

		case cmUserInfo:
			UserInfo();
			break;

		}
	}
}

void User::AboutDialog()
{
	TDialog *dlg = new TDialog( TRect(16, 4, 64, 19 ), "About" );
	if (dlg==0)
	{
		return;
	}

	dlg->options = 0x0343;

	TView *control = new TStaticText(TRect(3,3,45,11),
	 "\003USER.EXE  v1.00  04/24/93\n"
	 "\003\n"
	 "\003Turbo Vision and Paradox Engine\n"
	 "\003\n"
	 "\003Multi User Example Program\n"
	 "\003\n"
	 "\003Written by:  Dan Ambrose 71062,523\n"
	 "\003\n"
	 "\003Multi User Example Program");

	 control->options = 0x0300;
	dlg->insert(control);

	control = new TButton(TRect(16,12,32,14),
		"    ~O~k    ", cmCancel, bfNormal);
	control->options = 0x0135;
	dlg->insert(control);

	dlg->selectNext(False);

	deskTop->execView( dlg );

	destroy(dlg);
}

void User::Login()
{
	DLogin *dLogin;
	dLogin = new DLogin;
	deskTop->execView(dLogin);
	destroy(dLogin);
}

void User::UserInfo()
{
	DUserInfoList *userInfo;
	userInfo = new DUserInfoList;
	deskTop->execView(userInfo);
	destroy(userInfo);
}

void User::idle()
{
	//	debounce time down till a seccond has passed

	static struct time tm, ltm;
	gettime(&tm);
	if (ltm.ti_sec == tm.ti_sec)
		return;
	ltm.ti_sec = tm.ti_sec;

	//	We are here once a seccond

	//	If we are running on a network then cause a refresh
	if (uses_Network==True)
		message(TProgram::application, evBroadcast, cmRefresh, this);

}




int main(void)
{
	User *user = new User;
	user->run();
	delete user;
	return 0;
}