/***************************************************************************

 FILENAME - TDE.CPP: class TDataEntry definitions
 ------------------

 Class TDataEntry v1.0 - 07/14/92
 --------------------------------

 ----------------------------------------------------------------------------
 Author: Jeff Penrose * JDP Custom Software * (818) 344-7303 * CIS 71043,3727
 ----------------------------------------------------------------------------

 A data entry class for Borland's Turbo Vision, derived from TInputLine.

 Copyright Notice
 ================
  As this material is ultimately derived from Borland source files, any of
 their copyrights which MAY apply DO apply.
  From the author's standpoint, you may use this material freely and,
 hopefully, post any comments/corrections/enhancements to me at the above-
 noted addresses.  I do ask that you not distribute this material except as
 originally received, including all source/documentation files in their
 original form.
  If you DO modify or enhance any of this code, please send any such changes
 to me for incorporation into a future version.  Any such enhancements will
 be DONATED, without expectation of compensation or incorporation into
 future versions.  Again, if you distribute this code, please do so in its
 original, unmodified form including all source files and documentation.

 Source files included
=====================
 TDE     .DOC: This documentation.
 TDE     .MAN: How to use TDataEntry in your dialog objects
 TDE     .H  : header file containing class declarations for classes
 TDEFLAGS.H  :   "     "      "       flags and command definitions
 TDE     .CPP: Class TDataEntry
 TDEDATE .CPP: Class TDEDate
 TDEPHONE.CPP: Classes TDEPhone, TDEZipCode, TDEState
 TDENUMS .CPP: Class TDEInteger
 TDECLUST.CPP: Non-TDataEntry classes TDEButton, TDERadioButtons, TDECheckBoxes
 TDEINPLI.CPP: Non-TDataEntry class TDEInputLine
 TDELIB  .PRJ: Project for building library TDELIB.LIB
 TDEDEMO .CPP: Demo program
 TDEDEMO .PRJ: Project for building TDEDEMO.EXE

***************************************************************************/

#define Uses_TDrawBuffer
#define Uses_TEvent
#define Uses_TInputLine
#define Uses_TKeys
#define Uses_TProgram // TESTING for cmReleasedFocus
#define Uses_TRect
#define Uses_MsgBox
#define Uses_opstream
#define Uses_ipstream
//#include <tv.h>

#include "tde.h"
//	#include "tdeflags.h"

#if !defined( __STRING_H )  // for strlen()
#include <String.h>
#endif  // __STRING_H

#ifndef __LIMITS_H          // for UCHAR_MAX
#include <limits.h>
#endif
                            // define static members

uchar  TDataEntry::globalID        = 0;
ushort TDataEntry::globalMode      = (tdgBeepEnable | tdgSelectOnFocus);
char  *TDataEntry::msgDataRequired = "\003Required data is missing!";
char  *TDataEntry::msgDataInvalid  = "\003Invalid data!";
char   TDataEntry::secureChar      = '#';

static Boolean  exitAuto = False;
const int CONTROL_Y = 25;

//--------------------------------------------------------------------------
//
// **** TDataEntry::TDataEntry()
//
// CONSTRUCTOR for formatted data entry (usually including punctuation, etc.
//   which cannot be edited by the user).  You MUST use this version if the
//   format includes non-MASK_CHAR's.
//--------------------------------------------------------------------------
TDataEntry::TDataEntry(int col, int row, char *format, const char *fName ) :
            TInputLine(TRect(col, row, col + strlen(format), row + 1), 1),
            tdCurPos( -1 ),
            localMode( tdlRLArrows | tdlInsertEnable ),
            dataFormat( 0 ),
            mask( NULL ),
            outView( NULL ),
            origData( NULL ),
            fieldName( NULL )
{
  int len = strlen(format);

  maxLen  = 0;
  mask    = new char[len + 1];
  if ( !mask ) return;
  outView = new char[len + 1];
  if ( !outView ) return;
  strcpy (mask, format);
  for ( int i = 0; i < len; i++ )
  {
    if ( mask[i] == MASK_CHAR )
    {
      outView[i] = ' ';
      ++maxLen;
      tdLastPos = i;
      if ( tdCurPos < 0 ) tdCurPos = firstPos = i;
    }
    else
      outView[i] = mask[i];
  }
  delete data;
  data       = NULL;
  data       = new char[maxLen + 1];
  origData   = new char[maxLen + 1];
  outView[i] = *data = *origData = EOS;
  eventMask |= evBroadcast;
  if ( globalID + 1 > UCHAR_MAX )
    localID = UCHAR_MAX;
  else
    localID = globalID++;
  if ( fName && (fieldName = new char[strlen(fName) + 1]) != NULL )
    strcpy( fieldName, fName );
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::TDataEntry()
//
// CONSTRUCTOR for data entry field where format is all MASK char's.  Ie,
//   user can enter data in any position.  Useful when you want something
//   like a long numeric field w/no formatting.  You don't need to type in
//   a string of (say) 40 MASK_CHAR's.  You CANNOT use this version if the
//   format string contains any non-MASK_CHAR's.
//--------------------------------------------------------------------------
TDataEntry::TDataEntry(int col, int row, int len, const char *fName ) :
            TInputLine(TRect(col, row, col + len, row + 1), len + 1 ),
            tdCurPos( 0 ),
            localMode( tdlRLArrows | tdlInsertEnable ),
            dataFormat( 0 ),
            mask( NULL ),
            outView( NULL ),
            origData( NULL ),
            fieldName( NULL )
{
  mask    = new char[len + 1];  // maxLen, data set in base constructor
  if ( !mask ) return;
  outView = new char[len + 1];
  if ( !outView ) return;
  memset(mask, MASK_CHAR, maxLen);
  memset(outView, ' ', maxLen);
  origData   = new char[maxLen + 1];
  if ( !origData ) return;
  mask[maxLen] = outView[maxLen] = *data = *origData = EOS;
  firstPos = 0;
  tdLastPos = len - 1;
  eventMask |= evBroadcast;
  if ( globalID + 1 > UCHAR_MAX )
    localID = UCHAR_MAX;
  else
    localID = globalID++;
  if ( fName && (fieldName = new char[strlen(fName) + 1]) != NULL )
    strcpy( fieldName, fName );
};

//--------------------------------------------------------------------------
//
// **** TDataEntry::~TDataEntry()
//
//--------------------------------------------------------------------------
TDataEntry::~TDataEntry()
{
  delete mask;
  delete outView;
  delete origData;
  delete fieldName;
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::dataSize()
//
//--------------------------------------------------------------------------
ushort TDataEntry::dataSize()
{
  return maxLen + 1;
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::draw()
//
//--------------------------------------------------------------------------
void TDataEntry::draw()
{
  int L, R;
  TDrawBuffer b;

  uchar color = (state & sfFocused) ? getColor( 2 ) : getColor( 1 );

  b.moveChar( 0, ' ', color, size.x );
  char buf[256];
  formatView();  // ADDED BACK 06/02/92 for THistory to WORK!!!
  strncpy(buf, outView, size.x );
  buf[size.x ] = EOS;
  b.moveStr( 0, buf, color );
  if( (state & sfSelected) != 0 )  // strlen(data) &&
  {
    L = tdSelStart;  // JDP 01/19/92 WAS: l = selStart;  // JDP ... - firstPos
    R = tdSelEnd;    // JDP 01/19/92 WAS: r = selEnd;    // JDP ... - firstPos;
    L = max(firstPos, L );  // JDP 01/21/92 firstPos WAS 0
    R = min( size.x, R );
    if ( L < R )          //* JDP 07/13/92 removed -->  && L + 1 != R
      b.moveChar( L, 0, getColor(3), R - L); // +- 1 );
  }
  writeLine( 0, 0, size.x, size.y, b );
  setCursor( tdCurPos, 0);
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::getData()
//
//--------------------------------------------------------------------------
void TDataEntry::getData( void *rec )
{
  // memcpy( rec, data, dataSize() );
  memcpy( rec, data, strlen(data) + 1 );
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::mousePos()
//
//--------------------------------------------------------------------------
int TDataEntry::mousePos( TEvent& event )
{
  TPoint mouse = makeLocal( event.mouse.where );
  mouse.x = max( mouse.x, firstPos);   // JDP 01/21/92 firstPos = 0
  int pos = max( mouse.x, firstPos );  // JDP 01/21/92 firstPos = 0
  pos = min( mouse.x, tdLastPos + 1);  // + 1);  //* JDP 01/21/92 tdLastPos = strlen(data) );
  return pos;                      //* JDP 07/13/92 added +1 back in
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::deleteSelect()
//
//--------------------------------------------------------------------------
void  TDataEntry::deleteSelect()
{
  if( selStart < selEnd )
  {
    strcpy( data + selStart, data + selEnd); // JDP + 1 );
    curPos = selStart;
    tdCurPos = tdSelStart;  // JDP 01/19/92
    // formatView();           // JDP added 1/18/92; deleted 06/02/92
  }
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::setViewPos
//
//  Called every time cursor position must change.  curPos keeps track of
//   the current index into data, as it always has.  tdCurPos tracks the
//   cursor within the outView mask.  Except in a few cases (such as when a
//   selection is made), the cursor should never appear under a non-MASK_CHAR.
//--------------------------------------------------------------------------
#define   modeSelMinus  0  //* JDP 07/13/92 added SelMinus, SelPlus mnemonics
#define   modeSelPlus   1
#define   modeSelEnd    2  // JDP added mode flags 01/19/92
#define   modeSelAll    3
#define   modeSelFwd    4
#define   modeSelBak    5

void near  TDataEntry::setViewPos(ushort mode)
{
  ushort  inc;
  int     i;

  if ( mode < modeSelEnd )
  { // find next writable position
    tdCurPos += (inc = (mode) ? 1 : -1);
    for ( i = tdCurPos;
          (i > firstPos) && (i < tdLastPos) && (mask[tdCurPos] != MASK_CHAR);
          i += inc )
      tdCurPos += inc;
  }
  else switch ( mode )
  {
    case modeSelEnd:               // find end of data
    case modeSelAll:
      tdCurPos = firstPos;
      for ( i = 0; data[i++] != EOS && tdCurPos <= tdLastPos; )
      {                     //* JDP 07/13/92 ----^ added =
        tdCurPos++;
        while ( mask[tdCurPos] != MASK_CHAR )
          tdCurPos++;
      }
      if ( mode == modeSelAll )
        tdSelEnd = tdCurPos;   //* JDP 07/13/92 removed + (i >= maxLen) ? 1 : 0;
      break;

    case modeSelFwd:
    case modeSelBak:
      // Here, find correct outView and data start/end. First, find diff.
      //  betw. tdSelStart, tdSelEnd and copy that portion of outView into a
      //  temp. string.  Then, bump tdSelStart until we find the next
      //  MASK_CHAR pos. and adjust tdSelEnd.  Then, find selStart correspond-
      //  ing to the new tdSelStart.  If selection (tdSelEnd - tdSelStart)
      //  is <= 1 OR the temp. string has nothing but non-mask char's in it,
      //  then nothing's been selected (might just have been a relocation by
      //  mouse): reset all and set new curPos to selStart.  All this work
      //  must be done even when there's no selection because we need to
      //  find the new curPos relative to the new outView position.
      // Otherwise, assuming something is selected, find selEnd correspond-
      //  ing to tdSelEnd, then adjust curPos and tdCurPos.

      i = tdSelEnd - tdSelStart;
      char *tmp = new char[i + 1];
      memcpy(tmp, mask + tdSelStart, i);
      tmp[i] = EOS;
      for ( i = 0; mask[tdSelStart] != MASK_CHAR; ++tdSelStart, i++);
      if ( tdSelEnd > tdLastPos )
        tdSelEnd = tdLastPos + 1;
      else
        while ( mask[tdSelEnd - 1] != MASK_CHAR ) --tdSelEnd;
      for ( i = 0, selStart = 0; i < tdSelStart && selStart < strlen(data); )
        if ( mask[i++] == MASK_CHAR ) selStart++;
      selEnd = selStart;
      if ( tdSelEnd - tdSelStart < 1 || strchr(tmp, MASK_CHAR) == NULL )
      {                           //* JDP 07/13/92 removed <= 1
        tdCurPos   = tdSelStart;
        tdSelStart = tdSelEnd = firstPos;
        curPos     = selStart;
        selStart   = selEnd = 0;
      }
      else
      {
        for ( ; i < tdSelEnd && selEnd < strlen(data); )
          if ( mask[i++] == MASK_CHAR ) selEnd++;
        tdCurPos = (mode == modeSelFwd) ? tdSelEnd /* - 1 */ : tdSelStart;
        curPos   = (mode == modeSelBak) ? //* JDP 07/13/92 REMOVED || selEnd - selStart <= 1 ) ?
                    selStart : selEnd;    //* JDP 07/13/92 WAS SelEnd - 1;
      }
      delete tmp;

  }  // END ...switch(mode)...

  if ( tdCurPos < firstPos ) tdCurPos = firstPos;          // check limits
  else if ( tdCurPos > tdLastPos  ) tdCurPos = tdLastPos;
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::formatView()
//
//  Places the data into the outView; it's called prior to drawView() only
//  when the data has been changed.  ** WRONG: called every draw()
//--------------------------------------------------------------------------
void near TDataEntry::formatView()
{
  int  maskPos = 0, dataPos = 0, dataLen = strlen(data);

  while ( maskPos < strlen(mask) )
  {
    if ( mask[maskPos] != MASK_CHAR )      // if NOT MASK_CHAR
      outView[maskPos] = mask[maskPos];    //  insert literal
    else if ( dataPos < dataLen )
    {                                      // else if not past dataLen
      if ( (localMode & tdlSecure ) != 0 )
        outView[maskPos] = secureChar;
      else
        outView[maskPos] = data[dataPos];
      ++dataPos;
    }
    else                                   // else
      outView[maskPos] = ' ';              //  insert space
    ++maskPos;
  }
  outView[maskPos] = EOS;                  // button up
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::handleEvent()
//
//--------------------------------------------------------------------------
void  TDataEntry::handleEvent( TEvent& event )
{
  TView::handleEvent(event);

  int anchor, i;

  if ( event.what == evBroadcast )    //**** && owner == event.message.infoPtr )
  {
    switch ( event.message.command )
    {
      case cmTDQueryValid:
        if ( !validData(NULL, NULL) )
          clearEvent(event);
        return;
      case cmTDQueryChanged:
        if ( strcmp(origData, data) != 0 )
          clearEvent(event);
        return;
      case cmTDGotoNumber:
        if ( localID == *(uchar *)event.message.infoPtr )
          clearEvent(event);
        return;
      case cmTDResetData:
        strcpy( origData, data );
        return;
      case cmTDGotoName:
        if ( strcmp( fieldName, (char *)event.message.infoPtr ) == 0 )
          clearEvent(event);
        return;
      default:
        TInputLine::handleEvent(event);
    }
  }

  if( (state & sfSelected) != 0 )
    switch( event.what )
    {
      case  evMouseDown:
        if (event.mouse.doubleClick)
          selectAll(True);
        else
        {
          ushort dir = modeSelFwd;
          setViewPos(modeSelAll);         // Get max. allowable selection
          i = tdSelEnd;                   //  and store in i.  Get anchor
          anchor = mousePos(event);       //  and make sure anchor <= i.
          if ( anchor > i ) anchor = i;   // In 'do' loop, make sure i is
          do                              //  not exceeded.
          {
            tdCurPos = mousePos(event);
            if ( tdCurPos > i ) tdCurPos = i;
            if( tdCurPos < anchor )
            {
              tdSelStart = tdCurPos;
              tdSelEnd   = anchor;  // + 1;  // JDP 01/21/92 + 1
              dir = modeSelBak;
            }
            else
            {
              tdSelStart = anchor;
              tdSelEnd   = tdCurPos;  // + 1;  // JDP 01/21/92 + 1
              dir = modeSelFwd;
            }
            drawView();
          } while (mouseEvent(event, evMouseMove | evMouseAuto));

          setViewPos(dir);
          drawView();
        }
        clearEvent(event);
        break;

      case  evKeyDown:
        switch( ctrlToArrow(event.keyDown.keyCode) )
        {
          case kbEsc:  // Pass on
            return;

          case kbEnter:    // Is ENTER treated like tab?
            if ( (globalMode & tdgEnterIsTab) )
            {
              event.keyDown.keyCode = kbTab;
            }
            else
              return;       // RETURN regardless of whether we handled it ourselves
          case kbTab:       // If validation enabled, is data valid?
          case kbShiftTab:
            if ( !(globalMode & tdgValidNow) || validData(NULL, NULL) )
            {
              TInputLine::handleEvent(event);
              return;
            }
            break;

          // kbUp/kbDown:  Is up/down enabled?  Is immediate validation set?
          //  If so, is up/down validation set and data valid?  If so, reset
          //  keycode to TAB/SHFT-TAB and let base handle.
          case kbUp:
          case kbDown:
            if ( (globalMode & tdgUpDownEnable) )
            {
              if ( (globalMode & tdgValidNow) &&
                  ((globalMode & tdgValidUpDown) && !validData(NULL,NULL)) )
                 break;  // return;
              event.keyDown.keyCode =
                (event.keyDown.keyCode == kbUp) ? kbShiftTab : kbTab;
              TInputLine::handleEvent(event);
              return; // JDP 01/19/92 added here instead of below
            }
            break;    // JDP 01/19/92 WAS return;

          case kbLeft:          // Are arrow keys enabled?
            if ( curPos > 0 && (localMode & tdlRLArrows) )
            {
              curPos--;
              setViewPos(modeSelMinus);
            }
            break;

          case kbRight:                    // Are arrow keys enabled?
            if ( curPos < strlen(data) && (localMode & tdlRLArrows) )
            {
              curPos = (curPos + 1 < maxLen) ? ++curPos : maxLen - 1;
              setViewPos(modeSelPlus);
              // formatView();  // JDP added 1/18, deleted 1/27
            }
            break;

          case kbHome:
            curPos =  0;
            tdCurPos = firstPos;
            break;

          case kbEnd:                            // JDP 01/19 moved code to
            i = strlen(data);                    //  setViewPos()
            curPos = (i < maxLen) ? i : maxLen - 1;
            setViewPos(modeSelEnd);
            break;

          case kbBack:
            if( curPos > 0 )
            {
              strcpy( data + curPos - 1, data+curPos );
              curPos--;
              setViewPos(modeSelMinus);
              // formatView();  // JDP added 1/18, deleted 06/02/92
            }
            break;

          case kbDel:
            if( selStart == selEnd )
              if( curPos < strlen(data) )
              {
                selStart = curPos;
                tdSelStart = tdCurPos;  // JDP 01/19/92
                selEnd = curPos + 1;
              }
            deleteSelect();
            break;

          case kbIns:         // Is insert enabled?
            if ( (localMode & tdlInsertEnable) )
              setState(sfCursorIns, Boolean(!(state & sfCursorIns)));
            break;

		  default:
			if( validKey(&event.keyDown.charScan.charCode) )
			{

			   if ((dataFormat & tdfUpper) !=  0)
			   {
				  event.keyDown.charScan.charCode =
					 toupper(event.keyDown.charScan.charCode);
			   }

			  if( (state & sfCursorIns) != 0 )
			  {
				if ( curPos == strlen(data) )   // JDP
				  *(data + curPos + 1) = EOS;
				else
				  strcpy( data + curPos, data + curPos + 1 );
			  }
			  else
				deleteSelect();
			  if( strlen(data) < maxLen )
			  {
				memmove( data + curPos + 1, data + curPos,
						 strlen(data+curPos)+1 );
				data[curPos++] = event.keyDown.charScan.charCode;
				if ( curPos >= maxLen )
				{
				  curPos = maxLen - 1;
				  if ( (localMode & tdlAutoExit) != 0 )
					exitAuto = True;
				}
				setViewPos(modeSelPlus);
              }
              else                  //* JDP 07/13/92
              {                     //*  Added 'beep' logic when user tries
                cout << (char)7;    //*  to insert in a full field.
                clearEvent(event);
                return;
              }
              // formatView();  // JDP added 1/18, deleted 06/02/92
            }
            else if ( event.keyDown.charScan.charCode == kbCtrlR )
            {
              if ( strlen(origData) && strcmp(data, origData) != 0 )
                strcpy( data, origData );    // Restore original data
              else
              {
                clearEvent(event);
                return;
              }
            }
            else if( event.keyDown.charScan.charCode == CONTROL_Y)
            {
              *data = EOS;
              curPos = 0;
              tdCurPos = firstPos;
              // formatView();  // JDP added 1/18, deleted 06/92/92
            }
            else
            {
              if ( (globalMode & tdgBeepEnable) )  cout << (char) 7;
              clearEvent(event);  //* JDP 07/13/92 ADDED so ofPostProcess
              return;             //*  fields don't grab the keystroke!
            }
        }
      selStart = selEnd = 0;
      tdSelStart = tdSelEnd = firstPos;
      drawView();
      clearEvent( event );
      if ( exitAuto )
      {
        exitAuto = False;
        if ( (globalMode & tdgValidNow) == 0 || validData(NULL, NULL) )
          owner->selectNext(False);
      }
      break;

    }  // END ...if (state && sfSelected...)
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::selectAll()
//
//--------------------------------------------------------------------------
void TDataEntry::selectAll( Boolean enable )
{
  selStart = 0;
  tdSelStart = firstPos;
  if( enable )
  {
    curPos = selEnd = strlen(data);
    if ( curPos >= maxLen ) --curPos;  // JDP 01/19/92
    setViewPos(modeSelAll);
  }
  else
  {
    selEnd = 0;                        // JDP 01/19 WAS curPos = selEnd = 0;
    tdSelStart = tdSelEnd = firstPos;  // JDP 01/19/92
  }
  drawView();
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::setData()
//
//--------------------------------------------------------------------------
void TDataEntry::setData( void *rec )
{
  memcpy( data, rec, dataSize()-1 );
  data[dataSize()-1] = EOS;
  strcpy(origData, data);
  tdSelStart = tdSelEnd = curPos = 0;  // JDP 06/23/92 added curPos = 0
  tdCurPos = firstPos;
  // formatView();        // JDP added 1/27/92
  // selectAll( True ); // JDP 02/02/92
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::setState()
//
//--------------------------------------------------------------------------
void TDataEntry::setState( ushort aState, Boolean enable )
{
  TView::setState( aState, enable );
  if( aState == sfSelected ||
      ( aState == sfActive && (state & sfSelected) != 0 ) )
     if ( (globalMode & tdgSelectOnFocus) )  // JDP 01/19 !enable ||
       selectAll( enable );
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::validData()
//
//--------------------------------------------------------------------------
Boolean TDataEntry::validData( const char *iMsg, const char *rMsg) // JDP 05/30/92
{
  if ( strlen(data) )
  {
    for ( char *p = data; *p != EOS; p++ )
      if ( !validKey((uchar *)p) )
      {
        const char *msg = ( iMsg ) ? iMsg : msgDataInvalid;
        if ( (globalMode & tdgBeepEnable) != 0 ) cout << (char)7;
        if ( msg ) messageBox( msg, mfError|mfOKButton );
        select();
        return False;
      }
  }
  else if ( (localMode & tdlRequired) != 0 )
  {
	const char *msg = ( rMsg ) ? rMsg : msgDataRequired;
	if ( (globalMode & tdgBeepEnable) != 0 ) cout << (char)7;
  /*
	if ( rMsg )
	{
		if (fieldName != 0)
			messageBox(mfError|mfOKButton, "\003Required data is missing\n"
				"\003from field %s", fieldName);
		else
			messageBox( msg, mfError|mfOKButton );
	}
  */

	if (fieldName != 0)
		messageBox(mfError|mfOKButton, "\003Required data is missing\n"
			"\003from %s field", fieldName);
	else
		messageBox( msg, mfError|mfOKButton );

	select(); return False;
  }
  return True;
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::valid()
//
//--------------------------------------------------------------------------
Boolean TDataEntry::valid(ushort cmd)
{
  if ( (cmd == cmValid) &&
       (data == NULL || mask == NULL || outView == NULL || origData == NULL)
     )
  {
    return False;
  }
  return True;
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::locateID()
//
//--------------------------------------------------------------------------
TDataEntry *TDataEntry::locateID( TView *fieldOwner, uchar fieldNumber,
                                         Boolean select )
{
  uchar i = fieldNumber;
  TDataEntry *field =
    (TDataEntry *)message( fieldOwner, evBroadcast, cmTDGotoNumber, &i );
  if ( field && select ) field->select();
  return field;
}

//--------------------------------------------------------------------------
//
// **** TDataEntry::locateName()
//
//--------------------------------------------------------------------------
TDataEntry *TDataEntry::locateName( TView *fieldOwner, const char *fName,
                                           Boolean select )
{
  TDataEntry *field =
    (TDataEntry *)message( fieldOwner, evBroadcast, cmTDGotoName, (void *)fName );
  if ( field && select ) field->select();
  return field;
};

//--------------------------------------------------------------------------
//
// **** TDataEntry::resetData()
//
//--------------------------------------------------------------------------
void TDataEntry::resetData( TView *fieldOwner, TDataEntry *target )
{
  message( (target == NULL) ? fieldOwner : target,
           evBroadcast, cmTDResetData, fieldOwner );
};

//--------------------------------------------------------------------------
//
// **** TDataEntry::queryChanged()
//
//--------------------------------------------------------------------------
TDataEntry *TDataEntry::queryChanged( TView *fieldOwner, TDataEntry *target )
{
  TDataEntry *field =
    (TDataEntry *)message( (target == NULL) ? fieldOwner : target,
                           evBroadcast, cmTDQueryChanged, fieldOwner );
  return field;
};

//--------------------------------------------------------------------------
//
// **** TDataEntry::queryValid()
//
//--------------------------------------------------------------------------
TDataEntry *TDataEntry::queryValid( TView *fieldOwner, TDataEntry *target )
{
  TDataEntry *field =
    (TDataEntry *)message( (target == NULL) ? fieldOwner : target,
                           evBroadcast, cmTDQueryValid, fieldOwner );
  return field;
};

