/*
	PX1.CPP

	Copyright 1987-1993		Ambrose & Muckerman

	Written by:				Dan Ambrose
							Ambrose & Muckerman
	CIS ID:					71062,523
*/

#ifndef _PX1_
#define _PX1_


#include "px.h"
#include "debug.h"
#include <stdio.h>

#define Uses_MsgBox
#include <tv.h>


	int uses_Network = False;

	PXCODE _pxerror;
	int _pxerrcnt = 0;

	char pxNetPath[64];
	char pxWorkSpacePath[64];
	char pxUserName[64];


	char *uiTName = "USER";
	char uiTPath[64];
	TABLEHANDLE uiTblHandle;
	RECORDHANDLE uiRecHandle;

	char *uiTFldNames[] =
	{
		"Last",		"First",	"Middle",	"Social",
		"Addr1",	"Addr2",	"City",		"State",
		"Zip",		"Tel",		"Pass",		"Login",
		"aRights"
	};

	char *uiTFldTypes[] =
	{
		"A25",		"A25",		"A25",      "A10",
		"A25",		"A25",		"A25",      "A2",
		"A9",		"A10",      "A25",      "S",
		"A32"
	};

	int uiTFldNum =
		(sizeof(uiTFldNames) / sizeof(char *));

	FIELDHANDLE uiTFldPrimary[] =
	{
		1,	2,	3,	4
	};

	int uiTPrimarySz =
		(sizeof(uiTFldPrimary) / sizeof(FIELDHANDLE));



void iToArray(unsigned int bits, char *array, char off, char on)
{
	unsigned int mask;

	for (int i = 0; i < 16; i++)
	{
		mask = 1 << i;
		if ((bits& mask) == 0)
			array[i] = off;
		else
			array[i] = on;
	}
	array[i] = 0;
}

void arrayToi(unsigned int &bits, char *array, char off)
{
	unsigned int mask;

	bits = 0;
	for (int i = 0; i < 16; i++)
	{
		mask = (1 << i);

		if (array[i] != off)
			bits |= mask;
	}
}



PXCODE _pxcheck(PXCODE code, const char *file, const int line)
{
	if (code != PXSUCCESS)
	{
		_pxerror = code;
		_pxerrcnt++;
		if (debug==True)
			dout << file << ", " << line << " : "<< PXOopErrMsg(code) << endl;
		else
			messageBox(mfError|mfOKButton, "\003%s", PXOopErrMsg(_pxerror) );
	}

	return code;
}

int pxstart()
{
	toute();

//	sprintf(pxNetPath,			"F:\\PDOXNET\\");
//	sprintf(pxWorkSpacePath,	"F:\\TAS\\");
	sprintf(pxUserName, 		"User");
	sprintf(uiTPath,            "%s\\%s", pxWorkSpacePath, uiTName);


	if (uses_Network == True)
	{
		if (pxCheck(PXNetInit(pxNetPath, NETSHARE, pxUserName)))
		{
			if (_pxerror == PXERR_NOTLOGGEDIN)
			{
				messageBox(mfError|mfOKButton,
					"\003%s!\n"
					"\003You must specify the network path\n"
					"\003via NET= command line argument!"
					, PXOopErrMsg(_pxerror), _pxerror );
			}
			else
				messageBox(mfError|mfOKButton, "\003%s [%d]",
				PXOopErrMsg(_pxerror), _pxerror );

			return 1;
		}
	}
	else
	{
		if (pxCheck(PXInit()))
		{
			messageBox(mfError|mfOKButton, "\003%s [%d]",
				PXOopErrMsg(_pxerror), _pxerror );
			return 1;
		}
	}


	int rc;
	pxCheck(PXTblExist(uiTPath, &rc));
	if (!rc)
	{
		if (pxCheck(PXTblCreate(uiTPath, uiTFldNum, uiTFldNames, uiTFldTypes) ))
			return 1;
		if (pxCheck(PXKeyAdd(uiTPath, uiTPrimarySz, uiTFldPrimary, PRIMARY) ))
			return 1;

		if (pxCheck(PXTblOpen(uiTPath, &uiTblHandle, 0, 0)))
			return 1;

		if (pxCheck(PXRecBufOpen(uiTblHandle, &uiRecHandle)))
			return 1;

		for (int i = 1; i < 14; i++)
			pxCheck(PXPutBlank(uiRecHandle, i));

		pxCheck( PXPutAlpha(uiRecHandle, 1, "SUPERVISOR") );
		pxCheck( PXPutAlpha(uiRecHandle, 11, "PASSWORD") );
		pxCheck( PXPutShort(uiRecHandle, 12, 3) );
		pxCheck( PXPutAlpha(uiRecHandle, 13, "1111111111111111") );
		pxCheck( PXRecAppend(uiTblHandle, uiRecHandle) );
	}

	if (pxCheck(PXTblOpen(uiTPath, &uiTblHandle, 0, 0)))
		return 1;

	if (pxCheck(PXRecBufOpen(uiTblHandle, &uiRecHandle)))
		return 1;

	return 0;
}

void pxstop()
{

	PXExit();
}


#endif	//	_PX1_