////////////////////////////////////////////
// tsplash.cpp - Source file for TSplash
//
// Author - 		Russell Morris
// Version - 		1.5
// Release date -	June 22, 1995

#include <owl\owlpch.h>
#pragma hdrstop

#include "tsplash.h"
#include "tsplash.rh"
#include "bmpctl.h"
#include "splshapp.rh"

static HHOOK	SplashhookKbd;				// hookchain used by KbdProc

LRESULT CALLBACK SplashKbdProc (int code, WPARAM wParam, LPARAM lParam);

static TSplash* ptSplash;
DEFINE_RESPONSE_TABLE1(TSplash, TDialog)
	EV_WM_LBUTTONDOWN,
	EV_WM_TIMER,
END_RESPONSE_TABLE;


TSplash::TSplash (TWindow* parent, bool use, TResId resId, TModule* module):
	TDialog(parent, resId, module)
{
	bc = new TBitmapControl(this, IDB_SPLASHBITMAP);
	::ptSplash = this;
	UseOnce = use;
}


TSplash::~TSplash ()
{
	Destroy();
}


void TSplash::EvLButtonDown (uint, TPoint&)
{
	CloseWindow();
}


void TSplash::SetupWindow ()
{
	TDialog::SetupWindow();

#ifdef __WIN32__
	::SplashhookKbd		= SetWindowsHookEx (WH_KEYBOARD, SplashKbdProc, NULL, GetCurrentThreadId ());
#else
	::SplashhookKbd		= SetWindowsHookEx (WH_KEYBOARD, SplashKbdProc, GetApplication ()->GetInstance (), GetCurrentTask ());
#endif

	SetWindowPos(HWND_TOPMOST, TRect(), SWP_NOMOVE | SWP_NOSIZE);

	TRect	SplashRect = GetWindowRect();
	RECT	ScreenRectRECT;
	::GetWindowRect(GetDesktopWindow(),&ScreenRectRECT);
	TRect  ScreenRect(ScreenRectRECT.left,
							ScreenRectRECT.top,
							ScreenRectRECT.right,
							ScreenRectRECT.bottom);
	int offsetX = (int) (ScreenRect.Width() - SplashRect.Width()) / 2;
	int offsetY = (int) (ScreenRect.Height() - SplashRect.Height()) / 2;
	SetWindowPos(  HWND_TOPMOST,
					offsetX,
					offsetY,
					0,
					0,
					SWP_NOSIZE);

	SetTimer(1, 3000, NULL);
	SetCapture();
	SetFocus();
}


void TSplash::CloseWindow (int retVal)
{
	KillTimer(1);
	ReleaseCapture();
	UnhookWindowsHook(WH_KEYBOARD, SplashKbdProc);
	if(UseOnce)
		Parent->PostMessage(WM_DELETESPLASHDLG, GetDefaultId(), 0);

	TDialog::CloseWindow(retVal);
}


void TSplash::EvTimer (uint timerId)
{
	TDialog::EvTimer(timerId);

	CloseWindow();
}

LRESULT CALLBACK SplashKbdProc (int code, WPARAM wParam, LPARAM lParam)
{
	if ( code >= 0 )
	{
		//
		// I don't test for VK_RETURN because the app could have been started
		// by pressing "enter" on the app's icon in program manager.  For some
		// reason the SplashKbdHook() is called with the VK_ENTER keycode when
		// this happens.  If anyone can think of a fix let me know!
		//
		if( (wParam == VK_SPACE) )
			ptSplash->CloseWindow ();
	}

	return CallNextHookEx (SplashhookKbd, code, wParam, lParam);
}

