#if !defined(__splshapp_h)              // Sentry, use file only if it's not already included.
#define __splshapp_h

/*  Project Splash
    Official Good Software
    Copywrite 1995

    SUBSYSTEM:    splash.exe Application
    FILE:         splshapp.h
    AUTHOR:       Russell Morris


    OVERVIEW
    ========
    Class definition for SplashApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "splshapp.rh"            // Definition of all resources.
#include "tsplash.h"

//
// FrameWindow must be derived to override Paint for Preview and Print.
//
//{{TDecoratedFrame = SDIDecFrame}}
class SDIDecFrame : public TDecoratedFrame {
public:
	 SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection = false, TModule *module = 0);
	 ~SDIDecFrame ();
};    //{{SDIDecFrame}}


//{{TApplication = SplashApp}}
class SplashApp : public TApplication {
private:

public:
	 SplashApp ();
	 virtual ~SplashApp ();

	 TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.
	 void OpenFile (const char *fileName = 0);
//{{SplashAppVIRTUAL_BEGIN}}
public:
	 virtual void InitMainWindow();
//{{SplashAppVIRTUAL_END}}
	 LRESULT DeleteSplashDlg(WPARAM, LPARAM);

//{{SplashAppRSP_TBL_BEGIN}}
protected:
	 void CmFileNew ();
    void CmFileOpen ();
    void CmHelpAbout ();
    void CmSplash ();
    void CeSplash (TCommandEnabler &tce);
//{{SplashAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(SplashApp);
protected:
	TSplash* splash;
};    //{{SplashApp}}


#endif                                      // __splshapp_h sentry.
