/*  Project Splash
    Official Good Software
    Copywrite 1995

    SUBSYSTEM:    splash.exe Application
    FILE:         splshapp.cpp
    AUTHOR:       Russell Morris


	 OVERVIEW
    ========
    Source file for implementation of SplashApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "splshapp.h"
#include "splshedf.h"                        // Definition of client class.       
#include "splshabd.h"                        // Definition of about dialog.       


//{{SplashApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(SplashApp, TApplication)
//{{SplashAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILENEW, CmFileNew),
	 EV_COMMAND(CM_FILEOPEN, CmFileOpen),
	 EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
	 EV_MESSAGE(WM_DELETESPLASHDLG,DeleteSplashDlg),
	 EV_COMMAND(CM_SPLASH, CmSplash),
	 EV_COMMAND_ENABLE(CM_SPLASH, CeSplash),
//{{SplashAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// SplashApp
// =====
//
SplashApp::SplashApp () : TApplication("Splash")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	 FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.
}


SplashApp::~SplashApp ()
{
    // INSERT>> Your destructor code here.
}


//////////////////////////////////////////////////////////
// SplashApp
// =====
// Application intialization.
//
void SplashApp::InitMainWindow ()
{
    if (nCmdShow != SW_HIDE)
        nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

	 SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, false);

    //
    // Assign ICON w/ this application.
	 //
	 frame->SetIcon(this, IDI_SDIAPPLICATION);

	 //
	 // Menu associated with window and accelerator table associated with table.
	 //
	 frame->AssignMenu(SDI_MENU);

	 //
	 // Associate with the accelerator table.
	 //
	 frame->Attr.AccelTable = SDI_MENU;


	 SetMainWindow(frame);

	 frame->SetMenuDescr(TMenuDescr(SDI_MENU));

	EnableCtl3d();

	 //
	 // Create the splash window
	 // Un-comment the second parameter to TSplash in order to re-display
	 // the splash screen in response to a user request (perhaps as an about
	 // dialog box?)
	 //

	splash = new TSplash(GetMainWindow()/*, false*/);
	splash->Create();
}


//////////////////////////////////////////////////////////
// SplashApp
// ===========
// Menu File New command
void SplashApp::CmFileNew ()
{
	 SplashEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), SplashEditFile);     // Client window for the frame.
	 client->NewFile();
}


//////////////////////////////////////////////////////////
// SplashApp
// ===========
// Menu File Open command
void SplashApp::CmFileOpen ()
{
	 //
	 // Display standard Open dialog box to select a file name.
	 //
	 *FileData.FileName = 0;

    SplashEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), SplashEditFile);     // Client window for the frame.
    if (client->CanClose())
		  if (TFileOpenDialog(GetMainWindow(), FileData).Execute() == IDOK)
            OpenFile();
}


void SplashApp::OpenFile (const char *fileName)
{
    if (fileName)
		  strcpy(FileData.FileName, fileName);

    SplashEditFile *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), SplashEditFile);     // Client window for the frame.
    client->ReplaceWith(FileData.FileName);
}


//{{SDIDecFrame Implementation}}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection, TModule *module)
	 : TDecoratedFrame(parent, title, clientWnd == 0 ? new SplashEditFile(0, 0, 0) : clientWnd, trackMenuSelection, module)
{
	 // INSERT>> Your constructor code here.

}


SDIDecFrame::~SDIDecFrame ()
{
	 // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// SplashApp
// ===========
// Menu Help About splash.exe command
void SplashApp::CmHelpAbout ()
{
	 //
	 // Show the modal dialog.
	 //
	 SplashAboutDlg(MainWindow).Execute();
}
int OwlMain (int , char* [])
{
	 try {
		  SplashApp    app;
		  return app.Run();
	 }
	 catch (xmsg& x) {
		  ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
	 }

	 return -1;
}

LRESULT SplashApp::DeleteSplashDlg(WPARAM, LPARAM)
{
  if(splash)
  {
	delete splash;
	splash = 0;
  }
  return TRUE;
}


void SplashApp::CmSplash ()
{
	 // INSERT>> Your code here.
	 if(splash)
		splash->Create();
}


void SplashApp::CeSplash (TCommandEnabler &tce)
{
	 // INSERT>> Your code here.
	tce.Enable(splash != 0);
}

