// =========================================================
// BMPCTL.CPP
//
// Bitmap Control for OWL 2
// - used to place bitmaps in a dialog box
//
// Author:  Steve Saxon (Compuserve: 100321,2355)
// Written: 15th October 1994
//
// Revised by: Russell Morris (Compuserve: 75627,3615)
// Revision:   1.02
// Date:       January 23, 1995
// =========================================================

#include <owl\owlpch.h>
#pragma hdrstop

#include "bmpctl.h"

// =========================================================
// TBitmapControl
//
// bitmap control - assumes a placeholder exists in the
// dialog template (eg. a blackrect static control)
// =========================================================

TBitmapControl::TBitmapControl (TWindow* parent, int resourceID, Style _style, TModule* module)
	: TControl (parent, resourceID, module)
{
	style 	= _style;
	dib 	= new TDib (*GetApplication(), resourceID);
	bitmap	= new TBitmap(*dib);
	palette = new TPalette(*dib);
}

TBitmapControl::~TBitmapControl ()
{
	delete bitmap;
	delete dib;
	delete palette;
}

void TBitmapControl::SetupWindow ()
{
	TControl::SetupWindow ();

	ClearFlag (wfPredefinedClass);
}

void TBitmapControl::Paint (TDC& dc, BOOL, TRect&)
{
	BITMAP		bm;

	bitmap->GetObject (bm);

	TRect		client (0, 0, bm.bmWidth, bm.bmHeight);
	int			nMargin;

	switch (style)
	{
		case Plain :
		{
			nMargin = 1;
			break;
		}
		case Recessed :
		case Raised :
		{
			nMargin = 2;
			break;
		}
		default :
		{
			nMargin = 0;
			break;
		}
	}

	if (nMargin)
	{
		client.right 	+= (nMargin << 1);
		client.bottom 	+= (nMargin << 1);
	}

	switch (style)
	{
		case Plain :
		{
			dc.FrameRect (client, TBrush (GetSysColor (COLOR_WINDOWFRAME)));
			client = client.InflatedBy (-1, -1);
			break;
		}
		case Recessed :
		case Raised :
		{
			TPen	penShadow (GetSysColor (COLOR_BTNSHADOW));
			TPen	penHilite (GetSysColor (COLOR_BTNHIGHLIGHT));
			TPen	penGrey (GetSysColor (COLOR_BTNFACE));
			TPen	penBlack (GetSysColor (COLOR_WINDOWFRAME));

			dc.SelectObject (penShadow);
			dc.MoveTo (client.right - 1, client.top);
			dc.LineTo (client.left, client.top);
			dc.LineTo (client.left, client.bottom - 1);
			dc.SelectObject (penHilite);
			dc.LineTo (client.right - 1, client.bottom - 1);
			dc.LineTo (client.right - 1, client.top - 1);
			client = client.InflatedBy (-1, -1);

			dc.SelectObject (penBlack);
			dc.MoveTo (client.right - 1, client.top);
			dc.LineTo (client.left, client.top);
			dc.LineTo (client.left, client.bottom - 1);
			dc.SelectObject (penGrey);
			dc.LineTo (client.right - 1, client.bottom - 1);
			dc.LineTo (client.right - 1, client.top - 1);
			client = client.InflatedBy (-1, -1);

			//
			// select stock objects back into the DC
			//
			dc.SelectStockObject (BLACK_PEN);
			break;
		}
	}

	//
	// draw the bitmap
	//
	TMemoryDC	dcMem (dc);

	dcMem.SelectObject (*bitmap);
	dc.BitBlt (client, dcMem, TPoint (0, 0));
	dc.SelectObject(*palette);
	dc.RealizePalette();
}


