/* 
 * xchar.h
 * extended character codes 
 * use 2 getch() calls...1st call will return 0 if extended char
 *                    ...2nd will return the key code
 */

#define SHFT_TAB   15			/* Shifted Tab */

#define ALT_Q      16			/* Alt Q */
#define ALT_W      17			/* Alt W */
#define ALT_E      18			/* Alt E */
#define ALT_R      19			/* Alt R */
#define ALT_T      20			/* Alt T */
#define ALT_Y      21			/* Alt Y */
#define ALT_U      22			/* Alt U */
#define ALT_I      23			/* Alt I */
#define ALT_O      24			/* Alt O */
#define ALT_P      25			/* Alt P */

#define ALT_A      30			/* Alt A */
#define ALT_S      31			/* Alt S */
#define ALT_D      32			/* Alt D */
#define ALT_F      33			/* Alt F */
#define ALT_G      34			/* Alt G */
#define ALT_H      35			/* Alt H */
#define ALT_J      36			/* Alt J */
#define ALT_K      37			/* Alt K */
#define ALT_L      38			/* Alt L */

#define ALT_Z      44			/* Alt Z */
#define ALT_X      45			/* Alt X */
#define ALT_C      46			/* Alt C */
#define ALT_V      47			/* Alt V */
#define ALT_B      48			/* Alt B */
#define ALT_N      49			/* Alt N */
#define ALT_M      50			/* Alt M */

#define F1         59			/* Function 1 */
#define F2         60			/* Function 2 */
#define F3         61			/* Function 3 */
#define F4         62			/* Function 4 */
#define F5         63			/* Function 5 */
#define F6         64			/* Function 6 */
#define F7         65			/* Function 7 */
#define F8         66			/* Function 8 */
#define F9         67			/* Function 9 */
#define F10        68			/* Function 10 */

#define HOME_KEY   71			/* Home key */
#define UP_ARR     72			/* Up Arrow key */
#define PAGE_UP    73			/* Page Up key */
#define LT_ARR     75			/* Left Arrow key */
#define RT_ARR     77			/* Right Arrow key */
#define END_KEY    79			/* End key */
#define DN_ARR     80			/* Down Arrow key */
#define PAGE_DN    81			/* Page Down key */
#define INS_KEY    82			/* Insert key */
#define DEL_KEY    83			/* Delete key */

#define SHIFT_F1   84			/* Shift F1 */
#define SHIFT_F2   85			/* Shift F2 */
#define SHIFT_F3   86			/* Shift F3 */
#define SHIFT_F4   87			/* Shift F4 */
#define SHIFT_F5   88			/* Shift F5 */
#define SHIFT_F6   89			/* Shift F6 */
#define SHIFT_F7   90			/* Shift F7 */
#define SHIFT_F8   91			/* Shift F8 */
#define SHIFT_F9   92			/* Shift F9 */
#define SHIFT_F10  93			/* Shift F10 */

#define CTL_F1     94			/* Control F1 */
#define CTL_F2     95			/* Control F2 */
#define CTL_F3     96			/* Control F3 */
#define CTL_F4     97			/* Control F4 */
#define CTL_F5     98			/* Control F5 */
#define CTL_F6     99			/* Control F6 */
#define CTL_F7     100			/* Control F7 */
#define CTL_F8     101			/* Control F8 */
#define CTL_F9     102			/* Control F9 */
#define CTL_F10    103			/* Control F10 */

#define ALT_F1     104			/* Alt F1 */
#define ALT_F2     105			/* Alt F2 */
#define FLT_F3     106			/* Alt F3 */
#define ALT_F4     107			/* Alt F4 */
#define ALT_F5     108			/* Alt F5 */
#define ALT_F6     109			/* Alt F6 */
#define ALT_F7     110			/* Alt F7 */
#define ALT_F8     111			/* Alt F8 */
#define ALT_F9     112			/* Alt F9 */
#define ALT_F10    113			/* Alt F10 */

#define CTL_PRTS   114			/* Control Print Screen */
#define CTL_LTARR  115			/* Control Left Arrow */
#define CTL_RTARR  116			/* Control Right Arrow */
#define CTL_END    117			/* Control End */
#define CTL_PGDN   118			/* Control Page Down */
#define CTL_HOME   119			/* Control Home */

#define ALT_1      120			/* Alt 1 */
#define ALT_2      121			/* Alt 2 */
#define ALT_3      122			/* Alt 3 */
#define ALT_4      123			/* Alt 4 */
#define ALT_5      124			/* Alt 5 */
#define ALT_6      125			/* Alt 6 */
#define ALT_7      126			/* Alt 7 */
#define ALT_8      127			/* Alt 8 */
#define ALT_9      128			/* Alt 9 */
#define ALT_0      129			/* Alt 0 */

#define ALT_HYPH   130			/* Alt - */
#define ALT_EQUAL  131			/* Alt = */
#define CTL_PGUP   132			/* Control Page Up */

/*
 * non extended character codes
 * use only 1 getch() call
 */

#define CTL_A      1
#define CTL_B      2
#define CTL_C      3
#define CTL_D      4
#define CTL_E      5
#define CTL_F      6
#define CTL_G      7
#define CTL_H      8
#define CTL_I      9
#define CTL_J      10
#define CTL_K      11
#define CTL_L      12
#define CTL_M      13
#define CTL_N      14
#define CTL_O      15
#define CTL_P      16
#define CTL_Q      17
#define CTL_R      18
#define CTL_S      19
#define CTL_T      20
#define CTL_U      21
#define CTL_V      22
#define CTL_W      23
#define CTL_X      24
#define CTL_Y      25
#define CTL_Z      26

#define TAB        9
#define SHIFT_DEL  46
#define SHIFT_INS  48
#define SHIFT_END  49
#define SHIFT_DNAR 50
#define SHIFT_PGDN 51 
#define SHIFT_LTAR 52
#define SHIFT_RTAR 54
#define SHIFT_HOME 55
#define SHIFT_UPAR 56
#define SHIFT_PGUP 57

#define CRG_RETN   13
#define LINE_FEED  10
#define FORM_FEED  12
#define BEEP       7
#define BACK_SPC   8
