/* tckey.h
 * Object code is in mylib.lib
 * Taken from Inside Turbo C, Special Issue
 * header file for TCKEY.C and programs that use it
 *
 * Uses DOS Interrupt 16 basic (0) or extended (10h) service.  Extended
 * adds F11 & F12 and the additional cursor control keys.
 *
 * KbdEnhanced lets an application program toggle TCKEY's use of the
 * extended services (default is FALSE, use standard services).
 * KbdEnhanced(TRUE) to toggle.
 *
 * KbdGetChar is a replacement for getch, but retrieves both the next
 * character and the Scan code. The Scan code is in the upper 8 bits and
 * the character code in the lower 8 bits.  Then use the macros defined
 * in tckey.h to retrieve the portion you want. KbdChar retrives the
 * character, KbdScan the Scan code, KbdNoScan shift the Scan code to the
 * lower 8 bits, while KbdMakeScan shift the 8 lower bits up to the upper
 * 8 bits to compare to a Scan code as in;
 *    c = KbdGetChar();
 *    if (KbdScan(c) == KbdMakeScan(73)   where 73 is a Scan code
 *
 * KbdHit replaces kbhit. KbdHit return TRUE or FALSE.
 *
 * KbdFlags returns the status of the keyboard flags.  Use the status
 * code detection and the Enhanced Keyboard status code macros to find
 * the status. KbdFlags returns _AL or _AX if enhanced.  For example,
 * if (RightShift(KbdFlags) == TRUE)
 *
 * KbdCharIn returns the character code, Scan code, and state of the
 * of the keyboard flags in a single call.  For example,
 *
 * unsigned flags, keys;
 * KbdCharIn(&key, &flags, TRUE);
 * if (RightShift(flags))
 *
 */

#if !defined(TRUE)
#define TRUE 1
#endif

#if !defined(FALSE)
#define FALSE 0
#endif

#define KEYINT  0x16

/* Status code detection: */
#define RightShift(val)             (val & 0x0001)
#define LeftShift(val)              (val & 0x0002)
#define CtrlKey(val)                (val & 0x0004)
#define AltKey(val)                 (val & 0x0008)
#define ScrollLockToggle(val)       (val & 0x0010)
#define NumLockToggle(val)          (val & 0x0020)
#define CapsLockToggle(val)         (val & 0x0040)
#define InsertToggle(val)           (val & 0x0080)

/* Enhanced Keyboard status codes: */
#define LeftCtrlKey(val)            (val & 0x0100)
#define LeftAltKey(val)             (val & 0x0200)
#define RightCtrlKey(val)           (val & 0x0400)
#define RightAltKey(val)            (val & 0x0800)
#define Scroll(val)                 (val & 0x1000)
#define NumLock(val)                (val & 0x2000)
#define CapsLock(val)               (val & 0x4000)

/* Essential keyboard macros: */
#define KbdChar(value)              (value & 0x00ff)
#define KbdScan(value)              (value & 0xff00)
#define KbdMakeScan(value)          (value << 8)
#define KbdNoScan(value)            (value >> 8)

#define Ctrl(value)                 (value - 'A' + 1)
#define F1                          KbdMakeScan(59)
#define F2                          KbdMakeScan(60)
#define F3                          KbdMakeScan(61)
#define F4                          KbdMakeScan(62)
#define F5                          KbdMakeScan(63)
#define F6                          KbdMakeScan(64)
#define F7                          KbdMakeScan(65)
#define F8                          KbdMakeScan(66)
#define F9                          KbdMakeScan(67)
#define F10                         KbdMakeScan(68)
#define F11                         KbdMakeScan(133)
#define F12                         KbdMakeScan(134)

#define HOME                        KbdMakeScan(71)
#define END                         KbdMakeScan(79)
#define PGUP                        KbdMakeScan(73)
#define PGDN                        KbdMakeScan(81)
#define UPARROW                     KbdMakeScan(72)
#define DOWNARROW                   KbdMakeScan(80)
#define LEFTARROW                   KbdMakeScan(75)
#define RIGHTARROW                  KbdMakeScan(77)

void KbdEnhanced(int is_enhanced);
unsigned KbdGetChar(void);
unsigned KbdFlags(void);
void KbdCharIn(unsigned *character, unsigned *flags, unsigned wait);
int KbdHit(void);
