/****************************************************** Switch! Demo
******************************************************* Version 2.0
******************************************************* Tab Size:  4 ******
******************************************************* December 19, 1988
******************************************************* Curtis Little
******************************************************* 1087 Murrietta Blvd
*******************************************************                #244
******************************************************* Livermore, CA 94550
*
*	NOTES:  This demo was designed for Turbo C.  If you don't have Turbo C
*	you may need to change the calls from cputs to puts.  In addition if
*	you change cputs to puts you should get rid of the \r at the end of
*	each line to be printed.
*
*/

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>

#define BLK_SIZE	3000L			/* size of memory chunks ate */
#define PRG_SIZE	13000L			/* approx size of the demo itself */

int main( void )
{
	int mmem;					/* to hold the amount of memory required */
	int i = 0;
	char mybuff[6];				/* temp buffer */
	char mprog[83];				/* to hold the program name and parameters */

	/* eat up a lot of memory if possible */
	while (1) {
		if (((char *)malloc( BLK_SIZE )) == NULL)	/* eat chunks till all gone */
			break;
		i++;						/* no need to save the pointers */
								/* since just eating memory here */
	}

	printf( "\x01b[2J\n" );		/* clear the screen */


	cputs( "\n\n     This demo demonstrates the usefullness of Switch!.  Switch! is an\n\r" );
	cputs( "     assembly function that frees up as much memory as needed to run\n\r" );
	cputs( "     another program.  Switch! saves the memory used by your C and/or\n\r" );
	cputs( "     Assembly application to a temporary disk file (registered versions\n\r" );
	cputs( "     of Switch! use EMS if present) then frees it up for use by DOS. It\n\r" );
	cputs( "     can free up all but about 8K of available memory!!  To see how\n\r" );
	cputs( "     helpful Switch! is this program allows you to specify a program \n\r" );
	cputs( "     to run and the amount of memory required by the program.  Use a \n\r" );
	cputs( "     map program or CHKDSK to see how much memory you have free before \n\r" );
	cputs( "     running this demo.  Then specify CHKDSK as the program to run from \n\r" );
	cputs( "     within this demo and specify 0 for the amount of memory required \n\r" );
	cputs( "     (a value of 0 causes Switch! to free all memory possible).  You'll \n\r" );
	cputs( "     be amazed how much memory becomes available!\n\n\r" );
	cputs( "     Switch! was designed to work with ANY language that allows you to\n\r" );
	cputs( "     call external C functions (using standard C parameter passing\n\r" );
	cputs( "     conventions).  It doesn't matter how big the program is!  You can\n\r" );
	cputs( "     free most of the used memory to run another program!  Using Switch!\n\r" );
	cputs( "     you can run a 630K program from within a 640K program by using a\n\r" );
	cputs( "     simple function call.  With Switch! there's no worries about memory!\n\n\r" );
	cputs( "     The syntax for calling the C version of Switch! is:\n\n\r" );
	cputs( "     switch_(Drive to use, K mem needed, Program to run and parameters)\n\r" );
	getch();



	while (1) {
		/* initialize the variables */
		mprog[0] = '\0';
		mmem = 0;

		printf( "\n\nThis DEMO Program occupies approximately %ld bytes of memory.",
			i * BLK_SIZE + PRG_SIZE);
		/* get the program name and the amount of memory required */
		cputs( "\n\r\nEnter the program to run (leave blank for DOS shell):\n\r>" );
		fflush(stdin);
		fgets( mprog, 80, stdin );
		cputs( "\n\r Enter amount of RAM required by program (0 for all) \n\r" );
		cputs( "                           (Negative number to quit): " );
		fgets( mybuff, 4, stdin );
		mmem = atoi( mybuff );

		/* exit the loop if the user wants to quit */
		if (mmem < 0)
			break;

		/* Execute the specified program using the default drive to save mem */
		mmem = switch_(0,mmem, mprog);

		/* check for error */
		if (mmem) {
			printf( "\n\nSwitch!  Error #%d.  SWDEMO aborted.\n", mmem );
			exit(mmem);
		}

		cputs( "\n\r\n>> Press Any Key to Continue <<" );
		getch();
	}

	printf( "\x01b[2J\n" );		/* clear the screen */

	cputs("\n\n\n\n\n     Switch! only frees up the memory it needs to.  For instance, if you\n\r" );
	cputs("     specify the program to run needs 64K Switch! will only save memory\n\r" );
	cputs("     if there isn't already 64K free memory.  Setting the value to the \n\r" );
	cputs("     minimum required by the application reduces the time it takes to\n\r" );
	cputs("     Switch! applications.  To really get a feel for what Switch! can do \n\r" );
	cputs("     for you use the SWITCH.OBJ file to link Switch! into your own \n\r" );
	cputs("     applications and use it to call other programs.\n\n\r" );
	cputs("     To register Switch! (and get the source!) please send $20.00 check \n\r" );
	cputs("     or money order to:\n\n\r" );
	cputs("                      Curtis Little\n\r" );
	cputs("                      1087 Murrietta Blvd #244\n\r" );
	cputs("                      Livermore, CA  94550\n\n\n\n\n\n\n\r" );

	exit(0);
}

