#include <stdio.h>
#include <stdlib.h>
#include "strings.h"
#include "strfile.h"

int main( int argc, char *argv[] )
{
   String line;
   int columns;
   StringFile outfile;
   int i;

   printf("\nINDENT (v1.0) Copyright (c) 1992 to Tracking Technologies, Inc\n");
   if (argc <3) {
      printf("USAGE : indent filename columns [outfile]\n\n");
      printf(

      "This program will step through the designated text file and shift\n"
      "the file over to the right the number of columns specified by \n"
      "inserting spaces at the beginning of each line.");
      return 1;
   }

   // open the infile and check for errors

   StringFile infile( argv[1], READ_FILE );
   if (!infile.IsOpen()) {
      printf("Cannot open file %s", argv[1]);
      return 1;
   }

   // extract the number of columns and check for errors

   columns = atoi(argv[2]);

   // if an outfile was specified then open it

   if (argc>3) {
      outfile.open(argv[3],WRITE_FILE);
      if (!outfile.IsOpen()) {
         printf("Cannot create outputfile %s\n",argv[3]);
         return 1;
      }
   }

   // create a string with the proper pad and read the first line

   String pad = StringOf(columns,' ');
   line = infile.read();

   // loop through the entire file and write to the file

   if (outfile.IsOpen()) {
      while (!infile.eof()) {
         outfile.write(pad+line);
         line = infile.read();
      }
   } else {
      while (!infile.eof()) {
         line=pad+line;
         For (i,line.Length()) putchar(line[i]);
         line = infile.read();
      }
   }
   return 0;
}
